/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5;

import jakarta.xml.soap.SOAPBody;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.utils.MessageWriteToRunnable;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreExtBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREConnectionConfig;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREConnectionManager;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREUtils;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHttpPoolParamsBuilder;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHttpRequestInterceptor;
import org.openspcoop2.pdd.core.connettori.httpcore5.FileStreamingEntity;
import org.openspcoop2.pdd.core.connettori.httpcore5.MessageObjectEntity;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.ConnectorApplicativeThreadPool;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedOutputStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedStreamFactory;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpBodyParameters;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;
import org.slf4j.Logger;

public class ConnettoreHTTPCORE
extends ConnettoreExtBaseHTTP {
    public static final String ENDPOINT_TYPE = "httpcore";
    public static final String ID_HTTPCORE = "HTTPCore5-BIO";
    private static final String MSG_RELEASE_RESOURCES_FAILED = "Release resources failed: ";
    private static boolean gestioneRedirectTramiteLibrerieApache = false;
    private HttpEntity httpEntityResponse = null;
    private HttpUriRequestBase httpRequest;
    private CloseableHttpClient cloasebleHttpClient;
    private DumpByteArrayOutputStream cloasebleDumpBout;
    private Map<String, List<String>> recHeaderForInterceptor = null;

    public ConnettoreHTTPCORE() {
    }

    public ConnettoreHTTPCORE(boolean https) {
        super(https);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean sendHTTP(ConnettoreMsg request) {
        block175: {
            block179: {
                block171: {
                    block172: {
                        block173: {
                            connectionTimeout = -1;
                            connectionTimeoutConfigurazioneGlobale = true;
                            readConnectionTimeout = -1;
                            readConnectionTimeoutConfigurazioneGlobale = true;
                            try {
                                block178: {
                                    block177: {
                                        if (this.debug) {
                                            this.logger.debug("Creazione URL...");
                                        }
                                        this.buildLocation();
                                        if (this.debug) {
                                            this.logger.debug("Creazione URL [" + this.location + "]...");
                                        }
                                        url = new URI(this.location).toURL();
                                        keepAliveStrategy = null;
                                        propertiesTrasportoDebug = null;
                                        if (this.isDumpBinarioRichiesta()) {
                                            propertiesTrasportoDebug = new HashMap<String, List<String>>();
                                        }
                                        config = new ConnettoreHTTPCOREConnectionConfig();
                                        config.setDebug(this.debug);
                                        config.setSslContextProperties(this.sslContextProperties);
                                        if (this.properties.get("connectionTimeout") != null) {
                                            try {
                                                connectionTimeout = Integer.parseInt((String)this.properties.get("connectionTimeout"));
                                                connectionTimeoutConfigurazioneGlobale = this.properties.containsKey("connectionTimeoutGlobale");
                                            }
                                            catch (Exception e) {
                                                this.logger.error("Parametro 'connectionTimeout' errato", e);
                                            }
                                        }
                                        if (connectionTimeout == -1) {
                                            connectionTimeout = 10000;
                                        }
                                        config.setConnectionTimeout(connectionTimeout);
                                        poolParams = ConnettoreHttpPoolParamsBuilder.newConnettoreHttpPoolParams(this.openspcoopProperties, url, this.proprietaPorta);
                                        config.setHttpPoolParams(poolParams);
                                        httpRequestInterceptor = null;
                                        if (this.debug) {
                                            this.recHeaderForInterceptor = new HashMap<String, List<String>>();
                                            httpRequestInterceptor = new ConnettoreHttpRequestInterceptor(this.logger, this.recHeaderForInterceptor);
                                        }
                                        if (this.httpMethod == null) {
                                            throw new ConnettoreException("HttpRequestMethod non definito");
                                        }
                                        this.httpRequest = ConnettoreHTTPCOREUtils.buildHttpRequest(this.httpMethod, url);
                                        if (this.httpRequest == null) {
                                            throw new ConnettoreException("HttpRequest non definita ?");
                                        }
                                        soapMessageRequest = null;
                                        requestMessageType = this.requestMsg.getMessageType();
                                        if (this.debug) {
                                            this.logger.debug("Tipologia Servizio: " + String.valueOf(this.requestMsg.getServiceBinding()));
                                        }
                                        if (this.isSoap) {
                                            soapMessageRequest = this.requestMsg.castAsSoap();
                                        }
                                        this.requestMsg.updateContentType();
                                        if (this.proxyType != null && this.proxyUsername != null) {
                                            if (this.debug) {
                                                this.logger.debug("Impostazione autenticazione per proxy (username[" + this.proxyUsername + "] password[" + this.proxyPassword + "]) ...");
                                            }
                                            if (this.proxyUsername != null && this.proxyPassword != null) {
                                                authentication = this.proxyUsername + ":" + this.proxyPassword;
                                                authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                                                this.setRequestHeader("Proxy-Authorization", authentication, propertiesTrasportoDebug);
                                                if (this.debug) {
                                                    this.logger.info("Impostazione autenticazione per proxy (username[" + this.proxyUsername + "] password[" + this.proxyPassword + "]) [" + authentication + "]", false);
                                                }
                                            }
                                        }
                                        if (this.debug) {
                                            this.logger.debug("Impostazione content type...");
                                        }
                                        contentTypeRichiesta = null;
                                        if (this.isSoap) {
                                            contentTypeRichiesta = this.sbustamentoSoap != false && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) != false ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                                            if (contentTypeRichiesta == null) {
                                                throw new ConnettoreException("Content-Type del messaggio da spedire non definito");
                                            }
                                        } else {
                                            contentTypeRichiesta = this.requestMsg.getContentType();
                                        }
                                        if (this.debug) {
                                            this.logger.info("Impostazione http Content-Type [" + contentTypeRichiesta + "]", false);
                                        }
                                        if (contentTypeRichiesta != null) {
                                            this.setRequestHeader("Content-Type", contentTypeRichiesta, propertiesTrasportoDebug);
                                        }
                                        if (this.debug) {
                                            this.logger.debug("Impostazione transfer-length...");
                                        }
                                        transferEncodingChunked = TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)this.tlm);
                                        if (this.debug) {
                                            this.logger.info("Impostazione transfer-length effettuata (chunkLength:" + this.chunkLength + "): " + String.valueOf(this.tlm), false);
                                        }
                                        if (this.debug) {
                                            this.logger.debug("Impostazione timeout...");
                                        }
                                        if (this.properties.get("readConnectionTimeout") != null) {
                                            try {
                                                readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                                                readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                                            }
                                            catch (Exception e) {
                                                this.logger.error("Parametro 'readConnectionTimeout' errato", e);
                                            }
                                        }
                                        if (readConnectionTimeout == -1) {
                                            readConnectionTimeout = 120000;
                                        }
                                        if (this.debug) {
                                            this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]", false);
                                        }
                                        config.setReadTimeout(readConnectionTimeout);
                                        if (!this.followRedirects) break block177;
                                        if (ConnettoreHTTPCORE.gestioneRedirectTramiteLibrerieApache && !this.isRest) {
                                            config.setFollowRedirect(true);
                                            if (this.maxNumberRedirects > 0) {
                                                config.setMaxNumberRedirects(this.maxNumberRedirects);
                                            }
                                            break block178;
                                        } else {
                                            config.setFollowRedirect(false);
                                        }
                                        break block178;
                                    }
                                    config.setFollowRedirect(false);
                                }
                                if (this.debug) {
                                    this.logger.debug("Impostazione autenticazione...");
                                }
                                user = null;
                                password = null;
                                if (this.credenziali != null) {
                                    user = this.credenziali.getUser();
                                    password = this.credenziali.getPassword();
                                } else {
                                    user = (String)this.properties.get("user");
                                    password = (String)this.properties.get("password");
                                }
                                if (user != null && password != null) {
                                    authentication = user + ":" + password;
                                    authentication = "Basic " + Base64Utilities.encodeAsString((byte[])authentication.getBytes());
                                    this.setRequestHeader("Authorization", authentication, propertiesTrasportoDebug);
                                    if (this.debug) {
                                        this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                                    }
                                }
                                if ((nv = this.getTokenHeader()) != null) {
                                    if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                                        this.requestMsg.getTransportRequestContext().removeHeader(nv.getName());
                                    }
                                    this.setRequestHeader(nv.getName(), nv.getValue(), propertiesTrasportoDebug);
                                    if (this.debug) {
                                        this.logger.info("Impostazione autenticazione token (header-name '" + nv.getName() + "' value '" + nv.getValue() + "')", false);
                                    }
                                }
                                if ((apiKey = (String)this.properties.get("apiKey")) != null && StringUtils.isNotEmpty((CharSequence)apiKey)) {
                                    apiKeyHeader = (String)this.properties.get("apiKeyHeader");
                                    if (apiKeyHeader == null || StringUtils.isEmpty((CharSequence)apiKeyHeader)) {
                                        apiKeyHeader = "X-API-KEY";
                                    }
                                    this.setRequestHeader(apiKeyHeader, apiKey, propertiesTrasportoDebug);
                                    if (this.debug) {
                                        this.logger.info("Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]", false);
                                    }
                                    if ((appId = (String)this.properties.get("appId")) != null && StringUtils.isNotEmpty((CharSequence)appId)) {
                                        appIdHeader = (String)this.properties.get("appIdHeader");
                                        if (appIdHeader == null || StringUtils.isEmpty((CharSequence)appIdHeader)) {
                                            appIdHeader = "X-APP-ID";
                                        }
                                        this.setRequestHeader(appIdHeader, appId, propertiesTrasportoDebug);
                                        if (this.debug) {
                                            this.logger.info("Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]", false);
                                        }
                                    }
                                }
                                if (this.forwardProxyHeaderName != null && this.forwardProxyHeaderValue != null) {
                                    if (this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
                                        this.requestMsg.getTransportRequestContext().removeHeader(this.forwardProxyHeaderName);
                                    }
                                    this.setRequestHeader(this.forwardProxyHeaderName, this.forwardProxyHeaderValue, propertiesTrasportoDebug);
                                    if (this.debug) {
                                        this.logger.info("Impostazione ForwardProxy (header-name '" + this.forwardProxyHeaderName + "' value '" + this.forwardProxyHeaderValue + "')", false);
                                    }
                                }
                                if (this.debug) {
                                    this.logger.debug("Impostazione header di trasporto...");
                                }
                                this.forwardHttpRequestHeader();
                                if (this.propertiesTrasporto == null) break block171;
lbl147:
                                // 3 sources

                                for (String key : this.propertiesTrasporto.keySet()) {
                                    values = (List)this.propertiesTrasporto.get(key);
                                    if (this.debug && values != null && !values.isEmpty()) {
                                        for (Object value : values) {
                                            this.logger.info("Set Transport Header [" + key + "]=[" + (String)value + "]", false);
                                        }
                                    }
                                    if (this.encodingRFC2047) {
                                        valuesEncoded = new ArrayList<String>();
                                        if (values == null || values.isEmpty()) break block172;
                                        value = values.iterator();
                                        break block173;
                                    }
                                    this.setRequestHeader(this.validazioneHeaderRFC2047, key, values, this.logger, propertiesTrasportoDebug);
                                }
                                break block171;
                            }
                            catch (Exception e) {
                                this.eccezioneProcessamento = e;
                                msgErrore = this.readExceptionMessageFromException(e);
                                this.errore = this.generateErrorWithConnectorPrefix != false ? "Errore avvenuto durante la consegna HTTP: " + msgErrore : msgErrore;
                                this.logger.error("Errore avvenuto durante la consegna HTTP: " + msgErrore, e);
                                this.processConnectionTimeoutException(connectionTimeout, connectionTimeoutConfigurazioneGlobale, e, msgErrore);
                                this.processReadTimeoutException(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
                                var8_10 = false;
                                return var8_10;
                            }
                        }
                        while (value.hasNext()) {
                            value = (String)value.next();
                            if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)this.charsetRFC2047)) {
                                encoded = RFC2047Utilities.encode((String)value, (Charset)this.charsetRFC2047, (RFC2047Encoding)this.encodingAlgorithmRFC2047);
                                if (this.debug) {
                                    this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + String.valueOf(this.charsetRFC2047) + " encoding-algorithm:" + String.valueOf(this.encodingAlgorithmRFC2047) + ")", false);
                                }
                                valuesEncoded.add(encoded);
                                continue;
                            }
                            valuesEncoded.add(value);
                        }
                    }
                    this.setRequestHeader(this.validazioneHeaderRFC2047, key, valuesEncoded, this.logger, propertiesTrasportoDebug);
                    ** GOTO lbl147
                }
                if (this.isSoap && !this.sbustamentoSoap) {
                    if (this.debug) {
                        this.logger.debug("Impostazione soap action...");
                    }
                    existsTransportProperties = false;
                    if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                        this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                        v0 = existsTransportProperties = this.soapAction != null;
                    }
                    if (!existsTransportProperties) {
                        this.soapAction = soapMessageRequest.getSoapAction();
                    }
                    if (this.soapAction == null) {
                        this.soapAction = "\"OpenSPCoop\"";
                    }
                    if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                        this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                    }
                    if (this.debug) {
                        this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                    }
                }
                if (this.debug) {
                    this.logger.info("Impostazione " + String.valueOf(this.httpMethod) + "...", false);
                }
                httpBody = new HttpBodyParameters(this.httpMethod, contentTypeRichiesta);
                messageWriteToRunnable = null;
                if (!httpBody.isDoOutput() && !request.isForceSendContent()) break block179;
                consumeRequestMessage = true;
                if (this.followRedirects && !ConnettoreHTTPCORE.gestioneRedirectTramiteLibrerieApache) {
                    consumeRequestMessage = false;
                }
                if (this.debug) {
                    this.logger.debug("Spedizione byte (consume-request-message:" + consumeRequestMessage + ")...");
                }
                hasContentBuilded = false;
                hasContent = false;
                restMessage = null;
                soapMessage = null;
                if (this.isRest) {
                    restMessage = this.requestMsg.castAsRest();
                    hasContent = restMessage.hasContent();
                    hasContentBuilded = restMessage.isContentBuilded();
                } else if (this.requestMsg instanceof AbstractOpenSPCoop2Message_soap_impl) {
                    soapMessage = (AbstractOpenSPCoop2Message_soap_impl)this.requestMsg;
                    hasContent = soapMessage.hasContent();
                    hasContentBuilded = soapMessage.isContentBuilded();
                }
                if (!transferEncodingChunked || this.isDumpBinarioRichiesta() || this.isSoap && soapMessage == null || hasContentBuilded || !consumeRequestMessage) {
                    this.cloasebleDumpBout = new DumpByteArrayOutputStream(this.dumpBinarioSoglia, this.dumpBinarioRepositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                    try {
                        if (this.isSoap && this.sbustamentoSoap) {
                            if (this.debug) {
                                this.logger.debug("Sbustamento...");
                            }
                            TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.cloasebleDumpBout);
                        } else {
                            this.requestMsg.writeTo((OutputStream)this.cloasebleDumpBout, consumeRequestMessage);
                        }
                        this.cloasebleDumpBout.flush();
                        this.cloasebleDumpBout.close();
                        if (this.isDumpBinarioRichiesta()) {
                            this.dumpBinarioRichiestaUscita(this.cloasebleDumpBout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                        }
                        httpEntity /* !! */  = null;
                        baseMimeType = ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeRichiesta);
                        ct = ContentType.create((String)baseMimeType);
                        httpEntity /* !! */  = this.cloasebleDumpBout.isSerializedOnFileSystem() ? (transferEncodingChunked ? new FileStreamingEntity(this.cloasebleDumpBout.getSerializedFile(), ct, null) : new FileEntity(this.cloasebleDumpBout.getSerializedFile(), ct)) : new ByteArrayEntity(this.cloasebleDumpBout.toByteArray(), ct, transferEncodingChunked);
                        this.httpRequest.setEntity((HttpEntity)httpEntity /* !! */ );
                    }
                    finally {
                        if (!this.cloasebleDumpBout.isSerializedOnFileSystem()) {
                            try {
                                this.cloasebleDumpBout.clearResources();
                            }
                            catch (Exception t) {
                                this.logger.error("Release resources failed: " + t.getMessage(), t);
                            }
                            finally {
                                this.cloasebleDumpBout = null;
                            }
                        }
                    }
                }
                if (hasContent) {
                    baseMimeType = ContentTypeUtilities.readBaseTypeFromContentType((String)contentTypeRichiesta);
                    ct = ContentType.create((String)baseMimeType);
                    useMessageObjectEntity = this.openspcoopProperties.isBIOConfigSyncClientUseCustomMessageObjectEntity();
                    if (useMessageObjectEntity) {
                        moe = new MessageObjectEntity(this.requestMsg, consumeRequestMessage, ct, null);
                        this.httpRequest.setEntity((HttpEntity)moe);
                        break block175;
                    } else {
                        isRequest = null;
                        if (this.isRest) {
                            isRequest = restMessage.getInputStream();
                        } else {
                            requestReadTimeout = readConnectionTimeout;
                            if (this.getPddContext() != null && this.getPddContext().containsKey(CostantiPdD.REQUEST_READ_TIMEOUT) && (o = this.getPddContext().get(CostantiPdD.REQUEST_READ_TIMEOUT)) instanceof Integer) {
                                t = (Integer)o;
                                requestReadTimeout = t;
                            }
                            isRequest = PipedUnblockedStreamFactory.newPipedUnblockedStream((Logger)this.logger.getLogger(), (long)this.openspcoopProperties.getBIOConfigSyncClientPipedUnblockedStreamBuffer(), (int)(requestReadTimeout += 1000), (String)"Request");
                            puos = new PipedUnblockedOutputStream((IPipedUnblockedStream)isRequest);
                            messageWriteToRunnable = new MessageWriteToRunnable(this.logger.getLogger(), this.requestMsg, (OutputStream)puos, consumeRequestMessage);
                            ConnectorApplicativeThreadPool.executeBySyncRequestPool((Runnable)messageWriteToRunnable);
                        }
                        httpEntity = new InputStreamEntity(isRequest, ct);
                        this.httpRequest.setEntity((HttpEntity)httpEntity);
                    }
                }
                break block175;
            }
            if (this.isDumpBinarioRichiesta()) {
                this.dumpBinarioRichiestaUscita(null, null, null, this.location, propertiesTrasportoDebug);
            }
        }
        if (this.proxyType == null) {
            if (this.debug) {
                this.logger.info("Creazione connessione alla URL [" + this.location + "]...", false);
            }
        } else {
            if (this.debug) {
                this.logger.info("Creazione connessione alla URL [" + this.location + "] (via proxy " + this.proxyHostname + ":" + this.proxyPort + ") (username[" + this.proxyUsername + "] psw[" + this.proxyPassword + "])...", false);
            }
            config.setProxyHost(this.proxyHostname);
            config.setProxyPort(this.proxyPort);
        }
        conn = ConnettoreHTTPCOREConnectionManager.getConnettoreHTTPCOREConnection(config, this.buildSSLContextFactory(), this.loader, this.logger, keepAliveStrategy, httpRequestInterceptor);
        httpClient = (HttpClient)conn.getHttpclient();
        this.httpRequest.setConfig(conn.getRequestConfig());
        if (this.debug) {
            this.logger.debug("Spedizione byte...");
        }
        httpHost = HttpHost.create((URI)this.httpRequest.getUri());
        httpResponse = httpClient.executeOpen(httpHost, (ClassicHttpRequest)this.httpRequest, null);
        if (this.cloasebleDumpBout != null) {
            try {
                this.cloasebleDumpBout.clearResources();
            }
            catch (Exception t) {
                this.logger.error("Release resources failed: " + t.getMessage(), t);
            }
            finally {
                this.cloasebleDumpBout = null;
            }
        }
        if (messageWriteToRunnable != null && messageWriteToRunnable.getException() != null) {
            throw messageWriteToRunnable.getException();
        }
        this.httpEntityResponse = httpResponse.getEntity();
        if (this.debug) {
            this.logger.debug("Analisi risposta...");
        }
        hdrRisposta = httpResponse.getHeaders();
        mapHeaderHttpResponse = new HashMap<String, ArrayList<E>>();
        if (hdrRisposta != null) {
            for (i = 0; i < hdrRisposta.length; ++i) {
                key = null;
                value = null;
                if (hdrRisposta[i].getName() == null) {
                    if (this.debug) {
                        this.logger.debug("HTTP risposta [ReturnCode] [" + hdrRisposta[i].getValue() + "]...");
                    }
                    key = "ReturnCode";
                    value = hdrRisposta[i].getValue();
                } else {
                    if (this.debug) {
                        this.logger.debug("HTTP risposta [" + hdrRisposta[i].getName() + "] [" + hdrRisposta[i].getValue() + "]...");
                    }
                    key = hdrRisposta[i].getName();
                    value = hdrRisposta[i].getValue();
                }
                TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)key, (String)value);
                list = null;
                if (mapHeaderHttpResponse.containsKey(key)) {
                    list = (ArrayList<String>)mapHeaderHttpResponse.get(key);
                }
                if (list == null) {
                    list = new ArrayList<String>();
                    mapHeaderHttpResponse.put(key, list);
                }
                list.add(value);
            }
        }
        this.tipoRisposta = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Type");
        contentLengthHdr = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Content-Length");
        if (contentLengthHdr != null) {
            this.contentLength = Long.parseLong(contentLengthHdr);
        } else if (this.httpEntityResponse != null && this.httpEntityResponse.getContentLength() > 0L) {
            this.contentLength = this.httpEntityResponse.getContentLength();
        }
        if (this.isSoap) {
            if ("true".equals(TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                this.imbustamentoConAttachment = true;
            }
            this.mimeTypeAttachment = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
            if (this.mimeTypeAttachment == null) {
                this.mimeTypeAttachment = "application/openspcoop2";
            }
        }
        if (this.debug) {
            this.logger.debug("Analisi risposta input stream e risultato http...");
        }
        this.initConfigurationAcceptOnlyReturnCode202or200();
        this.codice = httpResponse.getCode();
        this.resultHTTPMessage = httpResponse.getReasonPhrase();
        if (this.codice < 300) {
            if (this.isSoap && this.acceptOnlyReturnCode202or200 && this.codice != 200 && this.codice != 202) {
                throw new ConnettoreException("Return code [" + this.codice + "] non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Success_Status_Codes)");
            }
            if (httpBody.isDoInput() && this.httpEntityResponse != null) {
                this.isResponse = this.httpEntityResponse.getContent();
            }
        } else if (this.codice < 400) {
            redirectLocation = TransportUtils.getObjectAsString(mapHeaderHttpResponse, (String)"Location");
            if (this.followRedirects && !ConnettoreHTTPCORE.gestioneRedirectTramiteLibrerieApache) {
                if (redirectLocation == null) {
                    throw new ConnettoreException("Non \u00e8 stato rilevato l'header HTTP [Location] necessario alla gestione del Redirect (code:" + this.codice + ")");
                }
                TransportUtils.removeObject(request.getConnectorProperties(), (String)"location");
                TransportUtils.removeObject(request.getConnectorProperties(), (String)"numberRedirect");
                TransportUtils.removeObject(request.getConnectorProperties(), (String)"routeRedirect");
                request.getConnectorProperties().put("location", redirectLocation);
                request.getConnectorProperties().put("numberRedirect", "" + (this.numberRedirect + 1));
                if (this.routeRedirect != null) {
                    request.getConnectorProperties().put("routeRedirect", this.routeRedirect + " -> " + redirectLocation);
                } else {
                    request.getConnectorProperties().put("routeRedirect", redirectLocation);
                }
                if (this.originalAbsolutePrefixForRelativeRedirectLocation == null) {
                    this.originalAbsolutePrefixForRelativeRedirectLocation = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
                }
                this.redirectLocation = redirectLocation;
                if (this.redirectLocation.startsWith("/")) {
                    this.redirectLocation = this.originalAbsolutePrefixForRelativeRedirectLocation + this.redirectLocation;
                }
                this.logger.warn("(hope:" + (this.numberRedirect + 1) + ") Redirect verso [" + redirectLocation + "] ...");
                if (this.numberRedirect == this.maxNumberRedirects) {
                    throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non consentita ulteriormente, sono gi\u00e0 stati gestiti " + this.maxNumberRedirects + " redirects: " + this.routeRedirect);
                }
                acceptOnlyReturnCode307 = false;
                if (this.isSoap) {
                    acceptOnlyReturnCode307 = "ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isAcceptOnlyReturnCode_307_consegnaContenutiApplicativi() : this.openspcoopProperties.isAcceptOnlyReturnCode_307_inoltroBuste();
                }
                if (acceptOnlyReturnCode307 && this.codice != 307) {
                    throw new ConnettoreException("Return code [" + this.codice + "] (redirect Location:" + redirectLocation + ") non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Redirect_Status_Codes)");
                }
                this.clearRequestHeader();
                if (this.propertiesTrasportoRisposta != null) {
                    this.propertiesTrasportoRisposta.clear();
                }
                this.contentLength = -1L;
                this.disconnect();
                return this.send(request);
            }
            if (this.isSoap) {
                throw new ConnettoreException(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non attiva");
            }
            this.logger.debug(ConnettoreUtils.getPrefixRedirect(this.codice, redirectLocation) + "non attiva");
            if (this.location != null && redirectLocation != null) {
                this.location = this.location + " [redirect-location: " + redirectLocation + "]";
            }
            if (this.httpEntityResponse != null) {
                this.isResponse = this.httpEntityResponse.getContent();
            }
        } else if (this.httpEntityResponse != null) {
            this.isResponse = this.httpEntityResponse.getContent();
        }
        this.postOutRequest();
        this.preInResponse();
        this.notifierInputStreamParams = null;
        if (this.preInResponseContext != null) {
            this.notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
        }
        this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
        this.initCheckContentTypeConfiguration();
        if (this.isDumpBinarioRisposta() && !this.dumpResponse(this.propertiesTrasportoRisposta)) {
            return false;
        }
        if (this.isRest != false ? this.doRestResponse() == false : this.doSoapResponse() == false) {
            return false;
        }
        if (this.debug == false) return true;
        this.logger.info("Gestione invio/risposta http effettuata con successo", false);
        return true;
        finally {
            if (this.cloasebleDumpBout != null) {
                try {
                    this.cloasebleDumpBout.clearResources();
                    this.cloasebleDumpBout = null;
                }
                catch (Exception t) {
                    this.logger.error("Release resources failed: " + t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        ArrayList<Exception> listExceptionChiusura = new ArrayList<Exception>();
        this.releaseResponse(listExceptionChiusura);
        try {
            super.disconnect();
        }
        catch (Exception t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura risorse fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
        }
        if (!listExceptionChiusura.isEmpty()) {
            UtilsMultiException multiException = new UtilsMultiException(listExceptionChiusura.toArray(new Throwable[1]));
            throw new ConnettoreException("Chiusura connessione non riuscita: " + multiException.getMessage(), multiException);
        }
    }

    private void releaseResponse(List<Exception> listExceptionChiusura) {
        boolean responseReadTimeout = false;
        try {
            if (this.isResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura socket...");
                }
                this.isResponse.close();
            }
        }
        catch (Exception t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura socket fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
            responseReadTimeout = ServicesUtils.isConnessioneServerReadTimeout(t);
        }
        try {
            if (this.httpEntityResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura httpEntityResponse...");
                }
                if (!responseReadTimeout) {
                    EntityUtils.consume((HttpEntity)this.httpEntityResponse);
                }
            }
        }
        catch (Exception t) {
            if (this.logger != null) {
                this.logger.debug("Chiusura connessione fallita: " + t.getMessage(), t);
            }
            listExceptionChiusura.add(t);
        }
    }

    @Override
    protected String getTipoImplConnettore() {
        if (this.tipoConnettore != null && StringUtils.isNotEmpty((CharSequence)this.tipoConnettore)) {
            return this.tipoConnettore;
        }
        return this.connettoreHttps ? "httpscore" : ENDPOINT_TYPE;
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws ConnettoreException {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                this.httpRequest.addHeader(key, (Object)value);
                if (this.recHeaderForInterceptor == null) continue;
                this.recHeaderForInterceptor.put(key, values);
            }
        }
    }
}

