/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreConnectionConfig;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHttpPoolParams;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREConnection;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREConnectionConfig;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREConnectionEvictor;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREUtils;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHttpRequestInterceptor;
import org.openspcoop2.security.keystore.SSLSocketFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogTlsSocketStrategy;
import org.slf4j.Logger;

public class ConnettoreHTTPCOREConnectionManager {
    private static final Semaphore semaphorePoolingConnectionManager = new Semaphore("HTTPCore5-BIO-PoolingConnectionManager");
    public static final boolean USE_POOL_CONNECTION = false;
    private static final Semaphore semaphoreConnection = new Semaphore("HTTPCore5-BIO-ConnectionManager");
    static Map<String, PoolingHttpClientConnectionManager> mapPoolingConnectionManager = new HashMap<String, PoolingHttpClientConnectionManager>();
    static Map<String, ConnettoreHTTPCOREConnection> mapConnection = new HashMap<String, ConnettoreHTTPCOREConnection>();
    private static ConnettoreHTTPCOREConnectionEvictor idleConnectionEvictor;

    private ConnettoreHTTPCOREConnectionManager() {
    }

    public static synchronized void initialize() throws ConnettoreException {
        try {
            if (idleConnectionEvictor == null) {
                boolean idleConnectionEvictorEnabled;
                OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
                Integer closeIdleConnectionsAfterSeconds = op2Properties.getBIOConfigSyncClientCloseIdleConnectionsAfterSeconds();
                boolean bl = idleConnectionEvictorEnabled = closeIdleConnectionsAfterSeconds != null && closeIdleConnectionsAfterSeconds > 0;
                if (idleConnectionEvictorEnabled) {
                    int sleepTimeSeconds = op2Properties.getBIOConfigSyncClientCloseIdleConnectionsCheckIntervalSeconds();
                    boolean debug = op2Properties.isBIOConfigSyncClientCloseIdleConnectionsDebug();
                    idleConnectionEvictor = new ConnettoreHTTPCOREConnectionEvictor(debug, sleepTimeSeconds, closeIdleConnectionsAfterSeconds);
                    idleConnectionEvictor.start();
                }
            }
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    public static String getHttpClientConnectionManagerStatus() {
        if (idleConnectionEvictor != null) {
            StringBuilder sb = new StringBuilder();
            idleConnectionEvictor.internalCheck(sb);
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String key, TlsSocketStrategy tlsSocketStrategy, ConnettoreHTTPCOREConnectionConfig connectionConfig, ConnettoreLogger logger) throws ConnettoreException {
        block11: {
            String idTransazione = logger != null ? logger.getIdTransazione() : null;
            SemaphoreLock lock = null;
            try {
                lock = semaphorePoolingConnectionManager.acquire("initPoolingConnectionManager", idTransazione);
            }
            catch (Exception t) {
                throw new ConnettoreException(t.getMessage(), t);
            }
            try {
                if (mapPoolingConnectionManager.containsKey(key)) break block11;
                try {
                    PoolingHttpClientConnectionManagerBuilder poolingConnectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
                    if (tlsSocketStrategy != null) {
                        poolingConnectionManagerBuilder.setTlsSocketStrategy(tlsSocketStrategy);
                    } else {
                        poolingConnectionManagerBuilder.useSystemProperties();
                    }
                    poolingConnectionManagerBuilder.setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX);
                    poolingConnectionManagerBuilder.setConnPoolPolicy(PoolReusePolicy.FIFO);
                    ConnettoreHttpPoolParams poolParams = connectionConfig.getHttpPoolParams();
                    Integer defaultMaxPerRoute = poolParams.getDefaultMaxPerRoute();
                    Integer maxTotal = poolParams.getMaxTotal();
                    if (maxTotal != null && maxTotal > 0) {
                        poolingConnectionManagerBuilder.setMaxConnTotal(poolParams.getMaxTotal());
                    }
                    if (defaultMaxPerRoute != null && defaultMaxPerRoute > 0) {
                        poolingConnectionManagerBuilder.setMaxConnPerRoute(poolParams.getDefaultMaxPerRoute());
                    }
                    ConnectionConfig config = ConnettoreHTTPCOREConnectionManager.buildConnectionConfig(poolParams, connectionConfig.getConnectionTimeout().intValue());
                    poolingConnectionManagerBuilder.setDefaultConnectionConfig(config);
                    PoolingHttpClientConnectionManager poolingConnectionManager = poolingConnectionManagerBuilder.build();
                    mapPoolingConnectionManager.put(key, poolingConnectionManager);
                }
                catch (Exception t) {
                    throw new ConnettoreException(t.getMessage(), t);
                }
            }
            finally {
                semaphorePoolingConnectionManager.release(lock, "initPoolingConnectionManager", idTransazione);
            }
        }
    }

    private static ConnectionConfig buildConnectionConfig(ConnettoreHttpPoolParams poolParams, long connectionTimeout) {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Integer closeIdleConnectionsAfterSeconds = op2Properties.getBIOConfigSyncClientCloseIdleConnectionsAfterSeconds();
        boolean idleConnectionEvictorEnabled = closeIdleConnectionsAfterSeconds != null && closeIdleConnectionsAfterSeconds > 0;
        int sleepTimeSeconds = -1;
        if (idleConnectionEvictorEnabled) {
            sleepTimeSeconds = op2Properties.getBIOConfigSyncClientCloseIdleConnectionsCheckIntervalSeconds();
        }
        return ConnettoreHTTPCOREUtils.buildConnectionConfig(poolParams, connectionTimeout, idleConnectionEvictorEnabled, sleepTimeSeconds);
    }

    public static synchronized void stop() throws ConnettoreException {
        ArrayList<Throwable> listT = new ArrayList<Throwable>();
        if (idleConnectionEvictor != null) {
            try {
                idleConnectionEvictor.setStop(true);
                idleConnectionEvictor.waitShutdown();
            }
            catch (Exception t) {
                listT.add(t);
            }
        }
        ConnettoreHTTPCOREConnectionManager.stopClients(listT);
        ConnettoreHTTPCOREConnectionManager.stopConnectionManager(listT);
        ConnettoreHTTPCOREConnectionManager.throwExceptions(listT);
    }

    public static synchronized void restartConnectionManager() throws ConnettoreException {
        ArrayList<Throwable> listT = new ArrayList<Throwable>();
        ConnettoreHTTPCOREConnectionManager.stopClients(listT);
        ConnettoreHTTPCOREConnectionManager.stopConnectionManager(listT);
        ConnettoreHTTPCOREConnectionManager.throwExceptions(listT);
    }

    private static void throwExceptions(List<Throwable> listT) throws ConnettoreException {
        if (listT != null && !listT.isEmpty()) {
            if (listT.size() == 1) {
                throw new ConnettoreException(listT.get(0).getMessage(), listT.get(0));
            }
            UtilsMultiException multiExc = new UtilsMultiException(listT.toArray(new Throwable[1]));
            throw new ConnettoreException(multiExc.getMessage(), multiExc);
        }
    }

    private static void stopClients(List<Throwable> listT) throws ConnettoreException {
        if (mapConnection != null && !mapConnection.isEmpty()) {
            for (String key : mapConnection.keySet()) {
                ConnettoreHTTPCOREConnection connection = mapConnection.get(key);
                try {
                    connection.close();
                }
                catch (Exception t) {
                    listT.add(new ConnettoreException("Connection [" + key + "] close error: " + t.getMessage(), t));
                }
            }
            mapConnection.clear();
        }
    }

    private static void stopConnectionManager(List<Throwable> listT) {
        if (mapPoolingConnectionManager != null && !mapPoolingConnectionManager.isEmpty()) {
            for (String key : mapPoolingConnectionManager.keySet()) {
                if (key == null) continue;
                PoolingHttpClientConnectionManager cm = mapPoolingConnectionManager.get(key);
                ConnettoreHTTPCOREConnectionManager.stopConnectionManager(cm, listT);
            }
            mapPoolingConnectionManager.clear();
        }
    }

    private static void stopConnectionManager(PoolingHttpClientConnectionManager cm, List<Throwable> listT) {
        if (cm != null) {
            try {
                cm.close(CloseMode.GRACEFUL);
            }
            catch (Exception t) {
                listT.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(ConnettoreHTTPCOREConnectionConfig connectionConfig, SSLSocketFactory sslSocketFactory, Loader loader, ConnettoreLogger logger, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        String key = connectionConfig.toKeyConnection();
        String idTransazione = logger != null ? logger.getIdTransazione() : null;
        SemaphoreLock lock = null;
        try {
            lock = semaphoreConnection.acquire("initConnection", idTransazione);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
        try {
            if (!mapConnection.containsKey(key)) {
                ConnettoreHTTPCOREConnection resource = ConnettoreHTTPCOREConnectionManager.buildClient(connectionConfig, sslSocketFactory, loader, logger, key, keepAliveStrategy, httpRequestInterceptor);
                mapConnection.put(key, resource);
            }
        }
        finally {
            semaphoreConnection.release(lock, "initConnection", idTransazione);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnettoreHTTPCOREConnection update(ConnettoreHTTPCOREConnectionConfig connectionConfig, SSLSocketFactory sslSocketFactory, Loader loader, ConnettoreLogger logger, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        String key = connectionConfig.toKeyConnection();
        String idTransazione = logger != null ? logger.getIdTransazione() : null;
        SemaphoreLock lock = null;
        try {
            lock = semaphoreConnection.acquire("updateConnection", idTransazione);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
        try {
            if (mapConnection.containsKey(key)) {
                ConnettoreHTTPCOREConnection con = mapConnection.remove(key);
                mapConnection.put("expired_" + key + "_" + UUID.randomUUID().toString(), con);
            }
            ConnettoreHTTPCOREConnection resource = ConnettoreHTTPCOREConnectionManager.buildClient(connectionConfig, sslSocketFactory, loader, logger, key, keepAliveStrategy, httpRequestInterceptor);
            mapConnection.put(key, resource);
            ConnettoreHTTPCOREConnection connettoreHTTPCOREConnection = resource;
            return connettoreHTTPCOREConnection;
        }
        finally {
            semaphoreConnection.release(lock, "updateConnection", idTransazione);
        }
    }

    private static ConnettoreHTTPCOREConnection buildClient(ConnettoreHTTPCOREConnectionConfig connectionConfig, SSLSocketFactory sslSocketFactory, Loader loader, ConnettoreLogger logger, String key, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        try {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            ConnettoreHTTPCOREUtils.setTimeout(requestConfigBuilder, connectionConfig);
            ConnettoreHTTPCOREUtils.setRedirect(requestConfigBuilder, connectionConfig);
            RequestConfig requestConfig = requestConfigBuilder.build();
            String keyPool = connectionConfig.toKeyConnectionManager();
            if (!mapPoolingConnectionManager.containsKey(keyPool)) {
                TlsSocketStrategy tlsStrategy = ConnettoreHTTPCOREConnectionManager.buildSSLConnectionSocketFactory(connectionConfig, sslSocketFactory, loader, logger);
                ConnettoreHTTPCOREConnectionManager.initialize(keyPool, tlsStrategy, connectionConfig, logger);
            }
            PoolingHttpClientConnectionManager cm = mapPoolingConnectionManager.get(keyPool);
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
            httpClientBuilder.setConnectionManagerShared(true);
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            httpClientBuilder.disableAuthCaching();
            DefaultConnectionReuseStrategy defaultClientConnectionReuseStrategy = new DefaultConnectionReuseStrategy();
            httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)defaultClientConnectionReuseStrategy);
            if (keepAliveStrategy != null) {
                httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
            }
            if (httpRequestInterceptor != null) {
                httpClientBuilder.addRequestInterceptorLast((HttpRequestInterceptor)httpRequestInterceptor);
            }
            if (connectionConfig.isFollowRedirect()) {
                httpClientBuilder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
            }
            ConnettoreHTTPCOREConnectionManager.setProxy(httpClientBuilder, connectionConfig);
            CloseableHttpClient httpclient = httpClientBuilder.build();
            OpenSPCoop2Properties op2 = OpenSPCoop2Properties.getInstance();
            int expireUnusedAfterSeconds = op2.getBIOConfigSyncClientExpireUnusedAfterSeconds();
            int closeUnusedAfterSeconds = op2.getBIOConfigSyncClientCloseUnusedAfterSeconds();
            return new ConnettoreHTTPCOREConnection(key, httpclient, requestConfig, expireUnusedAfterSeconds, closeUnusedAfterSeconds);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    private static void setProxy(HttpClientBuilder httpClientBuilder, AbstractConnettoreConnectionConfig connectionConfig) {
        if (connectionConfig.getProxyHost() != null && connectionConfig.getProxyPort() != null) {
            HttpHost proxy = new HttpHost(connectionConfig.getProxyHost(), connectionConfig.getProxyPort().intValue());
            httpClientBuilder.setProxy(proxy);
        } else {
            httpClientBuilder.useSystemProperties();
        }
    }

    private static TlsSocketStrategy buildSSLConnectionSocketFactory(AbstractConnettoreConnectionConfig connectionConfig, SSLSocketFactory sslSocketFactory, Loader loader, ConnettoreLogger logger) throws UtilsException {
        DefaultClientTlsStrategy tlsSocketStrategy = null;
        if (connectionConfig.getSslContextProperties() != null) {
            StringBuilder bfLog = new StringBuilder();
            HostnameVerifier hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)connectionConfig.getSslContextProperties(), (StringBuilder)bfLog, (Logger)logger.getLogger(), (Loader)loader);
            if (connectionConfig.isDebug()) {
                logger.debug(bfLog.toString());
            }
            if (hostnameVerifier == null) {
                hostnameVerifier = new DefaultHostnameVerifier();
            }
            SSLContext sslContext = sslSocketFactory.getSSLContext();
            tlsSocketStrategy = new DefaultClientTlsStrategy(sslContext, hostnameVerifier);
            if (connectionConfig.isDebug()) {
                String clientCertificateConfigurated = connectionConfig.getSslContextProperties().getKeyStoreLocation();
                tlsSocketStrategy = new WrappedLogTlsSocketStrategy((TlsSocketStrategy)tlsSocketStrategy, logger.getLogger(), logger.buildMsg(""), clientCertificateConfigurated);
            }
        }
        return tlsSocketStrategy;
    }

    public static ConnettoreHTTPCOREConnection getConnettoreHTTPCOREConnection(ConnettoreHTTPCOREConnectionConfig connectionConfig, SSLSocketFactory sslSocketFactory, Loader loader, ConnettoreLogger logger, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        ConnettoreHTTPCOREConnection connection = null;
        connection = ConnettoreHTTPCOREConnectionManager.buildClient(connectionConfig, sslSocketFactory, loader, logger, connectionConfig.toKeyConnection(), keepAliveStrategy, httpRequestInterceptor);
        connection.refresh();
        return connection;
    }
}

