/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;

public class ConnettoreHttpRequestInterceptor
implements HttpRequestInterceptor {
    private ConnettoreLogger connettoreLogger;
    private Map<String, List<String>> recHeaderForInterceptor;

    public ConnettoreHttpRequestInterceptor(ConnettoreLogger connettoreLogger, Map<String, List<String>> recHeaderForInterceptor) {
        this.connettoreLogger = connettoreLogger;
        this.recHeaderForInterceptor = recHeaderForInterceptor;
    }

    public void process(HttpRequest request, EntityDetails details, HttpContext context) throws HttpException, IOException {
        if (request != null) {
            for (Header hdr : request.getHeaders()) {
                if (!this.recHeaderForInterceptor.containsKey(hdr.getName())) {
                    this.connettoreLogger.info("Set Transport Header (httpcore5) [" + hdr.getName() + "]=[" + hdr.getValue() + "]", false);
                    continue;
                }
                List<String> recList = this.recHeaderForInterceptor.get(hdr.getName());
                if (recList != null && recList.contains(hdr.getValue())) continue;
                this.connettoreLogger.info("Set Transport Header (httpcore5; different value) [" + hdr.getName() + "]=[" + hdr.getValue() + "]", false);
            }
        }
    }
}

