/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.TimeValue;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreConnectionEvictor;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREConnection;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREConnectionManager;

public class ConnettoreHTTPCOREConnectionEvictor
extends AbstractConnettoreConnectionEvictor {
    private static final String HTTPCORE_PREFIX = "[HTTPCore5-NIO] ";

    public ConnettoreHTTPCOREConnectionEvictor(boolean debug, int sleepTimeSeconds, int closeIdleConnectionsAfterSeconds) {
        super(debug, sleepTimeSeconds, closeIdleConnectionsAfterSeconds, ConnettoreHTTPCOREConnectionManager.mapConnection, "HTTPCore5-NIO");
    }

    @Override
    protected String getLogPrefix() {
        return HTTPCORE_PREFIX;
    }

    @Override
    protected boolean check() {
        return this.internalCheck(null);
    }

    protected boolean internalCheck(StringBuilder sb) {
        if (ConnettoreHTTPCOREConnectionManager.mapPoolingConnectionManager != null && !ConnettoreHTTPCOREConnectionManager.mapPoolingConnectionManager.isEmpty()) {
            this.print(sb, "ConnectionManager attivi: " + ConnettoreHTTPCOREConnectionManager.mapPoolingConnectionManager.size());
            for (String key : ConnettoreHTTPCOREConnectionManager.mapPoolingConnectionManager.keySet()) {
                if (key == null) continue;
                this.check(key, sb);
            }
            if (sb != null) {
                super.check(sb);
            }
            return true;
        }
        return false;
    }

    private void check(String key, StringBuilder sb) {
        PoolingAsyncClientConnectionManager connMgr = ConnettoreHTTPCOREConnectionManager.mapPoolingConnectionManager.get(key);
        ConnettoreHTTPCOREConnection connection = ConnettoreHTTPCOREConnectionManager.mapConnection.get(key);
        if (this.debug) {
            String status;
            PoolStats totalStats = connMgr.getTotalStats();
            this.print(sb, "(" + key + ") stats: " + totalStats.toString());
            if (connMgr.getRoutes() != null && !connMgr.getRoutes().isEmpty()) {
                for (HttpRoute route : connMgr.getRoutes()) {
                    PoolStats routeStats = connMgr.getStats(route);
                    this.print(sb, "(" + key + ") route [" + route.toString() + "]: " + routeStats.toString());
                }
            }
            if (connection != null && (status = connection.getStatus()) != null && StringUtils.isNotEmpty((CharSequence)status)) {
                this.print(sb, "(" + key + "): status: " + connection.getStatus());
            }
        }
        if (connMgr != null) {
            connMgr.closeExpired();
            connMgr.closeIdle(TimeValue.ofSeconds((long)this.closeIdleConnectionsAfterSeconds));
        }
    }
}

