/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.AbstractConnettoreHTTPCOREInputStreamEntityProducer;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.utils.UtilsRuntimeException;

public class ConnettoreHTTPCOREInputStreamEntityProducer
extends AbstractConnettoreHTTPCOREInputStreamEntityProducer<InputStream> {
    private int count = 0;

    public ConnettoreHTTPCOREInputStreamEntityProducer(InputStream is, ContentType contentType, String contentEncoding, ConnettoreLogger logger) throws TransactionNotExistsException {
        super(is, contentType, contentEncoding, logger);
    }

    public int available() {
        try {
            return ((InputStream)this.object).available();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void produce(DataStreamChannel channel) throws IOException {
        byte[] buffer = new byte[65536];
        int letti = 0;
        while ((letti = ((InputStream)this.object).read(buffer)) != -1) {
            if (letti == 0) continue;
            int startIx = 0;
            while (startIx < letti) {
                ByteBuffer bb = ByteBuffer.wrap(buffer, startIx, letti - startIx);
                int writtenBytes = channel.write(bb);
                if (writtenBytes == 0) {
                    channel.requestOutput();
                    continue;
                }
                startIx += writtenBytes;
            }
            this.count += letti;
        }
        channel.endStream();
    }
}

