/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.io.IOException;
import java.util.Set;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCORE;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsRuntimeException;

public class ConnettoreHTTPCORETransactionThreadContextSwitchEntityProducer<T extends AsyncEntityProducer>
implements AsyncEntityProducer {
    protected T wrapped;
    private ConnettoreHTTPCORE connettore;
    private boolean switchThreadContext = false;
    private String function;
    private BooleanNullable switchThreadLocalContextDoneHolder = BooleanNullable.FALSE();
    private boolean released = false;

    protected ConnettoreHTTPCORETransactionThreadContextSwitchEntityProducer(ConnettoreHTTPCORE connettore, T wrapped) {
        this.wrapped = wrapped;
        if (TransactionContext.isUseThreadLocal()) {
            this.switchThreadContext = true;
            this.connettore = connettore;
            this.function = "EntityProducer-" + this.wrapped.getClass().getName();
        }
    }

    public int available() {
        if (this.switchThreadContext) {
            try {
                this.connettore.checkThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return this.wrapped.available();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.switchThreadContext) {
            this.connettore.checkThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
        }
        this.wrapped.produce(channel);
    }

    public void releaseResources() {
        if (this.switchThreadContext && !this.released) {
            this.connettore.removeThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
            this.released = true;
        }
        this.wrapped.releaseResources();
    }

    public void failed(Exception e) {
        if (this.switchThreadContext && !this.released) {
            this.connettore.removeThreadLocalContext(this.function, this.switchThreadLocalContextDoneHolder);
            this.released = true;
        }
        this.wrapped.failed(e);
    }

    public String getContentEncoding() {
        return this.wrapped.getContentEncoding();
    }

    public long getContentLength() {
        return this.wrapped.getContentLength();
    }

    public String getContentType() {
        return this.wrapped.getContentType();
    }

    public Set<String> getTrailerNames() {
        return this.wrapped.getTrailerNames();
    }

    public boolean isChunked() {
        return this.wrapped.isChunked();
    }

    public boolean isRepeatable() {
        return this.wrapped.isRepeatable();
    }
}

