/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.Map;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.DatiTempiRisposta;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class ConnettoreUtilities {
    private ConnettoreUtilities() {
    }

    public static DatiTempiRisposta readDatiGlobaliTimeout(ConfigurazionePdDManager configPdDManager, TipoPdD tipoPdD, RequestInfo requestInfo, OpenSPCoop2Properties properties) throws DriverConfigurazioneException {
        AccessoConfigurazionePdD accessoConfigurazione = null;
        try {
            accessoConfigurazione = properties.getAccessoConfigurazionePdD();
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        ConfigurazioneGenerale configurazioneGenerale = null;
        if (accessoConfigurazione != null && "db".equalsIgnoreCase(accessoConfigurazione.getTipo())) {
            try {
                configurazioneGenerale = configPdDManager.getConfigurazioneControlloTraffico(requestInfo);
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
        if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
            return ConnettoreUtilities.readDatiGlobaliTimeoutFruizione(configurazioneGenerale, properties);
        }
        return ConnettoreUtilities.readDatiGlobaliTimeoutErogazione(configurazioneGenerale, properties);
    }

    private static DatiTempiRisposta readDatiGlobaliTimeoutFruizione(ConfigurazioneGenerale configurazioneGenerale, OpenSPCoop2Properties properties) {
        DatiTempiRisposta datiTempiRisposta = new DatiTempiRisposta();
        if (configurazioneGenerale != null && configurazioneGenerale.getTempiRispostaFruizione() != null) {
            if (configurazioneGenerale.getTempiRispostaFruizione().getConnectionTimeout() != null) {
                datiTempiRisposta.setConnectionTimeout(configurazioneGenerale.getTempiRispostaFruizione().getConnectionTimeout());
            } else {
                datiTempiRisposta.setConnectionTimeout(properties.getConnectionTimeoutInoltroBuste());
            }
            if (configurazioneGenerale.getTempiRispostaFruizione().getReadTimeout() != null) {
                datiTempiRisposta.setReadConnectionTimeout(configurazioneGenerale.getTempiRispostaFruizione().getReadTimeout());
            } else {
                datiTempiRisposta.setReadConnectionTimeout(properties.getReadConnectionTimeoutInoltroBuste());
            }
        } else {
            datiTempiRisposta.setConnectionTimeout(properties.getConnectionTimeoutInoltroBuste());
            datiTempiRisposta.setReadConnectionTimeout(properties.getReadConnectionTimeoutInoltroBuste());
        }
        return datiTempiRisposta;
    }

    private static DatiTempiRisposta readDatiGlobaliTimeoutErogazione(ConfigurazioneGenerale configurazioneGenerale, OpenSPCoop2Properties properties) {
        DatiTempiRisposta datiTempiRisposta = new DatiTempiRisposta();
        if (configurazioneGenerale != null && configurazioneGenerale.getTempiRispostaErogazione() != null) {
            if (configurazioneGenerale.getTempiRispostaErogazione().getConnectionTimeout() != null) {
                datiTempiRisposta.setConnectionTimeout(configurazioneGenerale.getTempiRispostaErogazione().getConnectionTimeout());
            } else {
                datiTempiRisposta.setConnectionTimeout(properties.getConnectionTimeoutConsegnaContenutiApplicativi());
            }
            if (configurazioneGenerale.getTempiRispostaErogazione().getReadTimeout() != null) {
                datiTempiRisposta.setReadConnectionTimeout(configurazioneGenerale.getTempiRispostaErogazione().getReadTimeout());
            } else {
                datiTempiRisposta.setReadConnectionTimeout(properties.getReadConnectionTimeoutConsegnaContenutiApplicativi());
            }
        } else {
            datiTempiRisposta.setConnectionTimeout(properties.getConnectionTimeoutConsegnaContenutiApplicativi());
            datiTempiRisposta.setReadConnectionTimeout(properties.getReadConnectionTimeoutConsegnaContenutiApplicativi());
        }
        return datiTempiRisposta;
    }

    public static DatiTempiRisposta readDatiTempiRisposta(TipoPdD tipoPdD, RequestInfo requestInfo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance();
        ConfigurazioneGenerale configurazioneGenerale = configPdDManager.getConfigurazioneControlloTraffico(requestInfo);
        DatiTempiRisposta datiTempiRisposta = new DatiTempiRisposta();
        if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
            datiTempiRisposta.setConnectionTimeout(configurazioneGenerale.getTempiRispostaFruizione().getConnectionTimeout());
            datiTempiRisposta.setReadConnectionTimeout(configurazioneGenerale.getTempiRispostaFruizione().getReadTimeout());
            datiTempiRisposta.setAvgResponseTime(configurazioneGenerale.getTempiRispostaFruizione().getTempoMedioRisposta());
        } else {
            datiTempiRisposta.setConnectionTimeout(configurazioneGenerale.getTempiRispostaErogazione().getConnectionTimeout());
            datiTempiRisposta.setReadConnectionTimeout(configurazioneGenerale.getTempiRispostaErogazione().getReadTimeout());
            datiTempiRisposta.setAvgResponseTime(configurazioneGenerale.getTempiRispostaErogazione().getTempoMedioRisposta());
        }
        return datiTempiRisposta;
    }

    public static void mergeTempiRisposta(DatiTempiRisposta datiTempiRisposta, Map<String, String> properties) {
        if (properties != null && properties.size() > 0) {
            Integer connectionTimeout = null;
            Integer readTimeout = null;
            Integer avgResponseTime = null;
            for (String key : properties.keySet()) {
                if (key.equals("connectionTimeout")) {
                    connectionTimeout = Integer.parseInt(properties.get(key));
                    continue;
                }
                if (key.endsWith("readConnectionTimeout")) {
                    readTimeout = Integer.parseInt(properties.get(key));
                    continue;
                }
                if (!key.endsWith("avgResponseTime")) continue;
                avgResponseTime = Integer.parseInt(properties.get(key));
            }
            if (connectionTimeout != null) {
                datiTempiRisposta.setConnectionTimeout(connectionTimeout);
            }
            if (readTimeout != null) {
                datiTempiRisposta.setReadConnectionTimeout(readTimeout);
            }
            if (avgResponseTime != null) {
                datiTempiRisposta.setAvgResponseTime(avgResponseTime);
            }
        }
    }

    public static DatiTempiRisposta getDatiTempiRisposta(InRequestProtocolContext context, DatiTransazione datiTransazione, RequestInfo requestInfo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        DatiTempiRisposta datiTempiRisposta = ConnettoreUtilities.readDatiTempiRisposta(context.getTipoPorta(), requestInfo);
        ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance();
        if (TipoPdD.DELEGATA.equals((Object)context.getTipoPorta())) {
            ConnettoreUtilities.setDatiTempiRispostaFruizione(configPdDManager, datiTempiRisposta, context, datiTransazione, requestInfo);
        } else {
            ConnettoreUtilities.setDatiTempiRispostaErogazione(configPdDManager, datiTempiRisposta, context, requestInfo);
        }
        return datiTempiRisposta;
    }

    private static void setDatiTempiRispostaFruizione(ConfigurazionePdDManager configPdDManager, DatiTempiRisposta datiTempiRisposta, InRequestProtocolContext context, DatiTransazione datiTransazione, RequestInfo requestInfo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        try {
            Connettore connettore = configPdDManager.getForwardRoute(datiTransazione.getSoggettoFruitore(), datiTransazione.getIdServizio(), false, requestInfo);
            ConnettoreUtilities.mergeTempiRisposta(datiTempiRisposta, connettore.getProperties());
        }
        catch (Exception e) {
            try {
                OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(OpenSPCoop2Properties.getInstance().isControlloTrafficoDebug()).error(e.getMessage(), (Throwable)e);
            }
            catch (Exception eLogger) {
                context.getLogCore().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void setDatiTempiRispostaErogazione(ConfigurazionePdDManager configPdDManager, DatiTempiRisposta datiTempiRisposta, InRequestProtocolContext context, RequestInfo requestInfo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        try {
            IDPortaApplicativa idPA;
            PortaApplicativa pa;
            if (context.getIntegrazione() != null && context.getIntegrazione().getIdPA() != null && (pa = configPdDManager.getPortaApplicativa(idPA = context.getIntegrazione().getIdPA(), requestInfo)).sizeServizioApplicativoList() > 0) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                idSA.setNome(pa.getServizioApplicativo(0).getNome());
                ServizioApplicativo sa = configPdDManager.getServizioApplicativo(idSA, requestInfo);
                ConnettoreUtilities.setConnettoreDatiTempiRispostaErogazione(context, sa, datiTempiRisposta);
            }
        }
        catch (Exception e) {
            try {
                OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(OpenSPCoop2Properties.getInstance().isControlloTrafficoDebug()).error(e.getMessage(), (Throwable)e);
            }
            catch (Exception eLogger) {
                context.getLogCore().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void setConnettoreDatiTempiRispostaErogazione(InRequestProtocolContext context, ServizioApplicativo sa, DatiTempiRisposta datiTempiRisposta) {
        Connettore connettore = null;
        String scenarioCooperazione = context.getProtocollo().getScenarioCooperazione();
        if (scenarioCooperazione != null) {
            if ("ConsegnaContenutiApplicativi".equals(scenarioCooperazione) || "AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione) || "AsincronoAsimmetrico_Polling".equals(scenarioCooperazione)) {
                if (sa.getRispostaAsincrona() != null) {
                    connettore = sa.getRispostaAsincrona().getConnettore();
                }
            } else if (sa.getInvocazioneServizio() != null) {
                connettore = sa.getInvocazioneServizio().getConnettore();
            }
        }
        if (connettore != null) {
            ConnettoreUtilities.mergeTempiRisposta(datiTempiRisposta, connettore.getProperties());
        }
    }
}

