/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.slf4j.Logger;

public class GeneratoreMessaggiDiagnostici {
    public static final int NUMERO_TEMPLATE_DINAMICI_ERRORI_GENERICI = 4;
    public static final int NUMERO_TEMPLATE_DINAMICI_DETTAGLI_SINGOLO_ERRORE = 10;
    public static final boolean saveSingleValueOfMessageError = false;

    public static void cleanPolicyValues(MsgDiagnostico msgDiag) throws Exception {
        Map<String, String> keywords = msgDiag.getKeywordLogPersonalizzati();
        if (keywords == null || keywords.size() <= 0) {
            return;
        }
        keywords.remove("@CT_POLICY_ACTIVE_ID@");
        keywords.remove("@CT_POLICY_ERROR_MSG@");
        keywords.remove("@CT_POLICY_FILTERED_REASON@");
        keywords.remove("@CT_POLICY_NOT_APPLICABLED_REASON@");
    }

    public static void emitDiagnostic(MsgDiagnostico msgDiag, String idDiagnostico, Logger log) {
        Map<String, String> keywords = msgDiag.getKeywordLogPersonalizzati();
        StringBuilder bf = new StringBuilder();
        try {
            if (keywords != null && keywords.size() > 0) {
                GeneratoreMessaggiDiagnostici.addNextValue(keywords, bf, "@CT_POLICY_ACTIVE_ID@");
                GeneratoreMessaggiDiagnostici.addNextValue(keywords, bf, "@CT_POLICY_ERROR_MSG@");
                GeneratoreMessaggiDiagnostici.addNextValue(keywords, bf, "@CT_POLICY_FILTERED_REASON@");
                GeneratoreMessaggiDiagnostici.addNextValue(keywords, bf, "@CT_POLICY_NOT_APPLICABLED_REASON@");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (bf.length() > 0) {
            msgDiag.getProperties().put("DYNAMIC_INFO_TYPE", "CT");
            msgDiag.getProperties().put("DYNAMIC_INFO_VALUE", bf.toString());
        }
        msgDiag.logPersonalizzato(idDiagnostico);
        if (bf.length() > 0) {
            msgDiag.getProperties().remove("DYNAMIC_INFO_TYPE");
            msgDiag.getProperties().remove("DYNAMIC_INFO_VALUE");
        }
    }

    private static void addNextValue(Map<String, String> keywords, StringBuilder bf, String keyId) throws Exception {
        if (bf.length() > 0) {
            bf.append("#_#");
        }
        if (keywords.containsKey(keyId)) {
            String v = keywords.get(keyId);
            if (v == null || v.length() <= 0) {
                bf.append("-");
            } else {
                if (v.contains("#_#")) {
                    throw new Exception("Valore [" + v + "] della chiave [" + keyId + "] non simulabile poich\u00e8 contiene il separatore [#_#]");
                }
                if (v.contains("###")) {
                    throw new Exception("Valore [" + v + "] della chiave [" + keyId + "] non simulabile poich\u00e8 contiene il separatore di diagnostici [###]");
                }
                bf.append(v);
            }
        } else {
            bf.append("-");
        }
    }

    public static Map<String, String> convertToProperties(String value) throws Exception {
        if (value.contains("#_#")) {
            String[] tmp = value.split("#_#");
            if (tmp == null || tmp.length <= 0) {
                throw new Exception("Split value [" + value + "] with [#_#] failed");
            }
            int NUMERO_TEMPLATE_DINAMICI = 4;
            if (tmp.length != NUMERO_TEMPLATE_DINAMICI) {
                throw new Exception("Split value [" + value + "] with [#_#] failed (expected:" + NUMERO_TEMPLATE_DINAMICI + " found:" + tmp.length + ")");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < tmp.length; ++i) {
                String v = tmp[i];
                if (v == null || v.length() == 1 && "-".equals(v)) continue;
                if (i == 0) {
                    map.put("@CT_POLICY_ACTIVE_ID@", v);
                    continue;
                }
                if (i == 1) {
                    map.put("@CT_POLICY_ERROR_MSG@", v);
                    continue;
                }
                if (i == 2) {
                    map.put("@CT_POLICY_FILTERED_REASON@", v);
                    continue;
                }
                if (i != 3) continue;
                map.put("@CT_POLICY_NOT_APPLICABLED_REASON@", v);
            }
            return map;
        }
        throw new Exception("Value is null");
    }
}

