/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico;

import java.util.List;
import org.openspcoop2.core.controllo_traffico.constants.TipoErrore;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.RisultatoVerificaPolicy;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

public class GeneratoreMessaggiErrore {
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE_SIMULTANEE = "controlloTraffico.policy.violata.risorsaNumeroRichieste.simultaneo";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE = "controlloTraffico.policy.violata.risorsaNumeroRichieste";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_OCCUPAZIONE_BANDA = "controlloTraffico.policy.violata.risorsaOccupazioneBanda";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_TEMPO_COMPLESSIVO = "controlloTraffico.policy.violata.risorsaTempoComplessivo";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_TEMPO_MEDIO = "controlloTraffico.policy.violata.risorsaTempoMedio";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO = "controlloTraffico.policy.violata.risorsaNumeroRichiesteCompletateConSuccesso";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE_FALLITE = "controlloTraffico.policy.violata.risorsaNumeroRichiesteFallite";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_FAULT_APPLICATIVI = "controlloTraffico.policy.violata.risorsaNumeroFaultApplicativi";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE_FALLITE_O_FAULT_APPLICATIVI = "controlloTraffico.policy.violata.risorsaNumeroRichiesteFalliteOFaultApplicativi";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_VIOLATA_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_O_FAULT_APPLICATIVI = "controlloTraffico.policy.violata.risorsaNumeroRichiesteCompletateConSuccessoOFaultApplicativi";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_PDD_NON_CONGESTIONATA = "controlloTraffico.policy.applicabilita.nonCongestionato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_PDD_NON_CONGESTIONATA_CONTROLLO_DISABILITATO = "controlloTraffico.policy.applicabilita.controlloCongestioneDisabilitato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_DEGRADO_PRESTAZIONALE_RILEVATO = "controlloTraffico.policy.applicabilita.degradoPrestazionale.rilevato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_DEGRADO_PRESTAZIONALE_NON_RILEVATO = "controlloTraffico.policy.applicabilita.degradoPrestazionale.nonRilevato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_STATO_ALLARME_RILEVATO = "controlloTraffico.policy.applicabilita.statoAllarme.rilevato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_POLICY_APPLICABILITA_STATO_ALLARME_NON_RILEVATO = "controlloTraffico.policy.applicabilita.statoAllarme.nonRilevato";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_MAXREQUESTS_VIOLATED = "controlloTraffico.maxRequestsViolated";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_MAXREQUESTS_VIOLATED_WARNING_ONLY = "controlloTraffico.maxRequestsViolatedWarningOnly";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_PDD_CONGESTIONATA = "controlloTraffico.pddCongestionata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_CONTROLLO_IN_CORSO = "controlloTraffico.policy.controlloInCorso";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_CONTROLLO_TERMINATO_CON_SUCCESSO = "controlloTraffico.policy.controlloTerminato.richiestaNonBloccata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_CONTROLLO_TERMINATO_CON_ERRORE = "controlloTraffico.policy.controlloTerminato.richiestaBloccata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_DISABILITATA = "controlloTraffico.policy.disabilitata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_FILTRATA = "controlloTraffico.policy.filtrata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_NON_APPLICABILE = "controlloTraffico.policy.nonApplicabile";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_VIOLATA = "controlloTraffico.policy.violata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_VIOLATA_WARNING_ONLY = "controlloTraffico.policy.violataWarningOnly";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_RISPETTATA = "controlloTraffico.policy.rispettata";
    public static final String MSG_DIAGNOSTICO_INTERCEPTOR_CONTROLLO_TRAFFICO_POLICY_IN_ERRORE = "controlloTraffico.policy.inErrore";
    public static final String TEMPLATE_MAX_THREADS_THRESHOLD = "@CT_MAX_THREADS_THRESHOLD@";
    public static final String TEMPLATE_CONTROLLO_TRAFFICO_THRESHOLD = "@CT_THRESHOLD@";
    public static final String TEMPLATE_ACTIVE_THREADS = "@CT_ACTIVE_THREADS@";
    public static final String TEMPLATE_NUMERO_POLICY = "@CT_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_DISABILITATE = "@CT_DISABLED_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_FILTRATE = "@CT_FILTERED_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_NON_APPLICATE = "@CT_NOT_APPLICABLED_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_RISPETTATE = "@CT_RESPECTED_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_VIOLATE = "@CT_VIOLATED_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_VIOLATE_WARNING_ONLY = "@CT_VIOLATED_WARNING_ONLY_POLICIES@";
    public static final String TEMPLATE_NUMERO_POLICY_IN_ERRORE = "@CT_ERROR_POLICIES@";
    public static final String TEMPLATE_POLICY_ACTIVE_ID = "@CT_POLICY_ACTIVE_ID@";
    public static final String TEMPLATE_POLICY_ACTIVE_TIPO = "@CT_POLICY_ACTIVE_TIPO@";
    public static final String TEMPLATE_POLICY_ACTIVE_ALIAS = "@CT_POLICY_ACTIVE_ALIAS@";
    public static final String TEMPLATE_POLICY_ACTIVE_RISORSA = "@CT_POLICY_ACTIVE_RISORSA@";
    public static final String TEMPLATE_POLICY_ACTIVE_CONTINUE = "@CT_POLICY_ACTIVE_CONTINUE@";
    public static final String TEMPLATE_POLICY_VIOLATA_MOTIVO = "@CT_POLICY_ERROR_MSG@";
    public static final String TEMPLATE_POLICY_FILTRATA_MOTIVO = "@CT_POLICY_FILTERED_REASON@";
    public static final String TEMPLATE_POLICY_NON_APPLICABILE_MOTIVO = "@CT_POLICY_NOT_APPLICABLED_REASON@";
    public static final String TEMPLATE_POLICY_FILTRATA_MOTIVO_FILTRO = "i dati della transazione non rispettano i criteri di filtro impostati: ";
    public static final String TEMPLATE_POLICY_FILTRATA_MOTIVO_BREAK = "rilevata precedente policy soddisfatta";
    public static final String TEMPLATE_POLICY_FILTRATA_MOTIVO_BREAK_VIOLATA = "rilevata precedente policy violata";
    public static final String TEMPLATE_POLICY_VALORE_SOGLIA = "@CT_SOGLIA@";
    public static final String TEMPLATE_POLICY_TIPOLOGIA_TEMPO_MEDIO = "@CT_TIPOLOGIA_TEMPO_MEDIO@";
    public static final String TEMPLATE_POLICY_VALORE_RILEVATO = "@CT_RILEVATO@";
    public static final String TEMPLATE_POLICY_AVG_TIME_RILEVATO = "@CT_AVG_TIME_RILEVATO@";
    public static final String TEMPLATE_POLICY_VALORE_SOGLIA_DEGRADO_PRESTAZIONALE = "@CT_DEGRADO_SOGLIA@";
    public static final String TEMPLATE_POLICY_GRUPPO = "@CT_DATI_IDENTIFICATIVI_GRUPPO@";
    public static final String TEMPLATE_POLICY_INTERVALLO_TEMPORALE = "@CT_INTERVALLO_TEMPORALE@";
    public static final String TEMPLATE_POLICY_NOME_ALLARME = "@CT_NOME_ALLARME@";
    public static final String TEMPLATE_POLICY_STATO_ALLARME = "@CT_STATO_ALLARME@";
    public static final String TEMPLATE_POLICY_STATO_ALLARME_ATTESO = "@CT_STATO_ALLARME_ATTESO@";
    private static final String SISTEMA_NON_DISPONIBILE = "Servizio Temporaneamente Non Erogabile";
    private static final String ERRORE_PROCESSAMENTO_CODE = "CC00";
    private static final String MAX_THREADS_VIOLATED_CODE = "CC01";
    private static final String ERRORE_GENERICO_DURANTE_VERIFICA = "ERR-";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_UNKNOW_TIPO = "CP00";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_SIMULTANEE_CODE = "CP01";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_CODE = "CP02";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_OCCUPAZIONE_BANDA_CODE = "CP03";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_TEMPO_COMPLESSIVO_CODE = "CP04";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_TEMPO_MEDIO_CODE = "CP05";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_CODE = "CP06";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_FALLITE_CODE = "CP07";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_FAULT_APPLICATIVI_CODE = "CP08";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_FALLITE_O_FAULT_APPLICATIVI_CODE = "CP09";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_DIMENSIONE_MASSIMA_MESSAGGIO_CODE = "CP10";
    private static final String CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_O_FAULT_APPLICATIVI_CODE = "CP11";
    private static final String APPLICABILITA_CONGESTIONE_CODE = "-CC";
    private static final String APPLICABILITA_DEGRADO_CODE = "-DP";
    private static final String APPLICABILITA_STATO_ALLARME_CODE = "-SA";
    public static final MapKey<String> PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE = org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE;
    private static final String PDD_CONTEXT_VALUE_GENERIC_ERROR = "controlloTrafficoGenericError";
    private static final String PDD_CONTEXT_VALUE_MAX_THREADS_VIOLATO = "controlloTrafficoNumeroMassimoRichiesteSimultaneeViolato";
    private static final String PDD_CONTEXT_VALUE_MAX_THREADS_VIOLATO_WARNING_ONLY = "controlloTrafficoNumeroMassimoRichiesteSimultaneeViolatoWarningOnly";
    private static final String PDD_CONTEXT_VALUE_POLICY_VIOLATA = "controlloTrafficoRateLimitingPolicyViolata";
    private static final String PDD_CONTEXT_VALUE_POLICY_VIOLATA_WARNING_ONLY = "controlloTrafficoRateLimitingPolicyViolataWarningOnly";
    private static final String PDD_CONTEXT_VALUE_POLICY_IN_ERRORE = "controlloTrafficoRateLimitingPolicyInErrore";
    public static final MapKey<String> PDD_CONTEXT_MAX_THREADS_THRESHOLD = Map.newMapKey((String)"CT_MAX_THREADS_THRESHOLD");
    public static final MapKey<String> PDD_CONTEXT_CONTROLLO_TRAFFICO_THRESHOLD = Map.newMapKey((String)"CT_THRESHOLD");
    public static final MapKey<String> PDD_CONTEXT_ACTIVE_THREADS = Map.newMapKey((String)"CT_ACTIVE_THREADS");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY = Map.newMapKey((String)"CT_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_DISABILITATE = Map.newMapKey((String)"CT_DISABLED_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_FILTRATE = Map.newMapKey((String)"CT_FILTERED_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_NON_APPLICATE = Map.newMapKey((String)"CT_NOT_APPLICABLED_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_RISPETTATE = Map.newMapKey((String)"CT_RESPECTED_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_VIOLATE = Map.newMapKey((String)"CT_VIOLATED_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_VIOLATE_WARNING_ONLY = Map.newMapKey((String)"CT_VIOLATED_WARNING_ONLY_POLICIES");
    public static final MapKey<String> PDD_CONTEXT_NUMERO_POLICY_IN_ERRORE = Map.newMapKey((String)"CT_ERROR_POLICIES");
    private static final String PDD_CONTEXT_VALUE_CONNECTION_TIMEOUT = "controlloTrafficoConnectionTimeout";
    private static final String PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT = "controlloTrafficoRequestReadTimeout";
    private static final String PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT = "controlloTrafficoResponseReadTimeout";
    private static final String PDD_CONTEXT_VALUE_READ_TIMEOUT = "controlloTrafficoReadTimeout";

    private GeneratoreMessaggiErrore() {
    }

    public static void addPddContextInfoControlloTrafficoGenericError(PdDContext pddContext) {
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, PDD_CONTEXT_VALUE_GENERIC_ERROR);
    }

    public static void addPddContextInfoControlloTrafficoMaxThreadsViolated(PdDContext pddContext, boolean warningOnly) {
        if (warningOnly) {
            pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, PDD_CONTEXT_VALUE_MAX_THREADS_VIOLATO_WARNING_ONLY);
        } else {
            pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, PDD_CONTEXT_VALUE_MAX_THREADS_VIOLATO);
        }
    }

    public static void addPddContextInfoControlloTrafficoPolicyViolated(PdDContext pddContext, boolean warningOnly) {
        GeneratoreMessaggiErrore.addContextInfoControlloTrafficoPolicyViolated(pddContext, warningOnly);
    }

    public static void addContextInfoControlloTrafficoPolicyViolated(Context context, boolean warningOnly) {
        if (warningOnly) {
            context.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_POLICY_VIOLATA_WARNING_ONLY);
        } else {
            context.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_POLICY_VIOLATA);
        }
    }

    public static void addPddContextInfoControlloTrafficoPolicyInError(PdDContext pddContext, EsitoTransazioneName esito) {
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, PDD_CONTEXT_VALUE_POLICY_IN_ERRORE);
        pddContext.addObject(org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_VALUE_POLICY_IN_ERROR_ESITO, esito);
    }

    public static boolean addPddContextInfoControlloTrafficoConnectionTimeout(Context pddContext) {
        if (GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_CONNECTION_TIMEOUT)) {
            return false;
        }
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_CONNECTION_TIMEOUT);
        return true;
    }

    public static boolean addPddContextInfoControlloTrafficoReadRequestTimeout(Context pddContext, boolean checkAll) {
        if (checkAll ? GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_READ_TIMEOUT, PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT, PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT) : GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT)) {
            return false;
        }
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT);
        return true;
    }

    public static boolean addPddContextInfoControlloTrafficoReadResponseTimeout(Context pddContext, boolean checkAll) {
        if (checkAll ? GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_READ_TIMEOUT, PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT, PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT) : GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT)) {
            return false;
        }
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT);
        return true;
    }

    public static boolean addPddContextInfoControlloTrafficoReadTimeout(Context pddContext, boolean checkAll) {
        if (checkAll ? GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_READ_TIMEOUT, PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT, PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT) : GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, PDD_CONTEXT_VALUE_READ_TIMEOUT)) {
            return false;
        }
        pddContext.addObject(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, (Object)PDD_CONTEXT_VALUE_READ_TIMEOUT);
        return true;
    }

    private static boolean alreadyExistsPddContextInfoControlloTrafficoTimeout(Context pddContext, String ... valore) {
        if (valore != null && valore.length > 0) {
            for (String v : valore) {
                if (!GeneratoreMessaggiErrore.alreadyExistsPddContextInfoControlloTrafficoTimeout(pddContext, v)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean alreadyExistsPddContextInfoControlloTrafficoTimeout(Context pddContext, String valore) {
        String tipo;
        if (pddContext.containsKey(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE) && (tipo = (String)pddContext.get(PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE)) != null) {
            return valore.equals(tipo);
        }
        return false;
    }

    public static HandlerException getErroreProcessamento(Exception e, PdDContext pddContext) {
        if (pddContext != null) {
            // empty if block
        }
        HandlerException he = new HandlerException("Servizio Temporaneamente Non Erogabile [CC00]", e);
        he.setCustomizedResponse(true);
        he.setCustomizedResponseAs4xxCode(false);
        he.setCustomizedResponseCode(ERRORE_PROCESSAMENTO_CODE);
        return he;
    }

    public static HandlerException getMaxThreadsViolated(String messaggioErroreInChiaro, boolean erroreGenerico, PdDContext pddContext) {
        if (pddContext != null) {
            // empty if block
        }
        HandlerException he = null;
        he = erroreGenerico ? new HandlerException("Servizio Temporaneamente Non Erogabile [CC01]") : new HandlerException(messaggioErroreInChiaro);
        he.setCustomizedResponse(true);
        he.setCustomizedResponseAs4xxCode(true);
        he.setCustomizedResponseCode(MAX_THREADS_VIOLATED_CODE);
        he.setIntegrationFunctionError(IntegrationFunctionError.TOO_MANY_REQUESTS);
        return he;
    }

    public static HandlerException getControlloTrafficoPolicyViolated(List<RisultatoVerificaPolicy> policyViolate, boolean erroreGenerico, PdDContext pddContext) {
        if (pddContext != null) {
            // empty if block
        }
        HandlerException he = null;
        StringBuilder bf = new StringBuilder();
        if (!erroreGenerico) {
            bf.append("Rilevate " + policyViolate.size() + " policy violate:\n");
        }
        boolean limitExceededConditionalCongestion = false;
        boolean limitExceededConditionalDeteriorationPerformance = false;
        boolean limitExceeded = false;
        boolean tooManyRequestsConditionalCongestion = false;
        boolean tooManyRequestsConditionalDeteriorationPerformance = false;
        boolean tooManyRequests = false;
        for (int i = 0; i < policyViolate.size(); ++i) {
            RisultatoVerificaPolicy risultato = policyViolate.get(i);
            if (!risultato.isErroreGenerico()) {
                if (risultato.isSimultanee()) {
                    if (risultato.isApplicabilitaCongestione()) {
                        tooManyRequestsConditionalCongestion = true;
                    } else if (risultato.isApplicabilitaDegradoPrestazionale()) {
                        tooManyRequestsConditionalDeteriorationPerformance = true;
                    } else if (risultato.isApplicabilitaStatoAllarme()) {
                        tooManyRequestsConditionalDeteriorationPerformance = true;
                    } else {
                        tooManyRequests = true;
                    }
                } else if (risultato.isApplicabilitaCongestione()) {
                    limitExceededConditionalCongestion = true;
                } else if (risultato.isApplicabilitaDegradoPrestazionale()) {
                    limitExceededConditionalDeteriorationPerformance = true;
                } else if (risultato.isApplicabilitaStatoAllarme()) {
                    limitExceededConditionalDeteriorationPerformance = true;
                } else {
                    limitExceeded = true;
                }
            } else {
                tooManyRequests = true;
            }
            if (erroreGenerico) {
                if (i > 0) {
                    bf.append(",");
                }
                bf.append(GeneratoreMessaggiErrore.toCode(risultato));
                continue;
            }
            if (i > 0) {
                bf.append("\n");
            }
            if (risultato.isErroreGenerico()) {
                bf.append("\tPolicy-" + (i + 1) + " (Errore interno) " + risultato.getDescrizione());
                continue;
            }
            bf.append("\tPolicy-" + (i + 1) + " (Violata) " + risultato.getDescrizione());
        }
        he = erroreGenerico ? new HandlerException("Servizio Temporaneamente Non Erogabile [" + bf.toString() + "]") : new HandlerException(bf.toString());
        he.setCustomizedResponse(true);
        he.setCustomizedResponseAs4xxCode(true);
        StringBuilder bfCode = new StringBuilder();
        for (int i = 0; i < policyViolate.size(); ++i) {
            RisultatoVerificaPolicy risultato = policyViolate.get(i);
            if (i > 0) {
                bfCode.append("_");
            }
            bfCode.append(GeneratoreMessaggiErrore.toCode(risultato));
        }
        he.setCustomizedResponseCode(bfCode.toString());
        if (limitExceeded) {
            he.setIntegrationFunctionError(IntegrationFunctionError.LIMIT_EXCEEDED);
        } else if (limitExceededConditionalCongestion) {
            he.setIntegrationFunctionError(IntegrationFunctionError.LIMIT_EXCEEDED_CONDITIONAL_CONGESTION);
        } else if (limitExceededConditionalDeteriorationPerformance) {
            he.setIntegrationFunctionError(IntegrationFunctionError.LIMIT_EXCEEDED_CONDITIONAL_DETERIORATION_PERFORMANCE);
        } else if (tooManyRequests) {
            he.setIntegrationFunctionError(IntegrationFunctionError.TOO_MANY_REQUESTS);
        } else if (tooManyRequestsConditionalCongestion) {
            he.setIntegrationFunctionError(IntegrationFunctionError.TOO_MANY_REQUESTS_CONDITIONAL_CONGESTION);
        } else if (tooManyRequestsConditionalDeteriorationPerformance) {
            he.setIntegrationFunctionError(IntegrationFunctionError.TOO_MANY_REQUESTS_CONDITIONAL_DETERIORATION_PERFORMANCE);
        } else {
            he.setIntegrationFunctionError(IntegrationFunctionError.TOO_MANY_REQUESTS);
        }
        return he;
    }

    private static String toCode(RisultatoVerificaPolicy risultato) {
        StringBuilder bf = new StringBuilder();
        if (risultato.isErroreGenerico()) {
            bf.append(ERRORE_GENERICO_DURANTE_VERIFICA);
        }
        if (risultato.getRisorsa() == null) {
            bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_UNKNOW_TIPO);
        } else {
            switch (risultato.getRisorsa()) {
                case NUMERO_RICHIESTE: {
                    if (risultato.isSimultanee()) {
                        bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_SIMULTANEE_CODE);
                        break;
                    }
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_CODE);
                    break;
                }
                case DIMENSIONE_MASSIMA_MESSAGGIO: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_DIMENSIONE_MASSIMA_MESSAGGIO_CODE);
                    break;
                }
                case OCCUPAZIONE_BANDA: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_OCCUPAZIONE_BANDA_CODE);
                    break;
                }
                case TEMPO_COMPLESSIVO_RISPOSTA: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_TEMPO_COMPLESSIVO_CODE);
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_TEMPO_MEDIO_CODE);
                    break;
                }
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_CODE);
                    break;
                }
                case NUMERO_RICHIESTE_FALLITE: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_FALLITE_CODE);
                    break;
                }
                case NUMERO_FAULT_APPLICATIVI: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_FAULT_APPLICATIVI_CODE);
                    break;
                }
                case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_FALLITE_O_FAULT_APPLICATIVI_CODE);
                    break;
                }
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                    bf.append(CONTROLLO_TRAFFICO_POLICY_VIOLATED_NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_O_FAULT_APPLICATIVI_CODE);
                }
            }
            if (risultato.isApplicabilitaCongestione()) {
                bf.append(APPLICABILITA_CONGESTIONE_CODE);
            }
            if (risultato.isApplicabilitaDegradoPrestazionale()) {
                bf.append(APPLICABILITA_DEGRADO_CODE);
            }
            if (risultato.isApplicabilitaStatoAllarme()) {
                bf.append(APPLICABILITA_STATO_ALLARME_CODE);
            }
        }
        return bf.toString();
    }

    public static void configureHandlerExceptionByTipoErrore(ServiceBinding serviceBinding, HandlerException he, TipoErrore tipoErroreParam, boolean includiDescrizioneErrore, Logger log) throws ProtocolException {
        TipoErrore tipoErrore = tipoErroreParam;
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            tipoErrore = TipoErrore.FAULT;
        }
        if (he == null) {
            throw new ProtocolException("HandlerException is null");
        }
        switch (tipoErrore) {
            case HTTP_429: {
                if (includiDescrizioneErrore) {
                    he.setResponseContentType("text/html");
                    String tipo = null;
                    if (he.getIntegrationFunctionError() != null) {
                        switch (he.getIntegrationFunctionError()) {
                            case LIMIT_EXCEEDED: 
                            case LIMIT_EXCEEDED_CONDITIONAL_CONGESTION: 
                            case LIMIT_EXCEEDED_CONDITIONAL_DETERIORATION_PERFORMANCE: {
                                tipo = CostantiControlloTraffico.HTML_429_LIMIT_EXCEEDED_ERROR;
                                break;
                            }
                            case TOO_MANY_REQUESTS: 
                            case TOO_MANY_REQUESTS_CONDITIONAL_CONGESTION: 
                            case TOO_MANY_REQUESTS_CONDITIONAL_DETERIORATION_PERFORMANCE: {
                                tipo = CostantiControlloTraffico.HTML_429_TOO_MANY_REQUESTS_ERROR;
                                break;
                            }
                            default: {
                                tipo = CostantiControlloTraffico.HTML_429_TOO_MANY_REQUESTS_ERROR;
                                break;
                            }
                        }
                    } else {
                        tipo = CostantiControlloTraffico.HTML_429_TOO_MANY_REQUESTS_ERROR;
                    }
                    String msgErrore = null;
                    ErroriProperties erroriProperties = ErroriProperties.getInstance((Logger)log);
                    boolean genericDetails = true;
                    IntegrationFunctionError functionError = IntegrationFunctionError.TOO_MANY_REQUESTS;
                    if (he.getIntegrationFunctionError() != null) {
                        functionError = he.getIntegrationFunctionError();
                    }
                    if (Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                        genericDetails = false;
                    }
                    msgErrore = !genericDetails ? he.getMessage() : erroriProperties.getGenericDetails(functionError);
                    String html = tipo.replace("MESSAGE", msgErrore);
                    he.setResponse(html.getBytes());
                } else {
                    he.setEmptyResponse(true);
                }
                he.setResponseCode("429");
                break;
            }
            case HTTP_503: {
                if (includiDescrizioneErrore) {
                    he.setResponseContentType("text/html");
                    String html = CostantiControlloTraffico.HTML_503_ERROR.replace("MESSAGE", he.getMessage());
                    he.setResponse(html.getBytes());
                } else {
                    he.setEmptyResponse(true);
                }
                he.setResponseCode("503");
                break;
            }
            case HTTP_500: {
                if (includiDescrizioneErrore) {
                    he.setResponseContentType("text/html");
                    String html = CostantiControlloTraffico.HTML_500_ERROR.replace("MESSAGE", he.getMessage());
                    he.setResponse(html.getBytes());
                } else {
                    he.setEmptyResponse(true);
                }
                he.setResponseCode("500");
                break;
            }
            case FAULT: {
                if (includiDescrizioneErrore) break;
                he.setCustomizedResponse(false);
            }
        }
    }
}

