/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.handler;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.ElencoIdPolicyAttive;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ConfigurazioneControlloTraffico;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.TipoErrore;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.driver.IGestorePolicyAttive;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.eventi.constants.CodiceEventoControlloTraffico;
import org.openspcoop2.core.eventi.constants.TipoEvento;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.ConnettoreUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.DatiTempiRisposta;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiDiagnostici;
import org.openspcoop2.pdd.core.controllo_traffico.GeneratoreMessaggiErrore;
import org.openspcoop2.pdd.core.controllo_traffico.GestoreControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.RisultatoVerificaPolicy;
import org.openspcoop2.pdd.core.controllo_traffico.StatoTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.policy.InterceptorPolicyUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyFiltroApplicativoUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyVerifier;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttive;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class InRequestProtocolHandlerGestioneControlloTraffico {
    private static Random rndEngine = null;

    private static synchronized void initRandom() {
        if (rndEngine == null) {
            rndEngine = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (rndEngine == null) {
            InRequestProtocolHandlerGestioneControlloTraffico.initRandom();
        }
        return rndEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InRequestProtocolContext context, Transaction tr) throws HandlerException {
        block103: {
            OpenSPCoop2Properties op2Properties;
            boolean registerThread;
            RequestInfo requestInfo;
            ServiceBinding serviceBinding;
            Logger log;
            ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico;
            boolean includiDescrizioneErrore;
            TipoErrore tipoErrore;
            ConfigurazionePdDManager configPdDManager;
            GestoreControlloTraffico gestoreControlloTraffico;
            PolicyConfiguration policyConfigurationHeaderHttp;
            PolicyConfiguration policyConfigurationPorta;
            PolicyConfiguration policyConfigurationGlobale;
            IGestorePolicyAttive gestorePolicyPorta;
            IGestorePolicyAttive gestorePolicyGlobale;
            DatiTransazione datiTransazione;
            boolean mapFromRequestInfo;
            Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttive;
            block102: {
                mapPolicyAttive = null;
                mapFromRequestInfo = false;
                datiTransazione = null;
                gestorePolicyGlobale = null;
                gestorePolicyPorta = null;
                policyConfigurationGlobale = null;
                policyConfigurationPorta = null;
                policyConfigurationHeaderHttp = null;
                gestoreControlloTraffico = null;
                configPdDManager = null;
                tipoErrore = TipoErrore.FAULT;
                includiDescrizioneErrore = true;
                configurazioneControlloTraffico = null;
                log = null;
                serviceBinding = ServiceBinding.REST;
                requestInfo = null;
                if (context != null && context.getPddContext() != null && context.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)context.getPddContext().getObject(Costanti.REQUEST_INFO);
                }
                registerThread = true;
                op2Properties = null;
                try {
                    op2Properties = OpenSPCoop2Properties.getInstance();
                    configurazioneControlloTraffico = op2Properties.getConfigurazioneControlloTraffico();
                    log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
                    if (context == null) {
                        throw new CoreException("InRequestProtocolContext is null");
                    }
                    datiTransazione = InterceptorPolicyUtilities.readDatiTransazione(context);
                    registerThread = InterceptorPolicyUtilities.checkRegisterThread(datiTransazione);
                    if (context != null && context.getMessaggio() != null && context.getMessaggio().getServiceBinding() != null) {
                        serviceBinding = context.getMessaggio().getServiceBinding();
                    }
                    if (!registerThread) break block102;
                    configPdDManager = ConfigurazionePdDManager.getInstance(context.getStato());
                    if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                        if (requestInfo.getRequestRateLimitingConfig().getNomePorta() == null && datiTransazione != null) {
                            requestInfo.getRequestRateLimitingConfig().setDatiPorta(context.getTipoPorta(), datiTransazione.getNomePorta(), datiTransazione.getIdServizio(), datiTransazione.getSoggettoFruitore());
                        }
                        if (requestInfo.getRequestRateLimitingConfig().getMapPolicyAttive() != null) {
                            mapPolicyAttive = requestInfo.getRequestRateLimitingConfig().getMapPolicyAttive();
                            mapFromRequestInfo = true;
                        }
                    }
                    if (!mapFromRequestInfo) {
                        mapPolicyAttive = new HashMap();
                        Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttiveAPI = null;
                        try {
                            mapPolicyAttiveAPI = configPdDManager.getElencoIdPolicyAttiveAPI(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), context.getTipoPorta(), datiTransazione.getNomePorta());
                        }
                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                            // empty catch block
                        }
                        if (mapPolicyAttiveAPI != null && !mapPolicyAttiveAPI.isEmpty()) {
                            for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttiveAPI.keySet()) {
                                ElencoIdPolicyAttive elencoPolicyAttiveAPI = mapPolicyAttiveAPI.get(tipoRisorsaPolicyAttiva);
                                if (elencoPolicyAttiveAPI == null) continue;
                                ElencoIdPolicyAttive cloned = (ElencoIdPolicyAttive)elencoPolicyAttiveAPI.clone();
                                mapPolicyAttive.put(tipoRisorsaPolicyAttiva, cloned);
                            }
                        }
                        Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> mapPolicyAttiveGlobali = null;
                        try {
                            mapPolicyAttiveGlobali = configPdDManager.getElencoIdPolicyAttiveGlobali(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache());
                        }
                        catch (DriverConfigurazioneNotFound tipoRisorsaPolicyAttiva) {
                            // empty catch block
                        }
                        if (mapPolicyAttiveGlobali != null && !mapPolicyAttiveGlobali.isEmpty()) {
                            for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttiveGlobali.keySet()) {
                                ElencoIdPolicyAttive elencoPolicyAttiveGlobali = mapPolicyAttiveGlobali.get(tipoRisorsaPolicyAttiva);
                                if (mapPolicyAttive.containsKey(tipoRisorsaPolicyAttiva)) {
                                    ElencoIdPolicyAttive elencoPolicyAttiveCloned = (ElencoIdPolicyAttive)mapPolicyAttive.get(tipoRisorsaPolicyAttiva);
                                    for (IdActivePolicy idActivePolicyGlobale : elencoPolicyAttiveGlobali.getIdActivePolicyList()) {
                                        elencoPolicyAttiveCloned.addIdActivePolicy(idActivePolicyGlobale);
                                    }
                                    continue;
                                }
                                ElencoIdPolicyAttive cloned = (ElencoIdPolicyAttive)elencoPolicyAttiveGlobali.clone();
                                mapPolicyAttive.put(tipoRisorsaPolicyAttiva, cloned);
                            }
                        }
                        if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                            requestInfo.getRequestRateLimitingConfig().setMapPolicyAttive(mapPolicyAttive);
                        }
                    }
                    policyConfigurationGlobale = configPdDManager.getConfigurazionePolicyRateLimitingGlobali(requestInfo);
                    context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_POLICY_CONFIG_GLOBALE, policyConfigurationGlobale);
                    PolicyConfiguration policyConfigurationApiInternal = null;
                    if (context.getIntegrazione() != null && context.getIntegrazione().getIdPD() != null) {
                        PortaDelegata pd = configPdDManager.getPortaDelegata(context.getIntegrazione().getIdPD(), requestInfo);
                        policyConfigurationApiInternal = new PolicyConfiguration(pd.getProprietaRateLimitingList());
                    } else if (context.getIntegrazione() != null && context.getIntegrazione().getIdPA() != null) {
                        PortaApplicativa pa = configPdDManager.getPortaApplicativa(context.getIntegrazione().getIdPA(), requestInfo);
                        policyConfigurationApiInternal = new PolicyConfiguration(pa.getProprietaRateLimitingList());
                    }
                    if (policyConfigurationApiInternal == null) {
                        throw new CoreException("Policy configuration not found");
                    }
                    policyConfigurationPorta = policyConfigurationApiInternal.isGestionePolicyRidefinita() ? policyConfigurationApiInternal : policyConfigurationGlobale;
                    context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_POLICY_CONFIG_PORTA, policyConfigurationPorta);
                    policyConfigurationHeaderHttp = policyConfigurationApiInternal.isGestioneHttpHeadersRidefinita() ? policyConfigurationApiInternal : policyConfigurationGlobale;
                    gestorePolicyPorta = GestorePolicyAttive.getInstance(policyConfigurationPorta.getType());
                    gestorePolicyGlobale = GestorePolicyAttive.getInstance(policyConfigurationGlobale.getType());
                    gestoreControlloTraffico = GestoreControlloTraffico.getInstance();
                    ConfigurazioneGenerale configurazioneGenerale = configPdDManager.getConfigurazioneControlloTraffico(requestInfo);
                    if (configurazioneGenerale.getRateLimiting() != null) {
                        TipoErrore tipoErrorTmp;
                        if (configurazioneGenerale.getRateLimiting().getTipoErrore() != null && (tipoErrorTmp = TipoErrore.toEnumConstant((String)configurazioneGenerale.getRateLimiting().getTipoErrore())) != null) {
                            tipoErrore = tipoErrorTmp;
                        }
                        includiDescrizioneErrore = configurazioneGenerale.getRateLimiting().isTipoErroreIncludiDescrizione();
                    }
                }
                catch (Exception e) {
                    throw new HandlerException("Configurazione non disponibile: " + e.getMessage(), e);
                }
            }
            if (registerThread) {
                try {
                    MsgDiagnostico msgDiag = this.buildMsgDiagnostico(context);
                    boolean pddCongestionata = this.isCondizioneCongestionamentoPortaDominio(context, gestoreControlloTraffico, msgDiag, tr);
                    if (mapPolicyAttive == null || mapPolicyAttive.isEmpty()) break block103;
                    msgDiag.logPersonalizzato("controlloTraffico.policy.controlloInCorso");
                    int policyTotali = 0;
                    int policyDisabilitate = 0;
                    int policyFiltrate = 0;
                    int policyNonApplicabili = 0;
                    int policyRispettate = 0;
                    int policyViolate = 0;
                    int policyViolateWarningOnly = 0;
                    int policyInErrore = 0;
                    ArrayList<RisultatoVerificaPolicy> policyBloccanti = new ArrayList<RisultatoVerificaPolicy>();
                    ArrayList<String> pddContextUniqueIdsPolicy = new ArrayList<String>();
                    ArrayList<IDUnivocoGroupByPolicy> pddContextIdUnivociGroupBy = new ArrayList<IDUnivocoGroupByPolicy>();
                    ArrayList<Boolean> pddContextPolicyApplicabile = new ArrayList<Boolean>();
                    ArrayList<Boolean> pddContextPolicyViolata = new ArrayList<Boolean>();
                    ArrayList<String> pddContextApi = new ArrayList<String>();
                    DatiTempiRisposta datiTempiRisposta = null;
                    ArrayList<RisultatoVerificaPolicy> risultatiVerificaPolicyViolate = new ArrayList<RisultatoVerificaPolicy>();
                    HashMap<TipoRisorsa, List<RisultatoVerificaPolicy>> risultatiVerificaPolicyRispettate = new HashMap<TipoRisorsa, List<RisultatoVerificaPolicy>>();
                    for (TipoRisorsa tipoRisorsa : TipoRisorsa.values()) {
                        risultatiVerificaPolicyRispettate.put(tipoRisorsa, new ArrayList());
                    }
                    try {
                        for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : mapPolicyAttive.keySet()) {
                            ElencoIdPolicyAttive elencoPolicyAttivePerRisorsa = (ElencoIdPolicyAttive)mapPolicyAttive.get(tipoRisorsaPolicyAttiva);
                            msgDiag.addKeyword("@CT_POLICY_ACTIVE_RISORSA@", tipoRisorsaPolicyAttiva.getValue());
                            boolean policyRispettataCheRichiedeBreak = false;
                            boolean policyViolataBreak = false;
                            for (IdActivePolicy idActive : elencoPolicyAttivePerRisorsa.getIdActivePolicyList()) {
                                block104: {
                                    ++policyTotali;
                                    msgDiag.addKeyword("@CT_POLICY_ACTIVE_ID@", idActive.getNome());
                                    try {
                                        if (idActive.isEnabled()) {
                                            boolean matchFiltro;
                                            AttivazionePolicy attivazionePolicy = null;
                                            try {
                                                String id = UniqueIdentifierUtilities.getUniqueId((IdActivePolicy)idActive);
                                                if (mapFromRequestInfo) {
                                                    attivazionePolicy = requestInfo.getRequestRateLimitingConfig().getAttivazionePolicy(id);
                                                }
                                                if (attivazionePolicy == null) {
                                                    attivazionePolicy = configPdDManager.getAttivazionePolicy(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), id);
                                                    if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                                                        requestInfo.getRequestRateLimitingConfig().addAttivazionePolicy(id, attivazionePolicy);
                                                    }
                                                }
                                            }
                                            catch (DriverConfigurazioneNotFound notFound) {
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_ALIAS@", idActive.getNome());
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_TIPO@", "");
                                                throw new CoreException("Istanza di Policy con id [" + idActive.getNome() + "] non esistente: " + notFound.getMessage(), (Throwable)notFound);
                                            }
                                            if (attivazionePolicy == null) {
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_ALIAS@", idActive.getNome());
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_TIPO@", "");
                                                throw new CoreException("Istanza di Policy con id [" + idActive.getNome() + "] non esistente?");
                                            }
                                            msgDiag.addKeyword("@CT_POLICY_ACTIVE_ALIAS@", PolicyUtilities.getNomeActivePolicy((String)attivazionePolicy.getAlias(), (String)attivazionePolicy.getIdActivePolicy()));
                                            if (attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getNomePorta() != null && !"".equals(attivazionePolicy.getFiltro().getNomePorta())) {
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_TIPO@", "API");
                                            } else {
                                                msgDiag.addKeyword("@CT_POLICY_ACTIVE_TIPO@", "Globale");
                                            }
                                            boolean bl = matchFiltro = !policyRispettataCheRichiedeBreak && !policyViolataBreak && InterceptorPolicyUtilities.filter(attivazionePolicy.getFiltro(), datiTransazione, context.getStato(), requestInfo);
                                            if (matchFiltro) {
                                                String valorePresente;
                                                if (attivazionePolicy.getFiltro().isEnabled() && attivazionePolicy.getFiltro().isInformazioneApplicativaEnabled() && ((valorePresente = PolicyFiltroApplicativoUtilities.getValore(log, attivazionePolicy.getFiltro().getInformazioneApplicativaTipo(), attivazionePolicy.getFiltro().getInformazioneApplicativaNome(), context, datiTransazione, true)) == null || !valorePresente.equals(attivazionePolicy.getFiltro().getInformazioneApplicativaValore()))) {
                                                    ++policyFiltrate;
                                                    if (valorePresente == null) {
                                                        valorePresente = "n.d.";
                                                    }
                                                    msgDiag.addKeyword("@CT_POLICY_FILTERED_REASON@", "Filtro Applicativo atteso [" + attivazionePolicy.getFiltro().getInformazioneApplicativaValore() + "] differente da quello estratto dalla transazione [" + valorePresente + "]");
                                                    GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.filtrata", log);
                                                    matchFiltro = false;
                                                }
                                                if (!matchFiltro) break block104;
                                                ConfigurazionePolicy configurazionePolicy = null;
                                                try {
                                                    String id = idActive.getIdPolicy();
                                                    if (mapFromRequestInfo) {
                                                        configurazionePolicy = requestInfo.getRequestRateLimitingConfig().getConfigurazionePolicy(id);
                                                    }
                                                    if (configurazionePolicy == null) {
                                                        configurazionePolicy = configPdDManager.getConfigurazionePolicy(configurazioneControlloTraffico.isPolicyReadedWithDynamicCache(), id);
                                                        if (requestInfo != null && requestInfo.getRequestRateLimitingConfig() != null) {
                                                            requestInfo.getRequestRateLimitingConfig().addConfigurazionePolicy(id, configurazionePolicy);
                                                        }
                                                    }
                                                }
                                                catch (DriverConfigurazioneNotFound notFound) {
                                                    throw new CoreException("Policy con id [" + idActive.getIdPolicy() + "] non esistente: " + notFound.getMessage(), (Throwable)notFound);
                                                }
                                                if (configurazionePolicy == null) {
                                                    throw new CoreException("Policy con id [" + idActive.getIdPolicy() + "] non esistente?");
                                                }
                                                ActivePolicy activePolicy = new ActivePolicy();
                                                activePolicy.setInstanceConfiguration(attivazionePolicy);
                                                activePolicy.setConfigurazionePolicy(configurazionePolicy);
                                                activePolicy.setTipoRisorsaPolicy(TipoRisorsa.toEnumConstant((String)configurazionePolicy.getRisorsa(), (boolean)true));
                                                activePolicy.setConfigurazioneControlloTraffico((ConfigurazioneControlloTraffico)configurazioneControlloTraffico);
                                                IDUnivocoGroupByPolicy idUnivocoGroupBy = InterceptorPolicyUtilities.convertToID(log, datiTransazione, attivazionePolicy.getGroupBy(), context);
                                                pddContextIdUnivociGroupBy.add(idUnivocoGroupBy);
                                                pddContextUniqueIdsPolicy.add(UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)attivazionePolicy));
                                                if (datiTempiRisposta == null) {
                                                    datiTempiRisposta = ConnettoreUtilities.getDatiTempiRisposta(context, datiTransazione, requestInfo);
                                                }
                                                IGestorePolicyAttive gestorePolicy = null;
                                                PolicyConfiguration policyConfiguration = null;
                                                if (attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getNomePorta() != null && !"".equals(attivazionePolicy.getFiltro().getNomePorta())) {
                                                    gestorePolicy = gestorePolicyPorta;
                                                    policyConfiguration = policyConfigurationPorta;
                                                    TipoRisorsaPolicyAttiva tipoRisorsaPolicy = TipoRisorsaPolicyAttiva.getTipo((TipoRisorsa)activePolicy.getTipoRisorsaPolicy(), (boolean)configurazionePolicy.isSimultanee());
                                                    if (!gestorePolicy.getType().isSupportedResource(tipoRisorsaPolicy)) {
                                                        log.error("Riscontrata policy '" + attivazionePolicy.getIdActivePolicy() + "' (alias:" + attivazionePolicy.getAlias() + ") non compatibile con il tipo di gestore '" + String.valueOf(gestorePolicy.getType()) + "'; verr\u00e0 utilizzato il gestore di default");
                                                        policyConfiguration = new PolicyConfiguration(true);
                                                        gestorePolicy = GestorePolicyAttive.getInstance(policyConfiguration.getType());
                                                        pddContextApi.add("DEFAULT");
                                                    } else {
                                                        pddContextApi.add("API");
                                                    }
                                                } else {
                                                    gestorePolicy = gestorePolicyGlobale;
                                                    policyConfiguration = policyConfigurationGlobale;
                                                    pddContextApi.add("GLOBAL");
                                                }
                                                RisultatoVerificaPolicy risultatoVerifica = PolicyVerifier.verifica(configPdDManager, context.getProtocolFactory(), gestorePolicy, policyConfiguration, log, activePolicy, idUnivocoGroupBy, context.getPddContext(), msgDiag, tr, datiTransazione, pddCongestionata, datiTempiRisposta, pddContextPolicyApplicabile, pddContextPolicyViolata, context.getStato());
                                                if (risultatoVerifica.isErroreGenerico()) {
                                                    ++policyInErrore;
                                                    log.error("Errore durante il controllo della policy con id[" + idActive.getNome() + "]: " + risultatoVerifica.getDescrizione());
                                                    msgDiag.addKeyword("@CT_POLICY_ERROR_MSG@", risultatoVerifica.getDescrizione());
                                                    GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.inErrore", log);
                                                    policyBloccanti.add(risultatoVerifica);
                                                } else if (risultatoVerifica.isNonApplicabile()) {
                                                    ++policyNonApplicabili;
                                                    msgDiag.addKeyword("@CT_POLICY_NOT_APPLICABLED_REASON@", risultatoVerifica.getDescrizione());
                                                    GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.nonApplicabile", log);
                                                } else if (risultatoVerifica.isViolata()) {
                                                    risultatiVerificaPolicyViolate.add(risultatoVerifica);
                                                    if (risultatoVerifica.isWarningOnly()) {
                                                        ++policyViolateWarningOnly;
                                                        msgDiag.addKeyword("@CT_POLICY_ERROR_MSG@", risultatoVerifica.getDescrizione());
                                                        GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.violataWarningOnly", log);
                                                    } else {
                                                        ++policyViolate;
                                                        msgDiag.addKeyword("@CT_POLICY_ERROR_MSG@", risultatoVerifica.getDescrizione());
                                                        GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.violata", log);
                                                        policyBloccanti.add(risultatoVerifica);
                                                    }
                                                    policyViolataBreak = true;
                                                } else {
                                                    msgDiag.addKeyword("@CT_POLICY_ACTIVE_CONTINUE@", "" + attivazionePolicy.isContinuaValutazione());
                                                    ((List)risultatiVerificaPolicyRispettate.get(risultatoVerifica.getRisorsa())).add(risultatoVerifica);
                                                    GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.rispettata", log);
                                                    ++policyRispettate;
                                                    if (!attivazionePolicy.isContinuaValutazione()) {
                                                        policyRispettataCheRichiedeBreak = true;
                                                    }
                                                }
                                                break block104;
                                            }
                                            ++policyFiltrate;
                                            if (policyRispettataCheRichiedeBreak) {
                                                msgDiag.addKeyword("@CT_POLICY_FILTERED_REASON@", "rilevata precedente policy soddisfatta");
                                            } else if (policyViolataBreak) {
                                                msgDiag.addKeyword("@CT_POLICY_FILTERED_REASON@", "rilevata precedente policy violata");
                                            } else {
                                                msgDiag.addKeyword("@CT_POLICY_FILTERED_REASON@", "i dati della transazione non rispettano i criteri di filtro impostati: " + PolicyUtilities.toStringFilter((AttivazionePolicyFiltro)attivazionePolicy.getFiltro()));
                                            }
                                            GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.filtrata", log);
                                            break block104;
                                        }
                                        ++policyDisabilitate;
                                        GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.disabilitata", log);
                                    }
                                    catch (Throwable e) {
                                        ++policyInErrore;
                                        Throwable tConMessaggio = Utilities.getInnerNotEmptyMessageException((Throwable)e);
                                        String eMessaggio = tConMessaggio.getMessage();
                                        if (eMessaggio == null || "".equals(eMessaggio) || "null".equalsIgnoreCase(eMessaggio)) {
                                            eMessaggio = "Internal Error";
                                        }
                                        log.error("Errore durante il controllo della policy con id[" + idActive.getNome() + "]: " + eMessaggio, e);
                                        msgDiag.addKeyword("@CT_POLICY_ERROR_MSG@", eMessaggio);
                                        GeneratoreMessaggiDiagnostici.emitDiagnostic(msgDiag, "controlloTraffico.policy.inErrore", log);
                                        RisultatoVerificaPolicy policyError = new RisultatoVerificaPolicy();
                                        policyError.setErroreGenerico(true);
                                        policyError.setDescrizione(eMessaggio);
                                        policyBloccanti.add(policyError);
                                    }
                                }
                                GeneratoreMessaggiDiagnostici.cleanPolicyValues(msgDiag);
                            }
                        }
                    }
                    finally {
                        if (!pddContextIdUnivociGroupBy.isEmpty()) {
                            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_LIST_GROUP_BY_CONDITION, pddContextIdUnivociGroupBy);
                            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_LIST_UNIQUE_ID_POLICY, pddContextUniqueIdsPolicy);
                            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_LIST_POLICY_APPLICABILE, pddContextPolicyApplicabile);
                            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_LIST_POLICY_VIOLATA, pddContextPolicyViolata);
                            context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_LIST_API_OR_GLOBAL_OR_DEFAULT, pddContextApi);
                        }
                    }
                    Properties headerTrasportoRateLimiting = new Properties();
                    if (!risultatiVerificaPolicyViolate.isEmpty()) {
                        long ms = -1L;
                        HashMap<TipoRisorsa, List<RisultatoVerificaPolicy>> risultatiVerificaPolicyViolateMap = new HashMap<TipoRisorsa, List<RisultatoVerificaPolicy>>();
                        for (RisultatoVerificaPolicy risultatoVerificaPolicy : risultatiVerificaPolicyViolate) {
                            long tmp;
                            List<RisultatoVerificaPolicy> l = null;
                            if (risultatiVerificaPolicyViolateMap.containsKey(risultatoVerificaPolicy.getRisorsa())) {
                                l = (List)risultatiVerificaPolicyViolateMap.get(risultatoVerificaPolicy.getRisorsa());
                            } else {
                                l = new ArrayList();
                                risultatiVerificaPolicyViolateMap.put(risultatoVerificaPolicy.getRisorsa(), l);
                            }
                            l.add(risultatoVerificaPolicy);
                            if (risultatoVerificaPolicy.getMsBeforeResetCounters() == null || (tmp = risultatoVerificaPolicy.getMsBeforeResetCounters().longValue()) <= ms) continue;
                            ms = tmp;
                        }
                        if (ms > 0L) {
                            long sec = -1L;
                            if (ms > 1000L) {
                                sec = ms / 1000L;
                            } else if (ms > 0L) {
                                sec = 1L;
                            }
                            if (!policyConfigurationHeaderHttp.isDisabledHttpHeaders_retryAfter()) {
                                String[] headers;
                                if (!policyConfigurationHeaderHttp.isForceDisabledHttpHeaders_retryAfter_backoff()) {
                                    if (policyConfigurationHeaderHttp.getForceHttpHeaders_retryAfter_backoff() > 0) {
                                        sec += (long)InRequestProtocolHandlerGestioneControlloTraffico.getRandom().nextInt(policyConfigurationHeaderHttp.getForceHttpHeaders_retryAfter_backoff());
                                    } else if (op2Properties.getControlloTrafficoRetryAfterHeaderRandomBackoff() != null && op2Properties.getControlloTrafficoRetryAfterHeaderRandomBackoff() > 0) {
                                        sec += (long)InRequestProtocolHandlerGestioneControlloTraffico.getRandom().nextInt(op2Properties.getControlloTrafficoRetryAfterHeaderRandomBackoff());
                                    }
                                }
                                if ((headers = op2Properties.getControlloTrafficoRetryAfterHeader()) != null && headers.length > 0) {
                                    for (String header : headers) {
                                        headerTrasportoRateLimiting.put(header, "" + sec);
                                    }
                                }
                            }
                        }
                        if (risultatiVerificaPolicyViolateMap.size() > 0) {
                            this.gestioneHeaderRateLimit(risultatiVerificaPolicyViolateMap, headerTrasportoRateLimiting, op2Properties, policyConfigurationHeaderHttp);
                        }
                    } else if (risultatiVerificaPolicyRispettate.size() > 0) {
                        this.gestioneHeaderRateLimit(risultatiVerificaPolicyRispettate, headerTrasportoRateLimiting, op2Properties, policyConfigurationHeaderHttp);
                    }
                    if (headerTrasportoRateLimiting.size() > 0) {
                        context.getPddContext().addObject(CostantiControlloTraffico.PDD_CONTEXT_HEADER_RATE_LIMITING, headerTrasportoRateLimiting);
                    }
                    msgDiag.addKeyword("@CT_POLICIES@", "" + policyTotali);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY, policyTotali);
                    msgDiag.addKeyword("@CT_DISABLED_POLICIES@", "" + policyDisabilitate);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_DISABILITATE, policyDisabilitate);
                    msgDiag.addKeyword("@CT_FILTERED_POLICIES@", "" + policyFiltrate);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_FILTRATE, policyFiltrate);
                    msgDiag.addKeyword("@CT_NOT_APPLICABLED_POLICIES@", "" + policyNonApplicabili);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_NON_APPLICATE, policyNonApplicabili);
                    msgDiag.addKeyword("@CT_RESPECTED_POLICIES@", "" + policyRispettate);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_RISPETTATE, policyRispettate);
                    msgDiag.addKeyword("@CT_VIOLATED_POLICIES@", "" + policyViolate);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_VIOLATE, policyViolate);
                    msgDiag.addKeyword("@CT_VIOLATED_WARNING_ONLY_POLICIES@", "" + policyViolateWarningOnly);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_VIOLATE_WARNING_ONLY, policyViolateWarningOnly);
                    msgDiag.addKeyword("@CT_ERROR_POLICIES@", "" + policyInErrore);
                    context.getPddContext().addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_NUMERO_POLICY_IN_ERRORE, policyInErrore);
                    if (policyViolate > 0 || policyInErrore > 0) {
                        msgDiag.logPersonalizzato("controlloTraffico.policy.controlloTerminato.richiestaBloccata");
                        if (policyInErrore > 0) {
                            EsitoTransazioneName esito = op2Properties.getControlloTrafficoEsitiPolicyElaborazioneInErrore(EsitiProperties.getInstance((Logger)log, context.getProtocolFactory()));
                            if (EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA.equals((Object)esito)) {
                                GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoPolicyViolated(context.getPddContext(), false);
                            } else {
                                GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoPolicyInError(context.getPddContext(), esito);
                            }
                        } else {
                            GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoPolicyViolated(context.getPddContext(), false);
                        }
                        HandlerException he = GeneratoreMessaggiErrore.getControlloTrafficoPolicyViolated(policyBloccanti, configurazioneControlloTraffico.isErroreGenerico(), context.getPddContext());
                        he.setEmettiDiagnostico(false);
                        GeneratoreMessaggiErrore.configureHandlerExceptionByTipoErrore(serviceBinding, he, tipoErrore, includiDescrizioneErrore, log);
                        throw he;
                    }
                    if (policyViolateWarningOnly > 0) {
                        GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoPolicyViolated(context.getPddContext(), true);
                        msgDiag.logPersonalizzato("controlloTraffico.policy.controlloTerminato.richiestaNonBloccata");
                    } else {
                        msgDiag.logPersonalizzato("controlloTraffico.policy.controlloTerminato.richiestaNonBloccata");
                    }
                }
                catch (HandlerException e) {
                    throw e;
                }
                catch (Exception e) {
                    GeneratoreMessaggiErrore.addPddContextInfoControlloTrafficoGenericError(context.getPddContext());
                    throw GeneratoreMessaggiErrore.getErroreProcessamento(e, context.getPddContext());
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void gestioneHeaderRateLimit(Map<TipoRisorsa, List<RisultatoVerificaPolicy>> risultatiVerificaPolicy, Properties headerTrasportoRateLimiting, OpenSPCoop2Properties op2Properties, PolicyConfiguration policyConfigurationPorta) {
        if (policyConfigurationPorta.isDisabledHttpHeaders()) {
            return;
        }
        for (TipoRisorsa tipoRisorsa : risultatiVerificaPolicy.keySet()) {
            int n;
            String[] headers2;
            List<RisultatoVerificaPolicy> risultato = risultatiVerificaPolicy.get(tipoRisorsa);
            String[] risultatoUtilizzato = null;
            String[] risultatoUtilizzatoSimultanee = null;
            ArrayList<String[]> altrePolicy = new ArrayList<String[]>();
            ArrayList<String[]> altrePolicySimultanee = new ArrayList<String[]>();
            for (String[] risultatoVerificaPolicy : risultato) {
                boolean switchPolicy;
                long numeroCheck;
                long numeroRimasti;
                if (TipoRisorsa.NUMERO_RICHIESTE.equals((Object)tipoRisorsa) && risultatoVerificaPolicy.isSimultanee()) {
                    if (risultatoUtilizzatoSimultanee == null) {
                        risultatoUtilizzatoSimultanee = risultatoVerificaPolicy;
                        continue;
                    }
                    numeroRimasti = -1L;
                    if (risultatoUtilizzatoSimultanee.getMaxValue() != null) {
                        numeroRimasti = risultatoUtilizzatoSimultanee.getMaxValue();
                    }
                    numeroCheck = -1L;
                    if (risultatoVerificaPolicy.getMaxValue() != null) {
                        numeroCheck = risultatoVerificaPolicy.getMaxValue();
                    }
                    switchPolicy = false;
                    if (numeroCheck > 0L) {
                        if (numeroRimasti > 0L) {
                            if (numeroCheck < numeroRimasti) {
                                altrePolicySimultanee.add(risultatoUtilizzatoSimultanee);
                                risultatoUtilizzatoSimultanee = risultatoVerificaPolicy;
                                switchPolicy = true;
                            }
                        } else {
                            altrePolicySimultanee.add(risultatoUtilizzatoSimultanee);
                            risultatoUtilizzatoSimultanee = risultatoVerificaPolicy;
                            switchPolicy = true;
                        }
                    }
                    if (switchPolicy) continue;
                    altrePolicySimultanee.add(risultatoVerificaPolicy);
                    continue;
                }
                if (risultatoUtilizzato == null) {
                    risultatoUtilizzato = risultatoVerificaPolicy;
                    continue;
                }
                numeroRimasti = -1L;
                if (risultatoUtilizzato.getMaxValue() != null) {
                    numeroRimasti = risultatoUtilizzato.getMaxValue();
                }
                numeroCheck = -1L;
                if (risultatoVerificaPolicy.getMaxValue() != null) {
                    numeroCheck = risultatoVerificaPolicy.getMaxValue();
                }
                switchPolicy = false;
                if (numeroCheck > 0L) {
                    if (numeroRimasti > 0L) {
                        if (numeroCheck < numeroRimasti) {
                            altrePolicy.add(risultatoUtilizzato);
                            risultatoUtilizzato = risultatoVerificaPolicy;
                            switchPolicy = true;
                        }
                    } else {
                        altrePolicy.add(risultatoUtilizzato);
                        risultatoUtilizzato = risultatoVerificaPolicy;
                        switchPolicy = true;
                    }
                }
                if (switchPolicy) continue;
                altrePolicy.add(risultatoVerificaPolicy);
            }
            if (!policyConfigurationPorta.isDisabledHttpHeaders_limit() && risultatoUtilizzatoSimultanee != null && risultatoUtilizzatoSimultanee.getMaxValue() != null) {
                try {
                    headers2 = op2Properties.getControlloTrafficoNumeroRichiesteSimultaneeHeaderLimit();
                    if (headers2 != null && headers2.length > 0) {
                        for (String header : headers2) {
                            headerTrasportoRateLimiting.put(header, "" + risultatoUtilizzatoSimultanee.getMaxValue());
                        }
                    }
                }
                catch (Exception headers2) {
                    // empty catch block
                }
                if (risultatoUtilizzatoSimultanee.getActualValue() != null) {
                    long rimanenti = risultatoUtilizzatoSimultanee.getMaxValue() - risultatoUtilizzatoSimultanee.getActualValue();
                    if (rimanenti < 0L) {
                        rimanenti = 0L;
                    }
                    try {
                        String[] headers3 = op2Properties.getControlloTrafficoNumeroRichiesteSimultaneeHeaderRemaining();
                        if (headers3 != null && headers3.length > 0) {
                            String[] stringArray = headers3;
                            int header = stringArray.length;
                            for (n = 0; n < header; ++n) {
                                String header2 = stringArray[n];
                                headerTrasportoRateLimiting.put(header2, "" + rimanenti);
                            }
                        }
                    }
                    catch (Exception headers3) {
                        // empty catch block
                    }
                }
            }
            if (risultatoUtilizzato != null && risultatoUtilizzato.getMaxValue() != null) {
                if (!policyConfigurationPorta.isDisabledHttpHeaders_limit()) {
                    try {
                        headers2 = null;
                        boolean windows = false;
                        switch (tipoRisorsa) {
                            case DIMENSIONE_MASSIMA_MESSAGGIO: {
                                break;
                            }
                            case NUMERO_RICHIESTE: {
                                headers2 = op2Properties.getControlloTrafficoNumeroRichiesteHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroRichiesteHeaderLimitWindows();
                                break;
                            }
                            case OCCUPAZIONE_BANDA: {
                                headers2 = op2Properties.getControlloTrafficoOccupazioneBandaHeaderLimit();
                                windows = op2Properties.getControlloTrafficoOccupazioneBandaHeaderLimitWindows();
                                break;
                            }
                            case TEMPO_MEDIO_RISPOSTA: {
                                headers2 = op2Properties.getControlloTrafficoTempoMedioRispostaHeaderLimit();
                                windows = op2Properties.getControlloTrafficoTempoMedioRispostaHeaderLimitWindows();
                                break;
                            }
                            case TEMPO_COMPLESSIVO_RISPOSTA: {
                                headers2 = op2Properties.getControlloTrafficoTempoComplessivoRispostaHeaderLimit();
                                windows = op2Properties.getControlloTrafficoTempoComplessivoRispostaHeaderLimitWindows();
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                                headers2 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoHeaderLimitWindows();
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE: {
                                headers2 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroRichiesteFalliteHeaderLimitWindows();
                                break;
                            }
                            case NUMERO_FAULT_APPLICATIVI: {
                                headers2 = op2Properties.getControlloTrafficoNumeroFaultApplicativiHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroFaultApplicativiHeaderLimitWindows();
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                                headers2 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteOFaultApplicativiHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroRichiesteFalliteOFaultApplicativiHeaderLimitWindows();
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                                headers2 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoOFaultApplicativiHeaderLimit();
                                windows = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoOFaultApplicativiHeaderLimitWindows();
                            }
                        }
                        if (policyConfigurationPorta.isForceHttpHeaders_limit_no_windows()) {
                            windows = false;
                        } else if (policyConfigurationPorta.isForceHttpHeaders_limit_windows()) {
                            windows = true;
                        }
                        if (headers2 != null && headers2.length > 0) {
                            Long maxValue = risultatoUtilizzato.getMaxValueBeforeNormalizing() != null ? risultatoUtilizzato.getMaxValueBeforeNormalizing() : risultatoUtilizzato.getMaxValue();
                            StringBuilder sb = new StringBuilder("");
                            if (windows && risultatoUtilizzato.getMsWindow() != null && maxValue != null) {
                                long ms = risultatoUtilizzato.getMsWindow();
                                long sec = -1L;
                                if (ms > 1000L) {
                                    sec = ms / 1000L;
                                }
                                if (sec > 0L) {
                                    sb.append(", ").append(maxValue).append(";w=").append(sec);
                                }
                                if (!altrePolicy.isEmpty()) {
                                    for (RisultatoVerificaPolicy r : altrePolicy) {
                                        Long maxValueR;
                                        Long l = maxValueR = r.getMaxValueBeforeNormalizing() != null ? r.getMaxValueBeforeNormalizing() : r.getMaxValue();
                                        if (r.getMsWindow() == null || maxValueR == null) continue;
                                        ms = r.getMsWindow();
                                        sec = -1L;
                                        if (ms > 1000L) {
                                            sec = ms / 1000L;
                                        }
                                        if (sec <= 0L) continue;
                                        sb.append(", ").append(maxValueR).append(";w=").append(sec);
                                    }
                                }
                            }
                            String[] ms = headers2;
                            n = ms.length;
                            for (int sec = 0; sec < n; ++sec) {
                                String header = ms[sec];
                                headerTrasportoRateLimiting.put(header, maxValue + sb.toString());
                            }
                        }
                    }
                    catch (Exception headers4) {
                        // empty catch block
                    }
                }
                if (!policyConfigurationPorta.isDisabledHttpHeaders_remaining() && risultatoUtilizzato.getActualValue() != null) {
                    long rimanenti = risultatoUtilizzato.getMaxValue() - risultatoUtilizzato.getActualValue();
                    if (rimanenti < 0L) {
                        rimanenti = 0L;
                    }
                    if (rimanenti == 0L && !risultatoUtilizzato.isViolata() && !risultatoUtilizzato.isRemainingZeroValue()) {
                        rimanenti = 1L;
                    }
                    try {
                        String[] headers5 = null;
                        switch (tipoRisorsa) {
                            case DIMENSIONE_MASSIMA_MESSAGGIO: {
                                break;
                            }
                            case NUMERO_RICHIESTE: {
                                headers5 = op2Properties.getControlloTrafficoNumeroRichiesteHeaderRemaining();
                                break;
                            }
                            case OCCUPAZIONE_BANDA: {
                                headers5 = op2Properties.getControlloTrafficoOccupazioneBandaHeaderRemaining();
                                break;
                            }
                            case TEMPO_MEDIO_RISPOSTA: {
                                break;
                            }
                            case TEMPO_COMPLESSIVO_RISPOSTA: {
                                headers5 = op2Properties.getControlloTrafficoTempoComplessivoRispostaHeaderRemaining();
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                                headers5 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoHeaderRemaining();
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE: {
                                headers5 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteHeaderRemaining();
                                break;
                            }
                            case NUMERO_FAULT_APPLICATIVI: {
                                headers5 = op2Properties.getControlloTrafficoNumeroFaultApplicativiHeaderRemaining();
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                                headers5 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteOFaultApplicativiHeaderRemaining();
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                                headers5 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoOFaultApplicativiHeaderRemaining();
                            }
                        }
                        if (headers5 != null && headers5.length > 0) {
                            String[] stringArray = headers5;
                            int ms = stringArray.length;
                            for (n = 0; n < ms; ++n) {
                                String header = stringArray[n];
                                headerTrasportoRateLimiting.put(header, "" + rimanenti);
                            }
                        }
                    }
                    catch (Exception headers5) {
                        // empty catch block
                    }
                }
            }
            if (policyConfigurationPorta.isDisabledHttpHeaders_reset() || risultatoUtilizzato == null || risultatoUtilizzato.getMsBeforeResetCounters() == null) continue;
            long ms = risultatoUtilizzato.getMsBeforeResetCounters();
            long sec = -1L;
            if (ms > 1000L) {
                sec = ms / 1000L;
            } else if (ms > 0L) {
                sec = 1L;
            }
            if (sec <= 0L) continue;
            try {
                String[] headers6 = null;
                switch (tipoRisorsa) {
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        break;
                    }
                    case NUMERO_RICHIESTE: {
                        headers6 = op2Properties.getControlloTrafficoNumeroRichiesteHeaderReset();
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        headers6 = op2Properties.getControlloTrafficoOccupazioneBandaHeaderReset();
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        headers6 = op2Properties.getControlloTrafficoTempoMedioRispostaHeaderReset();
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        headers6 = op2Properties.getControlloTrafficoTempoComplessivoRispostaHeaderReset();
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                        headers6 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoHeaderReset();
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE: {
                        headers6 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteHeaderReset();
                        break;
                    }
                    case NUMERO_FAULT_APPLICATIVI: {
                        headers6 = op2Properties.getControlloTrafficoNumeroFaultApplicativiHeaderReset();
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                        headers6 = op2Properties.getControlloTrafficoNumeroRichiesteFalliteOFaultApplicativiHeaderReset();
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                        headers6 = op2Properties.getControlloTrafficoNumeroRichiesteCompletateConSuccessoOFaultApplicativiHeaderReset();
                    }
                }
                if (headers6 == null || headers6.length <= 0) continue;
                for (String header : headers6) {
                    headerTrasportoRateLimiting.put(header, "" + sec);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean isCondizioneCongestionamentoPortaDominio(InRequestProtocolContext context, GestoreControlloTraffico gestoreControlloCongestione, MsgDiagnostico msgDiag, Transaction tr) throws TransactionDeletedException {
        Object oThreshold;
        StatoTraffico statoControlloCongestione;
        if (context == null) {
            throw new TransactionDeletedException("Context is null");
        }
        PdDContext pddContext = context.getPddContext();
        boolean isPddCongestionataInformazioneIdentificataDalThread = false;
        Object oPddCongestionataThread = pddContext.getObject(CostantiControlloTraffico.PDD_CONTEXT_PDD_CONGESTIONATA);
        if (oPddCongestionataThread instanceof Boolean) {
            isPddCongestionataInformazioneIdentificataDalThread = (Boolean)oPddCongestionataThread;
        }
        if ((statoControlloCongestione = gestoreControlloCongestione.getStatoControlloTraffico()).isPddCongestionata() != isPddCongestionataInformazioneIdentificataDalThread) {
            pddContext.removeObject(CostantiControlloTraffico.PDD_CONTEXT_PDD_CONGESTIONATA);
            pddContext.addObject(CostantiControlloTraffico.PDD_CONTEXT_PDD_CONGESTIONATA, statoControlloCongestione.isPddCongestionata());
        }
        msgDiag.addKeyword("@CT_ACTIVE_THREADS@", "" + statoControlloCongestione.getActiveThreads());
        pddContext.addObject(GeneratoreMessaggiErrore.PDD_CONTEXT_ACTIVE_THREADS, statoControlloCongestione.getActiveThreads());
        Object oMaxThreads = pddContext.getObject(GeneratoreMessaggiErrore.PDD_CONTEXT_MAX_THREADS_THRESHOLD);
        if (oMaxThreads != null) {
            msgDiag.addKeyword("@CT_MAX_THREADS_THRESHOLD@", oMaxThreads.toString());
        }
        if ((oThreshold = pddContext.getObject(GeneratoreMessaggiErrore.PDD_CONTEXT_CONTROLLO_TRAFFICO_THRESHOLD)) != null) {
            msgDiag.addKeyword("@CT_THRESHOLD@", oThreshold.toString());
        }
        if (statoControlloCongestione.isPddCongestionata()) {
            tr.addEventoGestione(TipoEvento.CONTROLLO_TRAFFICO_SOGLIA_CONGESTIONE.getValue() + "_" + CodiceEventoControlloTraffico.VIOLAZIONE.getValue());
            msgDiag.logPersonalizzato("controlloTraffico.pddCongestionata");
        }
        return statoControlloCongestione.isPddCongestionata();
    }

    private MsgDiagnostico buildMsgDiagnostico(InRequestProtocolContext context) throws HandlerException {
        MsgDiagnostico msgDiag = null;
        try {
            String nomePorta = null;
            if (context.getIntegrazione() != null) {
                if (context.getIntegrazione().getIdPA() != null) {
                    nomePorta = context.getIntegrazione().getIdPA().getNome();
                } else if (context.getIntegrazione().getIdPD() != null) {
                    nomePorta = context.getIntegrazione().getIdPD().getNome();
                }
            }
            RequestInfo requestInfo = null;
            if (context.getPddContext() != null && context.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)context.getPddContext().getObject(Costanti.REQUEST_INFO);
            }
            msgDiag = MsgDiagnostico.newInstance(context.getTipoPorta(), context.getIdModulo(), nomePorta, requestInfo);
            msgDiag.setPddContext(context.getPddContext(), context.getProtocolFactory());
            if (TipoPdD.DELEGATA.equals((Object)context.getTipoPorta())) {
                msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            } else {
                msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
            }
        }
        catch (Exception e) {
            throw new HandlerException("Generazione Messaggio Diagnostico non riuscita: " + e.getMessage(), e);
        }
        return msgDiag;
    }
}

