/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.AbstractPolicyGroupByActiveThreadsDistributed;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.slf4j.Logger;

public abstract class AbstractPolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessor
extends AbstractPolicyGroupByActiveThreadsDistributed {
    private boolean putAsync = false;

    public AbstractPolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessor(ActivePolicy policy, String uniqueIdMap, HazelcastInstance hazelcast, PolicyGroupByActiveThreadsType type) throws PolicyException {
        super(policy, uniqueIdMap, type, hazelcast);
        this.putAsync = PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP.equals((Object)type);
    }

    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
        boolean newDati = false;
        if (datiCollezionati == null) {
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
            datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
            newDati = true;
        } else if (datiCollezionati.getUpdatePolicyDate() != null && !datiCollezionati.getUpdatePolicyDate().equals(this.activePolicy.getInstanceConfiguration().getUpdateTime())) {
            datiCollezionati.resetCounters(this.activePolicy.getInstanceConfiguration().getUpdateTime());
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        if (newDati) {
            datiCollezionatiPerPolicyVerifier.initDatiIniziali(this.activePolicy);
            datiCollezionatiPerPolicyVerifier.checkDate(log, this.activePolicy);
        }
        datiCollezionati.registerStartRequest(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        if (this.putAsync) {
            this.distributedMap.putAsync((Object)datiGroupBy, (Object)datiCollezionati);
        } else {
            this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
        }
        return datiCollezionatiPerPolicyVerifier;
    }

    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)(datiGroupBy = this.augmentIDUnivoco(datiGroupBy)));
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        boolean updated = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        if (updated) {
            if (this.putAsync) {
                this.distributedMap.putAsync((Object)datiGroupBy, (Object)datiCollezionati);
            } else {
                this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
            }
            return datiCollezionatiPerPolicyVerifier;
        }
        return null;
    }

    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)(datiGroupBy = this.augmentIDUnivoco(datiGroupBy)));
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
        if (isApplicabile) {
            List esitiCodeOk = null;
            List esitiCodeKo_senzaFaultApplicativo = null;
            List esitiCodeFaultApplicativo = null;
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                esitiCodeKo_senzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
            }
            catch (Exception e) {
                throw new PolicyException(e.getMessage(), (Throwable)e);
            }
            datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, esitiCodeOk, esitiCodeKo_senzaFaultApplicativo, esitiCodeFaultApplicativo, isViolata);
            if (this.putAsync) {
                this.distributedMap.putAsync((Object)datiGroupBy, (Object)datiCollezionati);
            } else {
                this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
            }
        }
    }

    @Override
    public void resetCounters() {
        if (this.distributedMap.size() > 0) {
            for (IDUnivocoGroupByPolicy datiGroupBy : this.distributedMap.keySet()) {
                DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
                datiCollezionati.resetCounters();
                this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
            }
        }
    }

    @Override
    public void initMap(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        if (map != null && map.size() > 0) {
            this.distributedMap.putAll(map);
        }
    }
}

