/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.Offloadable;
import com.hazelcast.map.EntryProcessor;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.slf4j.Logger;

public class EndRequestProcessor
implements EntryProcessor<IDUnivocoGroupByPolicy, DatiCollezionati, Boolean>,
Offloadable {
    private static final long serialVersionUID = 1L;
    private final ActivePolicy activePolicy;
    private final MisurazioniTransazione dati;
    private final Map<Object> ctx;
    private final boolean isApplicabile;
    private final boolean isViolata;

    public EndRequestProcessor(ActivePolicy policy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) {
        this.activePolicy = policy;
        this.ctx = ctx;
        this.dati = dati;
        this.isApplicabile = isApplicabile;
        this.isViolata = isViolata;
    }

    public Boolean process(Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry) {
        DatiCollezionati datiCollezionati = entry.getValue();
        if (datiCollezionati == null) {
            System.out.println("<>updateDatiStartRequestApplicabile Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + entry.getKey().toString() + "]");
            return false;
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
        if (this.isApplicabile) {
            datiCollezionati.registerEndRequest(log, this.activePolicy, this.ctx, this.dati);
            List esitiCodeOk = null;
            List esitiCodeKo_senzaFaultApplicativo = null;
            List esitiCodeFaultApplicativo = null;
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.dati.getProtocollo());
                esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                esitiCodeKo_senzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
                datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, this.ctx, this.dati, esitiCodeOk, esitiCodeKo_senzaFaultApplicativo, esitiCodeFaultApplicativo, this.isViolata);
            }
            catch (Exception e) {
                System.out.println("<>EndRequestProcessor, errore sulla policy con dati identificativi [" + entry.getKey().toString() + "]: " + e.getMessage());
                return false;
            }
            entry.setValue(datiCollezionati);
        } else {
            datiCollezionati.registerEndRequest(null, this.activePolicy, this.ctx, this.dati);
            entry.setValue(datiCollezionati);
        }
        return true;
    }

    public String getExecutorName() {
        return "hz:offloadable";
    }
}

