/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters;

import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.DatoAtomicLong;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.slf4j.Logger;

public class DatiCollezionatiDistributedAtomicLong
extends DatiCollezionati
implements IDatiCollezionatiDistributed {
    private static final long serialVersionUID = 1L;
    private final transient Semaphore lock = new Semaphore("DatiCollezionatiDistributedAtomicLong");
    private final transient HazelcastInstance hazelcast;
    private final IDUnivocoGroupByPolicyMapId groupByPolicyMapId;
    private final int groupByPolicyMapIdHashCode;
    protected final transient DatoAtomicLong distributedUpdatePolicyDate;
    protected final transient DatoAtomicLong distributedPolicyDate;
    protected transient DatoAtomicLong distributedPolicyRequestCounter;
    protected transient DatoAtomicLong distributedPolicyCounter;
    protected final transient DatoAtomicLong distributedPolicyDegradoPrestazionaleDate;
    protected transient DatoAtomicLong distributedPolicyDegradoPrestazionaleRequestCounter;
    protected transient DatoAtomicLong distributedPolicyDegradoPrestazionaleCounter;
    protected final transient boolean distribuitedActiveRequestCounterPolicyRichiesteSimultanee;
    protected final transient DatoAtomicLong distributedActiveRequestCounterForStats;
    protected transient DatoAtomicLong distributedActiveRequestCounterForCheck;
    protected transient DatoAtomicLong distributedPolicyDenyRequestCounter;
    private transient List<DatoAtomicLong> cestinoPolicyCounters = new ArrayList<DatoAtomicLong>();
    private transient List<DatoAtomicLong> cestinoPolicyCountersDegradoPrestazionale = new ArrayList<DatoAtomicLong>();
    private boolean initialized = false;

    public DatiCollezionatiDistributedAtomicLong(Logger log, Date updatePolicyDate, Date gestorePolicyConfigDate, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(updatePolicyDate, gestorePolicyConfigDate);
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.initDatiIniziali(activePolicy);
        this.checkDate(log, activePolicy);
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.initPolicyCounters(super.getPolicyDate().getTime());
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.initPolicyCountersDegradoPrestazionale(super.getPolicyDegradoPrestazionaleDate().getTime());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue() && updatePolicyDate != null && this.distributedUpdatePolicyDate != null && this.distributedUpdatePolicyDate.get() < updatePolicyDate.getTime()) {
            this.resetCounters(updatePolicyDate);
        }
        this.initialized = true;
    }

    public DatiCollezionatiDistributedAtomicLong(Logger log, DatiCollezionati dati, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(dati.getUpdatePolicyDate(), dati.getGestorePolicyConfigDate());
        if (log != null) {
            // empty if block
        }
        dati.setValuesIn((DatiCollezionati)this, false);
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (super.getPolicyDate() != null) {
            if (this.distributedPolicyDate != null && this.distributedPolicyDate.compareAndSet(0L, super.getPolicyDate().getTime())) {
                Long getActiveRequestCounter;
                Long getPolicyCounter;
                Long getPolicyDenyRequestCounter;
                polDate = super.getPolicyDate().getTime();
                this.initPolicyCounters(polDate);
                Long getPolicyRequestCounter = super.getPolicyRequestCounter(true);
                if (getPolicyRequestCounter != null) {
                    this.distributedPolicyRequestCounter.addAndGet(getPolicyRequestCounter);
                }
                if ((getPolicyDenyRequestCounter = super.getPolicyDenyRequestCounter(true)) != null) {
                    this.distributedPolicyDenyRequestCounter.set(getPolicyDenyRequestCounter);
                }
                if (!(this.tipoRisorsa != null && this.isRisorsaContaNumeroRichieste(this.tipoRisorsa) || (getPolicyCounter = super.getPolicyCounter(true)) == null)) {
                    this.distributedPolicyCounter.addAndGet(getPolicyCounter);
                }
                if ((getActiveRequestCounter = super.getActiveRequestCounter(true)) != null && getActiveRequestCounter != 0L) {
                    if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
                        this.distributedActiveRequestCounterForCheck.set(getActiveRequestCounter);
                    } else if (this.distributedActiveRequestCounterForStats != null) {
                        this.distributedActiveRequestCounterForStats.set(getActiveRequestCounter);
                    }
                }
            } else {
                polDate = this.distributedPolicyDate != null ? Long.valueOf(this.distributedPolicyDate.get()) : null;
                this.initPolicyCounters(polDate);
            }
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue() && super.getPolicyDegradoPrestazionaleDate() != null) {
            if (this.distributedPolicyDegradoPrestazionaleDate != null && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(0L, super.getPolicyDegradoPrestazionaleDate().getTime())) {
                Long getPolicyDegradoPrestazionaleCounter;
                degradoPrestazionaleTime = super.getPolicyDegradoPrestazionaleDate().getTime();
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
                Long getPolicyDegradoPrestazionaleRequestCounter = super.getPolicyDegradoPrestazionaleRequestCounter(true);
                if (getPolicyDegradoPrestazionaleRequestCounter != null) {
                    this.distributedPolicyDegradoPrestazionaleRequestCounter.addAndGet(getPolicyDegradoPrestazionaleRequestCounter);
                }
                if ((getPolicyDegradoPrestazionaleCounter = super.getPolicyDegradoPrestazionaleCounter(true)) != null) {
                    this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(getPolicyDegradoPrestazionaleCounter);
                }
            } else {
                degradoPrestazionaleTime = this.distributedPolicyDegradoPrestazionaleDate != null ? Long.valueOf(this.distributedPolicyDegradoPrestazionaleDate.get()) : null;
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
            }
        }
        this.initialized = true;
    }

    private DatoAtomicLong initPolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDate-c" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoAtomicLong initUpdatePolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-updatePolicyDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoAtomicLong initPolicyDegradoPrestazionaleDate() {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoAtomicLong initActiveRequestCounters() {
        return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-activeRequestCounter-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
    }

    private void initPolicyCounters(Long policyDate) {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.distributedPolicyRequestCounter = new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            this.distributedPolicyDenyRequestCounter = new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDenyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.distributedPolicyCounter = new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            }
        }
    }

    private void initPolicyCountersDegradoPrestazionale(Long policyDate) {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.distributedPolicyDegradoPrestazionaleCounter = new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            this.distributedPolicyDegradoPrestazionaleRequestCounter = new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDate(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDate");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDate != null ? this.policyDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCounters.isEmpty()) {
                        for (DatoAtomicLong iAtomicLong : this.cestinoPolicyCounters) {
                            iAtomicLong.destroy();
                        }
                        this.cestinoPolicyCounters.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyRequestCounter);
                        }
                        if (this.distributedPolicyDenyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyDenyRequestCounter);
                        }
                        if (this.distributedPolicyCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCounters(policyDate);
                super.resetPolicyCounterForDate(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDate");
            }
        } else {
            super.resetPolicyCounterForDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDateDegradoPrestazionale(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDateDegradoPrestazionale");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDegradoPrestazionaleDate.get();
                long l = actualSuper = this.policyDegradoPrestazionaleDate != null ? this.policyDegradoPrestazionaleDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
                        for (DatoAtomicLong iAtomicLong : this.cestinoPolicyCountersDegradoPrestazionale) {
                            iAtomicLong.destroy();
                        }
                        this.cestinoPolicyCountersDegradoPrestazionale.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleCounter);
                        }
                        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleRequestCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCountersDegradoPrestazionale(policyDate);
                super.resetPolicyCounterForDateDegradoPrestazionale(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDateDegradoPrestazionale");
            }
        } else {
            super.resetPolicyCounterForDateDegradoPrestazionale(date);
        }
    }

    public void resetCounters(Date updatePolicyDate) {
        super.resetCounters(updatePolicyDate);
        if (updatePolicyDate != null) {
            this.distributedUpdatePolicyDate.set(updatePolicyDate.getTime());
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.set(0L);
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.set(0L);
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.set(0L);
        }
    }

    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.activeRequestCounter = datiCollezionatiPerPolicyVerifier != null ? Long.valueOf(datiCollezionatiPerPolicyVerifier.setAndGetActiveRequestCounter(this.distributedActiveRequestCounterForCheck.incrementAndGet())) : Long.valueOf(this.distributedActiveRequestCounterForCheck.incrementAndGet());
        } else {
            this.distributedActiveRequestCounterForStats.incrementAndGetAsync();
        }
    }

    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        this.policyRequestCounter = datiCollezionatiPerPolicyVerifier != null ? datiCollezionatiPerPolicyVerifier.setAndGetPolicyRequestCounter(Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet())) : Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet());
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.activeRequestCounter = this.distributedActiveRequestCounterForCheck.decrementAndGet();
        } else {
            this.distributedActiveRequestCounterForStats.decrementAndGetAsync();
        }
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        this.policyDegradoPrestazionaleRequestCounter = this.distributedPolicyDegradoPrestazionaleRequestCounter.incrementAndGet();
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        this.policyDegradoPrestazionaleCounter = this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(latenza);
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.incrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.decrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        this.distributedPolicyDenyRequestCounter.incrementAndGetAsync();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        this.policyCounter = this.distributedPolicyCounter.addAndGet(v);
    }

    public void destroyDatiDistribuiti() {
        if (this.distributedPolicyDate != null) {
            this.distributedPolicyDate.destroy();
        }
        if (this.distributedUpdatePolicyDate != null) {
            this.distributedUpdatePolicyDate.destroy();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.destroy();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleDate != null) {
            this.distributedPolicyDegradoPrestazionaleDate.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.destroy();
        }
        if (this.distributedActiveRequestCounterForStats != null) {
            this.distributedActiveRequestCounterForStats.destroy();
        }
        if (this.distributedActiveRequestCounterForCheck != null) {
            this.distributedActiveRequestCounterForCheck.destroy();
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.destroy();
        }
    }

    public Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (readRemoteInfo) {
                return this.distributedActiveRequestCounterForCheck.get();
            }
            return this.activeRequestCounter;
        }
        return this.distributedActiveRequestCounterForStats.get();
    }

    public Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDenyRequestCounter != null) {
                return this.distributedPolicyDenyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDenyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyRequestCounter != null) {
                return this.distributedPolicyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyCounter != null) {
                return this.distributedPolicyCounter.get();
            }
            return null;
        }
        return super.getPolicyCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
    }
}

