/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters;

import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.DatoAtomicLong;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.DatoPNCounter;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.slf4j.Logger;

public class DatiCollezionatiDistributedPNCounter
extends DatiCollezionati
implements IDatiCollezionatiDistributed {
    private static final long serialVersionUID = 1L;
    private final transient Semaphore lock = new Semaphore("DatiCollezionatiDistributedPNCounter");
    private final transient HazelcastInstance hazelcast;
    private final IDUnivocoGroupByPolicyMapId groupByPolicyMapId;
    private final int groupByPolicyMapIdHashCode;
    private final transient DatoAtomicLong distributedUpdatePolicyDate;
    private final transient DatoAtomicLong distributedPolicyDate;
    private transient DatoPNCounter distributedPolicyRequestCounter;
    private transient DatoPNCounter distributedPolicyCounter;
    private final transient DatoAtomicLong distributedPolicyDegradoPrestazionaleDate;
    private transient DatoPNCounter distributedPolicyDegradoPrestazionaleRequestCounter;
    private transient DatoPNCounter distributedPolicyDegradoPrestazionaleCounter;
    private final boolean distribuitedActiveRequestCounterPolicyRichiesteSimultanee;
    private final transient DatoPNCounter distributedActiveRequestCounterForStats;
    private transient DatoPNCounter distributedActiveRequestCounterForCheck;
    private transient DatoPNCounter distributedPolicyDenyRequestCounter;
    private transient List<DatoPNCounter> cestinoPolicyCounters = new ArrayList<DatoPNCounter>();
    private transient List<DatoPNCounter> cestinoPolicyCountersDegradoPrestazionale = new ArrayList<DatoPNCounter>();
    private boolean initialized = false;

    private String getPNCounterName(String name, Long date) {
        Object t = "";
        if (date != null) {
            t = "" + date;
        }
        String configDate = "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L);
        return "pncounter-" + this.groupByPolicyMapIdHashCode + "-" + name + (String)t + configDate + "-rl";
    }

    public DatiCollezionatiDistributedPNCounter(Logger log, Date updatePolicyDate, Date gestorePolicyConfigDate, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(updatePolicyDate, gestorePolicyConfigDate);
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.initDatiIniziali(activePolicy);
        this.checkDate(log, activePolicy);
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.initPolicyCounters(super.getPolicyDate().getTime());
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.initPolicyCountersDegradoPrestazionale(super.getPolicyDegradoPrestazionaleDate().getTime());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue() && updatePolicyDate != null && this.distributedUpdatePolicyDate != null && this.distributedUpdatePolicyDate.get() < updatePolicyDate.getTime()) {
            this.resetCounters(updatePolicyDate);
        }
        this.initialized = true;
    }

    public DatiCollezionatiDistributedPNCounter(Logger log, DatiCollezionati dati, HazelcastInstance hazelcast, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(dati.getUpdatePolicyDate(), dati.getGestorePolicyConfigDate());
        if (log != null) {
            // empty if block
        }
        dati.setValuesIn((DatiCollezionati)this, false);
        this.hazelcast = hazelcast;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (super.getPolicyDate() != null) {
            if (this.distributedPolicyDate != null && this.distributedPolicyDate.compareAndSet(0L, super.getPolicyDate().getTime())) {
                Long getActiveRequestCounter;
                Long getPolicyCounter;
                Long getPolicyDenyRequestCounter;
                polDate = super.getPolicyDate().getTime();
                this.initPolicyCounters(polDate);
                Long getPolicyRequestCounter = super.getPolicyRequestCounter(true);
                if (getPolicyRequestCounter != null) {
                    this.distributedPolicyRequestCounter.addAndGet(getPolicyRequestCounter);
                }
                if ((getPolicyDenyRequestCounter = super.getPolicyDenyRequestCounter(true)) != null) {
                    this.distributedPolicyDenyRequestCounter.addAndGet(getPolicyDenyRequestCounter);
                }
                if (!(this.tipoRisorsa != null && this.isRisorsaContaNumeroRichieste(this.tipoRisorsa) || (getPolicyCounter = super.getPolicyCounter(true)) == null)) {
                    this.distributedPolicyCounter.addAndGet(getPolicyCounter);
                }
                if ((getActiveRequestCounter = super.getActiveRequestCounter(true)) != null && getActiveRequestCounter != 0L) {
                    if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
                        this.distributedActiveRequestCounterForCheck.addAndGet(getActiveRequestCounter);
                    } else if (this.distributedActiveRequestCounterForStats != null) {
                        this.distributedActiveRequestCounterForStats.addAndGet(getActiveRequestCounter);
                    }
                }
            } else {
                polDate = this.distributedPolicyDate != null ? Long.valueOf(this.distributedPolicyDate.get()) : null;
                this.initPolicyCounters(polDate);
            }
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue() && super.getPolicyDegradoPrestazionaleDate() != null) {
            if (this.distributedPolicyDegradoPrestazionaleDate != null && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(0L, super.getPolicyDegradoPrestazionaleDate().getTime())) {
                Long getPolicyDegradoPrestazionaleCounter;
                degradoPrestazionaleTime = super.getPolicyDegradoPrestazionaleDate().getTime();
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
                Long getPolicyDegradoPrestazionaleRequestCounter = super.getPolicyDegradoPrestazionaleRequestCounter(true);
                if (getPolicyDegradoPrestazionaleRequestCounter != null) {
                    this.distributedPolicyDegradoPrestazionaleRequestCounter.addAndGet(getPolicyDegradoPrestazionaleRequestCounter);
                }
                if ((getPolicyDegradoPrestazionaleCounter = super.getPolicyDegradoPrestazionaleCounter(true)) != null) {
                    this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(getPolicyDegradoPrestazionaleCounter);
                }
            } else {
                degradoPrestazionaleTime = this.distributedPolicyDegradoPrestazionaleDate != null ? Long.valueOf(this.distributedPolicyDegradoPrestazionaleDate.get()) : null;
                this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
            }
        }
        this.initialized = true;
    }

    private DatoAtomicLong initPolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDate-c" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoAtomicLong initUpdatePolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-updatePolicyDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoAtomicLong initPolicyDegradoPrestazionaleDate() {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            return new DatoAtomicLong(this.hazelcast, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoPNCounter initActiveRequestCounters() {
        return new DatoPNCounter(this.hazelcast, this.getPNCounterName("-activeRequestCounter-c-", this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
    }

    private void initPolicyCounters(Long policyDate) {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.distributedPolicyRequestCounter = new DatoPNCounter(this.hazelcast, this.getPNCounterName("-policyRequestCounter-i-", policyDate));
            this.distributedPolicyDenyRequestCounter = new DatoPNCounter(this.hazelcast, this.getPNCounterName("-policyDenyRequestCounter-i-", policyDate));
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.distributedPolicyCounter = new DatoPNCounter(this.hazelcast, this.getPNCounterName("-policyCounter-i-", policyDate));
            }
        }
    }

    private void initPolicyCountersDegradoPrestazionale(Long policyDate) {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.distributedPolicyDegradoPrestazionaleCounter = new DatoPNCounter(this.hazelcast, this.getPNCounterName("-policyDegradoPrestazionaleCounter-i-", policyDate));
            this.distributedPolicyDegradoPrestazionaleRequestCounter = new DatoPNCounter(this.hazelcast, this.getPNCounterName("-policyDegradoPrestazionaleRequestCounter-i-", policyDate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDate(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDate");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDate != null ? this.policyDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCounters.isEmpty()) {
                        for (DatoPNCounter pnCounter : this.cestinoPolicyCounters) {
                            pnCounter.destroy();
                        }
                        this.cestinoPolicyCounters.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyRequestCounter);
                        }
                        if (this.distributedPolicyDenyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyDenyRequestCounter);
                        }
                        if (this.distributedPolicyCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCounters(policyDate);
                super.resetPolicyCounterForDate(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDate");
            }
        } else {
            super.resetPolicyCounterForDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDateDegradoPrestazionale(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDateDegradoPrestazionale");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDegradoPrestazionaleDate != null ? this.policyDegradoPrestazionaleDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
                        for (DatoPNCounter pnCounter : this.cestinoPolicyCountersDegradoPrestazionale) {
                            pnCounter.destroy();
                        }
                        this.cestinoPolicyCountersDegradoPrestazionale.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleCounter);
                        }
                        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleRequestCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCountersDegradoPrestazionale(policyDate);
                super.resetPolicyCounterForDateDegradoPrestazionale(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDateDegradoPrestazionale");
            }
        } else {
            super.resetPolicyCounterForDateDegradoPrestazionale(date);
        }
    }

    public void resetCounters(Date updatePolicyDate) {
        super.resetCounters(updatePolicyDate);
        if (updatePolicyDate != null) {
            this.distributedUpdatePolicyDate.set(updatePolicyDate.getTime());
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.subtractAndGet(this.distributedPolicyDenyRequestCounter.get());
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.subtractAndGet(this.distributedPolicyRequestCounter.get());
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.subtractAndGet(this.distributedPolicyCounter.get());
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.subtractAndGet(this.distributedPolicyDegradoPrestazionaleRequestCounter.get());
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.subtractAndGet(this.distributedPolicyDegradoPrestazionaleCounter.get());
        }
    }

    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        this.activeRequestCounter = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee ? (datiCollezionatiPerPolicyVerifier != null ? Long.valueOf(datiCollezionatiPerPolicyVerifier.setAndGetActiveRequestCounter(this.distributedActiveRequestCounterForCheck.incrementAndGet())) : Long.valueOf(this.distributedActiveRequestCounterForCheck.incrementAndGet())) : Long.valueOf(this.distributedActiveRequestCounterForStats.incrementAndGet());
    }

    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        this.policyRequestCounter = datiCollezionatiPerPolicyVerifier != null ? datiCollezionatiPerPolicyVerifier.setAndGetPolicyRequestCounter(Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet())) : Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet());
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        this.activeRequestCounter = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee ? Long.valueOf(this.distributedActiveRequestCounterForCheck.decrementAndGet()) : Long.valueOf(this.distributedActiveRequestCounterForStats.decrementAndGet());
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        this.policyDegradoPrestazionaleRequestCounter = this.distributedPolicyDegradoPrestazionaleRequestCounter.incrementAndGet();
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        this.policyDegradoPrestazionaleCounter = this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(latenza);
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.incrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.decrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        this.policyDenyRequestCounter = this.distributedPolicyDenyRequestCounter.incrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        this.policyCounter = this.distributedPolicyCounter.addAndGet(v);
    }

    public void destroyDatiDistribuiti() {
        if (this.distributedPolicyDate != null) {
            this.distributedPolicyDate.destroy();
        }
        if (this.distributedUpdatePolicyDate != null) {
            this.distributedUpdatePolicyDate.destroy();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.destroy();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleDate != null) {
            this.distributedPolicyDegradoPrestazionaleDate.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.destroy();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.destroy();
        }
        if (this.distributedActiveRequestCounterForStats != null) {
            this.distributedActiveRequestCounterForStats.destroy();
        }
        if (this.distributedActiveRequestCounterForCheck != null) {
            this.distributedActiveRequestCounterForCheck.destroy();
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.destroy();
        }
    }

    public Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
                return this.distributedActiveRequestCounterForCheck.get();
            }
            return this.distributedActiveRequestCounterForStats.get();
        }
        return super.getActiveRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDenyRequestCounter != null) {
                return this.distributedPolicyDenyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDenyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyRequestCounter != null) {
                return this.distributedPolicyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyCounter != null) {
                return this.distributedPolicyCounter.get();
            }
            return null;
        }
        return super.getPolicyCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
    }
}

