/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupBy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.UtilsException;
import org.redisson.api.RMap;
import org.redisson.api.RTransaction;
import org.redisson.api.RedissonClient;
import org.redisson.api.TransactionOptions;
import org.redisson.transaction.TransactionException;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsDistributedRedis
implements IPolicyGroupByActiveThreadsInMemory {
    private final ActivePolicy activePolicy;
    private final RedissonClient redisson;
    private final RMap<IDUnivocoGroupByPolicy, DatiCollezionati> distributedMap;
    private String mapId = null;
    protected PolicyGroupByActiveThreadsType type;
    protected String uniqueIdMap_idActivePolicy;
    protected Date uniqueIdMap_updateTime;

    public PolicyGroupByActiveThreadsDistributedRedis(ActivePolicy activePolicy, String uniqueIdMap, RedissonClient redisson) throws PolicyException {
        this.activePolicy = activePolicy;
        this.redisson = redisson;
        this.uniqueIdMap_idActivePolicy = UniqueIdentifierUtilities.extractIdActivePolicy((String)uniqueIdMap);
        try {
            this.uniqueIdMap_updateTime = UniqueIdentifierUtilities.extractUpdateTimeActivePolicy((String)uniqueIdMap);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
        this.type = PolicyGroupByActiveThreadsType.REDISSON_MAP;
        boolean oneMapForeachPolicy = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryRedisOneMapForeachPolicy();
        String mapName = "redis-";
        if (oneMapForeachPolicy) {
            this.mapId = mapName + this.uniqueIdMap_idActivePolicy + "-rate-limiting";
            this.distributedMap = redisson.getMap(this.mapId);
            log.info("Hazelcast: Utilizzo Una Distributed Map per gruppo.");
        } else {
            this.mapId = mapName + "rate-limiting";
            this.distributedMap = redisson.getMap(this.mapId);
            log.info("Hazelcast: Utilizzo Una Distributed Map globale.");
        }
    }

    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        RTransaction transaction = this.redisson.createTransaction(TransactionOptions.defaults());
        RMap map = transaction.getMap(this.mapId);
        DatiCollezionati datiCollezionati = (DatiCollezionati)map.get((Object)datiGroupBy);
        if (datiCollezionati == null) {
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
            datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
        } else if (datiCollezionati.getUpdatePolicyDate() != null && !datiCollezionati.getUpdatePolicyDate().equals(this.activePolicy.getInstanceConfiguration().getUpdateTime())) {
            datiCollezionati.resetCounters(this.activePolicy.getInstanceConfiguration().getUpdateTime());
        }
        datiCollezionati.registerStartRequest(log, this.activePolicy, ctx);
        DatiCollezionati datiCollezionatiReaded = datiCollezionati.newInstance();
        map.fastPut((Object)datiGroupBy, (Object)datiCollezionati);
        try {
            transaction.commit();
        }
        catch (TransactionException e) {
            transaction.rollback();
            throw new PolicyException("Errore durante la transazione registerStartRequest di Redis", (Throwable)e);
        }
        return datiCollezionatiReaded;
    }

    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        RTransaction transaction = this.redisson.createTransaction(TransactionOptions.defaults());
        RMap map = transaction.getMap(this.mapId);
        DatiCollezionati datiCollezionati = (DatiCollezionati)map.get((Object)datiGroupBy);
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx);
        DatiCollezionati datiCollezionatiReaded = datiCollezionati.newInstance();
        map.fastPut((Object)datiGroupBy, (Object)datiCollezionati);
        try {
            transaction.commit();
        }
        catch (TransactionException e) {
            transaction.rollback();
            throw new PolicyException("Errore durante la transazione registerStartRequest di Redis", (Throwable)e);
        }
        return datiCollezionatiReaded;
    }

    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        RTransaction transaction = this.redisson.createTransaction(TransactionOptions.defaults());
        RMap map = transaction.getMap(this.mapId);
        DatiCollezionati datiCollezionati = (DatiCollezionati)map.get((Object)datiGroupBy);
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        if (isApplicabile) {
            datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
            List esitiCodeOk = null;
            List esitiCodeKo_senzaFaultApplicativo = null;
            List esitiCodeFaultApplicativo = null;
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                esitiCodeKo_senzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
                datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, esitiCodeOk, esitiCodeKo_senzaFaultApplicativo, esitiCodeFaultApplicativo, isViolata);
            }
            catch (Exception e) {
                throw new PolicyException(e.getMessage(), (Throwable)e);
            }
            map.fastPut((Object)datiGroupBy, (Object)datiCollezionati);
        } else {
            datiCollezionati.registerEndRequest(null, this.activePolicy, ctx, dati);
            map.fastPut((Object)datiGroupBy, (Object)datiCollezionati);
        }
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        return this.distributedMap;
    }

    public void initMap(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        this.distributedMap.putAll(map);
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        long counter = 0L;
        Set cloned = this.distributedMap.readAllEntrySet();
        for (Map.Entry entry : cloned) {
            IDUnivocoGroupBy idAstype;
            if (filtro == null || !(idAstype = (IDUnivocoGroupBy)entry.getKey()).match((Object)filtro)) continue;
            counter += ((DatiCollezionati)entry.getValue()).getActiveRequestCounter().longValue();
        }
        return counter;
    }

    public void resetCounters() {
        this.distributedMap.forEach((id, dati) -> dati.resetCounters());
    }

    public void remove() throws UtilsException {
        ArrayList<IDUnivocoGroupByPolicy> deleteList = new ArrayList<IDUnivocoGroupByPolicy>();
        for (IDUnivocoGroupByPolicy datiGroupBy : this.distributedMap.keySet()) {
            IDUnivocoGroupByPolicyMapId mapId;
            if (!(datiGroupBy instanceof IDUnivocoGroupByPolicyMapId) || !this.uniqueIdMap_idActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
            deleteList.add(datiGroupBy);
        }
        while (!deleteList.isEmpty()) {
            IDUnivocoGroupByPolicy id = (IDUnivocoGroupByPolicy)deleteList.remove(0);
            this.distributedMap.remove((Object)id);
        }
    }

    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        StringBuilder bf = new StringBuilder();
        this.distributedMap.forEach((id, dati) -> {
            IDUnivocoGroupByPolicy datiGroupBy = id;
            bf.append(separatorGroups);
            bf.append("\n");
            bf.append("Sincronizzazione").append(" ").append(this.type.toLabel());
            bf.append("\n");
            bf.append("Criterio di Collezionamento dei Dati\n");
            bf.append(datiGroupBy.toString(true));
            bf.append("\n");
            dati.checkDate(log, this.activePolicy);
            bf.append(dati.toString());
            bf.append("\n");
        });
        if (bf.length() <= 0) {
            bf.append("Nessuna informazione disponibile");
            return bf.toString();
        }
        return bf.toString() + separatorGroups;
    }
}

