/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.driver.xml.DriverConfigurazioneXML;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PddProperties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazione;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneCodifica;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazioneSorgente;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.dynamic.ZipTemplate;
import org.openspcoop2.pdd.core.dynamic.test.ClientTestThread;
import org.openspcoop2.pdd.core.dynamic.test.TestMap;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.sdk.ChannelSecurityToken;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.slf4j.Logger;

public class DynamicTest {
    private static final String ENVELOPE = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><prova>test</prova><prova2>test2</prova2><list>v1</list><list>v2</list><list>v3</list></soapenv:Body></soapenv:Envelope>";
    private static final String JSON = "{\n\"SortAs\": \"SGML\",\n\"GlossTerm\": \"Standard Generalized Markup Language\",\n\"Acronym\": \"SGML\",\n\"Abbrev\": \"ISO 8879:1986\",\n\"Enabled\": true,\n\"Year\": 2018,\n\"Quote\": 1.45, \n\"List\": [ \"Ford\", \"BMW\", \"Fiat\" ]\n}";
    private static final String JSON_TEMPLATE = "{\n\"SortAs\": \"${xpath://prova/text()}\",\n\"GlossTerm\": \"Standard Generalized Markup Language\",\n\"Acronym\": \"${xPath://{http://schemas.xmlsoap.org/soap/envelope/}:Envelope/{http://schemas.xmlsoap.org/soap/envelope/}:Body/prova2/text()}\",\n\"Abbrev\": \"ISO 8879:1986\",\n\"Enabled\": true,\n\"Year\": 2018,\n\"Quote\": 1.45 \n}";
    private static final String XML_TEMPLATE = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><prova>${jsonpath:$.Year}</prova><prova2>${jsonPath:$.Acronym}</prova2></soapenv:Body></soapenv:Envelope>";
    private static final String EXPECTED_JSON = "{\n\"SortAs\": \"test\",\n\"GlossTerm\": \"Standard Generalized Markup Language\",\n\"Acronym\": \"test2\",\n\"Abbrev\": \"ISO 8879:1986\",\n\"Enabled\": true,\n\"Year\": 2018,\n\"Quote\": 1.45 \n}";
    private static final String EXPECTED_JSON_2 = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}";
    private static final String EXPECTED_JSON_3 = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}";
    private static final String EXPECTED_XML = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><prova>2018</prova><prova2>SGML</prova2></soapenv:Body></soapenv:Envelope>";
    private static final String EXPECTED_XML_2 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \n\t\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t\t\t<soapenv:Body>\n\t\t\t<prova>2018</prova>\n\t\t\t<prova2>SGML</prova2>\n\t\t\t<list>Ford</list>\n\t\t\t<list>BMW</list>\n\t\t\t<list>Fiat</list>\n\t\t</soapenv:Body>\n</soapenv:Envelope>\n";
    private static final String EXPECTED_XML_3 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \n\t\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t\t\t<soapenv:Body>\n\t\t\t<prova>az2</prova>\n\t\t\t<prova2>test</prova2>\n\t\t</soapenv:Body>\n</soapenv:Envelope>\n";
    private static final String CONFIG = "<openspcoop2 xmlns=\"http://www.openspcoop2.org/core/config\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.openspcoop2.org/core/config config.xsd\">\n\t<soggetto tipo=\"proxy\" nome=\"MinisteroFruitore\" />\n   <configurazione> \n          <accesso-registro>\n               <registro nome=\"registroXML\" tipo=\"xml\" location=\"registroServizi.xml\" />\n          </accesso-registro>\n          <inoltro-buste-non-riscontrate cadenza=\"60\" />\n          <messaggi-diagnostici severita-log4j=\"infoIntegration\" severita=\"infoIntegration\" />\n          <system-properties>\n          \t\t<system-property nome=\"systemP1\" valore=\"systemV1\"/>\n          \t\t<system-property nome=\"systemP2\" valore=\"systemV2\"/>\n          </system-properties>\n     </configurazione>\n</openspcoop2>";
    private static final String JSON_COMPLEX = "{\n\"esempioString\": \"ValoreString\",\n\"esempioInt\": 13,\n\"esempioBoolean\": false,\n\"esempioFloat\": 13.2,\n\"esempioList\": [ \"Ford\", \"BMW\", \"Fiat\" ],\n\"esempioComplex\": {\n    \"esempioInternoString\": \"ValoreInternoString\",\n    \"esempioInternoInt\": 99,\n    \"esempioInternoBoolean\": true,\n    \"esempioInternoFloat\": 66.6,\n    \"esempioInternoList\": [ \"InternoFord\", \"InternoBMW\", \"InternoFiat\" ],\n    \"esempioInternoComplex\": {\n        \"esempioInternoInternoString\": \"ValoreInternoInternoString\",\n        \"esempioInternoInternoList\": [ 3 , 4, 6 ]\n    }\n}\n}";
    private static String PEM = "-----BEGIN CERTIFICATE-----\nMIIDjDCCAnSgAwIBAgIEYWaY3jANBgkqhkiG9w0BAQsFADCBhjEcMBoGCSqGSIb3\nDQEJARYNYXBvbGlAbGluay5pdDELMAkGA1UEBhMCSVQxDjAMBgNVBAgMBUl0YWx5\nMQ0wCwYDVQQHDARQaXNhMRcwFQYDVQQKDA5vcGVuc3Bjb29wLm9yZzENMAsGA1UE\nCwwEdGVzdDESMBAGA1UEAwwJU29nZ2V0dG8xMCAXDTIxMTAxMzA4MjkxOFoYDzIx\nMjEwOTE5MDgyOTE4WjCBhjEcMBoGCSqGSIb3DQEJARYNYXBvbGlAbGluay5pdDEL\nMAkGA1UEBhMCSVQxDjAMBgNVBAgMBUl0YWx5MQ0wCwYDVQQHDARQaXNhMRcwFQYD\nVQQKDA5vcGVuc3Bjb29wLm9yZzENMAsGA1UECwwEdGVzdDESMBAGA1UEAwwJU29n\nZ2V0dG8xMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1+gnDk9+xId2\nZsK0niTQ7IYD3aqsoBnYQuvKyovhJZ2yWoLQzxyqp+y8La0Qd8+P3WoRNTq6LuXk\nTT+lJYOFH8K//QUBeZncTy6ygrcZjAnaXPk45HehIMSunHXq36sBNC2IK4mk4NMF\nZ0vwoemX0pqFefSp0LtOuKZDLQG5n29SLp4fBCPndizRP6lvgE/sYt14j3t6kGWd\nFfrz6yylXzIrfn6jxYzAnY/1RvbOYp87cnTv/O4BpZ0s0Hh0iCBBbVrzCYPanydw\npq/Q4cQ9D5atlBO2l2pvI0vvZ5lGIn7Fym7nN7J67h7XBtprwrT0ihhH3MnoiioG\nnlqIO6j+awIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQCY+vg91jMi+hgbWFOHNmHt\n9YWoKbxD6k2LmCup7WjXlpoXJKkpH63rIFjJKe43eL3Pt+9Jenl2IFp7DFl8gln0\nRlgQdzJ6xpqlqcOFnDDwcnWKAcJiS6LGbcMyCF9Y9G0fP/74LgZUlHMMZqRj0FQN\nsX8hv+oyoN+q1gbwY0RaYCukxWm08OODVQvxX6Sf7zVBd1bh8h73MxRTa8l5LL8g\nnQkyHEnYrqWvfdqDWTvZmZuKb5PP4xNCm1sqSr/bgcr3Sr6wPF2LS3mENO3PoUJY\nJIm5Z4+1pMwViwc4EpuJ5Lz2gC7KiqDGnbBLueLtHb/X9jMyqQ1c3nWBZM2R1LgB\n-----END CERTIFICATE-----";

    public static void main(String[] args) throws Exception {
        DynamicTest.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test() throws Exception {
        File fTmpConfig = File.createTempFile("configTest", ".xml");
        File fTmpOp2Properties = File.createTempFile("govway", ".properties");
        try {
            String prefix = "$";
            String prefixOptional = "?";
            boolean addPrefixError = true;
            boolean forceDollaro = true;
            Logger log = LoggerWrapperFactory.getLogger(DynamicTest.class);
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
            ConnettoreMsg connettoreMsg = new ConnettoreMsg();
            connettoreMsg.setPropertiesTrasporto(new HashMap<String, List<String>>());
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)"Header1", (String)"Valore1");
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)"Header2", (String)"Valore2");
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)"Header3.1", (String)"Valore3.1");
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)"Header3.(2)", (String)"Valore3.(2)");
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)"Header3.[\"3\"4\"]", (String)"Valore3.[\"3\"4\"]");
            connettoreMsg.setPropertiesUrlBased(new HashMap<String, List<String>>());
            TransportUtils.addParameter(connettoreMsg.getPropertiesUrlBased(), (String)"P1", (String)"Valore1URL");
            TransportUtils.addParameter(connettoreMsg.getPropertiesUrlBased(), (String)"P2", (String)"Valore2URL");
            FileSystemUtilities.writeFile((String)fTmpOp2Properties.getAbsolutePath(), (byte[])"org.openspcoop2.pdd.confDirectory=/tmp\norg.openspcoop2.pdd.server=web".getBytes());
            OpenSPCoop2Properties.initialize(null, fTmpOp2Properties.getAbsolutePath());
            PddProperties.initialize(fTmpOp2Properties.getAbsolutePath(), null);
            AccessoConfigurazionePdD config = new AccessoConfigurazionePdD();
            config.setTipo("xml");
            config.setLocation(fTmpConfig.getAbsolutePath());
            FileSystemUtilities.writeFile((String)fTmpConfig.getAbsolutePath(), (byte[])CONFIG.getBytes());
            DriverConfigurazioneXML.disableBuildXsdValidator();
            ConfigurazionePdDReader.initialize(config, log, log, null, null, true, false, false, false, null, CacheType.JCS);
            PdDContext pddContext = new PdDContext();
            MapKey TEST1 = Map.newMapKey((String)"TEST1");
            MapKey TEST2 = Map.newMapKey((String)"TEST2.1.a.2.3");
            pddContext.addObject(TEST1, "VALORE DI ESEMPIO");
            boolean bufferMessage_readOnly = true;
            String idTransazione = "xxyy";
            pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
            InformazioniIntegrazioneSorgente sourceType = InformazioniIntegrazioneSorgente.http_header;
            String sourceName = "GovWay-Integration";
            InformazioniIntegrazioneCodifica sourceEncodeType = InformazioniIntegrazioneCodifica.base64;
            boolean sourceRequired = true;
            HttpServletTransportRequestContext transportRequestContext = new HttpServletTransportRequestContext();
            TransportUtils.addHeader(connettoreMsg.getPropertiesTrasporto(), (String)sourceName, (String)Base64Utilities.encodeAsString((byte[])JSON_COMPLEX.getBytes()));
            transportRequestContext.setHeaders(connettoreMsg.getPropertiesTrasporto());
            InformazioniIntegrazione infoIntegration = new InformazioniIntegrazione(sourceType, sourceName, sourceEncodeType, sourceRequired, log, (TransportRequestContext)transportRequestContext);
            pddContext.addObject(Costanti.INFORMAZIONI_INTEGRAZIONE, infoIntegration);
            RequestInfo requestInfo = new RequestInfo();
            requestInfo.setIdTransazione("Test");
            requestInfo.setIdentitaPdD(new IDSoggetto("TIPO", null));
            pddContext.addObject(Costanti.REQUEST_INFO, requestInfo);
            URLProtocolContextImpl urlProtocolContext = new URLProtocolContextImpl(log);
            urlProtocolContext.setHeaders(connettoreMsg.getPropertiesTrasporto());
            requestInfo.setProtocolContext((URLProtocolContext)urlProtocolContext);
            pddContext.addObject(TEST2, urlProtocolContext);
            Certificate cer = ArchiveLoader.load((byte[])PEM.getBytes());
            SecurityToken securityToken = new SecurityToken();
            securityToken.setChannel(new ChannelSecurityToken());
            securityToken.getChannel().setCertificate(cer.getCertificate());
            pddContext.addObject(Costanti.SECURITY_TOKEN, securityToken);
            DynamicInfo dInfo = new DynamicInfo(connettoreMsg, pddContext);
            DynamicUtils.fillDynamicMap(log, dynamicMap, dInfo);
            Object expr = prefix + "{transaction:id}";
            DynamicUtils.validate("testTransactionId", (String)expr, addPrefixError);
            String value = DynamicUtils.convertDynamicPropertyValue("testTransactionId", (String)expr, dynamicMap, pddContext);
            System.out.println("TransactionID: " + value + "\n\n");
            Object expected = idTransazione;
            if (!((String)expected).equals(value)) {
                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
            }
            expr = prefixOptional + "{transaction:id}";
            DynamicUtils.validate("testTransactionId", (String)expr, addPrefixError);
            value = DynamicUtils.convertDynamicPropertyValue("testTransactionId", (String)expr, dynamicMap, pddContext);
            System.out.println("optional TransactionID: " + value + "\n\n");
            expected = idTransazione;
            if (!((String)expected).equals(value)) {
                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
            }
            expr = prefixOptional + "{securityToken:channel.certificate.subject.CN(\".*gg([\\w\\t-_][\\w\\t-_][\\w\\t-_]).*\")}";
            DynamicUtils.validate("testSecurityToken", (String)expr, addPrefixError);
            value = DynamicUtils.convertDynamicPropertyValue("testSecurityToken", (String)expr, dynamicMap, pddContext);
            System.out.println("testSecurityToken: " + value + "\n\n");
            expected = "ett";
            if (!((String)expected).equals(value)) {
                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
            }
            String pattern = ".*gg([\\w\\t-_\"][\\w\\t-_\"][\\w\\t-_\"]).*";
            expr = prefixOptional + "{securityToken:channel.certificate.subject.CN(\"" + pattern + "\")}";
            DynamicUtils.validate("testSecurityTokenVirgoletteInMezzo", (String)expr, addPrefixError);
            value = DynamicUtils.convertDynamicPropertyValue("testSecurityTokenVirgoletteInMezzo", (String)expr, dynamicMap, pddContext);
            System.out.println("testSecurityToken: " + value + "\n\n");
            expected = "ett";
            if (!((String)expected).equals(value)) {
                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
            }
            expr = prefix + "{keywordNotExists:id}";
            DynamicUtils.validate("testKeywordNotExists:id", (String)expr, addPrefixError);
            try {
                DynamicUtils.convertDynamicPropertyValue("testKeywordNotExists:id", (String)expr, dynamicMap, pddContext);
                throw new Exception("Attesa eccezione");
            }
            catch (Exception e) {
                String atteso = "object with key 'keywordNotExists' not found";
                if (!e.getMessage().contains(atteso)) {
                    throw e;
                }
                System.out.println("Eccezione attesa: " + e.getMessage() + "\n\n");
                expr = prefixOptional + "{keywordNotExists:id}";
                DynamicUtils.validate("optional testKeywordNotExists:id", (String)expr, addPrefixError);
                value = DynamicUtils.convertDynamicPropertyValue("optional testKeywordNotExists:id", (String)expr, dynamicMap, pddContext);
                System.out.println("optional testKeywordNotExists:id: " + value + "\n\n");
                if (value != null) {
                    throw new Exception("Expected null value, found '" + value + "'");
                }
                expr = prefix + "{context:TEST1}";
                DynamicUtils.validate("testPddContext", (String)expr, addPrefixError);
                value = DynamicUtils.convertDynamicPropertyValue("testPddContext", (String)expr, dynamicMap, pddContext);
                System.out.println("testPddContext: " + value + "\n\n");
                expected = "VALORE DI ESEMPIO";
                if (!((String)expected).equals(value)) {
                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                }
                expr = prefixOptional + "{context:TEST1}";
                DynamicUtils.validate("testPddContext", (String)expr, addPrefixError);
                value = DynamicUtils.convertDynamicPropertyValue("testPddContext", (String)expr, dynamicMap, pddContext);
                System.out.println("optional testPddContext: " + value + "\n\n");
                expected = "VALORE DI ESEMPIO";
                if (!((String)expected).equals(value)) {
                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                }
                expr = prefix + "{context:test1}";
                DynamicUtils.validate("testPddContextLowerCase", (String)expr, addPrefixError);
                value = DynamicUtils.convertDynamicPropertyValue("testPddContextLowerCase", (String)expr, dynamicMap, pddContext);
                System.out.println("testPddContextLowerCase: " + value + "\n\n");
                expected = "VALORE DI ESEMPIO";
                if (!((String)expected).equals(value)) {
                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                }
                expr = prefix + "{context:TesT1}";
                DynamicUtils.validate("testPddContextMixedCase", (String)expr, addPrefixError);
                value = DynamicUtils.convertDynamicPropertyValue("testPddContextMixedCase", (String)expr, dynamicMap, pddContext);
                System.out.println("testPddContextMixedCase: " + value + "\n\n");
                expected = "VALORE DI ESEMPIO";
                if (!((String)expected).equals(value)) {
                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                }
                expr = prefix + "{context:keywordNotExists}";
                DynamicUtils.validate("testContextKeywordNotExists", (String)expr, addPrefixError);
                try {
                    DynamicUtils.convertDynamicPropertyValue("testContextKeywordNotExists", (String)expr, dynamicMap, pddContext);
                    throw new Exception("Attesa eccezione");
                }
                catch (Exception e2) {
                    atteso = "'keywordNotExists' not exists in map";
                    if (!e2.getMessage().contains(atteso)) {
                        throw e2;
                    }
                    System.out.println("Eccezione attesa: " + e2.getMessage() + "\n\n");
                    expr = prefixOptional + "{context:keywordNotExists}";
                    DynamicUtils.validate("optional testContextKeywordNotExists", (String)expr, addPrefixError);
                    value = DynamicUtils.convertDynamicPropertyValue("optional testContextKeywordNotExists", (String)expr, dynamicMap, pddContext);
                    System.out.println("optional testContextKeywordNotExists: " + value + "\n\n");
                    if (value != null) {
                        throw new Exception("Expected null value, found '" + value + "'");
                    }
                    expr = prefix + "{context:REQUEST_INFO.idTransazione}";
                    DynamicUtils.validate("testPddContextRequestInfoIdTransazione", (String)expr, addPrefixError);
                    value = DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoIdTransazione", (String)expr, dynamicMap, pddContext);
                    System.out.println("testPddContextRequestInfoIdTransazione: " + value + "\n\n");
                    expected = "Test";
                    if (!((String)expected).equals(value)) {
                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                    }
                    expr = prefix + "{context:REQUEST_INFO.messageFactory}";
                    DynamicUtils.validate("testPddContextRequestInfoMessageFactoryNotExists", (String)expr, addPrefixError);
                    try {
                        DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoMessageFactoryNotExists", (String)expr, dynamicMap, pddContext);
                        throw new Exception("Attesa eccezione");
                    }
                    catch (Exception e3) {
                        atteso = "return null object";
                        if (!e3.getMessage().contains(atteso)) {
                            throw e3;
                        }
                        System.out.println("Eccezione attesa: " + e3.getMessage() + "\n\n");
                        expr = prefixOptional + "{context:REQUEST_INFO.messageFactory}";
                        DynamicUtils.validate("optional testPddContextRequestInfoMessageFactoryNotExists", (String)expr, addPrefixError);
                        value = DynamicUtils.convertDynamicPropertyValue("optional testPddContextRequestInfoMessageFactoryNotExists", (String)expr, dynamicMap, pddContext);
                        System.out.println("optional testPddContextRequestInfoMessageFactoryNotExists: " + value + "\n\n");
                        if (value != null) {
                            throw new Exception("Expected null value, found '" + value + "'");
                        }
                        expr = prefix + "{context:REQUEST_INFO.idServizio}";
                        DynamicUtils.validate("testPddContextRequestInfoIdServizioNotExists", (String)expr, addPrefixError);
                        try {
                            DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoIdServizioNotExists", (String)expr, dynamicMap, pddContext);
                            throw new Exception("Attesa eccezione");
                        }
                        catch (Exception e4) {
                            atteso = "return null object";
                            if (!e4.getMessage().contains(atteso)) {
                                throw e4;
                            }
                            System.out.println("Eccezione attesa: " + e4.getMessage() + "\n\n");
                            expr = prefixOptional + "{context:REQUEST_INFO.idServizio}";
                            DynamicUtils.validate("optional testPddContextRequestInfoIdServizioNotExists", (String)expr, addPrefixError);
                            value = DynamicUtils.convertDynamicPropertyValue("optional testPddContextRequestInfoIdServizioNotExists", (String)expr, dynamicMap, pddContext);
                            System.out.println("optional testPddContextRequestInfoIdServizioNotExists: " + value + "\n\n");
                            if (value != null) {
                                throw new Exception("Expected null value, found '" + value + "'");
                            }
                            expr = prefix + "{context:REQUEST_INFO.identitaPdD.tipo}";
                            DynamicUtils.validate("testPddContextRequestInfoNomeIdentitaPdD", (String)expr, addPrefixError);
                            value = DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoNomeIdentitaPdD", (String)expr, dynamicMap, pddContext);
                            System.out.println("testPddContextRequestInfoNomeIdentitaPdD: " + value + "\n\n");
                            expected = "TIPO";
                            if (!((String)expected).equals(value)) {
                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                            }
                            expr = prefixOptional + "{context:REQUEST_INFO.identitaPdD.tipo}";
                            DynamicUtils.validate("testPddContextRequestInfoNomeIdentitaPdD", (String)expr, addPrefixError);
                            value = DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoNomeIdentitaPdD", (String)expr, dynamicMap, pddContext);
                            System.out.println("testPddContextRequestInfoNomeIdentitaPdD: " + value + "\n\n");
                            expected = "TIPO";
                            if (!((String)expected).equals(value)) {
                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                            }
                            expr = prefix + "{context:REQUEST_INFO.identitaPdD.nome}";
                            DynamicUtils.validate("testPddContextRequestInfoNomeIdentitaPdDNotExists", (String)expr, addPrefixError);
                            try {
                                DynamicUtils.convertDynamicPropertyValue("testPddContextRequestInfoNomeIdentitaPdDNotExists", (String)expr, dynamicMap, pddContext);
                                throw new Exception("Attesa eccezione");
                            }
                            catch (Exception e5) {
                                atteso = "return null object";
                                if (!e5.getMessage().contains(atteso)) {
                                    throw e5;
                                }
                                System.out.println("Eccezione attesa: " + e5.getMessage() + "\n\n");
                                expr = prefixOptional + "{context:REQUEST_INFO.identitaPdD.nome}";
                                DynamicUtils.validate("optional testPddContextRequestInfoNomeIdentitaPdDNotExists", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("optional testPddContextRequestInfoNomeIdentitaPdDNotExists", (String)expr, dynamicMap, pddContext);
                                System.out.println("optional testPddContextRequestInfoNomeIdentitaPdDNotExists: " + value + "\n\n");
                                if (value != null) {
                                    throw new Exception("Expected null value, found '" + value + "'");
                                }
                                expr = prefix + "{context:[TEST2.1.a.2.3].headerFirstValue(Header3.1)}";
                                DynamicUtils.validate("testContextHeaderParametroConPuntoMethod", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testContextHeaderParametroConPuntoMethod", (String)expr, dynamicMap, pddContext);
                                System.out.println("testContextHeaderParametroConPuntoMethod: " + value + "\n\n");
                                expected = "Valore3.1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{context:(TEST2.1.a.2.3).headerFirstValue(Header3.1)}";
                                DynamicUtils.validate("testContextHeaderParametroConPuntoMethod2", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testContextHeaderParametroConPuntoMethod2", (String)expr, dynamicMap, pddContext);
                                System.out.println("testContextHeaderParametroConPuntoMethod2: " + value + "\n\n");
                                expected = "Valore3.1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{context:[TEST2.1.a.2.3].headerValues(Header3.1)[0]}";
                                DynamicUtils.validate("testContextHeaderParametroConPuntoEArray", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testContextHeaderParametroConPuntoEArray", (String)expr, dynamicMap, pddContext);
                                System.out.println("testContextHeaderParametroConPuntoEArray: " + value + "\n\n");
                                expected = "Valore3.1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{context:[TEST2.1.a.2.3].headerFirstValue(Header3.(2))}";
                                DynamicUtils.validate("testContextHeaderParametroConPuntoMethodParentesiValue", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testContextHeaderParametroConPuntoMethodParentesiValue", (String)expr, dynamicMap, pddContext);
                                System.out.println("testContextHeaderParametroConPuntoMethodParentesiValue: " + value + "\n\n");
                                expected = "Valore3.(2)";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{context:[TEST2.1.a.2.3].headerFirstValue(Header3.[\"3\"4\"])}";
                                DynamicUtils.validate("testContextHeaderParametroConPuntoMethodParentesiValue2", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testContextHeaderParametroConPuntoMethodParentesiValue2", (String)expr, dynamicMap, pddContext);
                                System.out.println("testContextHeaderParametroConPuntoMethodParentesiValue2: " + value + "\n\n");
                                expected = "Valore3.[\"3\"4\"]";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = "VALORE_INIZIALE_STATICO_" + prefix + "{context:TEST1}_VALORE_FINALE_STATICO";
                                DynamicUtils.validate("testPddContext", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testPddContext", (String)expr, dynamicMap, pddContext);
                                System.out.println("testPddContext: " + value + "\n\n");
                                expected = "VALORE_INIZIALE_STATICO_VALORE DI ESEMPIO_VALORE_FINALE_STATICO";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = "VALORE_INIZIALE_STATICO_?" + prefix + "{context:TEST1}_VALORE_FINALE_STATICO?";
                                DynamicUtils.validate("testPddContext", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testPddContext", (String)expr, dynamicMap, pddContext);
                                System.out.println("testPddContext: " + value + "\n\n");
                                expected = "VALORE_INIZIALE_STATICO_?VALORE DI ESEMPIO_VALORE_FINALE_STATICO?";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = "VALORE_INIZIALE_STATICO_$" + prefixOptional + "{context:TEST1}_VALORE_FINALE_STATICO$?$";
                                DynamicUtils.validate("testPddContext", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testPddContext", (String)expr, dynamicMap, pddContext);
                                System.out.println("testPddContext: " + value + "\n\n");
                                expected = "VALORE_INIZIALE_STATICO_$VALORE DI ESEMPIO_VALORE_FINALE_STATICO$?$";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{header:Header1}";
                                DynamicUtils.validate("testHeader", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testHeader", (String)expr, dynamicMap, pddContext);
                                System.out.println("testHeader: " + value + "\n\n");
                                expected = "Valore1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{header:header1}";
                                DynamicUtils.validate("testHeaderLowerCase", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testHeaderLowerCase", (String)expr, dynamicMap, pddContext);
                                System.out.println("testHeaderLowerCase: " + value + "\n\n");
                                expected = "Valore1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{header:HEADER1}";
                                DynamicUtils.validate("testHeaderUpperCase", (String)expr, addPrefixError);
                                value = DynamicUtils.convertDynamicPropertyValue("testHeaderUpperCase", (String)expr, dynamicMap, pddContext);
                                System.out.println("testHeaderUpperCase: " + value + "\n\n");
                                expected = "Valore1";
                                if (!((String)expected).equals(value)) {
                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                }
                                expr = prefix + "{header:keywordNotExists}";
                                DynamicUtils.validate("testHeaderKeywordNotExists", (String)expr, addPrefixError);
                                try {
                                    DynamicUtils.convertDynamicPropertyValue("testHeaderKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                    throw new Exception("Attesa eccezione");
                                }
                                catch (Exception e6) {
                                    atteso = "'keywordNotExists' not exists in map";
                                    if (!e6.getMessage().contains(atteso)) {
                                        throw e6;
                                    }
                                    System.out.println("Eccezione attesa: " + e6.getMessage() + "\n\n");
                                    expr = prefixOptional + "{header:keywordNotExists}";
                                    DynamicUtils.validate("optional testHeaderKeywordNotExists", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("optional testHeaderKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                    System.out.println("optional testHeaderKeywordNotExists: " + value + "\n\n");
                                    if (value != null) {
                                        throw new Exception("Expected null value, found '" + value + "'");
                                    }
                                    expr = prefix + "{header:[Header3.1]}";
                                    DynamicUtils.validate("testHeaderParametroConPunto", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPunto", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPunto: " + value + "\n\n");
                                    expected = "Valore3.1";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{transportContext:headerFirstValue(Header3.1)}";
                                    DynamicUtils.validate("testHeaderParametroConPuntoMethod", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPuntoMethod", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPuntoMethod: " + value + "\n\n");
                                    expected = "Valore3.1";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{transportContext:headerValues(Header3.1)[0]}";
                                    DynamicUtils.validate("testHeaderParametroConPuntoEArray", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPuntoEArray", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPuntoEArray: " + value + "\n\n");
                                    expected = "Valore3.1";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{header:[Header3.(2)]}";
                                    DynamicUtils.validate("testHeaderParametroConPunto2", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPunto2", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPunto2: " + value + "\n\n");
                                    expected = "Valore3.(2)";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{transportContext:headerFirstValue(Header3.(2))}";
                                    DynamicUtils.validate("testHeaderParametroConPuntoMethod2", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPuntoMethod2", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPuntoMethod2: " + value + "\n\n");
                                    expected = "Valore3.(2)";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{transportContext:headerValues(Header3.(2))[0]}";
                                    DynamicUtils.validate("testHeaderParametroConPuntoEArray2", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPuntoEArray2", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPuntoEArray2: " + value + "\n\n");
                                    expected = "Valore3.(2)";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{header:[Header3.[\"3\"4\"]]}";
                                    DynamicUtils.validate("testHeaderParametroConPunto3", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPunto3", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPunto3: " + value + "\n\n");
                                    expected = "Valore3.[\"3\"4\"]";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{transportContext:headerFirstValue(Header3.[\"3\"4\"])}";
                                    DynamicUtils.validate("testHeaderParametroConPuntoMethod3", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testHeaderParametroConPuntoMethod3", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testHeaderParametroConPuntoMethod3: " + value + "\n\n");
                                    expected = "Valore3.[\"3\"4\"]";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{query:P1}";
                                    DynamicUtils.validate("testUrl", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testUrl", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testUrl: " + value + "\n\n");
                                    expected = "Valore1URL";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{query:p1}";
                                    DynamicUtils.validate("testUrlLowerCase", (String)expr, addPrefixError);
                                    value = DynamicUtils.convertDynamicPropertyValue("testUrlLowerCase", (String)expr, dynamicMap, pddContext);
                                    System.out.println("testUrlLowerCase: " + value + "\n\n");
                                    expected = "Valore1URL";
                                    if (!((String)expected).equals(value)) {
                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                    }
                                    expr = prefix + "{query:keywordNotExists}";
                                    DynamicUtils.validate("testUrlKeywordNotExists", (String)expr, addPrefixError);
                                    try {
                                        DynamicUtils.convertDynamicPropertyValue("testUrlKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                        throw new Exception("Attesa eccezione");
                                    }
                                    catch (Exception e7) {
                                        atteso = "'keywordNotExists' not exists in map";
                                        if (!e7.getMessage().contains(atteso)) {
                                            throw e7;
                                        }
                                        System.out.println("Eccezione attesa: " + e7.getMessage() + "\n\n");
                                        expr = prefixOptional + "{query:keywordNotExists}";
                                        DynamicUtils.validate("optional testUrlKeywordNotExists", (String)expr, addPrefixError);
                                        value = DynamicUtils.convertDynamicPropertyValue("optional testUrlKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                        System.out.println("optional testUrlKeywordNotExists: " + value + "\n\n");
                                        if (value != null) {
                                            throw new Exception("Expected null value, found '" + value + "'");
                                        }
                                        expr = "MixedString-" + prefix + "{query:p1}-" + prefix + "{header:header1}";
                                        DynamicUtils.validate("testMixedString", (String)expr, addPrefixError);
                                        value = DynamicUtils.convertDynamicPropertyValue("testMixedString", (String)expr, dynamicMap, pddContext);
                                        System.out.println("testMixedString: " + value + "\n\n");
                                        expected = "MixedString-Valore1URL-Valore1";
                                        if (!((String)expected).equals(value)) {
                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                        }
                                        expr = "MixedString-" + prefix + "{query:keywordNotExists}-" + prefix + "{header:keywordNotExists}";
                                        DynamicUtils.validate("testMixedStringKeywordNotExists", (String)expr, addPrefixError);
                                        try {
                                            DynamicUtils.convertDynamicPropertyValue("testMixedStringKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                            throw new Exception("Attesa eccezione");
                                        }
                                        catch (Exception e8) {
                                            atteso = "'keywordNotExists' not exists in map";
                                            if (!e8.getMessage().contains(atteso)) {
                                                throw e8;
                                            }
                                            System.out.println("Eccezione attesa: " + e8.getMessage() + "\n\n");
                                            expr = "MixedString-" + prefixOptional + "{query:keywordNotExists}-" + prefixOptional + "{header:keywordNotExists}";
                                            DynamicUtils.validate("optional testMixedStringKeywordNotExists", (String)expr, addPrefixError);
                                            value = DynamicUtils.convertDynamicPropertyValue("optional testMixedStringKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                            System.out.println("optional testMixedStringKeywordNotExists: " + value + "\n\n");
                                            expected = "MixedString--";
                                            if (!((String)expected).equals(value)) {
                                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                            }
                                            expr = prefix + "{integration:info[esempioString]}";
                                            DynamicUtils.validate("testIntegrationContextString", (String)expr, addPrefixError);
                                            value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextString", (String)expr, dynamicMap, pddContext);
                                            System.out.println("testIntegrationContextString: " + value + "\n\n");
                                            expected = "ValoreString";
                                            if (!((String)expected).equals(value)) {
                                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                            }
                                            expr = prefix + "{integration:info[keywordNotExists]}";
                                            DynamicUtils.validate("testIntegrationContexKeywordNotExistst", (String)expr, addPrefixError);
                                            try {
                                                DynamicUtils.convertDynamicPropertyValue("testIntegrationContexKeywordNotExistst", (String)expr, dynamicMap, pddContext);
                                                throw new Exception("Attesa eccezione");
                                            }
                                            catch (Exception e9) {
                                                atteso = "'keywordNotExists' not exists in map";
                                                if (!e9.getMessage().contains(atteso)) {
                                                    throw e9;
                                                }
                                                System.out.println("Eccezione attesa: " + e9.getMessage() + "\n\n");
                                                expr = prefixOptional + "{integration:info[keywordNotExists]}";
                                                DynamicUtils.validate("optional testIntegrationContexKeywordNotExistst", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("optional testIntegrationContexKeywordNotExistst", (String)expr, dynamicMap, pddContext);
                                                System.out.println("optional testIntegrationContexKeywordNotExistst: " + value + "\n\n");
                                                expected = "MixedString--";
                                                if (value != null) {
                                                    throw new Exception("Expected null value, found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInt]}";
                                                DynamicUtils.validate("testIntegrationContextInt", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInt", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInt: " + value + "\n\n");
                                                expected = "13";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioBoolean]}";
                                                DynamicUtils.validate("testIntegrationContextBoolean", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextBoolean", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextBoolean: " + value + "\n\n");
                                                expected = "false";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioFloat]}";
                                                DynamicUtils.validate("testIntegrationContextFloat", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextFloat", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextFloat: " + value + "\n\n");
                                                expected = "13.2";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioList]}";
                                                DynamicUtils.validate("testIntegrationContextList", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextList", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextList: " + value + "\n\n");
                                                expected = "[Ford, BMW, Fiat]";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioList][1]}";
                                                DynamicUtils.validate("testIntegrationContextList1", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextList1", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextList1: " + value + "\n\n");
                                                expected = "BMW";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInternoString]}";
                                                DynamicUtils.validate("testIntegrationContextInternoString", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoString", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoString: " + value + "\n\n");
                                                expected = "ValoreInternoString";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:claims[esempioComplex.esempioInternoString]}";
                                                DynamicUtils.validate("testIntegrationContextInternoStringAsClaim", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoStringAsClaim", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoStringAsClaim: " + value + "\n\n");
                                                expected = "ValoreInternoString";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInternoList]}";
                                                DynamicUtils.validate("testIntegrationContextInternoList", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoList", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoList: " + value + "\n\n");
                                                expected = "[InternoFord, InternoBMW, InternoFiat]";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:claims[esempioComplex.esempioInternoList]}";
                                                DynamicUtils.validate("testIntegrationContextInternoListAsClaim", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoListAsClaim", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoListAsClaim: " + value + "\n\n");
                                                expected = "[InternoFord, InternoBMW, InternoFiat]";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInternoList][2]}";
                                                DynamicUtils.validate("testIntegrationContextInternoList2", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoList2", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoList2: " + value + "\n\n");
                                                expected = "InternoFiat";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:claims[esempioComplex.esempioInternoList][2]}";
                                                DynamicUtils.validate("testIntegrationContextInternoList2AsClaim", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoList2AsClaim", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoList2AsClaim: " + value + "\n\n");
                                                expected = "InternoFiat";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInternoComplex.esempioInternoInternoString]}";
                                                DynamicUtils.validate("testIntegrationContextInternoInternoString", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoInternoString", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoInternoString: " + value + "\n\n");
                                                expected = "ValoreInternoInternoString";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:claims[esempioComplex.esempioInternoComplex.esempioInternoInternoString]}";
                                                DynamicUtils.validate("testIntegrationContextInternoInternoStringAsClaim", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoInternoStringAsClaim", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoInternoStringAsClaim: " + value + "\n\n");
                                                expected = "ValoreInternoInternoString";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:info[esempioInternoComplex.esempioInternoInternoList][2]}";
                                                DynamicUtils.validate("testIntegrationContextInternoInternoList2", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoInternoList2", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoInternoList2: " + value + "\n\n");
                                                expected = "6";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{integration:claims[esempioComplex.esempioInternoComplex.esempioInternoInternoList][2]}";
                                                DynamicUtils.validate("testIntegrationContextInternoInternoList2AsClaim", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testIntegrationContextInternoInternoList2AsClaim", (String)expr, dynamicMap, pddContext);
                                                System.out.println("testIntegrationContextInternoInternoList2AsClaim: " + value + "\n\n");
                                                expected = "6";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                dynamicMap = new HashMap();
                                                dInfo = new DynamicInfo(connettoreMsg, pddContext);
                                                OpenSPCoop2MessageParseResult parser = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.SOAP_11, MessageRole.NONE, "text/xml", ENVELOPE.getBytes(), AttachmentsProcessingMode.getMemoryCacheProcessingMode());
                                                MessageContent messageContent = new MessageContent(parser.getMessage().castAsSoap(), bufferMessage_readOnly, (Context)pddContext);
                                                dInfo.setMessageContent(messageContent);
                                                DynamicUtils.fillDynamicMap(log, dynamicMap, dInfo);
                                                expr = prefix + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}:Envelope/{http://schemas.xmlsoap.org/soap/envelope/}:Body/prova/text()}";
                                                DynamicUtils.validate("testXml", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXml", (String)expr, dynamicMap, pddContext);
                                                System.out.println("Pattern1: " + value);
                                                expected = "test";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}Envelope/{http://schemas.xmlsoap.org/soap/envelope/}Body/prova/text()}";
                                                DynamicUtils.validate("testXml", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXml", (String)expr, dynamicMap, pddContext);
                                                System.out.println("Pattern1b: " + value);
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}Envelope/{http://schemas.xmlsoap.org/soap/envelope/}Body/prova/text()}";
                                                DynamicUtils.validate("testXml", (String)expr, !forceDollaro, true);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXml", (String)expr, dynamicMap, pddContext, !forceDollaro);
                                                System.out.println("Pattern1c: " + value);
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{xpath://prova/text()}";
                                                DynamicUtils.validate("testXml2", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXml2", (String)expr, dynamicMap, pddContext);
                                                System.out.println("Pattern2: " + value);
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = "Metto un po (" + prefix + "{xPath://prova/text()}) di testo prima (" + prefix + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}:Envelope/{http://schemas.xmlsoap.org/soap/envelope/}:Body/prova2/text()}) e dopo";
                                                DynamicUtils.validate("testXml3", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXml3", (String)expr, dynamicMap, pddContext);
                                                System.out.println("Pattern3: " + value);
                                                expected = "Metto un po (test) di testo prima (test2) e dopo";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{xpath://provaNonEsiste/text()}";
                                                DynamicUtils.validate("testXmlPatternNotFound", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("testXmlPatternNotFound", (String)expr, dynamicMap, pddContext);
                                                System.out.println("Pattern4: " + value);
                                                expected = "";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefixOptional + "{xpath://provaNonEsiste/text()}";
                                                DynamicUtils.validate("optional testXmlPatternNotFound", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("optional testXmlPatternNotFound", (String)expr, dynamicMap, pddContext);
                                                System.out.println("optional testXmlPatternNotFound: " + value + "\n\n");
                                                if (value != null) {
                                                    throw new Exception("Expected null value, found '" + value + "'");
                                                }
                                                expr = "Metto un po (" + prefixOptional + "{xPath://provaNonEsiste/text()}) di testo prima (" + prefixOptional + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}:Envelope/{http://schemas.xmlsoap.org/soap/envelope/}:Body/prova2/text()}) e dopo";
                                                DynamicUtils.validate("optional testXml3 con mix non esiste", (String)expr, addPrefixError);
                                                value = DynamicUtils.convertDynamicPropertyValue("optional testXml3 con mix non esiste", (String)expr, dynamicMap, pddContext);
                                                System.out.println("optional testXml3 con mix non esiste: " + value);
                                                expected = "Metto un po () di testo prima (test2) e dopo";
                                                if (!((String)expected).equals(value)) {
                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                }
                                                expr = prefix + "{xpath://provaNonEsiste/Text()}";
                                                DynamicUtils.validate("testXmlPatternError", (String)expr, addPrefixError);
                                                try {
                                                    System.out.println("Pattern5: " + DynamicUtils.convertDynamicPropertyValue("testXmlPatternError", (String)expr, dynamicMap, pddContext, forceDollaro));
                                                    throw new Exception("Attesa eccezione pattern malformato");
                                                }
                                                catch (Exception e10) {
                                                    if (!e10.getMessage().contains("Compilazione dell'espressione XPATH ha causato un errore (Unknown nodetype: Text)")) {
                                                        throw e10;
                                                    }
                                                    System.out.println("Pattern5: attesa eccezione " + e10.getMessage());
                                                    expr = prefix + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}Envelope/{http://schemas.xmlsoap.org/soap/envelope/}Body/prova/text()";
                                                    try {
                                                        DynamicUtils.validate("testChiusuraMancante", (String)expr, addPrefixError);
                                                        throw new Exception("Attesa eccezione expr malformata");
                                                    }
                                                    catch (Exception e11) {
                                                        if (!e11.getMessage().contains("Trovata istruzione 'xPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                            throw e11;
                                                        }
                                                        System.out.println("PatternExprErrata1: attesa eccezione " + e11.getMessage());
                                                        try {
                                                            value = DynamicUtils.convertDynamicPropertyValue("testChiusuraMancante", (String)expr, dynamicMap, pddContext);
                                                            throw new Exception("Attesa eccezione expr malformata");
                                                        }
                                                        catch (Exception e12) {
                                                            if (!e12.getMessage().contains("Trovata istruzione 'xPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                                throw e12;
                                                            }
                                                            System.out.println("PatternExprErrata1: attesa eccezione " + e12.getMessage());
                                                            expr = prefix + "{xPath://{http://schemas.xmlsoap.org/soap/envelope/}Envelope/{http://schemas.xmlsoap.org/soap/envelope/Body/prova/text()}";
                                                            try {
                                                                DynamicUtils.validate("testChiusuraInternaMancante", (String)expr, addPrefixError);
                                                                throw new Exception("Attesa eccezione expr malformata");
                                                            }
                                                            catch (Exception e13) {
                                                                if (!e13.getMessage().contains("Trovata istruzione 'xPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                                    throw e13;
                                                                }
                                                                System.out.println("PatternExprErrata2: attesa eccezione " + e13.getMessage());
                                                                try {
                                                                    value = DynamicUtils.convertDynamicPropertyValue("testChiusuraInternaMancante", (String)expr, dynamicMap, pddContext);
                                                                    throw new Exception("Attesa eccezione expr malformata");
                                                                }
                                                                catch (Exception e14) {
                                                                    long diff;
                                                                    Date fine;
                                                                    ClientTestThread c;
                                                                    String threadName;
                                                                    Throwable exception;
                                                                    boolean error;
                                                                    Template templateObject;
                                                                    byte[] template;
                                                                    HashMap<CallSite, ClientTestThread> threads;
                                                                    ExecutorService threadsPool;
                                                                    Date inizio;
                                                                    Template templateObject2;
                                                                    ZipTemplate zipTemplateObject;
                                                                    byte[] zip;
                                                                    Template templateObject3;
                                                                    ByteArrayOutputStream bout;
                                                                    ByteArrayOutputStream bout2;
                                                                    byte[] template2;
                                                                    if (!e14.getMessage().contains("Trovata istruzione 'xPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                                        throw e14;
                                                                    }
                                                                    System.out.println("PatternExprErrata2: attesa eccezione " + e14.getMessage());
                                                                    if (prefix.equals("$")) {
                                                                        expr = JSON_TEMPLATE;
                                                                        DynamicUtils.validate("xml2json", (String)expr, addPrefixError);
                                                                        value = DynamicUtils.convertDynamicPropertyValue("xml2json", JSON_TEMPLATE, dynamicMap, pddContext);
                                                                        System.out.println("Test conversione xml2json: \n" + value);
                                                                        expected = EXPECTED_JSON;
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        template2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJson.ftl")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        Template templateObject4 = new Template("xml2jsonFTL", template2);
                                                                        DynamicUtils.convertFreeMarkerTemplate(templateObject4, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker: \n" + value);
                                                                        expected = EXPECTED_JSON_2;
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        template2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJson.vm")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        templateObject4 = new Template("xml2jsonVelocity", template2);
                                                                        DynamicUtils.convertVelocityTemplate(templateObject4, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via velocity: \n" + value);
                                                                        expected = EXPECTED_JSON_2;
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        template2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.ftl")).toByteArray();
                                                                        byte[] prova1 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude_1.ftl")).toByteArray();
                                                                        byte[] prova2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude_2.ftl")).toByteArray();
                                                                        bout = new ByteArrayOutputStream();
                                                                        HashMap<String, Object> templateIncludes = new HashMap<String, byte[]>();
                                                                        templateIncludes.put("TestJsonInclude_1.ftl", prova1);
                                                                        templateIncludes.put("lib/TestJsonInclude_2.ftl", prova2);
                                                                        templateObject3 = new Template("xml2jsonFTL_INCLUDE_MANUALE", template2, templateIncludes);
                                                                        DynamicUtils.convertFreeMarkerTemplate(templateObject3, dynamicMap, bout);
                                                                        bout.flush();
                                                                        bout.close();
                                                                        value = bout.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker (con include): \n" + value);
                                                                        expected = EXPECTED_JSON_3;
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        template2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.vm")).toByteArray();
                                                                        prova1 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude_1.vm")).toByteArray();
                                                                        prova2 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude_2.vm")).toByteArray();
                                                                        bout = new ByteArrayOutputStream();
                                                                        templateIncludes = new HashMap();
                                                                        templateIncludes.put("TestJsonInclude_1.vm", prova1);
                                                                        templateIncludes.put("lib/TestJsonInclude_2.vm", prova2);
                                                                        templateObject3 = new Template("xml2jsonVelocity_INCLUDE_MANUALE", template2, templateIncludes);
                                                                        DynamicUtils.convertVelocityTemplate(templateObject3, dynamicMap, bout);
                                                                        bout.flush();
                                                                        bout.close();
                                                                        value = bout.toString();
                                                                        System.out.println("Test conversione xml2json via velocity (con include): \n" + value);
                                                                        expected = EXPECTED_JSON_3;
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.ftl.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        zipTemplateObject = new ZipTemplate("xml2jsonFTL_INCLUDE_ZIP", zip);
                                                                        DynamicUtils.convertZipFreeMarkerTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker (con include in archivio zip): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.ftl.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        templateObject2 = new Template("xml2jsonFTL_INCLUDE_ZIP", zip);
                                                                        zipTemplateObject = templateObject2.getZipTemplate();
                                                                        DynamicUtils.convertZipFreeMarkerTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker (2) (con include in archivio zip): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.vm.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        zipTemplateObject = new ZipTemplate("xml2jsonVelocity_INCLUDE_ZIP", zip);
                                                                        DynamicUtils.convertZipVelocityTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via velocity (con include in archivio zip): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude.vm.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        templateObject2 = new Template("xml2jsonVelocity_INCLUDE_ZIP", zip);
                                                                        zipTemplateObject = templateObject2.getZipTemplate();
                                                                        DynamicUtils.convertZipVelocityTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via velocity (2) (con include in archivio zip): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude2.ftl.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        zipTemplateObject = new ZipTemplate("xml2jsonFTL_INCLUDE_ZIP2", zip);
                                                                        DynamicUtils.convertZipFreeMarkerTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker (con include in archivio zip test2): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude2.ftl.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        templateObject2 = new Template("xml2jsonFTL_INCLUDE_ZIP2", zip);
                                                                        zipTemplateObject = templateObject2.getZipTemplate();
                                                                        DynamicUtils.convertZipFreeMarkerTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via freemarker (2) (con include in archivio zip test2): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude2.vm.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        zipTemplateObject = new ZipTemplate("xml2jsonVelocity_INCLUDE_ZIP2", zip);
                                                                        DynamicUtils.convertZipVelocityTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via velocity (con include in archivio zip test2): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                        zip = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestJsonInclude2.vm.zip")).toByteArray();
                                                                        bout2 = new ByteArrayOutputStream();
                                                                        templateObject2 = new Template("xml2jsonVelocity_INCLUDE_ZIP2", zip);
                                                                        zipTemplateObject = templateObject2.getZipTemplate();
                                                                        DynamicUtils.convertZipVelocityTemplate(zipTemplateObject, dynamicMap, bout2);
                                                                        bout2.flush();
                                                                        bout2.close();
                                                                        value = bout2.toString();
                                                                        System.out.println("Test conversione xml2json via velocity (2) (con include in archivio zip test2): \n" + value);
                                                                        expected = "{\n    \"SortAs\": \"test\",\n    \"GlossTerm\": \"Standard Generalized Markup Language\",\n    \"Acronym\": \"test2\",\n    \"Abbrev\": \"ISO 8879:1986\",\n    \"Enabled\": true,\n    \"Year\": 2018,\n    \"Quote\": 1.45,\n    \"include1\": {\n\t\t\"SortAs\": \"111_test\",\n\t\t\"GlossTerm\": \"TestPROVA1\"\n    },\n    \"include2\": {\n\t\t\"SortAs\": \"222_test\",\n\t\t\"GlossTerm\": \"TestPROVA2\"\n    },\n    \"List\": [ \"v1\" ,\"v2\" ,\"v3\"  ]\n}\n";
                                                                        if (!((String)expected).equals(value)) {
                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        inizio = DateManager.getDate();
                                                                        boolean debug = false;
                                                                        int threadsNum = 100;
                                                                        threadsPool = Executors.newFixedThreadPool(threadsNum);
                                                                        threads = new HashMap<CallSite, ClientTestThread>();
                                                                        template = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestDynamic.ftl")).toByteArray();
                                                                        templateObject = new Template("xml2jsonDynamicFTL", template);
                                                                        error = false;
                                                                        exception = null;
                                                                        try {
                                                                            for (int i = 0; i < threadsNum; ++i) {
                                                                                String threadName2 = "Thread-" + i;
                                                                                ClientTestThread c2 = new ClientTestThread(threadName2, templateObject, true);
                                                                                threadsPool.execute(c2);
                                                                                threads.put((CallSite)((Object)threadName2), c2);
                                                                            }
                                                                            boolean terminated = false;
                                                                            while (!terminated) {
                                                                                if (debug) {
                                                                                    System.out.println("Attendo terminazione ...");
                                                                                }
                                                                                boolean tmpTerminated = true;
                                                                                for (int i = 0; i < threadsNum; ++i) {
                                                                                    threadName = "Thread-" + i;
                                                                                    c = (ClientTestThread)threads.get(threadName);
                                                                                    if (c.isError()) {
                                                                                        error = true;
                                                                                        exception = c.getException();
                                                                                    }
                                                                                    if (c.isFinished()) continue;
                                                                                    tmpTerminated = false;
                                                                                    break;
                                                                                }
                                                                                if (!tmpTerminated) {
                                                                                    Utilities.sleep((long)250L);
                                                                                    continue;
                                                                                }
                                                                                terminated = true;
                                                                            }
                                                                        }
                                                                        finally {
                                                                            threadsPool.shutdown();
                                                                        }
                                                                        fine = DateManager.getDate();
                                                                        diff = fine.getTime() - inizio.getTime();
                                                                        System.out.println("Tempo impiegato: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
                                                                        if (error) {
                                                                            throw new Exception("Error occurs in threads: " + exception.getMessage(), exception);
                                                                        }
                                                                    }
                                                                    if (prefix.equals("$")) {
                                                                        inizio = DateManager.getDate();
                                                                        boolean debug = false;
                                                                        int threadsNum = 100;
                                                                        threadsPool = Executors.newFixedThreadPool(threadsNum);
                                                                        threads = new HashMap();
                                                                        template = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestDynamic.vm")).toByteArray();
                                                                        templateObject = new Template("xml2jsonDynamicVelocity", template);
                                                                        error = false;
                                                                        exception = null;
                                                                        try {
                                                                            for (int i = 0; i < threadsNum; ++i) {
                                                                                String threadName3 = "Thread-" + i;
                                                                                ClientTestThread c3 = new ClientTestThread(threadName3, templateObject, false);
                                                                                threadsPool.execute(c3);
                                                                                threads.put((CallSite)((Object)threadName3), c3);
                                                                            }
                                                                            boolean terminated = false;
                                                                            while (!terminated) {
                                                                                if (debug) {
                                                                                    System.out.println("Attendo terminazione ...");
                                                                                }
                                                                                boolean tmpTerminated = true;
                                                                                for (int i = 0; i < threadsNum; ++i) {
                                                                                    threadName = "Thread-" + i;
                                                                                    c = (ClientTestThread)threads.get(threadName);
                                                                                    if (c.isError()) {
                                                                                        error = true;
                                                                                        exception = c.getException();
                                                                                    }
                                                                                    if (c.isFinished()) continue;
                                                                                    tmpTerminated = false;
                                                                                    break;
                                                                                }
                                                                                if (!tmpTerminated) {
                                                                                    Utilities.sleep((long)250L);
                                                                                    continue;
                                                                                }
                                                                                terminated = true;
                                                                            }
                                                                        }
                                                                        finally {
                                                                            threadsPool.shutdown();
                                                                        }
                                                                        fine = DateManager.getDate();
                                                                        diff = fine.getTime() - inizio.getTime();
                                                                        System.out.println("Tempo impiegato: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
                                                                        if (error) {
                                                                            throw new Exception("Error occurs in threads: " + exception.getMessage(), exception);
                                                                        }
                                                                    }
                                                                    dynamicMap = new HashMap();
                                                                    dInfo = new DynamicInfo(connettoreMsg, pddContext);
                                                                    OpenSPCoop2MessageParseResult parserJson = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.JSON, MessageRole.NONE, "application/json", JSON.getBytes(), AttachmentsProcessingMode.getMemoryCacheProcessingMode());
                                                                    MessageContent messageContentJson = new MessageContent(parserJson.getMessage().castAsRestJson(), bufferMessage_readOnly, (Context)pddContext);
                                                                    dInfo.setMessageContent(messageContentJson);
                                                                    DynamicUtils.fillDynamicMap(log, dynamicMap, dInfo);
                                                                    expr = prefix + "{jsonPath:$.Year}";
                                                                    DynamicUtils.validate("testJson", (String)expr, addPrefixError);
                                                                    value = DynamicUtils.convertDynamicPropertyValue("testJson", (String)expr, dynamicMap, pddContext);
                                                                    System.out.println("Pattern1: " + value);
                                                                    expected = "2018";
                                                                    if (!((String)expected).equals(value)) {
                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                    }
                                                                    expr = "Metto un po (" + prefix + "{jsonpath:$.Year}) di altro test (" + prefix + "{jsonPath:$.Acronym}) fine";
                                                                    DynamicUtils.validate("test2Json", (String)expr, addPrefixError);
                                                                    value = DynamicUtils.convertDynamicPropertyValue("test2Json", (String)expr, dynamicMap, pddContext);
                                                                    System.out.println("Pattern2: " + value);
                                                                    expected = "Metto un po (2018) di altro test (SGML) fine";
                                                                    if (!((String)expected).equals(value)) {
                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                    }
                                                                    expr = prefix + "{jsonPath:$.NotFound}";
                                                                    DynamicUtils.validate("testJsonPatternNotFound", (String)expr, addPrefixError);
                                                                    value = DynamicUtils.convertDynamicPropertyValue("testJsonPatternNotFound", (String)expr, dynamicMap, pddContext);
                                                                    System.out.println("Pattern3: " + value);
                                                                    expected = "";
                                                                    if (!((String)expected).equals(value)) {
                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                    }
                                                                    expr = prefixOptional + "{jsonPath:$.NotFound}";
                                                                    DynamicUtils.validate("optional testJsonPatternNotFound", (String)expr, addPrefixError);
                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testJsonPatternNotFound", (String)expr, dynamicMap, pddContext);
                                                                    System.out.println("optional testJsonPatternNotFound: " + value + "\n\n");
                                                                    if (value != null) {
                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                    }
                                                                    expr = prefix + "{jsonPath:$$$dedde}";
                                                                    DynamicUtils.validate("testJsonPatternError", (String)expr, addPrefixError);
                                                                    try {
                                                                        System.out.println("Pattern4: " + DynamicUtils.convertDynamicPropertyValue("testJsonPatternError", (String)expr, dynamicMap, pddContext, forceDollaro));
                                                                        throw new Exception("Attesa eccezione pattern malformato");
                                                                    }
                                                                    catch (Exception e15) {
                                                                        if (!e15.getMessage().contains("Illegal character at position 1 expected '.' or '[")) {
                                                                            throw e15;
                                                                        }
                                                                        System.out.println("Pattern4: attesa eccezione " + e15.getMessage());
                                                                        expr = prefix + "{jsonPath:$.NotFound";
                                                                        try {
                                                                            DynamicUtils.validate("testChiusuraMancante", (String)expr, addPrefixError);
                                                                            throw new Exception("Attesa eccezione expr malformata");
                                                                        }
                                                                        catch (Exception e16) {
                                                                            if (!e16.getMessage().contains("Trovata istruzione 'jsonPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                                                throw e16;
                                                                            }
                                                                            System.out.println("PatternExprErrata1: attesa eccezione " + e16.getMessage());
                                                                            try {
                                                                                value = DynamicUtils.convertDynamicPropertyValue("testChiusuraMancante", (String)expr, dynamicMap, pddContext);
                                                                                throw new Exception("Attesa eccezione expr malformata");
                                                                            }
                                                                            catch (Exception e17) {
                                                                                if (!e17.getMessage().contains("Trovata istruzione 'jsonPath' non correttamente formata (chiusura '}' non trovata)")) {
                                                                                    throw e17;
                                                                                }
                                                                                System.out.println("PatternExprErrata1: attesa eccezione " + e17.getMessage());
                                                                                if (prefix.equals("$")) {
                                                                                    expr = XML_TEMPLATE;
                                                                                    DynamicUtils.validate("json2xml", (String)expr, addPrefixError);
                                                                                    value = DynamicUtils.convertDynamicPropertyValue("json2xml", (String)expr, dynamicMap, pddContext);
                                                                                    System.out.println("Test conversione json2xml: \n" + value);
                                                                                    expected = EXPECTED_XML;
                                                                                    if (!((String)expected).equals(value)) {
                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                    }
                                                                                }
                                                                                if (prefix.equals("$")) {
                                                                                    byte[] template3 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestXml.ftl")).toByteArray();
                                                                                    bout = new ByteArrayOutputStream();
                                                                                    Template templateObject5 = new Template("json2xmlFTL", template3);
                                                                                    DynamicUtils.convertFreeMarkerTemplate(templateObject5, dynamicMap, bout);
                                                                                    bout.flush();
                                                                                    bout.close();
                                                                                    value = bout.toString();
                                                                                    System.out.println("Test conversione json2xml via freemarker: \n" + value);
                                                                                    expected = EXPECTED_XML_2;
                                                                                    if (!((String)expected).equals(value)) {
                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                    }
                                                                                    template3 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestXml.vm")).toByteArray();
                                                                                    bout = new ByteArrayOutputStream();
                                                                                    templateObject5 = new Template("json2xmlVelocity", template3);
                                                                                    DynamicUtils.convertVelocityTemplate(templateObject5, dynamicMap, bout);
                                                                                    bout.flush();
                                                                                    bout.close();
                                                                                    value = bout.toString();
                                                                                    System.out.println("Test conversione json2xml via velocity: \n" + value);
                                                                                    expected = EXPECTED_XML_2;
                                                                                    if (!((String)expected).equals(value)) {
                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                    }
                                                                                }
                                                                                String url = "/govway/out/ENTE/Erogatore/Servizio/v1/azione/test?prova=test&azione=az2";
                                                                                dynamicMap = new HashMap();
                                                                                dInfo = new DynamicInfo(connettoreMsg, pddContext);
                                                                                dInfo.setUrl(url);
                                                                                DynamicUtils.fillDynamicMap(log, dynamicMap, dInfo);
                                                                                expr = prefix + "{urlRegExp:.+azione=([^&]*).*}";
                                                                                DynamicUtils.validate("testUrl", (String)expr, addPrefixError);
                                                                                value = DynamicUtils.convertDynamicPropertyValue("testUrl", (String)expr, dynamicMap, pddContext);
                                                                                System.out.println("PatternUrl1: " + value);
                                                                                expected = "az2";
                                                                                if (!((String)expected).equals(value)) {
                                                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                }
                                                                                expr = prefix + "{urlRegExp:.+azioneNotFound=([^&]*).*}";
                                                                                DynamicUtils.validate("testUrlNotFound", (String)expr, addPrefixError);
                                                                                value = DynamicUtils.convertDynamicPropertyValue("testUrlNotFound", (String)expr, dynamicMap, pddContext);
                                                                                System.out.println("PatternUrlNotFound: " + value);
                                                                                expected = "";
                                                                                if (!((String)expected).equals(value)) {
                                                                                    throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                }
                                                                                expr = prefixOptional + "{urlRegExp:.+azioneNotFound=([^&]*).*}";
                                                                                DynamicUtils.validate("optional testUrlNotFound", (String)expr, addPrefixError);
                                                                                value = DynamicUtils.convertDynamicPropertyValue("optional testUrlNotFound", (String)expr, dynamicMap, pddContext);
                                                                                System.out.println("optional testUrlNotFound: " + value + "\n\n");
                                                                                if (value != null) {
                                                                                    throw new Exception("Expected null value, found '" + value + "'");
                                                                                }
                                                                                expr = prefix + "{urlRegExp:.+azione=([^&]*).*";
                                                                                try {
                                                                                    DynamicUtils.validate("testChiusuraMancante", (String)expr, addPrefixError);
                                                                                    throw new Exception("Attesa eccezione expr malformata");
                                                                                }
                                                                                catch (Exception e18) {
                                                                                    if (!e18.getMessage().contains("Trovata istruzione 'urlRegExp' non correttamente formata (chiusura '}' non trovata)")) {
                                                                                        throw e18;
                                                                                    }
                                                                                    System.out.println("PatternExprErrata1: attesa eccezione " + e18.getMessage());
                                                                                    try {
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testChiusuraMancante", (String)expr, dynamicMap, pddContext);
                                                                                        throw new Exception("Attesa eccezione expr malformata");
                                                                                    }
                                                                                    catch (Exception e19) {
                                                                                        if (!e19.getMessage().contains("Trovata istruzione 'urlRegExp' non correttamente formata (chiusura '}' non trovata)")) {
                                                                                            throw e19;
                                                                                        }
                                                                                        System.out.println("PatternExprErrata1: attesa eccezione " + e19.getMessage());
                                                                                        if (prefix.equals("$")) {
                                                                                            byte[] template4 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestUrl.ftl")).toByteArray();
                                                                                            ByteArrayOutputStream bout3 = new ByteArrayOutputStream();
                                                                                            templateObject3 = new Template("testUrlFTL", template4);
                                                                                            DynamicUtils.convertFreeMarkerTemplate(templateObject3, dynamicMap, bout3);
                                                                                            bout3.flush();
                                                                                            bout3.close();
                                                                                            value = bout3.toString();
                                                                                            System.out.println("Test conversione via freemarker: \n" + value);
                                                                                            expected = EXPECTED_XML_3;
                                                                                            if (!((String)expected).equals(value)) {
                                                                                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                            }
                                                                                            template4 = Utilities.getAsByteArrayOuputStream((InputStream)DynamicTest.class.getResourceAsStream("/org/openspcoop2/pdd/core/dynamic/test/TestUrl.vm")).toByteArray();
                                                                                            bout3 = new ByteArrayOutputStream();
                                                                                            templateObject3 = new Template("testUrlVelocity", template4);
                                                                                            DynamicUtils.convertVelocityTemplate(templateObject3, dynamicMap, bout3);
                                                                                            bout3.flush();
                                                                                            bout3.close();
                                                                                            value = bout3.toString();
                                                                                            System.out.println("Test conversione via velocity: \n" + value);
                                                                                            expected = EXPECTED_XML_3;
                                                                                            if (!((String)expected).equals(value)) {
                                                                                                throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                            }
                                                                                        }
                                                                                        HashMap<String, Object> mapLivello1 = new HashMap<String, Object>();
                                                                                        HashMap<String, Object> mapLivello2 = new HashMap<String, Object>();
                                                                                        mapLivello1.put("aa", mapLivello2);
                                                                                        mapLivello2.put("attr1", "value1");
                                                                                        mapLivello2.put("attr2", "value2");
                                                                                        HashMap<String, String> mapLivello22 = new HashMap<String, String>();
                                                                                        mapLivello1.put("aa2", mapLivello22);
                                                                                        mapLivello22.put("attr21", "value21");
                                                                                        HashMap<String, String> mapLivello3 = new HashMap<String, String>();
                                                                                        mapLivello3.put("attr31", "value31");
                                                                                        mapLivello3.put("attr32", "value32");
                                                                                        mapLivello2.put("attr3", mapLivello3);
                                                                                        ArrayList<String> arrayLivello4 = new ArrayList<String>();
                                                                                        arrayLivello4.add("41");
                                                                                        arrayLivello4.add("42");
                                                                                        arrayLivello4.add("43");
                                                                                        mapLivello2.put("attr4", arrayLivello4);
                                                                                        TestMap multimap = new TestMap();
                                                                                        multimap.map = mapLivello1;
                                                                                        MapKey MULTIMAP = Map.newMapKey((String)"MULTIMAP");
                                                                                        pddContext.addObject(MULTIMAP, multimap);
                                                                                        TestMap map = new TestMap();
                                                                                        map.map = mapLivello2;
                                                                                        MapKey MAP = Map.newMapKey((String)"MAP");
                                                                                        pddContext.addObject(MAP, map);
                                                                                        expr = "attribute value: ${context:MAP.map[attr1]}";
                                                                                        DynamicUtils.validate("testMAP", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMAP", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MapAttr: " + value + "\n\n");
                                                                                        expected = "attribute value: value1";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = "attribute value: ${context:MULTIMAP.map[aa][attr1]}";
                                                                                        DynamicUtils.validate("testMULTIMAP", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMULTIMAP", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MultiMapAttr: " + value + "\n\n");
                                                                                        expected = "attribute value: value1";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = "attribute value: ${context:MULTIMAP.map[aa][attr2]}";
                                                                                        DynamicUtils.validate("testMULTIMAP2", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMULTIMAP2", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MultiMapAttr2: " + value + "\n\n");
                                                                                        expected = "attribute value: value2";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = "attribute value: ${context:MULTIMAP.map[aa2][attr21]}";
                                                                                        DynamicUtils.validate("testMULTIMAP3", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMULTIMAP3", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MultiMapAttr3: " + value + "\n\n");
                                                                                        expected = "attribute value: value21";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = "attribute value: ${context:MULTIMAP.map[aa][attr3][attr32]}";
                                                                                        DynamicUtils.validate("testMULTIMAP4", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMULTIMAP4", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MultiMapAttr4: " + value + "\n\n");
                                                                                        expected = "attribute value: value32";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = "attribute value: ${context:MULTIMAP.map[aa][attr4][2]}";
                                                                                        DynamicUtils.validate("testMULTIMAP5", (String)expr, addPrefixError);
                                                                                        value = DynamicUtils.convertDynamicPropertyValue("testMULTIMAP5", (String)expr, dynamicMap, pddContext);
                                                                                        System.out.println("MultiMapAttr5: " + value + "\n\n");
                                                                                        expected = "attribute value: 43";
                                                                                        if (!((String)expected).equals(value)) {
                                                                                            throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                        }
                                                                                        expr = prefix + "{context:MULTIMAP.map[notExists]}";
                                                                                        DynamicUtils.validate("testMultimapKeywordNotExists", (String)expr, addPrefixError);
                                                                                        try {
                                                                                            DynamicUtils.convertDynamicPropertyValue("testMultimapKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                                                                            throw new Exception("Attesa eccezione");
                                                                                        }
                                                                                        catch (Exception e20) {
                                                                                            String atteso2 = "'notExists' not exists in map";
                                                                                            if (!e20.getMessage().contains(atteso2)) {
                                                                                                throw e20;
                                                                                            }
                                                                                            System.out.println("Eccezione attesa: " + e20.getMessage() + "\n\n");
                                                                                            expr = prefixOptional + "{context:MULTIMAP.map[notExists]}";
                                                                                            DynamicUtils.validate("optional testMultimapKeywordNotExists", (String)expr, addPrefixError);
                                                                                            value = DynamicUtils.convertDynamicPropertyValue("optional testMultimapKeywordNotExists", (String)expr, dynamicMap, pddContext);
                                                                                            System.out.println("optional testMultimapKeywordNotExists: " + value + "\n\n");
                                                                                            if (value != null) {
                                                                                                throw new Exception("Expected null value, found '" + value + "'");
                                                                                            }
                                                                                            expr = prefix + "{context:MULTIMAP.map[aa][notExists]}";
                                                                                            DynamicUtils.validate("testMultimapKeywordNotExistsLevel2", (String)expr, addPrefixError);
                                                                                            try {
                                                                                                DynamicUtils.convertDynamicPropertyValue("testMultimapKeywordNotExistsLevel2", (String)expr, dynamicMap, pddContext);
                                                                                                throw new Exception("Attesa eccezione");
                                                                                            }
                                                                                            catch (Exception e21) {
                                                                                                atteso2 = "'notExists' not exists in map";
                                                                                                if (!e21.getMessage().contains(atteso2)) {
                                                                                                    throw e21;
                                                                                                }
                                                                                                System.out.println("Eccezione attesa: " + e21.getMessage() + "\n\n");
                                                                                                expr = prefixOptional + "{context:MULTIMAP.map[aa][notExists]}";
                                                                                                DynamicUtils.validate("optional testMultimapKeywordNotExistsLevel2", (String)expr, addPrefixError);
                                                                                                value = DynamicUtils.convertDynamicPropertyValue("optional testMultimapKeywordNotExistsLevel2", (String)expr, dynamicMap, pddContext);
                                                                                                System.out.println("optional testMultimapKeywordNotExistsLevel2: " + value + "\n\n");
                                                                                                if (value != null) {
                                                                                                    throw new Exception("Expected null value, found '" + value + "'");
                                                                                                }
                                                                                                expr = prefix + "{context:MULTIMAP.map[aa][attr4][10]}";
                                                                                                DynamicUtils.validate("testMultimapKeywordNotExistsLevel3", (String)expr, addPrefixError);
                                                                                                try {
                                                                                                    DynamicUtils.convertDynamicPropertyValue("testMultimapKeywordNotExistsLevel3", (String)expr, dynamicMap, pddContext);
                                                                                                    throw new Exception("Attesa eccezione");
                                                                                                }
                                                                                                catch (Exception e22) {
                                                                                                    atteso2 = "wrong position '10' (list size:3)";
                                                                                                    if (!e22.getMessage().contains(atteso2)) {
                                                                                                        throw e22;
                                                                                                    }
                                                                                                    System.out.println("Eccezione attesa: " + e22.getMessage() + "\n\n");
                                                                                                    expr = prefixOptional + "{context:MULTIMAP.map[aa][attr4][10]}";
                                                                                                    DynamicUtils.validate("optional testMultimapKeywordNotExistsLevel3", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testMultimapKeywordNotExistsLevel3", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testMultimapKeywordNotExistsLevel3: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    expr = "Valore da non rimpiazzare {transaction:id} insieme ad altro";
                                                                                                    DynamicUtils.validate("test1{}DaNonRisolvere", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("test1{}DaNonRisolvere", (String)expr, dynamicMap, pddContext, true);
                                                                                                    System.out.println("test1{}DaNonRisolvere: " + value + "\n\n");
                                                                                                    expected = expr;
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = "{transaction:id}";
                                                                                                    DynamicUtils.validate("test2{}DaNonRisolvere", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("test2{}DaNonRisolvere", (String)expr, dynamicMap, pddContext, true);
                                                                                                    System.out.println("test2{}DaNonRisolvere: " + value + "\n\n");
                                                                                                    expected = expr;
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = "{\n \"transaction\": \"id\"\n}";
                                                                                                    DynamicUtils.validate("test3{}DaNonRisolvere", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("test3{}DaNonRisolvere", (String)expr, dynamicMap, pddContext, true);
                                                                                                    System.out.println("test3{}DaNonRisolvere: " + value + "\n\n");
                                                                                                    expected = expr;
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = "{\n \"transaction\": \"id\",\n \"transaction\": \"${transaction:id}\"\n}";
                                                                                                    DynamicUtils.validate("test4{}DaNonRisolvere", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("test4{}DaNonRisolvere", (String)expr, dynamicMap, pddContext, true);
                                                                                                    System.out.println("test4{}DaNonRisolvere: " + value + "\n\n");
                                                                                                    expected = ((String)expr).replace("${transaction:id}", idTransazione);
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{system:systemP1}";
                                                                                                    DynamicUtils.validate("testSystem", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testSystem", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testSystem: " + value + "\n\n");
                                                                                                    expected = "systemV1";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{system:systemNotFound}";
                                                                                                    DynamicUtils.validate("testSystemNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testSystemNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testSystemNotFound: " + value);
                                                                                                    expected = "";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefixOptional + "{system:systemNotFound}";
                                                                                                    DynamicUtils.validate("optional testSystemNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testSystemNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testSystemNotFound: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    System.setProperty("pCustomJava1", "v1java");
                                                                                                    System.setProperty("pCustomJava2", "v2java");
                                                                                                    expr = prefix + "{java:pCustomJava1}";
                                                                                                    DynamicUtils.validate("testJava", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testJava", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testJava: " + value + "\n\n");
                                                                                                    expected = "v1java";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{java:javaNotFound}";
                                                                                                    DynamicUtils.validate("testJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testJavaNotFound: " + value);
                                                                                                    expected = "";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefixOptional + "{java:javaNotFound}";
                                                                                                    DynamicUtils.validate("optional testJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testJavaNotFound: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{env:HOSTNAME}";
                                                                                                    DynamicUtils.validate("testEnv", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testEnv", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testEnv: " + value + "\n\n");
                                                                                                    expected = System.getenv("HOSTNAME");
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{env:envNotFound}";
                                                                                                    DynamicUtils.validate("testEnvNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testEnvNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testEnvNotFound: " + value);
                                                                                                    expected = "";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefixOptional + "{env:envNotFound}";
                                                                                                    DynamicUtils.validate("optional testEnvNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testEnvNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testEnvNotFound: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{envj:pCustomJava1}";
                                                                                                    DynamicUtils.validate("testEnvJava", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testJava", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testEnvJava: " + value + "\n\n");
                                                                                                    expected = "v1java";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{envj:javaNotFound}";
                                                                                                    DynamicUtils.validate("testEnvJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testEnvJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testEnvJavaNotFound: " + value);
                                                                                                    expected = "";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefixOptional + "{envj:javaNotFound}";
                                                                                                    DynamicUtils.validate("optional testEnvJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testEnvJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testEnvJavaNotFound: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{envj:HOSTNAME}";
                                                                                                    DynamicUtils.validate("testENVJava", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testENVJava", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testENVJava: " + value + "\n\n");
                                                                                                    expected = System.getenv("HOSTNAME");
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefix + "{envj:envNotFound}";
                                                                                                    DynamicUtils.validate("testENVJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("testENVJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("testENVJavaNotFound: " + value);
                                                                                                    expected = "";
                                                                                                    if (!((String)expected).equals(value)) {
                                                                                                        throw new Exception("Expected value '" + (String)expected + "', found '" + value + "'");
                                                                                                    }
                                                                                                    expr = prefixOptional + "{envj:envNotFound}";
                                                                                                    DynamicUtils.validate("optional testEVNJavaNotFound", (String)expr, addPrefixError);
                                                                                                    value = DynamicUtils.convertDynamicPropertyValue("optional testEVNJavaNotFound", (String)expr, dynamicMap, pddContext);
                                                                                                    System.out.println("optional testEVNJavaNotFound: " + value + "\n\n");
                                                                                                    if (value != null) {
                                                                                                        throw new Exception("Expected null value, found '" + value + "'");
                                                                                                    }
                                                                                                    if (fTmpConfig != null) {
                                                                                                        fTmpConfig.delete();
                                                                                                    }
                                                                                                    if (fTmpOp2Properties != null) {
                                                                                                        fTmpOp2Properties.delete();
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (fTmpConfig != null) {
                fTmpConfig.delete();
            }
            if (fTmpOp2Properties != null) {
                fTmpOp2Properties.delete();
            }
            throw throwable;
        }
        System.out.println("Testsuite terminata");
    }
}

