/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.statistics;

import java.util.Date;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseHandler;
import org.openspcoop2.pdd.core.handlers.statistics.Statistic;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticsCollection;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticsConstants;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;

public class StatisticsPostOutResponseHandler
implements PostOutResponseHandler {
    @Override
    public void invoke(PostOutResponseContext context) throws HandlerException {
        if (!OpenSPCoop2Properties.getInstance().isStatisticheViaJmx()) {
            return;
        }
        Object dataIngressoRichiesta = context.getPddContext().getObject(StatisticsConstants.DATA_INGRESSO_RICHIESTA);
        long timeMillisIngressoRichiesta = -1L;
        if (dataIngressoRichiesta != null) {
            timeMillisIngressoRichiesta = ((Date)dataIngressoRichiesta).getTime();
        }
        Object dataUscitaRichiesta = context.getPddContext().getObject(StatisticsConstants.DATA_USCITA_RICHIESTA);
        long timeMillisUscitaRichiesta = -1L;
        if (dataUscitaRichiesta != null) {
            timeMillisUscitaRichiesta = ((Date)dataUscitaRichiesta).getTime();
        } else {
            Object dataPresaInCarico = context.getPddContext().getObject(Costanti.DATA_PRESA_IN_CARICO);
            if (dataPresaInCarico != null) {
                try {
                    dataUscitaRichiesta = DateUtils.getSimpleDateFormatMs().parse((String)dataPresaInCarico);
                    timeMillisUscitaRichiesta = ((Date)dataUscitaRichiesta).getTime();
                }
                catch (Exception e) {
                    throw new HandlerException(e.getMessage(), e);
                }
            }
        }
        Object dataIngressoRisposta = context.getPddContext().getObject(StatisticsConstants.DATA_INGRESSO_RISPOSTA);
        long timeMillisIngressoRisposta = -1L;
        if (dataIngressoRisposta != null) {
            timeMillisIngressoRisposta = ((Date)dataIngressoRisposta).getTime();
        } else {
            Object dataPresaInCarico = context.getPddContext().getObject(Costanti.DATA_PRESA_IN_CARICO);
            if (dataPresaInCarico != null) {
                try {
                    dataIngressoRisposta = DateUtils.getSimpleDateFormatMs().parse((String)dataPresaInCarico);
                    timeMillisIngressoRisposta = ((Date)dataIngressoRisposta).getTime();
                }
                catch (Exception e) {
                    throw new HandlerException(e.getMessage(), e);
                }
            }
        }
        long timeMillisUscitaRisposta = DateManager.getTimeMillis();
        long dimensioneIngressoRichiesta = -1L;
        if (context.getInputRequestMessageSize() != null && context.getInputRequestMessageSize() > 0L) {
            dimensioneIngressoRichiesta = context.getInputRequestMessageSize();
        }
        long dimensioneUscitaRichiesta = -1L;
        if (context.getOutputRequestMessageSize() != null && context.getOutputRequestMessageSize() > 0L) {
            dimensioneUscitaRichiesta = context.getOutputRequestMessageSize();
        }
        long dimensioneIngressoRisposta = -1L;
        if (context.getInputResponseMessageSize() != null && context.getInputResponseMessageSize() > 0L) {
            dimensioneIngressoRisposta = context.getInputResponseMessageSize();
        }
        long dimensioneUscitaRisposta = -1L;
        if (context.getOutputResponseMessageSize() != null && context.getOutputResponseMessageSize() > 0L) {
            dimensioneUscitaRisposta = context.getOutputResponseMessageSize();
        }
        Statistic stat = new Statistic();
        stat.setEsito(context.getEsito());
        stat.setTipoPdD(context.getTipoPorta());
        stat.setProtocollo(context.getProtocolFactory());
        stat.setTimeMillisIngressoRichiesta(timeMillisIngressoRichiesta);
        stat.setTimeMillisIngressoRisposta(timeMillisIngressoRisposta);
        stat.setTimeMillisUscitaRichiesta(timeMillisUscitaRichiesta);
        stat.setTimeMillisUscitaRisposta(timeMillisUscitaRisposta);
        stat.setDimensioneIngressoRichiesta(dimensioneIngressoRichiesta);
        stat.setDimensioneIngressoRisposta(dimensioneIngressoRisposta);
        stat.setDimensioneUscitaRichiesta(dimensioneUscitaRichiesta);
        stat.setDimensioneUscitaRisposta(dimensioneUscitaRisposta);
        StatisticsCollection.update(stat);
    }
}

