/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.suap;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.ForcedResponseMessage;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.OutResponseHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class SUAPResponseGenerator
implements OutResponseHandler {
    private static final String ERROR_400_001_CODE = "ERROR_400_001";
    private static final String ERROR_400_001_MESSAGE = "incorrect request input";
    private static final String ERROR_401_001_CODE = "ERROR_401_001";
    private static final String ERROR_401_001_MESSAGE = "PDND token not found";
    private static final String ERROR_401_002_CODE = "ERROR_401_002";
    private static final String ERROR_401_002_MESSAGE = "Invalid PDND token";
    private static final String ERROR_401_003 = "ERROR_401_003";
    private static final String ERROR_401_003_MESSAGE = "AgID-JWT-Signature token not found";
    private static final String ERROR_401_004_CODE = "ERROR_401_004";
    private static final String ERROR_401_004_MESSAGE = "invalid AgID-JWT-Signature token";
    private static final String ERROR_404_001_CODE = "ERROR_404_001";
    private static final String ERROR_404_001_MESSAGE = "resource not found";
    private static final String ERROR_428_001_CODE = "ERROR_428_001";
    private static final String ERROR_428_001_MESSAGE = "hash not found";
    private static final String ERROR_428_001_MESSAGE_PATTERN_MATCH = ".*Parameter 'If-Match' is required.*";
    private static final String ERROR_500_007 = "ERROR_500_007";
    private static final String ERROR_500_007_MESSAGE = "response processing error";

    @Override
    public void invoke(OutResponseContext context) throws HandlerException {
        if (context != null && context.getMessaggio() != null && MessageType.JSON.equals((Object)context.getMessaggio().getMessageType()) && MessageRole.FAULT.equals((Object)context.getMessaggio().getMessageRole())) {
            try {
                String idTransazione = null;
                if (context.getPddContext() != null) {
                    PdDContext pddContext = context.getPddContext();
                    if (pddContext.getObject(Costanti.ID_TRANSAZIONE) == null) {
                        throw new HandlerException("Identificativo della transazione assente");
                    }
                    idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
                    if (idTransazione == null) {
                        throw new HandlerException("Identificativo della transazione assente");
                    }
                }
                if (SUAPResponseGenerator.isErroreValidazioneRichiesta(context)) {
                    if (SUAPResponseGenerator.isErroreValidazioneRichiestaHashNotFound(idTransazione)) {
                        SUAPResponseGenerator.modifyErrorMessage(428, ERROR_428_001_CODE, ERROR_428_001_MESSAGE, context.getMessaggio());
                    } else {
                        SUAPResponseGenerator.modifyErrorMessage(400, ERROR_400_001_CODE, ERROR_400_001_MESSAGE, context.getMessaggio());
                    }
                } else if (SUAPResponseGenerator.isRequestReadTimeout(context) || SUAPResponseGenerator.isContenutiRichiestaNonRiconosciuto(context) || SUAPResponseGenerator.isErroreCorrelazioneApplicativaRisposta(context) || SUAPResponseGenerator.isErroreTrasformazioneRichiesta(context)) {
                    SUAPResponseGenerator.modifyErrorMessage(400, ERROR_400_001_CODE, ERROR_400_001_MESSAGE, context.getMessaggio());
                } else if (SUAPResponseGenerator.isErroreTokenNonPresente(context)) {
                    if (SUAPResponseGenerator.isAuthorizationWithoutBearer(context)) {
                        SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_002_CODE, ERROR_401_002_MESSAGE, context.getMessaggio());
                    } else {
                        SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_001_CODE, ERROR_401_001_MESSAGE, context.getMessaggio());
                    }
                } else if (SUAPResponseGenerator.isErroreToken(context)) {
                    SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_002_CODE, ERROR_401_002_MESSAGE, context.getMessaggio());
                } else if (SUAPResponseGenerator.isOperazioneNonIndividuata(context)) {
                    SUAPResponseGenerator.modifyErrorMessage(404, ERROR_404_001_CODE, ERROR_404_001_MESSAGE, context.getMessaggio());
                } else if (SUAPResponseGenerator.isConnectorError(context) || SUAPResponseGenerator.isConnectionTimeout(context) || SUAPResponseGenerator.isReadTimeout(context) || SUAPResponseGenerator.isResponseReadTimeout(context) || SUAPResponseGenerator.isContenutiRispostaNonRiconosciuto(context) || SUAPResponseGenerator.isErroreCorrelazioneApplicativaRisposta(context) || SUAPResponseGenerator.isErroreSicurezzaMessaggioRisposta(context) || SUAPResponseGenerator.isErroreAllegatiRisposta(context) || SUAPResponseGenerator.isErroreValidazioneRisposta(context) || SUAPResponseGenerator.isErroreTrasformazioneRisposta(context) || SUAPResponseGenerator.isRispostaDuplicata(context)) {
                    SUAPResponseGenerator.modifyErrorMessage(500, ERROR_500_007, ERROR_500_007_MESSAGE, context.getMessaggio());
                } else if (context.getPddContext() != null) {
                    Transaction transaction = SUAPResponseGenerator.getTransaction(idTransazione);
                    boolean casoAgitJWTSignatureNonPresente = false;
                    boolean casoAgitJWTSignatureNonValido = false;
                    boolean casoVoucherPDNDNonValido = false;
                    if (transaction != null && transaction.getTracciaRisposta() != null && transaction.getTracciaRisposta().getBusta() != null && transaction.getTracciaRisposta().getBusta().getListaEccezioni() != null && !transaction.getTracciaRisposta().getBusta().getListaEccezioni().isEmpty()) {
                        for (Eccezione eccezione : transaction.getTracciaRisposta().getBusta().getListaEccezioni()) {
                            String desc;
                            if (eccezione.getCodiceEccezione() == null) continue;
                            if (eccezione.getCodiceEccezione().equals(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE.getCodice())) {
                                desc = eccezione.getDescrizione(context.getProtocolFactory());
                                if (desc == null || !"Header HTTP 'Agid-JWT-Signature' non presente".equals(desc)) continue;
                                casoAgitJWTSignatureNonPresente = true;
                                continue;
                            }
                            if (eccezione.getCodiceEccezione().equals(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA.getCodice()) || CodiceErroreCooperazione.isEccezioneSicurezza((CodiceErroreCooperazione)eccezione.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneSicurezzaToken((CodiceErroreCooperazione)eccezione.getCodiceEccezione()) || CodiceErroreCooperazione.isEccezioneServizioApplicativoErogatore((CodiceErroreCooperazione)eccezione.getCodiceEccezione())) {
                                desc = eccezione.getDescrizione(context.getProtocolFactory());
                                if (desc != null && desc.contains("Header 'Authorization'")) {
                                    casoVoucherPDNDNonValido = true;
                                    continue;
                                }
                                casoAgitJWTSignatureNonValido = true;
                                continue;
                            }
                            if (!CodiceErroreCooperazione.isEccezioneSicurezzaToken((CodiceErroreCooperazione)eccezione.getCodiceEccezione())) continue;
                            casoVoucherPDNDNonValido = true;
                        }
                    }
                    if (casoAgitJWTSignatureNonPresente) {
                        SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_003, ERROR_401_003_MESSAGE, context.getMessaggio());
                    } else if (casoAgitJWTSignatureNonValido) {
                        SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_004_CODE, ERROR_401_004_MESSAGE, context.getMessaggio());
                    } else if (casoVoucherPDNDNonValido) {
                        SUAPResponseGenerator.modifyErrorMessage(401, ERROR_401_002_CODE, ERROR_401_002_MESSAGE, context.getMessaggio());
                    }
                }
            }
            catch (Exception e) {
                context.getLogCore().error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
            }
        } else if (context != null && context.getMessaggio() != null) {
            try {
                if (SUAPResponseGenerator.isRisposta5xxDifferenteJson(context)) {
                    if (MessageType.JSON.equals((Object)context.getMessaggio().getMessageType())) {
                        SUAPResponseGenerator.modifyErrorMessage(500, ERROR_500_007, ERROR_500_007_MESSAGE, context.getMessaggio());
                    } else {
                        SUAPResponseGenerator.replaceErrorMessage(500, ERROR_500_007, ERROR_500_007_MESSAGE, context);
                    }
                }
            }
            catch (Exception e) {
                context.getLogCore().error("Conversione (risposta backend) non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Transaction getTransaction(String idTransazione) {
        Transaction transaction = null;
        try {
            transaction = TransactionContext.getTransaction(idTransazione);
        }
        catch (TransactionNotExistsException transactionNotExistsException) {
            // empty catch block
        }
        return transaction;
    }

    static boolean isErroreValidazioneRichiestaHashNotFound(String idTransazione) {
        Transaction transaction = SUAPResponseGenerator.getTransaction(idTransazione);
        if (transaction != null && transaction.getMsgDiagnostici() != null && !transaction.getMsgDiagnostici().isEmpty()) {
            for (MsgDiagnostico msg : transaction.getMsgDiagnostici()) {
                if (!SUAPResponseGenerator.isMessaggioErroreValidazioneRichiestaHashNotFound(msg)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isMessaggioErroreValidazioneRichiestaHashNotFound(MsgDiagnostico msg) {
        if (msg.getSeverita() <= 2 && msg.getMessaggio() != null) {
            boolean match = false;
            try {
                match = RegularExpressionEngine.isFind((String)msg.getMessaggio(), (String)ERROR_428_001_MESSAGE_PATTERN_MATCH);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    static boolean isErroreValidazioneRichiesta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_VALIDAZIONE_RICHIESTA, context);
    }

    static boolean isErroreValidazioneRisposta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_VALIDAZIONE_RISPOSTA, context);
    }

    static boolean isErroreTokenNonPresente(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.TOKEN_NON_PRESENTE, context);
    }

    static boolean isErroreToken(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TOKEN, context);
    }

    static boolean isOperazioneNonIndividuata(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.OPERAZIONE_NON_INDIVIDUATA, context);
    }

    static boolean isReadTimeout(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoReadTimeout", context);
    }

    static boolean isRequestReadTimeout(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoRequestReadTimeout", context);
    }

    static boolean isResponseReadTimeout(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoResponseReadTimeout", context);
    }

    static boolean isConnectionTimeout(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoConnectionTimeout", context);
    }

    static boolean isConnectorError(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_UTILIZZO_CONNETTORE, context);
    }

    static boolean isContenutiRichiestaNonRiconosciuto(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, context);
    }

    static boolean isContenutiRispostaNonRiconosciuto(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, context);
    }

    static boolean isErroreSicurezzaMessaggioRisposta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA, context);
    }

    static boolean isErroreAllegatiRisposta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA, context);
    }

    static boolean isErroreCorrelazioneApplicativaRichiesta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_CORRELAZIONE_APPLICATIVA_RICHIESTA, context);
    }

    static boolean isErroreCorrelazioneApplicativaRisposta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_CORRELAZIONE_APPLICATIVA_RISPOSTA, context);
    }

    static boolean isErroreTrasformazioneRichiesta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TRASFORMAZIONE_RICHIESTA, context);
    }

    static boolean isErroreTrasformazioneRisposta(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TRASFORMAZIONE_RISPOSTA, context);
    }

    static boolean isRispostaDuplicata(OutResponseContext context) {
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.RISPOSTA_DUPLICATA, context);
    }

    static boolean isErroreBoolean(String key, OutResponseContext context) {
        MapKey k = Map.newMapKey((String)key);
        return SUAPResponseGenerator.isErroreBoolean((MapKey<String>)k, context);
    }

    static boolean isErroreBoolean(MapKey<String> key, OutResponseContext context) {
        if (context.getPddContext() != null && context.getPddContext().containsKey(key)) {
            Object o = context.getPddContext().get(key);
            if (o instanceof String) {
                String s = (String)o;
                return "true".equals(s);
            }
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                return b;
            }
        }
        return false;
    }

    static boolean isErroreString(String key, String value, OutResponseContext context) {
        MapKey k = Map.newMapKey((String)key);
        return SUAPResponseGenerator.isErroreString((MapKey<String>)k, value, context);
    }

    static boolean isErroreString(MapKey<String> key, String value, OutResponseContext context) {
        Object o;
        if (context.getPddContext() != null && context.getPddContext().containsKey(key) && (o = context.getPddContext().get(key)) instanceof String) {
            String s = (String)o;
            return value.equals(s);
        }
        return false;
    }

    static boolean isRisposta5xxDifferenteJson(OutResponseContext context) {
        if (context != null && context.getMessaggio() != null && context.getMessaggio().getTransportResponseContext() != null && context.getMessaggio().getTransportResponseContext().getCodiceTrasporto() != null) {
            int codiceHttp = -1;
            try {
                codiceHttp = Integer.valueOf(context.getMessaggio().getTransportResponseContext().getCodiceTrasporto());
            }
            catch (Exception e) {
                context.getLogCore().error("isInternalRisposta5xxDifferenteJson: " + e.getMessage(), (Throwable)e);
            }
            if (codiceHttp >= 500 && codiceHttp <= 599) {
                return SUAPResponseGenerator.isInternalRisposta5xxDifferenteJson(context);
            }
        }
        return false;
    }

    private static boolean isInternalRisposta5xxDifferenteJson(OutResponseContext context) {
        try {
            OpenSPCoop2RestMessage rest;
            String ct = context.getMessaggio().getContentType();
            if (ct == null) {
                return true;
            }
            if (context.getMessaggio() instanceof OpenSPCoop2RestMessage && !(rest = context.getMessaggio().castAsRest()).hasContent()) {
                return true;
            }
            String baseCT = null;
            if (ContentTypeUtilities.isMultipartType((String)ct)) {
                baseCT = ContentTypeUtilities.getInternalMultipartContentType((String)ct);
                if (baseCT != null) {
                    baseCT = ContentTypeUtilities.readBaseTypeFromContentType((String)baseCT);
                }
            } else {
                baseCT = ContentTypeUtilities.readBaseTypeFromContentType((String)ct);
            }
            if (!"application/json".equalsIgnoreCase(baseCT)) {
                return true;
            }
        }
        catch (Exception e) {
            context.getLogCore().error("isInternalRisposta5xxDifferenteJson failed: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean isAuthorizationWithoutBearer(OutResponseContext context) {
        try {
            String v;
            RequestInfo requestInfo;
            return context.getPddContext() != null && context.getPddContext().containsKey(Costanti.REQUEST_INFO) && (requestInfo = (RequestInfo)context.getPddContext().getObject(Costanti.REQUEST_INFO)) != null && requestInfo.getProtocolContext() != null && (v = requestInfo.getProtocolContext().getHeaderFirstValue("Authorization")) != null && StringUtils.isNotEmpty((CharSequence)v);
        }
        catch (Exception e) {
            context.getLogCore().error("isAuthorizationWithoutBearer failed: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static void modifyErrorMessage(int responseCode, String code, String message, OpenSPCoop2Message msg) throws MessageException {
        String error = "{\"code\": \"" + code + "\", \"message\": \"" + message + "\"}";
        OpenSPCoop2RestJsonMessage json = msg.castAsRestJson();
        ForcedResponseMessage frs = new ForcedResponseMessage();
        frs.setContent(error.getBytes());
        frs.setContentType("application/json");
        frs.setResponseCode("" + responseCode);
        json.forceResponse(frs);
    }

    static void replaceErrorMessage(int responseCode, String code, String message, OutResponseContext context) throws MessageException {
        try {
            String error = "{\"code\": \"" + code + "\", \"message\": \"" + message + "\"}";
            TransportResponseContext responseContext = new TransportResponseContext();
            responseContext.setCodiceTrasporto("" + responseCode);
            HashMap headers = new HashMap();
            TransportUtils.addHeader(headers, (String)"Content-Type", (String)"application/json");
            responseContext.setHeaders(headers);
            OpenSPCoop2Message errorMessage = context.getMessaggio().getFactory().createMessage(MessageType.JSON, responseContext, error.getBytes()).getMessage_throwParseException();
            context.setMessaggio(errorMessage);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
    }
}

