/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.keystore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.pdd.config.PDNDConfigUtilities;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.KeystoreNotFoundException;
import org.openspcoop2.pdd.core.keystore.RemoteStore;
import org.openspcoop2.pdd.core.keystore.RemoteStoreClientDetails;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKey;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKeyEntry;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriver;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class RemoteStoreProviderDriverUtils {
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_NOME = "nome";
    private static final String COLUMN_DATA_REGISTRAZIONE = "data_registrazione";
    private static final String COLUMN_DATA_AGGIORNAMENTO = "data_aggiornamento";
    private static final String COLUMN_LAST_EVENT = "last_event";
    private static final String COLUMN_ID_REMOTE_STORE = "id_remote_store";
    private static final String COLUMN_KID = "kid";
    private static final String COLUMN_KEY = "content_key";
    private static final String COLUMN_CLIENT_ID = "client_id";
    private static final String COLUMN_CLIENT_DETAILS = "client_details";
    private static final String COLUMN_ORGANIZATION_DETAILS = "organization_details";
    private static final String COLUMN_CLIENT_DATA_AGGIORNAMENTO = "client_data_aggiornamento";
    private static final String SUFFIX_NOT_FOUND = " not found";
    private static Timestamp dataInvalidaScaduta = null;
    private static final byte[] KEY_UNDEFINED;

    private RemoteStoreProviderDriverUtils() {
    }

    public static long registerIfNotExistsRemoteStore(DriverConfigurazioneDB driverConfigurazioneDB, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        long idRemoteStore = RemoteStoreProviderDriverUtils.getIdRemoteStore(driverConfigurazioneDB, remoteStoreConfig);
        if (idRemoteStore <= 0L) {
            return RemoteStoreProviderDriverUtils.createRemoteStore(driverConfigurazioneDB, remoteStoreConfig);
        }
        return idRemoteStore;
    }

    public static long registerIfNotExistsRemoteStore(Connection con, String tipoDatabase, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        long idRemoteStore = RemoteStoreProviderDriverUtils.getIdRemoteStore(con, tipoDatabase, remoteStoreConfig);
        if (idRemoteStore <= 0L) {
            return RemoteStoreProviderDriverUtils.createRemoteStore(con, tipoDatabase, remoteStoreConfig);
        }
        return idRemoteStore;
    }

    public static long createRemoteStore(DriverConfigurazioneDB driverConfigurazioneDB, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("createRemoteStore");
            long l = RemoteStoreProviderDriverUtils.createRemoteStore(con, driverConfigurazioneDB.getTipoDB(), remoteStoreConfig);
            return l;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static long createRemoteStore(Connection con, String tipoDatabase, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        try {
            String remoteStoreName = RemoteStoreProviderDriver.getRemoteStoreConfigName(remoteStoreConfig);
            Timestamp now = DateManager.getTimestamp();
            ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject(COLUMN_NOME, (Object)remoteStoreName, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject(COLUMN_DATA_AGGIORNAMENTO, (Object)now, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            long idRemoteStore = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)tipoDatabase), (IKeyGeneratorObject)new CustomKeyGeneratorObject("remote_store", COLUMN_ID, "seq_remote_store", "remote_store_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
            if (idRemoteStore <= 0L) {
                throw new KeystoreException("ID (RemoteStore) autoincrementale non ottenuto");
            }
            return idRemoteStore;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
    }

    public static long getIdRemoteStore(DriverConfigurazioneDB driverConfigurazioneDB, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getIdRemoteStore");
            long l = RemoteStoreProviderDriverUtils.getIdRemoteStore(con, driverConfigurazioneDB.getTipoDB(), remoteStoreConfig);
            return l;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static long getIdRemoteStore(Connection con, String tipoDatabase, RemoteStoreConfig remoteStoreConfig) throws KeystoreException {
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long idRemoteStore = -1L;
        try {
            String remoteStoreName = RemoteStoreProviderDriver.getRemoteStoreConfigName(remoteStoreConfig);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store");
            sqlQueryObject.addSelectField(COLUMN_ID);
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectStmt.setString(1, remoteStoreName);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                idRemoteStore = selectRS.getLong(COLUMN_ID);
            }
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return idRemoteStore;
    }

    public static RemoteStore getRemoteStore(DriverConfigurazioneDB driverConfigurazioneDB, RemoteStoreConfig remoteStoreConfig, boolean throwExceptionNotFound) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getRemoteStore");
            RemoteStore remoteStore = RemoteStoreProviderDriverUtils.getRemoteStore(con, driverConfigurazioneDB.getTipoDB(), remoteStoreConfig, throwExceptionNotFound);
            return remoteStore;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static RemoteStore getRemoteStore(Connection con, String tipoDatabase, RemoteStoreConfig remoteStoreConfig, boolean throwExceptionNotFound) throws KeystoreException {
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        RemoteStore remoteStore = null;
        try {
            String remoteStoreName = RemoteStoreProviderDriver.getRemoteStoreConfigName(remoteStoreConfig);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectStmt.setString(1, remoteStoreName);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                remoteStore = new RemoteStore();
                remoteStore.setId(selectRS.getLong(COLUMN_ID));
                remoteStore.setDataAggiornamento(selectRS.getTimestamp(COLUMN_DATA_AGGIORNAMENTO));
                remoteStore.setLastEvent(selectRS.getString(COLUMN_LAST_EVENT));
                remoteStore.setNome(selectRS.getString(COLUMN_NOME));
            } else if (throwExceptionNotFound) {
                throw new KeystoreException("RemoteStore '" + remoteStoreName + "' not found");
            }
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return remoteStore;
    }

    public static int updateRemoteStore(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String lastEventId) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("updateRemoteStore");
            int n = RemoteStoreProviderDriverUtils.updateRemoteStore(con, driverConfigurazioneDB.getTipoDB(), idStore, lastEventId);
            return n;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static int updateRemoteStore(Connection con, String tipoDatabase, long idStore, String lastEventId) throws KeystoreException {
        int n;
        PreparedStatement updateStmt = null;
        try {
            RemoteStoreProviderDriverUtils.checkRemoteStoreParams(idStore, lastEventId);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addUpdateTable("remote_store");
            sqlQueryObject.addUpdateField(COLUMN_LAST_EVENT, "?");
            sqlQueryObject.addUpdateField(COLUMN_DATA_AGGIORNAMENTO, "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateQuery = sqlQueryObject.createSQLUpdate();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            Timestamp now = DateManager.getTimestamp();
            updateStmt.setString(index++, lastEventId);
            updateStmt.setTimestamp(index++, now);
            updateStmt.setLong(index++, idStore);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        return n;
    }

    private static void checkRemoteStoreParams(long idStore, String lastEventId) throws KeystoreException {
        if (idStore <= 0L) {
            throw new KeystoreException("IdStore undefined");
        }
        if (lastEventId == null) {
            throw new KeystoreException("LastEventId undefined");
        }
    }

    public static List<RemoteStore> getRemoteStores(DriverConfigurazioneDB driverConfigurazioneDB) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getRemoteStores");
            List<RemoteStore> list = RemoteStoreProviderDriverUtils.getRemoteStores(con, driverConfigurazioneDB.getTipoDB());
            return list;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static List<RemoteStore> getRemoteStores(Connection con, String tipoDatabase) throws KeystoreException {
        ArrayList<RemoteStore> list = new ArrayList<RemoteStore>();
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(COLUMN_NOME);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectRS = selectStmt.executeQuery();
            while (selectRS.next()) {
                long idRemoteStore = selectRS.getLong(COLUMN_ID);
                Timestamp dataAggiornamento = selectRS.getTimestamp(COLUMN_DATA_AGGIORNAMENTO);
                String lastEvent = selectRS.getString(COLUMN_LAST_EVENT);
                String nome = selectRS.getString(COLUMN_NOME);
                RemoteStore rs = new RemoteStore();
                rs.setId(idRemoteStore);
                rs.setDataAggiornamento(dataAggiornamento);
                rs.setLastEvent(lastEvent);
                rs.setNome(nome);
                list.add(rs);
            }
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return list;
    }

    public static int addRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, byte[] key) throws KeystoreException {
        int n;
        Connection con = null;
        PreparedStatement updateStmt = null;
        try {
            con = driverConfigurazioneDB.getConnection("addRemoteStoreKey");
            RemoteStoreProviderDriverUtils.checkParams(idStore, kid, key);
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)driverConfigurazioneDB.getTipoDB());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addInsertTable("remote_store_key");
            sqlQueryObject.addInsertField(COLUMN_ID_REMOTE_STORE, "?");
            sqlQueryObject.addInsertField(COLUMN_KID, "?");
            sqlQueryObject.addInsertField(COLUMN_KEY, "?");
            sqlQueryObject.addInsertField(COLUMN_DATA_REGISTRAZIONE, "?");
            sqlQueryObject.addInsertField(COLUMN_DATA_AGGIORNAMENTO, "?");
            String updateQuery = sqlQueryObject.createSQLInsert();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setLong(index++, idStore);
            updateStmt.setString(index++, kid);
            jdbcAdapter.setBinaryData(updateStmt, index++, key);
            Timestamp now = DateManager.getTimestamp();
            updateStmt.setTimestamp(index++, now);
            updateStmt.setTimestamp(index++, now);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                driverConfigurazioneDB.releaseConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        driverConfigurazioneDB.releaseConnection(con);
        return n;
    }

    public static int invalidRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid) throws KeystoreException {
        return RemoteStoreProviderDriverUtils.updateRemoteStoreKeyEngine(driverConfigurazioneDB, idStore, kid, null, true);
    }

    public static int invalidRemoteStoreKey(Connection con, String tipoDatabase, long idStore, String kid) throws KeystoreException {
        return RemoteStoreProviderDriverUtils.updateRemoteStoreKeyEngine(con, tipoDatabase, idStore, kid, null, true);
    }

    public static int updateRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, byte[] key) throws KeystoreException {
        return RemoteStoreProviderDriverUtils.updateRemoteStoreKeyEngine(driverConfigurazioneDB, idStore, kid, key, false);
    }

    private static int updateRemoteStoreKeyEngine(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, byte[] key, boolean invalid) throws KeystoreException {
        int n;
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection(invalid ? "invalidRemoteStoreKey" : "updateRemoteStoreKey");
            n = RemoteStoreProviderDriverUtils.updateRemoteStoreKeyEngine(con, driverConfigurazioneDB.getTipoDB(), idStore, kid, key, invalid);
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                driverConfigurazioneDB.releaseConnection(con);
                throw throwable;
            }
        }
        driverConfigurazioneDB.releaseConnection(con);
        return n;
    }

    private static int updateRemoteStoreKeyEngine(Connection con, String tipoDatabase, long idStore, String kid, byte[] key, boolean invalid) throws KeystoreException {
        int n;
        PreparedStatement updateStmt = null;
        try {
            if (invalid) {
                RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
            } else {
                RemoteStoreProviderDriverUtils.checkParams(idStore, kid, key);
            }
            IJDBCAdapter jdbcAdapter = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addUpdateTable("remote_store_key");
            if (!invalid) {
                sqlQueryObject.addUpdateField(COLUMN_KEY, "?");
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            }
            sqlQueryObject.addUpdateField(COLUMN_DATA_AGGIORNAMENTO, "?");
            if (invalid) {
                sqlQueryObject.addUpdateField(COLUMN_CLIENT_DATA_AGGIORNAMENTO, "?");
            }
            RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
            sqlQueryObject.setANDLogicOperator(true);
            String updateQuery = sqlQueryObject.createSQLUpdate();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            Timestamp now = DateManager.getTimestamp();
            if (invalid) {
                updateStmt.setTimestamp(index++, dataInvalidaScaduta);
                updateStmt.setTimestamp(index++, dataInvalidaScaduta);
            } else {
                jdbcAdapter.setBinaryData(updateStmt, index++, key);
                updateStmt.setTimestamp(index++, now);
            }
            updateStmt.setLong(index++, idStore);
            updateStmt.setString(index++, kid);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        return n;
    }

    public static int deleteRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("deleteRemoteStoreKey");
            int n = RemoteStoreProviderDriverUtils.deleteRemoteStoreKey(con, driverConfigurazioneDB.getTipoDB(), idStore, kid);
            return n;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static int deleteRemoteStoreKey(Connection con, String tipoDatabase, long idStore, String kid) throws KeystoreException {
        int n;
        PreparedStatement updateStmt = null;
        try {
            RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addDeleteTable("remote_store_key");
            RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
            sqlQueryObject.setANDLogicOperator(true);
            String updateQuery = sqlQueryObject.createSQLDelete();
            updateStmt = con.prepareStatement(updateQuery);
            updateStmt.setLong(1, idStore);
            updateStmt.setString(2, kid);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        return n;
    }

    public static RemoteStoreKey getRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid) throws KeystoreException, KeystoreNotFoundException {
        ResultSet selectRS;
        PreparedStatement selectStmt;
        Connection con;
        block6: {
            con = null;
            selectStmt = null;
            selectRS = null;
            con = driverConfigurazioneDB.getConnection("getRemoteStoreKey");
            RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)driverConfigurazioneDB.getTipoDB());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addFromTable("remote_store_key");
            sqlQueryObject.addSelectField(COLUMN_KEY);
            sqlQueryObject.addSelectField(COLUMN_DATA_AGGIORNAMENTO);
            RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectStmt.setLong(1, idStore);
            selectStmt.setString(2, kid);
            selectRS = selectStmt.executeQuery();
            if (!selectRS.next()) break block6;
            RemoteStoreKey rsk = new RemoteStoreKey();
            rsk.setKey(jdbcAdapter.getBinaryData(selectRS, COLUMN_KEY));
            rsk.setDataAggiornamento(selectRS.getTimestamp(COLUMN_DATA_AGGIORNAMENTO));
            rsk.setInvalid(dataInvalidaScaduta.equals(rsk.getDataAggiornamento()));
            RemoteStoreKey remoteStoreKey = rsk;
            JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
            driverConfigurazioneDB.releaseConnection(con);
            return remoteStoreKey;
        }
        try {
            try {
                throw new KeystoreNotFoundException("Key with kid '" + kid + "' not found");
            }
            catch (KeystoreNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            driverConfigurazioneDB.releaseConnection(con);
            throw throwable;
        }
    }

    public static boolean existsRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, boolean checkDates) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("existsRemoteStoreKey");
            boolean bl = RemoteStoreProviderDriverUtils.existsRemoteStoreKey(con, driverConfigurazioneDB.getTipoDB(), idStore, kid, checkDates);
            return bl;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static boolean existsRemoteStoreKey(Connection con, String tipoDatabase, long idStore, String kid, boolean checkDates) throws KeystoreException {
        boolean bl;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
            Timestamp tooOld = null;
            if (checkDates && RemoteStoreProviderDriver.getKeyMaxLifeMinutes() > 0) {
                long maxLifeSeconds = (long)RemoteStoreProviderDriver.getKeyMaxLifeMinutes() * 60L;
                long maxLifeMs = maxLifeSeconds * 1000L;
                tooOld = new Timestamp(DateManager.getTimeMillis() - maxLifeMs);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store_key");
            sqlQueryObject.addSelectField(COLUMN_KEY);
            RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
            if (checkDates) {
                sqlQueryObject.addWhereCondition("data_aggiornamento>?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            int index = 1;
            selectStmt.setLong(index++, idStore);
            selectStmt.setString(index++, kid);
            if (checkDates) {
                if (tooOld != null) {
                    selectStmt.setTimestamp(index++, tooOld);
                } else {
                    selectStmt.setTimestamp(index++, dataInvalidaScaduta);
                }
            }
            selectRS = selectStmt.executeQuery();
            bl = selectRS.next();
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return bl;
    }

    public static RemoteStoreClientDetails getRemoteStoreClientDetails(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, Logger log, boolean createEntryIfNotExists, RemoteStoreConfig remoteConfig) throws KeystoreException, KeystoreNotFoundException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getRemoteStoreClientDetails");
            RemoteStoreClientDetails remoteStoreClientDetails = RemoteStoreProviderDriverUtils.getRemoteStoreClientDetails(con, driverConfigurazioneDB.getTipoDB(), idStore, kid, log, createEntryIfNotExists, remoteConfig);
            return remoteStoreClientDetails;
        }
        catch (KeystoreNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static RemoteStoreClientDetails getRemoteStoreClientDetails(Connection con, String tipoDatabase, long idStore, String kid, Logger log, boolean createEntryIfNotExists, RemoteStoreConfig remoteConfig) throws KeystoreException, KeystoreNotFoundException {
        ResultSet selectRS;
        PreparedStatement selectStmt;
        block9: {
            int row;
            block8: {
                selectStmt = null;
                selectRS = null;
                RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                sqlQueryObject.addFromTable("remote_store_key");
                sqlQueryObject.addSelectField(COLUMN_CLIENT_ID);
                sqlQueryObject.addSelectField(COLUMN_CLIENT_DETAILS);
                sqlQueryObject.addSelectField(COLUMN_ORGANIZATION_DETAILS);
                sqlQueryObject.addSelectField(COLUMN_CLIENT_DATA_AGGIORNAMENTO);
                RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                selectStmt = con.prepareStatement(sqlQuery);
                selectStmt.setLong(1, idStore);
                selectStmt.setString(2, kid);
                selectRS = selectStmt.executeQuery();
                if (!selectRS.next()) break block8;
                RemoteStoreClientDetails rsk = new RemoteStoreClientDetails();
                rsk.setClientInfo(new RemoteStoreClientInfo());
                rsk.getClientInfo().setClientId(selectRS.getString(COLUMN_CLIENT_ID));
                rsk.getClientInfo().setClientDetails(selectRS.getString(COLUMN_CLIENT_DETAILS));
                if (rsk.getClientInfo().getClientId() != null && rsk.getClientInfo().getClientDetails() != null) {
                    String jsonPath = ModIUtils.extractInfoFromMetadati((Map)remoteConfig.getMetadati(), (String)"api-pdnd-clients-organizationJsonPath", (String)"Clients organization json path");
                    boolean readErrorAbortTransaction = false;
                    String organizationId = PDNDConfigUtilities.readOrganizationId(jsonPath, readErrorAbortTransaction, rsk.getClientInfo().getClientDetails(), log);
                    rsk.getClientInfo().setOrganizationId(organizationId);
                }
                rsk.getClientInfo().setOrganizationDetails(selectRS.getString(COLUMN_ORGANIZATION_DETAILS));
                rsk.setDataAggiornamento(selectRS.getTimestamp(COLUMN_CLIENT_DATA_AGGIORNAMENTO));
                rsk.setInvalid(dataInvalidaScaduta.equals(rsk.getDataAggiornamento()));
                RemoteStoreClientDetails remoteStoreClientDetails = rsk;
                JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
                return remoteStoreClientDetails;
            }
            if (!createEntryIfNotExists || (row = RemoteStoreProviderDriverUtils.initializeEmptyEntry(con, tipoDatabase, idStore, kid, log)) <= 0) break block9;
            RemoteStoreClientDetails remoteStoreClientDetails = new RemoteStoreClientDetails();
            JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
            return remoteStoreClientDetails;
        }
        try {
            try {
                throw new KeystoreNotFoundException("Key with kid '" + kid + "' not found");
            }
            catch (KeystoreNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int initializeEmptyEntry(Connection con, String tipoDB, long idStore, String kid, Logger log) {
        PreparedStatement updateStmt = null;
        try {
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addInsertTable("remote_store_key");
            sqlQueryObject.addInsertField(COLUMN_ID_REMOTE_STORE, "?");
            sqlQueryObject.addInsertField(COLUMN_KID, "?");
            sqlQueryObject.addInsertField(COLUMN_KEY, "?");
            sqlQueryObject.addInsertField(COLUMN_DATA_REGISTRAZIONE, "?");
            sqlQueryObject.addInsertField(COLUMN_DATA_AGGIORNAMENTO, "?");
            String updateQuery = sqlQueryObject.createSQLInsert();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setLong(index++, idStore);
            updateStmt.setString(index++, kid);
            jdbcAdapter.setBinaryData(updateStmt, index++, KEY_UNDEFINED);
            Timestamp now = DateManager.getTimestamp();
            updateStmt.setTimestamp(index++, now);
            updateStmt.setTimestamp(index++, dataInvalidaScaduta);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            int n = rows;
            JDBCUtilities.closeResources((PreparedStatement)updateStmt);
            return n;
        }
        catch (Exception e) {
            log.error("initializeEmptyEntry failed: " + e.getMessage(), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    public static int updateRemoteStoreClientDetails(DriverConfigurazioneDB driverConfigurazioneDB, long idStore, String kid, RemoteStoreClientDetails clientDetails) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("updateRemoteStoreClientDetails");
            int n = RemoteStoreProviderDriverUtils.updateRemoteStoreClientDetails(con, driverConfigurazioneDB.getTipoDB(), idStore, kid, clientDetails);
            return n;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static int updateRemoteStoreClientDetails(Connection con, String tipoDatabase, long idStore, String kid, RemoteStoreClientDetails clientDetails) throws KeystoreException {
        int n;
        PreparedStatement updateStmt = null;
        try {
            RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
            if (clientDetails == null) {
                throw new KeystoreException("ClientDetails undefined");
            }
            if (clientDetails.getClientInfo() == null) {
                throw new KeystoreException("ClientInfo undefined");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addUpdateTable("remote_store_key");
            sqlQueryObject.addUpdateField(COLUMN_CLIENT_ID, "?");
            sqlQueryObject.addUpdateField(COLUMN_CLIENT_DETAILS, "?");
            sqlQueryObject.addUpdateField(COLUMN_ORGANIZATION_DETAILS, "?");
            sqlQueryObject.addUpdateField(COLUMN_CLIENT_DATA_AGGIORNAMENTO, "?");
            RemoteStoreProviderDriverUtils.addWhereKidConditions(sqlQueryObject);
            sqlQueryObject.setANDLogicOperator(true);
            String updateQuery = sqlQueryObject.createSQLUpdate();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setString(index++, clientDetails.getClientInfo().getClientId());
            updateStmt.setString(index++, clientDetails.getClientInfo().getClientDetails());
            updateStmt.setString(index++, clientDetails.getClientInfo().getOrganizationDetails());
            updateStmt.setTimestamp(index++, clientDetails.getDataAggiornamento() != null ? new Timestamp(clientDetails.getDataAggiornamento().getTime()) : DateManager.getTimestamp());
            updateStmt.setLong(index++, idStore);
            updateStmt.setString(index++, kid);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        return n;
    }

    private static void checkParams(long idStore, String kid, byte[] key) throws KeystoreException {
        RemoteStoreProviderDriverUtils.checkParams(idStore, kid);
        if (key == null || key.length <= 0) {
            throw new KeystoreException("Key undefined");
        }
    }

    private static void checkParams(long idStore, String kid) throws KeystoreException {
        if (idStore <= 0L) {
            throw new KeystoreException("IdStore undefined");
        }
        if (kid == null) {
            throw new KeystoreException("Kid undefined");
        }
    }

    private static void addWhereKidConditions(ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        sqlQueryObject.addWhereCondition("id_remote_store=?");
        sqlQueryObject.addWhereCondition("kid=?");
    }

    public static List<RemoteStoreKeyEntry> getRemoteStoreKeyEntries(DriverConfigurazioneDB driverConfigurazioneDB, ISearch ricerca, long idRemoteStore) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getRemoteStoreKeyEntries");
            List<RemoteStoreKeyEntry> list = RemoteStoreProviderDriverUtils.getRemoteStoreKeyEntries(con, driverConfigurazioneDB.getTipoDB(), ricerca, idRemoteStore);
            return list;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static List<RemoteStoreKeyEntry> getRemoteStoreKeyEntries(Connection con, String tipoDatabase, ISearch ricerca, long idRemoteStore) throws KeystoreException {
        String filtroOrganizzazione;
        String filtroClientId;
        String filtroKid;
        int idLista = Liste.REMOTE_STORE_KEY;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        if (limit == 0) {
            limit = 1000;
        }
        if ((filtroKid = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyKid")) != null && "".equals(filtroKid)) {
            filtroKid = null;
        }
        if ((filtroClientId = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyClientId")) != null && "".equals(filtroClientId)) {
            filtroClientId = null;
        }
        if ((filtroOrganizzazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyOrganizzazione")) != null && "".equals(filtroOrganizzazione)) {
            filtroOrganizzazione = null;
        }
        PreparedStatement selectStmtCount = null;
        ResultSet selectRSCount = null;
        int size = 0;
        try {
            ISQLQueryObject sqlQueryObject = RemoteStoreProviderDriverUtils.buildSqlRemoteStoreKeyEntries(tipoDatabase, filtroKid, filtroClientId, filtroOrganizzazione);
            sqlQueryObject.addSelectCountField("somma");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmtCount = con.prepareStatement(sqlQuery);
            selectStmtCount.setLong(1, idRemoteStore);
            selectRSCount = selectStmtCount.executeQuery();
            if (selectRSCount.next()) {
                size = selectRSCount.getInt("somma");
                if (size < 0) {
                    size = 0;
                }
                ricerca.setNumEntries(idLista, size);
            }
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRSCount, selectStmtCount);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRSCount, (PreparedStatement)selectStmtCount);
        ArrayList<RemoteStoreKeyEntry> list = new ArrayList<RemoteStoreKeyEntry>();
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            ISQLQueryObject sqlQueryObject = RemoteStoreProviderDriverUtils.buildSqlRemoteStoreKeyEntries(tipoDatabase, filtroKid, filtroClientId, filtroOrganizzazione);
            sqlQueryObject.addOrderBy(COLUMN_DATA_REGISTRAZIONE, false);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectStmt.setLong(1, idRemoteStore);
            selectRS = selectStmt.executeQuery();
            while (selectRS.next()) {
                list.add(RemoteStoreProviderDriverUtils.readKeyEntry(selectRS, jdbcAdapter));
            }
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return list;
    }

    private static ISQLQueryObject buildSqlRemoteStoreKeyEntries(String tipoDatabase, String filtroKid, String filtroClientId, String filtroOrganizzazione) throws KeystoreException {
        ISQLQueryObject sqlQueryObject = null;
        try {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store_key");
            sqlQueryObject.addWhereCondition("id_remote_store=?");
            if (filtroKid != null) {
                if (filtroKid.equals("-")) {
                    sqlQueryObject.addWhereLikeCondition(COLUMN_KID, "ClientId--", LikeConfig.startsWith((boolean)false));
                } else {
                    sqlQueryObject.addWhereLikeCondition(COLUMN_KID, filtroKid, LikeConfig.contains((boolean)true));
                }
            }
            if (filtroClientId != null) {
                if (filtroClientId.equals("-")) {
                    sqlQueryObject.addWhereIsNullCondition(COLUMN_CLIENT_ID);
                } else {
                    sqlQueryObject.addWhereLikeCondition(COLUMN_CLIENT_ID, filtroClientId, LikeConfig.contains((boolean)true));
                }
            }
            if (filtroOrganizzazione != null) {
                if (filtroOrganizzazione.equals("-")) {
                    sqlQueryObject.addWhereIsNullCondition(COLUMN_ORGANIZATION_DETAILS);
                } else {
                    sqlQueryObject.addWhereLikeCondition(COLUMN_ORGANIZATION_DETAILS, filtroOrganizzazione, LikeConfig.contains((boolean)true));
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        return sqlQueryObject;
    }

    private static RemoteStoreKeyEntry readKeyEntry(ResultSet selectRS, IJDBCAdapter jdbcAdapter) throws SQLException, UtilsException {
        long id = selectRS.getLong(COLUMN_ID);
        long idStore = selectRS.getLong(COLUMN_ID_REMOTE_STORE);
        Timestamp dataRegistrazione = selectRS.getTimestamp(COLUMN_DATA_REGISTRAZIONE);
        String kid = selectRS.getString(COLUMN_KID);
        Timestamp dataAggiornamento = selectRS.getTimestamp(COLUMN_DATA_AGGIORNAMENTO);
        String clientId = selectRS.getString(COLUMN_CLIENT_ID);
        String clientDetails = selectRS.getString(COLUMN_CLIENT_DETAILS);
        String organizationDetails = selectRS.getString(COLUMN_ORGANIZATION_DETAILS);
        Timestamp clientDataAggiornamento = selectRS.getTimestamp(COLUMN_CLIENT_DATA_AGGIORNAMENTO);
        RemoteStoreKeyEntry rs = new RemoteStoreKeyEntry();
        rs.setId(id);
        rs.setDataRegistrazione(dataRegistrazione);
        rs.setIdRemoteStore(idStore);
        rs.setContentKey(jdbcAdapter.getBinaryData(selectRS, COLUMN_KEY));
        rs.setKid(kid);
        rs.setDataAggiornamento(dataAggiornamento);
        rs.setClientId(clientId);
        rs.setClientDetails(clientDetails);
        rs.setOrganizationDetails(organizationDetails);
        rs.setClientDataAggiornamento(clientDataAggiornamento);
        RemoteStoreProviderDriverUtils.enrichClientInfo(clientDetails, rs);
        RemoteStoreProviderDriverUtils.enrichOrganizationInfo(organizationDetails, rs);
        return rs;
    }

    private static void enrichClientInfo(String clientDetails, RemoteStoreKeyEntry rs) {
        if (clientDetails != null) {
            ModIPDNDClientConfig config = null;
            try {
                config = ModIUtils.getAPIPDNDClientConfig((String)clientDetails);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (config == null) {
                return;
            }
            rs.setClientIdPdnd(config.getId());
            rs.setClientConsumerId(config.getOrganization());
            rs.setClientName(config.getName());
            rs.setClientDescription(config.getDescription());
        }
    }

    private static void enrichOrganizationInfo(String organizationDetails, RemoteStoreKeyEntry rs) {
        if (organizationDetails != null) {
            ModIPDNDOrganizationConfig config = null;
            try {
                config = ModIUtils.getAPIPDNDOrganizationConfig((String)organizationDetails);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (config == null) {
                return;
            }
            rs.setOrganizationIdPdnd(config.getId());
            rs.setOrganizationName(config.getName());
            rs.setOrganizationExternalOrigin(config.getExternalOrigin());
            rs.setOrganizationExternalId(config.getExternalId());
            rs.setOrganizationCategory(config.getCategory());
            rs.setOrganizationSubunit(config.getSubUnit());
        }
    }

    public static int deleteRemoteStoreKeyEntry(DriverConfigurazioneDB driverConfigurazioneDB, long idRemoteStore, long idEntry) throws KeystoreException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("deleteRemoteStoreKeyEntry");
            int n = RemoteStoreProviderDriverUtils.deleteRemoteStoreKeyEntry(con, driverConfigurazioneDB.getTipoDB(), idRemoteStore, idEntry);
            return n;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static int deleteRemoteStoreKeyEntry(Connection con, String tipoDatabase, long idRemoteStore, long idEntry) throws KeystoreException {
        int n;
        PreparedStatement updateStmt = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addDeleteTable("remote_store_key");
            sqlQueryObject.addWhereCondition("id_remote_store=?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateQuery = sqlQueryObject.createSQLDelete();
            updateStmt = con.prepareStatement(updateQuery);
            updateStmt.setLong(1, idRemoteStore);
            updateStmt.setLong(2, idEntry);
            int rows = updateStmt.executeUpdate();
            updateStmt.close();
            n = rows;
        }
        catch (Exception e) {
            try {
                throw new KeystoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
        return n;
    }

    public static RemoteStoreKeyEntry getRemoteStoreKeyEntry(Logger log, DriverConfigurazioneDB driverConfigurazioneDB, long idRemoteStoreKey) throws KeystoreException, KeystoreNotFoundException {
        Connection con = null;
        try {
            con = driverConfigurazioneDB.getConnection("getRemoteStoreKeyEntry");
            RemoteStoreKeyEntry remoteStoreKeyEntry = RemoteStoreProviderDriverUtils.getRemoteStoreKeyEntry(con, driverConfigurazioneDB.getTipoDB(), idRemoteStoreKey);
            return remoteStoreKeyEntry;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        finally {
            driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public static RemoteStoreKeyEntry getRemoteStoreKeyEntry(Connection con, String tipoDatabase, long idRemoteStoreKey) throws KeystoreException, KeystoreNotFoundException {
        ResultSet selectRS;
        PreparedStatement selectStmt;
        block6: {
            selectStmt = null;
            selectRS = null;
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("remote_store_key");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            selectStmt = con.prepareStatement(sqlQuery);
            selectStmt.setLong(1, idRemoteStoreKey);
            selectRS = selectStmt.executeQuery();
            if (!selectRS.next()) break block6;
            RemoteStoreKeyEntry remoteStoreKeyEntry = RemoteStoreProviderDriverUtils.readKeyEntry(selectRS, jdbcAdapter);
            JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
            return remoteStoreKeyEntry;
        }
        try {
            try {
                throw new KeystoreNotFoundException("Key with id '" + idRemoteStoreKey + "' not found");
            }
            catch (KeystoreNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KeystoreException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            throw throwable;
        }
    }

    static {
        try {
            dataInvalidaScaduta = new Timestamp(DateUtils.getSimpleDateFormatDay().parse("2000-01-01").getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        KEY_UNDEFINED = "KEY_UNDEFINED".getBytes();
    }
}

