/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.state;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBConsegneMessageBoxManager;
import org.openspcoop2.pdd.config.DBConsegnePreseInCaricoManager;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateDBManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.GenericMessage;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public abstract class OpenSPCoopState
implements IOpenSPCoopState {
    protected Logger logger = null;
    protected OpenSPCoopStateDBManager dbManager = null;
    protected DBManager dbManager_runtime = null;
    protected DBConsegnePreseInCaricoManager dbManager_consegnePreseInCarico = null;
    protected DBConsegneMessageBoxManager dbManager_consegneMessageBox = null;
    protected Resource resourceDB = null;
    protected Connection connectionDB = null;
    protected boolean connessioneInizializzata = false;
    protected IDSoggetto identitaPdD = null;
    protected String idModulo = null;
    protected GenericMessage messageLib;
    protected String IDMessaggioSessione;
    protected StateMessage richiestaStato = null;
    protected StateMessage rispostaStato = null;
    protected boolean useConnection;

    public static OpenSPCoopStateless toStateless(OpenSPCoopStateful stateful, boolean useConnection) {
        OpenSPCoopStateless stateless = new OpenSPCoopStateless();
        stateless.connectionDB = stateful.connectionDB;
        stateless.dbManager = stateful.dbManager;
        stateless.dbManager_runtime = stateful.dbManager_runtime;
        stateless.dbManager_consegnePreseInCarico = stateful.dbManager_consegnePreseInCarico;
        stateless.dbManager_consegneMessageBox = stateful.dbManager_consegneMessageBox;
        stateless.IDMessaggioSessione = stateful.IDMessaggioSessione;
        stateless.identitaPdD = stateful.identitaPdD;
        stateless.idModulo = stateful.idModulo;
        stateless.logger = stateful.logger;
        stateless.messageLib = stateful.messageLib;
        stateless.resourceDB = stateful.resourceDB;
        stateless.richiestaStato = stateful.richiestaStato;
        stateless.rispostaStato = stateful.rispostaStato;
        stateless.useConnection = useConnection;
        stateless.connessioneInizializzata = stateful.connessioneInizializzata;
        StatelessMessage tempRichiesta = new StatelessMessage(stateful.getConnectionDB(), stateful.logger);
        if (stateful.getStatoRichiesta() != null) {
            tempRichiesta.setPreparedStatement(((StateMessage)stateful.getStatoRichiesta()).getPreparedStatement());
        }
        stateless.setStatoRichiesta((IState)new StatelessMessage((StateMessage)tempRichiesta));
        StatelessMessage tempRisposta = new StatelessMessage(stateful.getConnectionDB(), stateful.logger);
        if (stateful.getStatoRisposta() != null) {
            tempRisposta.setPreparedStatement(((StateMessage)stateful.getStatoRisposta()).getPreparedStatement());
        }
        stateless.setStatoRisposta((IState)new StatelessMessage((StateMessage)tempRisposta));
        return stateless;
    }

    public abstract void updateStatoRichiesta() throws UtilsException;

    public abstract void updateStatoRisposta() throws UtilsException;

    @Override
    public void initResource(IDSoggetto identitaPdD, String idModulo, String idTransazione) throws OpenSPCoopStateException {
        this.initResource(identitaPdD, idModulo, idTransazione, OpenSPCoopStateDBManager.runtime);
    }

    @Override
    public void initResource(IDSoggetto identitaPdD, String idModulo, String idTransazione, OpenSPCoopStateDBManager dbManager) throws OpenSPCoopStateException {
        this.dbManager = dbManager;
        if (identitaPdD == null) {
            throw new OpenSPCoopStateException("IdentitaPdD non presente");
        }
        this.identitaPdD = identitaPdD;
        if (idModulo == null) {
            throw new OpenSPCoopStateException("IDModulo non presente");
        }
        this.idModulo = idModulo;
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.useConnection) {
            if (dbManager != null) {
                switch (dbManager) {
                    case runtime: {
                        this.dbManager_runtime = DBManager.getInstance();
                        break;
                    }
                    case smistatoreMessaggiPresiInCarico: {
                        this.dbManager_consegnePreseInCarico = DBConsegnePreseInCaricoManager.getInstanceSmistatore();
                        break;
                    }
                    case consegnePreseInCarico: {
                        this.dbManager_consegnePreseInCarico = DBConsegnePreseInCaricoManager.getInstanceRuntime();
                        break;
                    }
                    case messageBox: {
                        this.dbManager_consegneMessageBox = DBConsegneMessageBoxManager.getInstanceRuntime();
                    }
                }
            } else {
                this.dbManager_runtime = DBManager.getInstance();
            }
            try {
                this.resourceDB = this.dbManager_runtime != null ? this.dbManager_runtime.getResource(identitaPdD, this.idModulo, idTransazione) : (this.dbManager_consegnePreseInCarico != null ? this.dbManager_consegnePreseInCarico.getResource(identitaPdD, this.idModulo, idTransazione) : this.dbManager_consegneMessageBox.getResource(identitaPdD, this.idModulo, idTransazione));
            }
            catch (Exception e) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB", e);
            }
            if (this.resourceDB == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Risorsa is null).");
            }
            if (this.resourceDB.getResource() == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Connessione is null).");
            }
            this.connectionDB = (Connection)this.resourceDB.getResource();
            try {
                this.updateStatoRichiesta();
                this.updateStatoRisposta();
            }
            catch (Exception e) {
                this.logger.error("Update stato richiesta/risposta non riuscito", (Throwable)e);
                if (this.dbManager_runtime != null) {
                    this.dbManager_runtime.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                } else if (this.dbManager_consegnePreseInCarico != null) {
                    this.dbManager_consegnePreseInCarico.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                } else {
                    this.dbManager_consegneMessageBox.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                }
                throw new OpenSPCoopStateException("Update stato richiesta/risposta non riuscito", e);
            }
            this.connessioneInizializzata = true;
        }
    }

    @Override
    public void updateResource(String idTransazione) throws OpenSPCoopStateException {
        if (this.useConnection) {
            try {
                if (this.dbManager != null) {
                    switch (this.dbManager) {
                        case runtime: {
                            if (this.dbManager_runtime != null) break;
                            this.dbManager_runtime = DBManager.getInstance();
                            break;
                        }
                        case smistatoreMessaggiPresiInCarico: {
                            if (this.dbManager_consegnePreseInCarico != null) break;
                            this.dbManager_consegnePreseInCarico = DBConsegnePreseInCaricoManager.getInstanceSmistatore();
                            break;
                        }
                        case consegnePreseInCarico: {
                            if (this.dbManager_consegnePreseInCarico != null) break;
                            this.dbManager_consegnePreseInCarico = DBConsegnePreseInCaricoManager.getInstanceRuntime();
                            break;
                        }
                        case messageBox: {
                            if (this.dbManager_consegneMessageBox != null) break;
                            this.dbManager_consegneMessageBox = DBConsegneMessageBoxManager.getInstanceRuntime();
                        }
                    }
                } else if (this.dbManager_runtime == null) {
                    this.dbManager_runtime = DBManager.getInstance();
                }
                this.resourceDB = this.dbManager_runtime != null ? this.dbManager_runtime.getResource(this.identitaPdD, this.idModulo, idTransazione) : (this.dbManager_consegnePreseInCarico != null ? this.dbManager_consegnePreseInCarico.getResource(this.identitaPdD, this.idModulo, idTransazione) : this.dbManager_consegneMessageBox.getResource(this.identitaPdD, this.idModulo, idTransazione));
            }
            catch (Exception e) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB", e);
            }
            if (this.resourceDB == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Risorsa is null).");
            }
            if (this.resourceDB.getResource() == null) {
                throw new OpenSPCoopStateException("Riscontrato errore durante la richiesta di una connessione al DB (Connessione is null).");
            }
            this.connectionDB = (Connection)this.resourceDB.getResource();
            this.richiestaStato.updateConnection(this.connectionDB);
            this.rispostaStato.updateConnection(this.connectionDB);
            this.connessioneInizializzata = true;
        }
    }

    @Override
    public void releaseResource() {
        if (this.useConnection && this.connessioneInizializzata) {
            List l;
            try {
                if (this.richiestaStato != null && this.richiestaStato.getPreparedStatement() != null && this.richiestaStato.getPreparedStatement().size() > 0) {
                    l = this.richiestaStato.getPreparedStatement().keys();
                    if (l != null && !l.isEmpty()) {
                        for (String key : l) {
                            this.logger.error("PREPARED STATEMENT NON CHIUSA (RICHIESTA): " + key);
                        }
                    }
                    this.richiestaStato.closePreparedStatement();
                }
            }
            catch (Exception e) {
                this.logger.error("Chiusure prepared statement della richiesta non riuscita", (Throwable)e);
            }
            try {
                if (this.rispostaStato != null && this.rispostaStato.getPreparedStatement() != null && this.rispostaStato.getPreparedStatement().size() > 0) {
                    l = this.rispostaStato.getPreparedStatement().keys();
                    if (l != null && !l.isEmpty()) {
                        for (String key : l) {
                            this.logger.error("PREPARED STATEMENT NON CHIUSA (RISPOSTA): " + key);
                        }
                    }
                    this.rispostaStato.closePreparedStatement();
                }
            }
            catch (Exception e) {
                this.logger.error("Chiusure prepared statement della risposta non riuscita", (Throwable)e);
            }
            try {
                if (this.resourceDB != null) {
                    if (this.dbManager_runtime != null) {
                        this.dbManager_runtime.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                    } else if (this.dbManager_consegnePreseInCarico != null) {
                        this.dbManager_consegnePreseInCarico.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                    } else {
                        this.dbManager_consegneMessageBox.releaseResource(this.identitaPdD, this.idModulo, this.resourceDB);
                    }
                }
                if (this.richiestaStato != null) {
                    this.richiestaStato.updateConnection(null);
                }
                if (this.rispostaStato != null) {
                    this.rispostaStato.updateConnection(null);
                }
            }
            catch (Exception e) {
                this.logger.error("Rilasciate risorse con errore: " + e.getMessage(), (Throwable)e);
                OpenSPCoop2Logger.getLoggerOpenSPCoopConsole().error("Rilasciate risorse con errore: " + e.getMessage());
            }
            this.connessioneInizializzata = false;
        }
    }

    @Override
    public boolean resourceReleased() {
        return !this.connessioneInizializzata;
    }

    public void forceFinallyReleaseResource() {
        if (this.connessioneInizializzata) {
            this.useConnection = true;
            this.releaseResource();
        }
    }

    @Override
    public void commit() throws OpenSPCoopStateException {
        if (this.useConnection && (this.richiestaStato != null && this.richiestaStato.getPreparedStatement() != null && this.richiestaStato.getPreparedStatement().size() > 0 || this.rispostaStato != null && this.rispostaStato.getPreparedStatement() != null && this.rispostaStato.getPreparedStatement().size() > 0)) {
            try {
                this.connectionDB.setAutoCommit(false);
                if (this.richiestaStato != null) {
                    this.richiestaStato.executePreparedStatement();
                }
                if (this.rispostaStato != null) {
                    this.rispostaStato.executePreparedStatement();
                }
                this.connectionDB.commit();
                this.connectionDB.setAutoCommit(true);
            }
            catch (Exception e) {
                try {
                    if (this.richiestaStato != null) {
                        this.richiestaStato.closePreparedStatement();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.rispostaStato != null) {
                        this.rispostaStato.closePreparedStatement();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.connectionDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.connectionDB.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new OpenSPCoopStateException(e.getMessage(), e);
            }
        }
    }

    @Override
    public GenericMessage getMessageLib() {
        return this.messageLib;
    }

    public void setMessageLib(GenericMessage messageLib) {
        this.messageLib = messageLib;
    }

    @Override
    public String getIDMessaggioSessione() {
        return this.IDMessaggioSessione;
    }

    public void setIDMessaggioSessione(String idSessione) {
        this.IDMessaggioSessione = idSessione;
    }

    @Override
    public IState getStatoRichiesta() {
        return this.richiestaStato;
    }

    @Override
    public void setStatoRichiesta(IState statoRichiesta) {
        this.richiestaStato = (StateMessage)statoRichiesta;
    }

    @Override
    public IState getStatoRisposta() {
        return this.rispostaStato;
    }

    @Override
    public void setStatoRisposta(IState statoRisposta) {
        this.rispostaStato = (StateMessage)statoRisposta;
    }

    public Connection getConnectionDB() {
        return this.connectionDB;
    }

    public void setConnectionDB(Connection connectionDB) {
        this.connectionDB = connectionDB;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }
}

