/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.threshold;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.threshold.IThreshold;
import org.openspcoop2.pdd.core.threshold.ThresholdException;

public class MySQLThreshold
implements IThreshold {
    public static OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
    public static String ID_MODULO = "MySQLThreshold";
    private static final String Query = "SHOW TABLE STATUS LIKE 'MESSAGGI'";

    @Override
    public boolean check(Properties parametri) throws ThresholdException {
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        boolean result = false;
        Statement s = null;
        ResultSet rs = null;
        try {
            try {
                resource = dbManager.getResource(properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null);
            }
            catch (Exception e) {
                throw new Exception("Impossibile ottenere una Risorsa dal DBManager", e);
            }
            if (resource == null) {
                throw new Exception("Risorsa is null");
            }
            if (resource.getResource() == null) {
                throw new Exception("Connessione is null");
            }
            Connection connection = (Connection)resource.getResource();
            String valore = parametri.getProperty("valore");
            if (valore == null) {
                throw new ThresholdException("Parametro [" + valore + "] non presente");
            }
            long Threshold = Long.parseLong(valore = valore.trim());
            if (Threshold < 0L) {
                throw new Exception("Valore di soglia negativo");
            }
            s = connection.createStatement();
            if (!s.execute(Query)) {
                throw new Exception("Impossibile verficare lo spazio rimanente sul tablespace");
            }
            rs = s.getResultSet();
            if (rs == null) {
                throw new Exception("Nessun risultato disponibile per la verifica di soglia");
            }
            if (!rs.next()) {
                throw new Exception("Nessun risultato disponibile per la verifica di soglia");
            }
            String Comment2 = rs.getString("Comment");
            if (Comment2 == null) {
                throw new Exception("La quantita' di spazio disponibile sul DB e' NULL");
            }
            long FreeTableSpace = Long.parseLong(Comment2.substring(13, Comment2.length() - 3));
            result = FreeTableSpace > Threshold;
        }
        catch (Exception e) {
            throw new ThresholdException("MySQLThreshold error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException sQLException) {}
            rs = null;
            s = null;
            dbManager.releaseResource(properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, resource);
        }
        return result;
    }
}

