/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.json.JSONUtils;

public class DynamicDiscovery
extends BaseBean
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean valid;
    private String jwksUri;
    private String introspectionEndpoint;
    private String userinfoEndpoint;
    private Map<String, Serializable> claims = new HashMap<String, Serializable>();
    private String rawResponse;
    private TipologiaClaims type;
    private String httpResponseCode;
    private String errorDetails;

    public DynamicDiscovery() {
    }

    public DynamicDiscovery(Integer httpResponseCode, TipologiaClaims tipo, String rawResponse, IDynamicDiscoveryParser parser) throws UtilsException {
        JsonNode root;
        Map readClaims;
        this.rawResponse = rawResponse;
        this.type = tipo;
        JSONUtils jsonUtils = JSONUtils.getInstance();
        if (jsonUtils.isJson(this.rawResponse) && (readClaims = jsonUtils.convertToSimpleMap(root = jsonUtils.getAsNode(this.rawResponse))) != null && readClaims.size() > 0) {
            this.claims.putAll(readClaims);
        }
        parser.init(this.rawResponse, this.claims);
        if (httpResponseCode != null) {
            parser.checkHttpTransaction(httpResponseCode);
        }
        this.jwksUri = parser.getJwksUri();
        this.introspectionEndpoint = parser.getIntrospectionEndpoint();
        this.userinfoEndpoint = parser.getUserInfoEndpoint();
        this.valid = true;
    }

    public DynamicDiscovery(String errorDetails, Integer httpResponseCode, byte[] rawResponse, TipologiaClaims tipo) {
        this.valid = false;
        this.claims = null;
        this.type = tipo;
        if (httpResponseCode != null) {
            this.httpResponseCode = "" + httpResponseCode;
        }
        if (rawResponse != null) {
            this.rawResponse = new String(rawResponse);
        }
        this.errorDetails = errorDetails;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public Map<String, Serializable> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, Serializable> claims) {
        this.claims = claims;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public TipologiaClaims getType() {
        return this.type;
    }

    public void setType(TipologiaClaims type) {
        this.type = type;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public void setHttpResponseCode(String httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }
}

