/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.token.AbstractPolicyToken;
import org.openspcoop2.pdd.core.token.TipoTokenRequest;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.BasicDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.BasicTokenParser;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class PolicyGestioneToken
extends AbstractPolicyToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean tokenOpzionale;
    private boolean dynamicDiscovery;
    private boolean validazioneJWT;
    private boolean validazioneJWTWarningOnly;
    private boolean introspection;
    private boolean introspectionWarningOnly;
    private boolean userInfo;
    private boolean userInfoWarningOnly;
    private boolean forwardToken;

    public boolean isTokenOpzionale() {
        return this.tokenOpzionale;
    }

    public void setTokenOpzionale(boolean tokenOpzionale) {
        this.tokenOpzionale = tokenOpzionale;
    }

    public boolean isDynamicDiscovery() {
        return this.dynamicDiscovery;
    }

    public void setDynamicDiscovery(boolean dynamicDiscovery) {
        this.dynamicDiscovery = dynamicDiscovery;
    }

    public boolean isValidazioneJWT() {
        return this.validazioneJWT;
    }

    public void setValidazioneJWT(boolean validazioneJWT) {
        this.validazioneJWT = validazioneJWT;
    }

    public boolean isValidazioneJWTWarningOnly() {
        return this.validazioneJWTWarningOnly;
    }

    public void setValidazioneJWTWarningOnly(boolean validazioneJWTWarningOnly) {
        this.validazioneJWTWarningOnly = validazioneJWTWarningOnly;
    }

    public boolean isIntrospection() {
        return this.introspection;
    }

    public void setIntrospection(boolean introspection) {
        this.introspection = introspection;
    }

    public boolean isIntrospectionWarningOnly() {
        return this.introspectionWarningOnly;
    }

    public void setIntrospectionWarningOnly(boolean introspectionWarningOnly) {
        this.introspectionWarningOnly = introspectionWarningOnly;
    }

    public boolean isUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(boolean userInfo) {
        this.userInfo = userInfo;
    }

    public boolean isUserInfoWarningOnly() {
        return this.userInfoWarningOnly;
    }

    public void setUserInfoWarningOnly(boolean userInfoWarningOnly) {
        this.userInfoWarningOnly = userInfoWarningOnly;
    }

    public boolean isForwardToken() {
        return this.forwardToken;
    }

    public void setForwardToken(boolean forwardToken) {
        this.forwardToken = forwardToken;
    }

    public String getRealm() {
        String realm = this.defaultProperties.getProperty("policy.realm");
        if (realm == null) {
            realm = this.name;
        }
        return realm;
    }

    public boolean isMessageErrorGenerateEmptyMessage() {
        boolean genericError = true;
        String tmp = this.defaultProperties.getProperty("policy.messageError.bodyEmpty");
        if (tmp != null) {
            genericError = Boolean.valueOf(tmp);
        }
        return genericError;
    }

    public boolean isMessageErrorGenerateGenericMessage() {
        boolean genericError = true;
        String tmp = this.defaultProperties.getProperty("policy.messageError.genericMessage");
        if (tmp != null) {
            genericError = Boolean.valueOf(tmp);
        }
        return genericError;
    }

    public String getLabelAzioniGestioneToken() {
        StringBuilder bf = new StringBuilder();
        if (this.isValidazioneJWT() || this.isIntrospection() || this.isUserInfo()) {
            bf.append("Validazione ");
            boolean first = true;
            if (this.isValidazioneJWT()) {
                bf.append("JWT");
                first = false;
            }
            if (this.isIntrospection()) {
                if (!first) {
                    bf.append(",");
                }
                bf.append("Introspection");
                first = false;
            }
            if (this.isUserInfo()) {
                if (!first) {
                    bf.append(",");
                }
                bf.append("UserInfo");
            }
            return bf.toString();
        }
        return "Nessuna Validazione Attiva";
    }

    public String getAzioniGestioneToken() {
        StringBuilder bf = new StringBuilder();
        if (this.isValidazioneJWT() || this.isIntrospection() || this.isUserInfo()) {
            boolean first = true;
            if (this.isValidazioneJWT()) {
                bf.append("JWT");
                first = false;
            }
            if (this.isIntrospection()) {
                if (!first) {
                    bf.append(",");
                }
                bf.append("Introspection");
                first = false;
            }
            if (this.isUserInfo()) {
                if (!first) {
                    bf.append(",");
                }
                bf.append("UserInfo");
            }
            return bf.toString();
        }
        return "NessunaValidazione";
    }

    public String getTipoToken() {
        return this.defaultProperties.getProperty("policy.token.type");
    }

    public String getLabelTipoToken() {
        String tokenType = this.defaultProperties.getProperty("policy.token.type");
        if ("opaque".equals(tokenType)) {
            return "Opaco";
        }
        return tokenType.toUpperCase();
    }

    public String getTokenSource() {
        return this.defaultProperties.getProperty("policy.token.source");
    }

    public String getTokenSourceHeaderName() {
        return this.defaultProperties.getProperty("policy.token.source.header");
    }

    public String getTokenSourceUrlPropertyName() {
        return this.defaultProperties.getProperty("policy.token.source.queryParameter");
    }

    public String getLabelPosizioneToken() {
        String position = this.defaultProperties.getProperty("policy.token.source");
        if ("RFC6750".equals(position)) {
            return "RFC 6750 - Bearer Token Usage";
        }
        if ("RFC6750_header".equals(position)) {
            return "RFC 6750 - Bearer Token Usage (Authorization Request Header Field)\"";
        }
        if ("RFC6750_form".equals(position)) {
            return "RFC 6750 - Bearer Token Usage (Form-Encoded Body Parameter)";
        }
        if ("RFC6750_url".equals(position)) {
            return "RFC 6750 - Bearer Token Usage (URI Query Parameter)";
        }
        if ("CUSTOM_header".equals(position)) {
            return "Header HTTP 'TEMPLATE'".replace("TEMPLATE", this.defaultProperties.getProperty("policy.token.source.header"));
        }
        if ("CUSTOM_url".equals(position)) {
            return "Parametro URL 'TEMPLATE'".replace("TEMPLATE", this.defaultProperties.getProperty("policy.token.source.queryParameter"));
        }
        return "Sconosciuto";
    }

    public boolean isEndpointHttps() {
        return this.isEndpointHttps(true, true);
    }

    public boolean isEndpointHttps(boolean checkIntrospection, boolean checkUserInfo) {
        boolean enabled = TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.https.stato");
        if (!enabled && checkIntrospection && TokenUtilities.isEnabled(this.defaultProperties, "policy.introspection.endpoint.https.stato")) {
            enabled = true;
        }
        if (!enabled && checkUserInfo && TokenUtilities.isEnabled(this.defaultProperties, "policy.userInfo.endpoint.https.stato")) {
            enabled = true;
        }
        return enabled;
    }

    public String getDynamicDiscoveryEndpoint() {
        return this.defaultProperties.getProperty("policy.discovery.endpoint.url");
    }

    public TipologiaClaims getDynamicDiscoveryType() {
        return TipologiaClaims.valueOf(this.defaultProperties.getProperty("policy.discovery.claimsParser"));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IDynamicDiscoveryParser getDynamicDiscoveryParser() throws TokenException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        void var1_6;
        Object var1_1 = null;
        TipologiaClaims tipologiaClaims = TipologiaClaims.valueOf(this.defaultProperties.getProperty("policy.discovery.claimsParser"));
        if (TipologiaClaims.CUSTOM.equals((Object)tipologiaClaims)) {
            String className = this.defaultProperties.getProperty("policy.discovery.claimsParser.className");
            if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
                IDynamicDiscoveryParser iDynamicDiscoveryParser = (IDynamicDiscoveryParser)ClassLoaderUtilities.newInstance((String)className);
                return var1_6;
            } else {
                String tipo = this.defaultProperties.getProperty("policy.discovery.claimsParser.pluginType");
                if (tipo == null || !StringUtils.isNotEmpty((CharSequence)tipo) || "-".equals(tipo)) throw new TokenException("Deve essere selezionato un plugin per il parser dei claims della risposta del servizio 'Introspection'");
                try {
                    PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                    IDynamicDiscoveryParser iDynamicDiscoveryParser = pluginLoader.newDynamicDiscovery(tipo);
                    return var1_6;
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
        } else {
            BasicDynamicDiscoveryParser basicDynamicDiscoveryParser = new BasicDynamicDiscoveryParser(tipologiaClaims, TokenUtilities.getDynamicDiscoveryClaimsMappingProperties(this.properties));
        }
        return var1_6;
    }

    public boolean isValidazioneJWTLocationHttp() {
        String location = this.getValidazioneJWTLocation();
        return location != null && (location.startsWith("http") || location.startsWith("https"));
    }

    public String getValidazioneJWTLocation() {
        Properties p;
        if (this.properties != null && (p = (Properties)this.properties.get("signatureVerificationPropRefId")) != null) {
            return p.getProperty("rs.security.keystore.file");
        }
        return null;
    }

    public boolean isValidazioneJWTSaveErrorInCache() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.validazioneJWT.saveErrorInCache");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITokenParser getValidazioneJWTTokenParser() throws TokenException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        void var1_6;
        Object var1_1 = null;
        TipologiaClaims tipologiaClaims = TipologiaClaims.valueOf(this.defaultProperties.getProperty("policy.validazioneJWT.claimsParser"));
        if (TipologiaClaims.CUSTOM.equals((Object)tipologiaClaims)) {
            String className = this.defaultProperties.getProperty("policy.validazioneJWT.claimsParser.className");
            if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
                ITokenParser iTokenParser = (ITokenParser)ClassLoaderUtilities.newInstance((String)className);
                return var1_6;
            } else {
                String tipo = this.defaultProperties.getProperty("policy.validazioneJWT.claimsParser.pluginType");
                if (tipo == null || !StringUtils.isNotEmpty((CharSequence)tipo) || "-".equals(tipo)) throw new TokenException("Deve essere selezionato un plugin per il parser del token JWT");
                try {
                    PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                    ITokenParser iTokenParser = pluginLoader.newTokenValidazione(tipo);
                    return var1_6;
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
        } else {
            BasicTokenParser basicTokenParser = new BasicTokenParser(tipologiaClaims, TokenUtilities.getValidazioneJwtClaimsMappingProperties(this.properties));
        }
        return var1_6;
    }

    public String getValidazioneJWTOcspPolicy() {
        return this.defaultProperties.getProperty("signatureOCSP");
    }

    public String getValidazioneJWTCrl() {
        return this.defaultProperties.getProperty("signatureCRL");
    }

    public boolean isValidazioneJWTHeader() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.validazioneJWT.header");
    }

    public List<String> getValidazioneJWTHeaderTyp() {
        return TokenUtilities.getClaims(this.defaultProperties, "policy.validazioneJWT.header.typ");
    }

    public List<String> getValidazioneJWTHeaderCty() {
        return TokenUtilities.getClaims(this.defaultProperties, "policy.validazioneJWT.header.cty");
    }

    public List<String> getValidazioneJWTHeaderAlg() {
        return TokenUtilities.getClaims(this.defaultProperties, "policy.validazioneJWT.header.alg");
    }

    public String getIntrospectionEndpoint() {
        return this.defaultProperties.getProperty("policy.introspection.endpoint.url");
    }

    public boolean isIntrospectionSaveErrorInCache() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.introspection.saveErrorInCache");
    }

    public HttpRequestMethod getIntrospectionHttpMethod() {
        return HttpRequestMethod.valueOf((String)this.defaultProperties.getProperty("policy.introspection.httpMethod"));
    }

    public TipoTokenRequest getIntrospectionTipoTokenRequest() {
        return TipoTokenRequest.valueOf(this.defaultProperties.getProperty("policy.introspection.requestTokenPosition"));
    }

    public String getIntrospectionTipoTokenRequestHeaderName() {
        return this.defaultProperties.getProperty("policy.introspection.requestTokenPosition.header");
    }

    public String getIntrospectionTipoTokenRequestUrlPropertyName() {
        return this.defaultProperties.getProperty("policy.introspection.requestTokenPosition.queryParameter");
    }

    public String getIntrospectionTipoTokenRequestFormPropertyName() {
        return this.defaultProperties.getProperty("policy.introspection.requestTokenPosition.formParameter");
    }

    public String getIntrospectionContentType() {
        return this.defaultProperties.getProperty("policy.introspection.contentType");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITokenParser getIntrospectionTokenParser() throws TokenException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        void var1_6;
        Object var1_1 = null;
        TipologiaClaims tipologiaClaims = TipologiaClaims.valueOf(this.defaultProperties.getProperty("policy.introspection.claimsParser"));
        if (TipologiaClaims.CUSTOM.equals((Object)tipologiaClaims)) {
            String className = this.defaultProperties.getProperty("policy.introspection.claimsParser.className");
            if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
                ITokenParser iTokenParser = (ITokenParser)ClassLoaderUtilities.newInstance((String)className);
                return var1_6;
            } else {
                String tipo = this.defaultProperties.getProperty("policy.introspection.claimsParser.pluginType");
                if (tipo == null || !StringUtils.isNotEmpty((CharSequence)tipo) || "-".equals(tipo)) throw new TokenException("Deve essere selezionato un plugin per il parser dei claims della risposta del servizio 'Introspection'");
                try {
                    PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                    ITokenParser iTokenParser = pluginLoader.newTokenValidazione(tipo);
                    return var1_6;
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
        } else {
            BasicTokenParser basicTokenParser = new BasicTokenParser(tipologiaClaims, TokenUtilities.getIntrospectionClaimsMappingProperties(this.properties));
        }
        return var1_6;
    }

    public boolean isIntrospectionBasicAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.introspection.endpoint.basic.stato");
    }

    public String getIntrospectionBasicAuthenticationUsername() {
        return this.defaultProperties.getProperty("policy.introspection.endpoint.basic.username");
    }

    public String getIntrospectionBasicAuthenticationPassword() {
        return this.defaultProperties.getProperty("policy.introspection.endpoint.basic.password");
    }

    public boolean isIntrospectionBearerAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.introspection.endpoint.bearer.stato");
    }

    public String getIntrospectionBeareAuthenticationToken() {
        return this.defaultProperties.getProperty("policy.introspection.endpoint.bearer.token");
    }

    public boolean isIntrospectionHttpsAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.introspection.endpoint.https.stato");
    }

    public String getUserInfoEndpoint() {
        return this.defaultProperties.getProperty("policy.userInfo.endpoint.url");
    }

    public boolean isUserInfoSaveErrorInCache() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.userInfo.saveErrorInCache");
    }

    public HttpRequestMethod getUserInfoHttpMethod() {
        return HttpRequestMethod.valueOf((String)this.defaultProperties.getProperty("policy.userInfo.httpMethod"));
    }

    public TipoTokenRequest getUserInfoTipoTokenRequest() {
        return TipoTokenRequest.valueOf(this.defaultProperties.getProperty("policy.userInfo.requestTokenPosition"));
    }

    public String getUserInfoTipoTokenRequestHeaderName() {
        return this.defaultProperties.getProperty("policy.userInfo.requestTokenPosition.header");
    }

    public String getUserInfoTipoTokenRequestUrlPropertyName() {
        return this.defaultProperties.getProperty("policy.userInfo.requestTokenPosition.queryParameter");
    }

    public String getUserInfoTipoTokenRequestFormPropertyName() {
        return this.defaultProperties.getProperty("policy.userInfo.requestTokenPosition.formParameter");
    }

    public String getUserInfoContentType() {
        return this.defaultProperties.getProperty("policy.userInfo.contentType");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITokenParser getUserInfoTokenParser() throws TokenException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        void var1_6;
        Object var1_1 = null;
        TipologiaClaims tipologiaClaims = TipologiaClaims.valueOf(this.defaultProperties.getProperty("policy.userInfo.claimsParser"));
        if (TipologiaClaims.CUSTOM.equals((Object)tipologiaClaims)) {
            String className = this.defaultProperties.getProperty("policy.userInfo.claimsParser.className");
            if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
                ITokenParser iTokenParser = (ITokenParser)ClassLoaderUtilities.newInstance((String)className);
                return var1_6;
            } else {
                String tipo = this.defaultProperties.getProperty("policy.userInfo.claimsParser.pluginType");
                if (tipo == null || !StringUtils.isNotEmpty((CharSequence)tipo) || "-".equals(tipo)) throw new TokenException("Deve essere selezionato un plugin per il parser dei claims della risposta del servizio 'UserInfo'");
                try {
                    PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                    ITokenParser iTokenParser = pluginLoader.newTokenValidazione(tipo);
                    return var1_6;
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            }
        } else {
            BasicTokenParser basicTokenParser = new BasicTokenParser(tipologiaClaims, TokenUtilities.getUserInfoClaimsMappingProperties(this.properties));
        }
        return var1_6;
    }

    public boolean isUserInfoBasicAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.userInfo.endpoint.basic.stato");
    }

    public String getUserInfoBasicAuthenticationUsername() {
        return this.defaultProperties.getProperty("policy.userInfo.endpoint.basic.username");
    }

    public String getUserInfoBasicAuthenticationPassword() {
        return this.defaultProperties.getProperty("policy.userInfo.endpoint.basic.password");
    }

    public boolean isUserInfoBearerAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.userInfo.endpoint.bearer.stato");
    }

    public String getUserInfoBeareAuthenticationToken() {
        return this.defaultProperties.getProperty("policy.userInfo.endpoint.bearer.token");
    }

    public boolean isUserInfoHttpsAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.userInfo.endpoint.https.stato");
    }

    public boolean isForwardTokenTrasparente() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.trasparente.stato");
    }

    public String getForwardTokenTrasparenteMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.trasparente.mode");
    }

    public String getForwardTokenTrasparenteModeCustomHeader() {
        return this.defaultProperties.getProperty("policy.tokenForward.trasparente.mode.header");
    }

    public String getForwardTokenTrasparenteModeCustomUrl() {
        return this.defaultProperties.getProperty("policy.tokenForward.trasparente.mode.queryParameter");
    }

    public boolean isForwardTokenInformazioniRaccolte() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.infoRaccolte.stato");
    }

    public String getForwardTokenInformazioniRaccolteMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.mode");
    }

    public boolean isForwardTokenInformazioniRaccolteEncodeBase64() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.infoRaccolte.base64");
    }

    public boolean isForwardTokenInformazioniRaccolteValidazioneJWT() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.infoRaccolte.validazioneJWT");
    }

    public String getForwardTokenInformazioniRaccolteValidazioneJWTMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode");
    }

    public String getForwardTokenInformazioniRaccolteValidazioneJWTModeHeaderName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode.header");
    }

    public String getForwardTokenInformazioniRaccolteValidazioneJWTModeQueryParameterName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.validazioneJWT.mode.queryParameter");
    }

    public boolean isForwardTokenInformazioniRaccolteIntrospection() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.infoRaccolte.introspection");
    }

    public String getForwardTokenInformazioniRaccolteIntrospectionMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.introspection.mode");
    }

    public String getForwardTokenInformazioniRaccolteIntrospectionModeHeaderName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.introspection.mode.header");
    }

    public String getForwardTokenInformazioniRaccolteIntrospectionModeQueryParameterName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.introspection.mode.queryParameter");
    }

    public boolean isForwardTokenInformazioniRaccolteUserInfo() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.tokenForward.infoRaccolte.userInfo");
    }

    public String getForwardTokenInformazioniRaccolteUserInfoMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode");
    }

    public String getForwardTokenInformazioniRaccolteUserInfoModeHeaderName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode.header");
    }

    public String getForwardTokenInformazioniRaccolteUserInfoModeQueryParameterName() {
        return this.defaultProperties.getProperty("policy.tokenForward.infoRaccolte.userInfo.mode.queryParameter");
    }

    public String getAzioniForwardToken() {
        StringBuilder bf = new StringBuilder();
        if (this.isForwardToken()) {
            String mode;
            boolean first = true;
            if (this.isForwardTokenTrasparente()) {
                mode = this.getForwardTokenTrasparenteMode();
                this.addPolicyTokenForwardTrasparente(mode, bf);
                first = false;
            }
            if (this.isForwardTokenInformazioniRaccolte()) {
                if (!first) {
                    bf.append(",");
                }
                mode = this.getForwardTokenInformazioniRaccolteMode();
                this.addPolicyTokenForwardInfoRaccolte(mode, bf);
            }
            return bf.toString();
        }
        return "Disabilitato";
    }

    private void addPolicyTokenForwardTrasparente(String mode, StringBuilder bf) {
        if ("asReceived".equals(mode)) {
            bf.append("Token Originale");
        } else if ("RFC6750_header".equals(mode)) {
            bf.append("Header HTTP 'Authorization Bearer'");
        } else if ("RFC6750_url".equals(mode)) {
            bf.append("Parametro URL 'access_token'");
        } else if ("CUSTOM_header".equals(mode)) {
            bf.append(MessageFormat.format("Header HTTP ''{0}''", this.getForwardTokenTrasparenteModeCustomHeader()));
        } else if ("CUSTOM_url".equals(mode)) {
            bf.append(MessageFormat.format("Parametro URL ''{0}''", this.getForwardTokenTrasparenteModeCustomUrl()));
        } else {
            bf.append("Originale '" + mode + "'");
        }
    }

    private void addPolicyTokenForwardInfoRaccolte(String mode, StringBuilder bf) {
        if ("op2header".equals(mode)) {
            bf.append("GovWay Headers");
        } else if ("op2json".equals(mode)) {
            bf.append("GovWay JSON");
        } else if ("op2jws".equals(mode)) {
            bf.append("GovWay JWS");
        } else if ("jws".equals(mode)) {
            bf.append("JWS");
        } else if ("jwe".equals(mode)) {
            bf.append("JWE");
        } else if ("json".equals(mode)) {
            bf.append("JSON");
        } else {
            bf.append(mode);
        }
    }
}

