/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.attribute_authority;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;

public class AttributeAuthorityUtilities {
    private AttributeAuthorityUtilities() {
    }

    public static KeystoreParams getRequestJwsKeystoreParams(GenericProperties gp) throws TokenException {
        PolicyAttributeAuthority policy = AttributeAuthorityUtilities.convertTo(gp);
        return AttributeAuthorityUtilities.getRequestJwsKeystoreParams(policy);
    }

    public static KeystoreParams getRequestJwsKeystoreParams(PolicyAttributeAuthority policy) throws TokenException {
        String keyAlias;
        if (!policy.isRequestJws()) {
            throw new TokenException("La configurazione nell'AttributeAuthority " + policy.getName() + " non definisce il tipo di richiesta come JWS");
        }
        String keystoreType = policy.getRequestJwtSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("JWS Signature keystore type undefined");
        }
        String keystoreFile = policy.getRequestJwtSignKeystoreFile();
        if (keystoreFile == null) {
            throw new TokenException("JWS Signature keystore file undefined");
        }
        String keystorePassword = policy.getRequestJwtSignKeystorePassword();
        if (!(keystorePassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("JWS Signature keystore password undefined");
            }
        }
        if ((keyAlias = policy.getRequestJwtSignKeyAlias()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("JWS Signature key alias undefined");
        }
        String keyPassword = policy.getRequestJwtSignKeyPassword();
        if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("JWS Signature key password undefined");
            }
        }
        String keystoreByokPolicy = policy.getRequestJwtSignKeystoreByokPolicy();
        KeystoreParams keystoreParams = new KeystoreParams();
        keystoreParams.setPath(keystoreFile);
        keystoreParams.setType(keystoreType);
        keystoreParams.setPassword(keystorePassword);
        keystoreParams.setKeyAlias(keyAlias);
        keystoreParams.setKeyPassword(keyPassword);
        keystoreParams.setByokPolicy(keystoreByokPolicy);
        AttributeAuthorityUtilities.fillKeyPairParamters(keystoreParams, keystoreType, policy);
        return keystoreParams;
    }

    private static void fillKeyPairParamters(KeystoreParams keystoreParams, String keystoreType, PolicyAttributeAuthority policy) throws TokenException {
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            String keystorePublicKeyFile = policy.getRequestJwtSignKeystoreFilePublicKey();
            if (keystorePublicKeyFile == null) {
                throw new TokenException("JWT Signature public key file undefined");
            }
            keystoreParams.setKeyPairPublicKeyPath(keystorePublicKeyFile);
        }
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            String keyPairAlgorithm = policy.getRequestJwtSignKeystoreFileAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("JWT Signature key pair algorithm undefined");
            }
            keystoreParams.setKeyPairAlgorithm(keyPairAlgorithm);
        }
    }

    public static KeystoreParams getResponseJwsKeystoreParams(GenericProperties gp) throws TokenException {
        PolicyAttributeAuthority policy = AttributeAuthorityUtilities.convertTo(gp);
        return AttributeAuthorityUtilities.getResponseJwsKeystoreParams(policy);
    }

    public static KeystoreParams getResponseJwsKeystoreParams(PolicyAttributeAuthority policy) throws TokenException {
        if (!policy.isResponseJws()) {
            throw new TokenException("La configurazione nell'AttributeAuthority " + policy.getName() + " non definisce il tipo di risposta come JWS");
        }
        Properties p = policy.getProperties().get("signatureVerifyPropRefId");
        if (p != null && p.containsKey("rs.security.keystore.file")) {
            KeystoreParams keystoreParams = new KeystoreParams();
            keystoreParams.setPath(p.getProperty("rs.security.keystore.file"));
            String type = p.getProperty("rs.security.keystore.type");
            if (type == null) {
                type = KeystoreType.JKS.getNome();
            }
            keystoreParams.setType(type);
            keystoreParams.setPassword(p.getProperty("rs.security.keystore.password"));
            keystoreParams.setKeyAlias(p.getProperty("rs.security.keystore.alias"));
            keystoreParams.setKeyPassword(p.getProperty("rs.security.key.password"));
            AttributeAuthorityUtilities.fillKeyPairParamters(keystoreParams, type, p);
            return keystoreParams;
        }
        return null;
    }

    private static void fillKeyPairParamters(KeystoreParams keystoreParams, String type, Properties p) throws TokenException {
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type)) {
            String keystorePublicKeyFile = p.getProperty("rs.security.keystore.file.public");
            if (keystorePublicKeyFile == null) {
                throw new TokenException("Public key file undefined");
            }
            keystoreParams.setKeyPairPublicKeyPath(keystorePublicKeyFile);
        }
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(type)) {
            String keyPairAlgorithm = p.getProperty("rs.security.keystore.file.algorithm");
            if (keyPairAlgorithm == null) {
                throw new TokenException("Key pair algorithm undefined");
            }
            keystoreParams.setKeyPairAlgorithm(keyPairAlgorithm);
        }
    }

    public static PolicyAttributeAuthority convertTo(GenericProperties gp) throws TokenException {
        PolicyAttributeAuthority policy = new PolicyAttributeAuthority();
        policy.setName(gp.getNome());
        policy.setDescrizione(gp.getDescrizione());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property pConfig : gp.getPropertyList()) {
            properties.put(pConfig.getNome(), pConfig.getValore());
        }
        try {
            Map multiProperties = DBPropertiesUtils.toMultiMap(properties);
            policy.setProperties(multiProperties);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
        return policy;
    }
}

