/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.attribute_authority;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.pdd.core.token.attribute_authority.TipologiaResponseAttributeAuthority;
import org.openspcoop2.pdd.core.token.parser.TokenUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.json.JSONUtils;
import org.slf4j.Logger;

public class BasicRetrieveAttributeAuthorityResponseParser
implements IRetrieveAttributeAuthorityResponseParser {
    protected Integer httpResponseCode;
    protected String raw;
    protected Map<String, Serializable> claims;
    protected TipologiaResponseAttributeAuthority parser;
    protected Date now;
    protected List<String> attributesClaims;
    protected String attributeAuthority;
    protected Logger log;

    public BasicRetrieveAttributeAuthorityResponseParser(String attributeAuthority, Logger log, TipologiaResponseAttributeAuthority parser, List<String> attributesClaims) {
        this.attributeAuthority = attributeAuthority;
        this.log = log;
        this.parser = parser;
        this.attributesClaims = attributesClaims;
    }

    @Override
    public void init(String raw, Map<String, Serializable> claims) {
        this.raw = raw;
        this.claims = claims;
        this.now = DateManager.getDate();
    }

    @Override
    public void init(byte[] content) {
        throw new UtilsRuntimeException("unsupported");
    }

    @Override
    public String getContentAsString() {
        throw new UtilsRuntimeException("unsupported");
    }

    @Override
    public void checkHttpTransaction(Integer httpResponseCode) throws UtilsException {
        this.httpResponseCode = httpResponseCode;
        switch (this.parser) {
            case jws: 
            case json: 
            case custom: {
                if (this.httpResponseCode == null || this.httpResponseCode >= 200 && this.httpResponseCode <= 299) break;
                String msgError = "Connessione terminata con errore (codice trasporto: " + this.httpResponseCode + ")";
                throw new UtilsException(msgError + ": " + this.raw);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.claims == null || this.claims.size() <= 0) {
            return false;
        }
        switch (this.parser) {
            case jws: 
            case json: 
            case custom: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        Map attributes = null;
        if (TipologiaResponseAttributeAuthority.custom.equals((Object)this.parser)) {
            return attributes;
        }
        if (TipologiaResponseAttributeAuthority.json.equals((Object)this.parser) && (this.attributesClaims == null || this.attributesClaims.isEmpty())) {
            return this.claims;
        }
        if (TipologiaResponseAttributeAuthority.jws.equals((Object)this.parser) && (this.attributesClaims == null || this.attributesClaims.isEmpty())) {
            return attributes;
        }
        JSONUtils jsonUtils = JSONUtils.getInstance();
        attributes = jsonUtils.convertToMap(this.log, "Attribute Authority: " + this.attributeAuthority, this.raw, this.attributesClaims);
        return attributes;
    }

    @Override
    public String getIssuer() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iss");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        return tmp;
    }

    @Override
    public String getSubject() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "sub");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        return tmp;
    }

    @Override
    public List<String> getAudience() {
        List<String> lNull = null;
        switch (this.parser) {
            case jws: {
                return TokenUtilities.getClaimAsList(this.claims, "aud");
            }
        }
        return lNull;
    }

    @Override
    public Date getExpired() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "exp");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public Date getIssuedAt() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iat");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public Date getNotToBeUsedBefore() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "nbf");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        String tmp = null;
        switch (this.parser) {
            case jws: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "jti");
                break;
            }
            case json: 
            case custom: {
                return null;
            }
        }
        return tmp;
    }
}

