/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.pa;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.token.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.token.EsitoDynamicDiscovery;
import org.openspcoop2.pdd.core.token.EsitoGestioneToken;
import org.openspcoop2.pdd.core.token.EsitoPresenzaToken;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoDynamicDiscoveryPortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoGestioneTokenPortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoPresenzaTokenPortaApplicativa;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.slf4j.Logger;

public class GestioneToken {
    private Logger log;
    private String idTransazione;
    private PdDContext pddContext;
    private IProtocolFactory<?> protocolFactory;

    public GestioneToken(Logger log, String idTransazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) {
        this.log = log;
        this.idTransazione = idTransazione;
        this.pddContext = pddContext;
        this.protocolFactory = protocolFactory;
    }

    public EsitoPresenzaTokenPortaApplicativa verificaPresenzaToken(DatiInvocazionePortaApplicativa datiInvocazione) {
        EsitoPresenzaTokenPortaApplicativa esito = (EsitoPresenzaTokenPortaApplicativa)GestoreToken.verificaPosizioneToken(datiInvocazione, false);
        if (esito.getEccezioneProcessamento() != null) {
            esito.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
        } else if (!esito.isPresente() && esito.getErrorMessage() == null) {
            esito.setErroreCooperazione(ErroriCooperazione.TOKEN_NON_PRESENTE.getErroreCooperazione());
        }
        return esito;
    }

    public EsitoDynamicDiscoveryPortaApplicativa dynamicDiscovery(Busta busta, DatiInvocazionePortaApplicativa datiInvocazione, EsitoPresenzaToken token) throws TokenException {
        try {
            EsitoDynamicDiscoveryPortaApplicativa esito = (EsitoDynamicDiscoveryPortaApplicativa)GestoreToken.dynamicDiscovery(this.log, datiInvocazione, this.pddContext, this.protocolFactory, token, false, busta, this.getDominio(datiInvocazione), this.getServizio(datiInvocazione));
            if (esito.getEccezioneProcessamento() != null) {
                esito.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            } else if (!esito.isValido() && esito.getErrorMessage() == null) {
                esito.setErroreCooperazione(ErroriCooperazione.TOKEN_NON_VALIDO.getErroreCooperazione());
            }
            return esito;
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    public EsitoGestioneTokenPortaApplicativa validazioneJWTToken(Busta busta, DatiInvocazionePortaApplicativa datiInvocazione, EsitoPresenzaToken token, EsitoDynamicDiscovery esitoDynamicDiscovery) throws TokenException {
        try {
            EsitoGestioneTokenPortaApplicativa esito = (EsitoGestioneTokenPortaApplicativa)GestoreToken.validazioneJWTToken(this.log, datiInvocazione, this.pddContext, this.protocolFactory, token, esitoDynamicDiscovery, false, busta, this.getDominio(datiInvocazione), this.getServizio(datiInvocazione));
            if (esito.getEccezioneProcessamento() != null) {
                esito.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            } else if (!esito.isValido() && esito.getErrorMessage() == null) {
                esito.setErroreCooperazione(ErroriCooperazione.TOKEN_NON_VALIDO.getErroreCooperazione());
            }
            return esito;
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    public EsitoGestioneTokenPortaApplicativa introspectionToken(Busta busta, DatiInvocazionePortaApplicativa datiInvocazione, EsitoPresenzaToken token, EsitoDynamicDiscovery esitoDynamicDiscovery) throws TokenException {
        try {
            EsitoGestioneTokenPortaApplicativa esito = (EsitoGestioneTokenPortaApplicativa)GestoreToken.introspectionToken(this.log, datiInvocazione, this.pddContext, this.protocolFactory, token, esitoDynamicDiscovery, false, busta, this.getDominio(datiInvocazione), this.getServizio(datiInvocazione));
            if (esito.getEccezioneProcessamento() != null) {
                esito.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            } else if (!esito.isValido() && esito.getErrorMessage() == null) {
                esito.setErroreCooperazione(ErroriCooperazione.TOKEN_NON_VALIDO.getErroreCooperazione());
            }
            return esito;
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    public EsitoGestioneTokenPortaApplicativa userInfoToken(Busta busta, DatiInvocazionePortaApplicativa datiInvocazione, EsitoPresenzaToken token, EsitoDynamicDiscovery esitoDynamicDiscovery) throws TokenException {
        try {
            EsitoGestioneTokenPortaApplicativa esito = (EsitoGestioneTokenPortaApplicativa)GestoreToken.userInfoToken(this.log, datiInvocazione, this.pddContext, this.protocolFactory, token, esitoDynamicDiscovery, false, busta, this.getDominio(datiInvocazione), this.getServizio(datiInvocazione));
            if (esito.getEccezioneProcessamento() != null) {
                esito.setErroreCooperazione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            } else if (!esito.isValido() && esito.getErrorMessage() == null) {
                esito.setErroreCooperazione(ErroriCooperazione.TOKEN_NON_VALIDO.getErroreCooperazione());
            }
            return esito;
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    public void forwardToken(AbstractDatiInvocazione datiInvocazione, EsitoPresenzaTokenPortaApplicativa esitoPresenzaToken, EsitoGestioneToken esitoValidazioneJWT, EsitoGestioneToken esitoIntrospection, EsitoGestioneToken esitoUserInfo, InformazioniToken informazioniTokenNormalizzate, Busta busta) throws TokenException {
        try {
            GestoreToken.forwardToken(this.log, this.idTransazione, datiInvocazione, esitoPresenzaToken, esitoValidazioneJWT, esitoIntrospection, esitoUserInfo, informazioniTokenNormalizzate, false, this.pddContext, busta);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    private IDSoggetto getDominio(DatiInvocazionePortaApplicativa datiInvocazione) {
        IDSoggetto soggetto = null;
        if (datiInvocazione.getPa() != null) {
            soggetto = new IDSoggetto(datiInvocazione.getPa().getTipoSoggettoProprietario(), datiInvocazione.getPa().getNomeSoggettoProprietario());
        } else if (datiInvocazione.getPd() != null) {
            soggetto = new IDSoggetto(datiInvocazione.getPd().getTipoSoggettoProprietario(), datiInvocazione.getPd().getNomeSoggettoProprietario());
        }
        return soggetto;
    }

    private IDServizio getServizio(DatiInvocazionePortaApplicativa datiInvocazione) throws DriverRegistroServiziException {
        IDServizio servizio = null;
        if (datiInvocazione.getPa() != null) {
            servizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiInvocazione.getPa().getServizio().getTipo(), datiInvocazione.getPa().getServizio().getNome(), datiInvocazione.getPa().getTipoSoggettoProprietario(), datiInvocazione.getPa().getNomeSoggettoProprietario(), datiInvocazione.getPa().getServizio().getVersione().intValue());
        } else if (datiInvocazione.getPd() != null) {
            servizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiInvocazione.getPd().getServizio().getTipo(), datiInvocazione.getPd().getServizio().getNome(), datiInvocazione.getPd().getSoggettoErogatore().getTipo(), datiInvocazione.getPd().getSoggettoErogatore().getNome(), datiInvocazione.getPd().getServizio().getVersione().intValue());
        }
        return servizio;
    }
}

