/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.IDynamicDiscoveryParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.utils.UtilsException;

public class BasicDynamicDiscoveryParser
implements IDynamicDiscoveryParser {
    protected Integer httpResponseCode;
    protected String raw;
    protected Map<String, Serializable> claims;
    protected TipologiaClaims parser;
    protected Properties parserConfig;

    public BasicDynamicDiscoveryParser(TipologiaClaims parser) {
        this(parser, null);
    }

    public BasicDynamicDiscoveryParser(TipologiaClaims parser, Properties parserConfig) {
        this.parser = parser;
        this.parserConfig = parserConfig;
    }

    @Override
    public void init(String raw, Map<String, Serializable> claims) {
        this.raw = raw;
        this.claims = claims;
    }

    private void throwUnsupportedParser() throws UtilsException {
        String msgError = "Tipo di parser '" + String.valueOf((Object)this.parser) + "' non supportato";
        throw new UtilsException(msgError);
    }

    @Override
    public void checkHttpTransaction(Integer httpResponseCode) throws UtilsException {
        this.httpResponseCode = httpResponseCode;
        switch (this.parser) {
            case OIDC_ID_TOKEN: 
            case MAPPING: 
            case CUSTOM: {
                if (this.httpResponseCode == null || this.httpResponseCode >= 200 && this.httpResponseCode <= 299) break;
                String msgError = "Connessione terminata con errore (codice trasporto: " + this.httpResponseCode + ")";
                throw new UtilsException(msgError + ": " + this.raw);
            }
            default: {
                this.throwUnsupportedParser();
            }
        }
    }

    @Override
    public String getJwksUri() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "jwks_uri");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "policy.discovery.jwk");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getIntrospectionEndpoint() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "introspection_endpoint");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "policy.discovery.introspection");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getUserInfoEndpoint() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "userinfo_endpoint");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "policy.discovery.userInfo");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }
}

