/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser.test;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Properties;
import org.openspcoop2.pdd.core.token.InformazioniJWTClientAssertion;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken_DatiRichiesta;
import org.openspcoop2.pdd.core.token.parser.BasicNegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaimsNegoziazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.slf4j.Logger;

public class BasicNegoziazioneTokenParserTest {
    public static void main(String[] args) throws Exception {
        BasicNegoziazioneTokenParserTest.test();
    }

    public static void test() throws Exception {
        InformazioniNegoziazioneToken info;
        BasicNegoziazioneTokenParser tokenParser;
        Logger log = LoggerWrapperFactory.getLogger(BasicNegoziazioneTokenParserTest.class);
        String idTransazione = "66aa1676-1f9e-34e2-7777-0cfca111a9999";
        InformazioniNegoziazioneToken_DatiRichiesta datiRichiesta = null;
        DecimalFormat decimalFormat9 = new DecimalFormat("0.#########E0");
        System.out.println("Test BasicNegoziazioneTokenParser, access token regolare ...");
        String accessToken = "33aa1676-1f9e-34e2-8515-0cfca111a188";
        String refreshToken = "33ref1676-1f9e-34e2-8515-0cfca111a188";
        String tokenType = "Bearer";
        String rawResponse = "{\"access_token\":\"" + accessToken + "\",\"refresh_token\":\"" + refreshToken + "\",\"scope\":\"s1 s2\",\"token_type\":\"" + tokenType + "\",\"expires_in\":3700,\"refresh_expires_in\":4000}";
        BasicNegoziazioneTokenParser tokenParser2 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.OAUTH2_RFC_6749);
        InformazioniNegoziazioneToken info2 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse, tokenParser2);
        if (info2.getClaims() == null || info2.getClaims().isEmpty()) {
            throw new Exception("Parse non riuscito?");
        }
        if (info2.getClaims().size() != 6) {
            throw new Exception("Claims attesi 6, trovati '" + info2.getClaims().size() + "'");
        }
        if (!info2.getClaims().containsKey("access_token")) {
            throw new Exception("Atteso access_token non presente tra i claims");
        }
        if (!info2.getClaims().containsKey("refresh_token")) {
            throw new Exception("Atteso refresh_token non presente tra i claims");
        }
        if (!info2.getClaims().containsKey("scope")) {
            throw new Exception("Atteso scope non presente tra i claims");
        }
        if (!info2.getClaims().containsKey("token_type")) {
            throw new Exception("Atteso token_type non presente tra i claims");
        }
        if (!info2.getClaims().containsKey("expires_in")) {
            throw new Exception("Atteso expires_in non presente tra i claims");
        }
        if (!info2.getClaims().containsKey("refresh_expires_in")) {
            throw new Exception("Atteso refresh_expires_in non presente tra i claims");
        }
        if (!accessToken.equals(info2.getAccessToken())) {
            throw new Exception("Atteso access_token '" + accessToken + "' trovato '" + info2.getAccessToken() + "'");
        }
        if (!refreshToken.equals(info2.getRefreshToken())) {
            throw new Exception("Atteso refresh_token '" + refreshToken + "' trovato '" + info2.getRefreshToken() + "'");
        }
        if (info2.getScopes() == null) {
            throw new Exception("Scope attesi non trovato");
        }
        if (info2.getScopes().size() != 2) {
            throw new Exception("Scope attesi 2, trovati '" + info2.getScopes().size() + "'");
        }
        boolean find = false;
        for (String s : info2.getScopes()) {
            if (!"s1".equals(s)) continue;
            find = true;
            break;
        }
        if (!find) {
            throw new Exception("Scope atteso 's1' non trovato");
        }
        find = false;
        for (String s : info2.getScopes()) {
            if (!"s2".equals(s)) continue;
            find = true;
            break;
        }
        if (!find) {
            throw new Exception("Scope atteso 's2' non trovato");
        }
        if (!tokenType.equals(info2.getTokenType())) {
            throw new Exception("Atteso token_type '" + tokenType + "' trovato '" + info2.getTokenType() + "'");
        }
        Date d = info2.getExpiresIn();
        if (d == null) {
            throw new Exception("Data di scadenza non trovata");
        }
        Date now = DateManager.getDate();
        if (!now.before(d)) {
            throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
            throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        if ((now = new Date(now.getTime() + 0x6DDD00L)).before(d)) {
            throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        d = info2.getRefreshExpiresIn();
        if (d == null) {
            throw new Exception("Data di scadenza non trovata");
        }
        now = DateManager.getDate();
        if (!now.before(d)) {
            throw new Exception("(1) RefreshToken scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
            throw new Exception("(2) RefreshToken scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        if ((now = new Date(now.getTime() + 0x6DDD00L)).before(d)) {
            throw new Exception("(3) Atteso refresh token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
        }
        System.out.println("Test BasicNegoziazioneTokenParser, access token regolare ok");
        System.out.println("Test BasicNegoziazioneTokenParser, access token senza alcuni campi ...");
        accessToken = "33aa1676-1f9e-34e2-8515-0cfca111a188";
        String tokenType2 = "Bearer";
        String rawResponse2 = "{\"access_token\":\"" + accessToken + "\",\"token_type\":\"" + tokenType2 + "\"}";
        BasicNegoziazioneTokenParser tokenParser3 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.OAUTH2_RFC_6749);
        InformazioniNegoziazioneToken info3 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse2, tokenParser3);
        if (info3.getClaims() == null || info3.getClaims().isEmpty()) {
            throw new Exception("Parse non riuscito?");
        }
        if (info3.getClaims().size() != 2) {
            throw new Exception("Claims attesi 2, trovati '" + info3.getClaims().size() + "'");
        }
        if (!info3.getClaims().containsKey("access_token")) {
            throw new Exception("Atteso access_token non presente tra i claims");
        }
        if (info3.getClaims().containsKey("refresh_token")) {
            throw new Exception("refresh_token non atteso tra i claims");
        }
        if (info3.getClaims().containsKey("scope")) {
            throw new Exception("scope non atteso tra i claims");
        }
        if (!info3.getClaims().containsKey("token_type")) {
            throw new Exception("Atteso token_type non presente tra i claims");
        }
        if (info3.getClaims().containsKey("expires_in")) {
            throw new Exception("expires_in non atteso tra i claims");
        }
        if (!accessToken.equals(info3.getAccessToken())) {
            throw new Exception("Atteso access_token '" + accessToken + "' trovato '" + info3.getAccessToken() + "'");
        }
        if (info3.getRefreshToken() != null) {
            throw new Exception("refresh_token non atteso");
        }
        if (info3.getScopes() != null) {
            throw new Exception("Scope non attesi");
        }
        if (!tokenType2.equals(info3.getTokenType())) {
            throw new Exception("Atteso token_type '" + tokenType2 + "' trovato '" + info3.getTokenType() + "'");
        }
        Date d2 = info3.getExpiresIn();
        if (d2 != null) {
            throw new Exception("Data di scadenza non attesa");
        }
        System.out.println("Test BasicNegoziazioneTokenParser, access token senza alcuni campi ok");
        for (int i = 0; i < 2; ++i) {
            String tipoTestDateSuffix = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
            System.out.println("Test BasicNegoziazioneTokenParser, access token con expires_in con max long value" + tipoTestDateSuffix + " e un solo scope ...");
            String accessToken2 = "33aa1676-1f9e-34e2-8515-0cfca111a188";
            String tokenType3 = "Bearer";
            Long dataL = 9223372036854775L;
            Object dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            String rawResponse3 = "{\"access_token\":\"" + accessToken2 + "\",\"scope\":\"s1\",\"token_type\":\"" + tokenType3 + "\",\"expires_in\":" + (String)dataS + "}";
            tokenParser = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.OAUTH2_RFC_6749);
            info = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse3, tokenParser);
            if (info.getClaims() == null || info.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info.getClaims().size() != 4) {
                throw new Exception("Claims attesi 4, trovati '" + info.getClaims().size() + "'");
            }
            if (!info.getClaims().containsKey("access_token")) {
                throw new Exception("Atteso access_token non presente tra i claims");
            }
            if (info.getClaims().containsKey("refresh_token")) {
                throw new Exception("refresh_token non atteso tra i claims");
            }
            if (!info.getClaims().containsKey("scope")) {
                throw new Exception("Atteso scope non presente tra i claims");
            }
            if (!info.getClaims().containsKey("token_type")) {
                throw new Exception("Atteso token_type non presente tra i claims");
            }
            if (!info.getClaims().containsKey("expires_in")) {
                throw new Exception("Atteso expires_in non presente tra i claims");
            }
            if (!accessToken2.equals(info.getAccessToken())) {
                throw new Exception("Atteso access_token '" + accessToken2 + "' trovato '" + info.getAccessToken() + "'");
            }
            if (info.getRefreshToken() != null) {
                throw new Exception("refresh_token non atteso");
            }
            if (info.getScopes() == null) {
                throw new Exception("Scope attesi non trovato");
            }
            if (info.getScopes().size() != 1) {
                throw new Exception("Scope attesi 1, trovati '" + info.getScopes().size() + "'");
            }
            boolean find2 = false;
            for (String s : info.getScopes()) {
                if (!"s1".equals(s)) continue;
                find2 = true;
                break;
            }
            if (!find2) {
                throw new Exception("Scope atteso 's1' non trovato");
            }
            if (!tokenType3.equals(info.getTokenType())) {
                throw new Exception("Atteso token_type '" + tokenType3 + "' trovato '" + info.getTokenType() + "'");
            }
            Date d3 = info.getExpiresIn();
            if (d3 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            Date now2 = DateManager.getDate();
            if (!now2.before(d3)) {
                throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d3));
            }
            if (!(now2 = new Date(now2.getTime() + 3600000L)).before(d3)) {
                throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d3));
            }
            now2 = new Date(0x7FFFFFFFFFFFFFFEL);
            if (!now2.before(d3)) {
                throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d3));
            }
            long atteso = Long.MAX_VALUE;
            if (d3.getTime() != atteso) {
                throw new Exception("(4) Attesa data associata la long max value '" + atteso + "', trovata con long value '" + d3.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d3));
            }
            System.out.println("Test BasicNegoziazioneTokenParser, access token con expires_in con max long value" + tipoTestDateSuffix + " e un solo scope ok");
            System.out.println("Test BasicNegoziazioneTokenParser, access token con expires_in con un valore maggiore del max long" + tipoTestDateSuffix + " ...");
            accessToken2 = "33aa1676-1f9e-34e2-8515-0cfca111a188";
            tokenType3 = "Bearer";
            dataL = 9223372036854775L;
            dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            rawResponse3 = "{\"access_token\":\"" + accessToken2 + "\",\"token_type\":\"" + tokenType3 + "\",\"expires_in\":1111" + (String)dataS + "}";
            tokenParser = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.OAUTH2_RFC_6749);
            info = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse3, tokenParser);
            if (info.getClaims() == null || info.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info.getClaims().size() != 3) {
                throw new Exception("Claims attesi 3, trovati '" + info.getClaims().size() + "'");
            }
            if (!info.getClaims().containsKey("access_token")) {
                throw new Exception("Atteso access_token non presente tra i claims");
            }
            if (info.getClaims().containsKey("refresh_token")) {
                throw new Exception("refresh_token non atteso tra i claims");
            }
            if (info.getClaims().containsKey("scope")) {
                throw new Exception("scope non atteso tra i claims");
            }
            if (!info.getClaims().containsKey("token_type")) {
                throw new Exception("Atteso token_type non presente tra i claims");
            }
            if (!info.getClaims().containsKey("expires_in")) {
                throw new Exception("Atteso expires_in non presente tra i claims");
            }
            if (!accessToken2.equals(info.getAccessToken())) {
                throw new Exception("Atteso access_token '" + accessToken2 + "' trovato '" + info.getAccessToken() + "'");
            }
            if (info.getRefreshToken() != null) {
                throw new Exception("refresh_token non atteso");
            }
            if (info.getScopes() != null) {
                throw new Exception("Scope non attesi");
            }
            if (!tokenType3.equals(info.getTokenType())) {
                throw new Exception("Atteso token_type '" + tokenType3 + "' trovato '" + info.getTokenType() + "'");
            }
            Date d4 = info.getExpiresIn();
            if (d4 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            Date now3 = DateManager.getDate();
            if (!now3.before(d4)) {
                throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d4));
            }
            if (!(now3 = new Date(now3.getTime() + 3600000L)).before(d4)) {
                throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d4));
            }
            now3 = new Date(0x7FFFFFFFFFFFFFFEL);
            if (!now3.before(d4)) {
                throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d4));
            }
            if (d4.getTime() != Long.MAX_VALUE) {
                throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + d4.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d4));
            }
            System.out.println("Test BasicNegoziazioneTokenParser, access token con expires_in con un valore maggiore del max long" + tipoTestDateSuffix + " ok");
        }
        System.out.println("Test ClientAssertionJWT ...");
        String hdr = "ewogICJhbGciOiAiUlMyNTYiLAogICJ0eXAiOiAiSldUIiwKICAia2lkIjogInByb3ZhIiwKICAieDVjIjogWwogICAgIk1JSS4uLi4uZjZ1UXhjbGhVaDBOaXZqNmhJSitDZDNSMS9GdncxejY5RXllT3ROd3FZU2JzdzJnamlkbzhHUGdEVWtxZFVaSThyYnRjbDIyK2x0S2VXbURhUXZOUUZnTlUreUJObTBBPSIKICBdCn0=";
        String payload = "ewogICJpYXQiOiAxNjUwMDMyOTAzLAogICJuYmYiOiAxNjUwMDMyOTAzLAogICJleHAiOiAxNjUwMDMzMDAzLAogICJqdGkiOiAiNGU2MWRjMTQtYmNjOC0xMWVjLTllOTktMDA1MDU2YWUwMzA3IiwKICAiYXVkIjogInRlc3QiLAogICJjbGllbnRfaWQiOiAiY1Rlc3QiLAogICJpc3MiOiAiaXNzVGVzdCIsCiAgInN1YiI6ICJzdWJUZXN0Igp9";
        String testBase64 = hdr + "." + payload + ".PDdXpT5htzB6JI0TdYsfsIBjH8tSV0IkIiKAI0S1IYkqcS6pOs84MsfVk3wnd1_dSiR-2KSpGzZU9s8TuGoXcdR-4oa6EN0RNJJsF8zC1KHVx1IBl4jcZGRY5vAgtKwBC87bPz7EaYXtesS3Go-fl5HTFWvZ4OR3yxvsrCfTy_ehQwVJwJy9yKrIpQFq_dSQr_xQbRBL495D9Fp4p54vNdP3IRtoDq16NUhwkH_dbQJGUJdYZ2M31bBZUvgu9RRZz_ftjI78Swwq5FIwIG7r5trwgmVebZtdLF2Ni5Vc2rL7ZNuBpH7Y_knRgRYbH4HxnMoHOU6nU8yM_ZPZyhHneA";
        InformazioniJWTClientAssertion jwtClientAssertion = new InformazioniJWTClientAssertion(log, testBase64, false);
        if (jwtClientAssertion.getToken() == null) {
            throw new Exception("Parse non riuscito?");
        }
        if (jwtClientAssertion.getJsonHeader() != null) {
            throw new Exception("JsonHeader non atteso");
        }
        if (jwtClientAssertion.getJsonPayload() != null) {
            throw new Exception("JsonPayload non atteso");
        }
        if (jwtClientAssertion.getHeader() != null) {
            throw new Exception("Header non atteso");
        }
        if (jwtClientAssertion.getPayload() != null) {
            throw new Exception("Payload non atteso");
        }
        String accessToken3 = "33aa1676-1f9e-34e2-8515-0cfca111a188";
        String tokenType4 = "Bearer";
        String rawResponse4 = "{\"access_token\":\"" + accessToken3 + "\",\"token_type\":\"" + tokenType4 + "\",\"expires_in\":11119223372036854775}";
        tokenParser = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.OAUTH2_RFC_6749);
        jwtClientAssertion = new InformazioniJWTClientAssertion(log, testBase64, true);
        datiRichiesta = new InformazioniNegoziazioneToken_DatiRichiesta();
        datiRichiesta.setPolicy("TEST");
        datiRichiesta.setTransactionId(idTransazione);
        datiRichiesta.setJwtClientAssertion(jwtClientAssertion);
        info = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse4, tokenParser);
        if (info.getClaims() == null || info.getClaims().isEmpty()) {
            throw new Exception("Parse non riuscito?");
        }
        if (info.getRequest() == null) {
            throw new Exception("Request not set");
        }
        if (info.getRequest().getJwtClientAssertion() == null) {
            throw new Exception("JWT client assertion not set");
        }
        if (info.getRequest().getJwtClientAssertion().getToken() == null) {
            throw new Exception("Parse non riuscito?");
        }
        if (info.getRequest().getJwtClientAssertion().getJsonHeader() == null) {
            throw new Exception("JsonHeader atteso non presente");
        }
        String base64DecodeHdr = new String(Base64Utilities.decode((byte[])hdr.getBytes()));
        if (!base64DecodeHdr.equals(info.getRequest().getJwtClientAssertion().getJsonHeader())) {
            throw new Exception("JsonHeader '" + info.getRequest().getJwtClientAssertion().getJsonHeader() + "' differente da quello atteso '" + base64DecodeHdr + "'");
        }
        if (info.getRequest().getJwtClientAssertion().getJsonPayload() == null) {
            throw new Exception("JsonPayload atteso non presente");
        }
        String base64DecodePayload = new String(Base64Utilities.decode((byte[])payload.getBytes()));
        if (!base64DecodePayload.equals(info.getRequest().getJwtClientAssertion().getJsonPayload())) {
            throw new Exception("JsonPayload '" + info.getRequest().getJwtClientAssertion().getJsonPayload() + "' differente da quello atteso '" + base64DecodePayload + "'");
        }
        if (jwtClientAssertion.getHeader() == null) {
            throw new Exception("Header atteso non presente");
        }
        if (jwtClientAssertion.getHeader().size() != 4) {
            throw new Exception("Claims attesi nell'header 4, trovati '" + jwtClientAssertion.getHeader().size() + "'");
        }
        if (!jwtClientAssertion.getHeader().containsKey("alg")) {
            throw new Exception("Atteso alg non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getHeader().containsKey("typ")) {
            throw new Exception("Atteso typ non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getHeader().containsKey("x5c")) {
            throw new Exception("Atteso x5c non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getHeader().containsKey("kid")) {
            throw new Exception("Atteso kid non presente tra i claims dell'header");
        }
        if (jwtClientAssertion.getPayload() == null) {
            throw new Exception("Payload atteso non presente");
        }
        if (jwtClientAssertion.getPayload().size() != 8) {
            throw new Exception("Claims attesi nel paylod 8, trovati '" + jwtClientAssertion.getPayload().size() + "'");
        }
        if (!jwtClientAssertion.getPayload().containsKey("iat")) {
            throw new Exception("Atteso iat non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("nbf")) {
            throw new Exception("Atteso nbf non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("exp")) {
            throw new Exception("Atteso exp non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("jti")) {
            throw new Exception("Atteso jti non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("aud")) {
            throw new Exception("Atteso aud non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("client_id")) {
            throw new Exception("Atteso client_id non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("iss")) {
            throw new Exception("Atteso iss non presente tra i claims dell'header");
        }
        if (!jwtClientAssertion.getPayload().containsKey("sub")) {
            throw new Exception("Atteso sub non presente tra i claims dell'header");
        }
        System.out.println("Test ClientAssertionJWT ok");
        System.out.println("Test MappingNegoziazioneTokenParser ...");
        Properties pMapping = new Properties();
        pMapping.put("token.parser.token_type", "TESTtoken_type");
        pMapping.put("token.parser.access_token", "TESTaccess_token,Altro");
        pMapping.put("token.parser.refresh_token", "TESTrefresh_token");
        pMapping.put("token.parser.scope", "TESTscope,AltroDiverso");
        pMapping.put("token.parser.expires_in", "TESTexpires_in");
        pMapping.put("token.parser.expires_on", "TESTexpires_on");
        pMapping.put("token.parser.refresh_expires_in", "TESTrefresh_expires_in");
        pMapping.put("token.parser.refresh_expires_on", "TESTrefresh_expires_on");
        long dateAccess = DateManager.getTimeMillis();
        dateAccess += 120000L;
        dateAccess /= 1000L;
        Utilities.sleep((long)1234L);
        long refreshDateAccess = DateManager.getTimeMillis();
        refreshDateAccess += 120000L;
        String accessToken4 = "33aa1676-1f9e-34e2-8515-0cfca111a188";
        String refreshToken2 = "33ref1676-1f9e-34e2-8515-0cfca111a188";
        String tokenType5 = "Bearer";
        String rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":" + dateAccess + ",\"TESTrefresh_expires_on\":" + (refreshDateAccess /= 1000L) + "}";
        BasicNegoziazioneTokenParser tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
        InformazioniNegoziazioneToken info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
        if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
            throw new Exception("Parse non riuscito?");
        }
        if (info4.getClaims().size() != 8) {
            throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
        }
        if (!info4.getClaims().containsKey("TESTaccess_token")) {
            throw new Exception("Atteso TESTaccess_token non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTrefresh_token")) {
            throw new Exception("Atteso TESTrefresh_token non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTscope")) {
            throw new Exception("Atteso TESTscope non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTtoken_type")) {
            throw new Exception("Atteso TESTtoken_type non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTexpires_in")) {
            throw new Exception("Atteso TESTexpires_in non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTexpires_on")) {
            throw new Exception("Atteso TESTexpires_on non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTrefresh_expires_in")) {
            throw new Exception("Atteso TESTrefresh_expires_in non presente tra i claims");
        }
        if (!info4.getClaims().containsKey("TESTrefresh_expires_on")) {
            throw new Exception("Atteso TESTrefresh_expires_on non presente tra i claims");
        }
        if (!accessToken4.equals(info4.getAccessToken())) {
            throw new Exception("Atteso access_token '" + accessToken4 + "' trovato '" + info4.getAccessToken() + "'");
        }
        if (!refreshToken2.equals(info4.getRefreshToken())) {
            throw new Exception("Atteso refresh_token '" + refreshToken2 + "' trovato '" + info4.getRefreshToken() + "'");
        }
        if (info4.getScopes() == null) {
            throw new Exception("Scope attesi non trovato");
        }
        if (info4.getScopes().size() != 2) {
            throw new Exception("Scope attesi 2, trovati '" + info4.getScopes().size() + "'");
        }
        boolean find3 = false;
        for (String s : info4.getScopes()) {
            if (!"s1".equals(s)) continue;
            find3 = true;
            break;
        }
        if (!find3) {
            throw new Exception("Scope atteso 's1' non trovato");
        }
        find3 = false;
        for (String s : info4.getScopes()) {
            if (!"s2".equals(s)) continue;
            find3 = true;
            break;
        }
        if (!find3) {
            throw new Exception("Scope atteso 's2' non trovato");
        }
        if (!tokenType5.equals(info4.getTokenType())) {
            throw new Exception("Atteso token_type '" + tokenType5 + "' trovato '" + info4.getTokenType() + "'");
        }
        Date d5 = info4.getExpiresIn();
        if (d5 == null) {
            throw new Exception("Data di scadenza non trovata");
        }
        Date now4 = DateManager.getDate();
        if (!now4.before(d5)) {
            throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        if (!(now4 = new Date(now4.getTime() + 3600000L)).before(d5)) {
            throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        if ((now4 = new Date(now4.getTime() + 0x6DDD00L)).before(d5)) {
            throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        d5 = info4.getRefreshExpiresIn();
        if (d5 == null) {
            throw new Exception("Data di scadenza non trovata");
        }
        now4 = DateManager.getDate();
        if (!now4.before(d5)) {
            throw new Exception("(1) RefreshToken scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        if (!(now4 = new Date(now4.getTime() + 3600000L)).before(d5)) {
            throw new Exception("(2) RefreshToken scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        if ((now4 = new Date(now4.getTime() + 0x6DDD00L)).before(d5)) {
            throw new Exception("(3) Atteso refresh token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d5));
        }
        System.out.println("Test MappingNegoziazioneTokenParser, access token regolare ok");
        for (int i = 0; i < 2; ++i) {
            String tipoTestDateSuffix = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
            System.out.println("Test MappingNegoziazioneTokenParser, date on" + tipoTestDateSuffix + " ...");
            pMapping.put("token.parser.expires_in", "ALTRO_DIVERSO_TESTexpires_in");
            pMapping.put("token.parser.refresh_expires_in", "ALTRO_DIVERSO_TESTrefresh_expires_in");
            rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":" + dateAccess + ",\"TESTrefresh_expires_on\":" + refreshDateAccess + "}";
            tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
            info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
            if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info4.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
            }
            long dataAccessAttesa = dateAccess * 1000L;
            d5 = info4.getExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != dataAccessAttesa) {
                throw new Exception("Token con scadenza attesa differente, rilevata=" + d5.getTime() + " attesa=" + dataAccessAttesa);
            }
            long refreshDateAccessAttesa = refreshDateAccess * 1000L;
            d5 = info4.getRefreshExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != refreshDateAccessAttesa) {
                throw new Exception("Token con scadenza refresh attesa differente, rilevata=" + d5.getTime() + " attesa=" + refreshDateAccessAttesa);
            }
            System.out.println("Test MappingNegoziazioneTokenParser, date on" + tipoTestDateSuffix + " ok");
            System.out.println("Test MappingNegoziazioneTokenParser, date on con max long value" + tipoTestDateSuffix + " ...");
            Long dataL = 9223372036854775L;
            Object dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":" + (String)dataS + ",\"TESTrefresh_expires_on\":" + refreshDateAccess + "}";
            tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
            info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
            if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info4.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
            }
            dataAccessAttesa = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
            d5 = info4.getExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != dataAccessAttesa) {
                throw new Exception("Token con scadenza attesa differente, rilevata=" + d5.getTime() + " attesa=" + dataAccessAttesa);
            }
            refreshDateAccessAttesa = refreshDateAccess * 1000L;
            d5 = info4.getRefreshExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != refreshDateAccessAttesa) {
                throw new Exception("Token con scadenza refresh attesa differente, rilevata=" + d5.getTime() + " attesa=" + refreshDateAccessAttesa);
            }
            System.out.println("Test MappingNegoziazioneTokenParser, date on con max long value" + tipoTestDateSuffix + " ok");
            System.out.println("Test MappingNegoziazioneTokenParser, date on con overflow long value" + tipoTestDateSuffix + " ...");
            dataL = 9223372036854775L;
            dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":11111" + (String)dataS + ",\"TESTrefresh_expires_on\":" + refreshDateAccess + "}";
            tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
            info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
            if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info4.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
            }
            dataAccessAttesa = Long.MAX_VALUE;
            d5 = info4.getExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != dataAccessAttesa) {
                throw new Exception("Token con scadenza attesa differente, rilevata=" + d5.getTime() + " attesa=" + dataAccessAttesa);
            }
            refreshDateAccessAttesa = refreshDateAccess * 1000L;
            d5 = info4.getRefreshExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != refreshDateAccessAttesa) {
                throw new Exception("Token con scadenza refresh attesa differente, rilevata=" + d5.getTime() + " attesa=" + refreshDateAccessAttesa);
            }
            System.out.println("Test MappingNegoziazioneTokenParser, date on con overflow long value" + tipoTestDateSuffix + " ok");
            System.out.println("Test MappingNegoziazioneTokenParser, date on con max long value in refresh_expires_on" + tipoTestDateSuffix + " ...");
            dataL = 9223372036854775L;
            dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":" + dateAccess + ",\"TESTrefresh_expires_on\":" + (String)dataS + "}";
            tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
            info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
            if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info4.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
            }
            dataAccessAttesa = dateAccess * 1000L;
            d5 = info4.getExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != dataAccessAttesa) {
                throw new Exception("Token con scadenza attesa differente, rilevata=" + d5.getTime() + " attesa=" + dataAccessAttesa);
            }
            refreshDateAccessAttesa = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
            d5 = info4.getRefreshExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != refreshDateAccessAttesa) {
                throw new Exception("Token con scadenza refresh attesa differente, rilevata=" + d5.getTime() + " attesa=" + refreshDateAccessAttesa);
            }
            System.out.println("Test MappingNegoziazioneTokenParser, date on con max long value in refresh_expires_on" + tipoTestDateSuffix + " ok");
            System.out.println("Test MappingNegoziazioneTokenParser, date on con overflow long value in refresh_expires_on" + tipoTestDateSuffix + " ...");
            dataL = 9223372036854775L;
            dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
            rawResponse5 = "{\"TESTaccess_token\":\"" + accessToken4 + "\",\"TESTrefresh_token\":\"" + refreshToken2 + "\",\"TESTscope\":\"s1 s2\",\"TESTtoken_type\":\"" + tokenType5 + "\",\"TESTexpires_in\":3700,\"TESTrefresh_expires_in\":4000,\"TESTexpires_on\":" + dateAccess + ",\"TESTrefresh_expires_on\":11111111" + (String)dataS + "}";
            tokenParser4 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.MAPPING, pMapping);
            info4 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse5, tokenParser4);
            if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info4.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info4.getClaims().size() + "'");
            }
            dataAccessAttesa = dateAccess * 1000L;
            d5 = info4.getExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != dataAccessAttesa) {
                throw new Exception("Token con scadenza attesa differente, rilevata=" + d5.getTime() + " attesa=" + dataAccessAttesa);
            }
            refreshDateAccessAttesa = Long.MAX_VALUE;
            d5 = info4.getRefreshExpiresIn();
            if (d5 == null) {
                throw new Exception("Data di scadenza non trovata");
            }
            if (d5.getTime() != refreshDateAccessAttesa) {
                throw new Exception("Token con scadenza refresh attesa differente, rilevata=" + d5.getTime() + " attesa=" + refreshDateAccessAttesa);
            }
            System.out.println("Test MappingNegoziazioneTokenParser, date on con overflow long value in refresh_expires_on" + tipoTestDateSuffix + " ok");
        }
        System.out.println("Test RawNegoziazioneTokenParser ...");
        pMapping = new Properties();
        pMapping.put("token.parser.expires_in_sec", "3700");
        String rawResponse6 = "XXXX.YYYY.ZZZZ";
        BasicNegoziazioneTokenParser tokenParser5 = new BasicNegoziazioneTokenParser(TipologiaClaimsNegoziazione.RAW, pMapping);
        InformazioniNegoziazioneToken info5 = new InformazioniNegoziazioneToken(datiRichiesta, 200, rawResponse6, tokenParser5);
        if (!rawResponse6.equals(info5.getAccessToken())) {
            throw new Exception("Atteso access_token '" + rawResponse6 + "' trovato '" + info5.getAccessToken() + "'");
        }
        Date d6 = info5.getExpiresIn();
        if (d6 == null) {
            throw new Exception("Data di scadenza non trovata");
        }
        Date now5 = DateManager.getDate();
        if (!now5.before(d6)) {
            throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d6));
        }
        if (!(now5 = new Date(now5.getTime() + 3600000L)).before(d6)) {
            throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d6));
        }
        if ((now5 = new Date(now5.getTime() + 0x6DDD00L)).before(d6)) {
            throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d6));
        }
        System.out.println("Test RawNegoziazioneTokenParser, access token regolare ok");
    }
}

