/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.utils.OpenSPCoopAppenderUtilities;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.RuoloTransazione;
import org.openspcoop2.core.transazioni.dao.ITransazioneService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.transazioni.InResponseStatefulObject;
import org.openspcoop2.pdd.core.transazioni.OutRequestStatefulObject;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.StatefulObject;
import org.openspcoop2.pdd.core.transazioni.TransactionDB;
import org.openspcoop2.pdd.logger.DumpOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.MsgDiagnosticoOpenSPCoopProtocolAppender;
import org.openspcoop2.pdd.logger.TracciamentoOpenSPCoopProtocolAppender;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.slf4j.Logger;

public class GestoreTransazioniStateful {
    private Logger log = null;
    private Logger logSql = null;
    private String tipoDatabase = null;
    private boolean debug = false;
    private ITracciaProducer tracciamentoOpenSPCoopAppender = null;
    private IDiagnosticProducer msgDiagnosticiOpenSPCoopAppender = null;
    private IDumpProducer dumpOpenSPCoopAppender = null;
    private boolean transazioniRegistrazioneDumpHeadersCompactEnabled = false;

    public GestoreTransazioniStateful(Logger log, Logger logSql, String tipoDatabase, boolean debug) throws Exception {
        this.log = log;
        this.logSql = logSql;
        this.tipoDatabase = tipoDatabase;
        this.debug = debug;
        boolean usePdDConnection = true;
        try {
            this.tracciamentoOpenSPCoopAppender = new TracciamentoOpenSPCoopProtocolAppender();
            OpenspcoopAppender tracciamentoOpenSPCoopAppender = new OpenspcoopAppender();
            tracciamentoOpenSPCoopAppender.setTipo("__gestoreTransazioniStateful");
            ArrayList tracciamentoOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.logSql, tracciamentoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabase, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(tracciamentoOpenSPCoopAppenderProperties, (boolean)false);
            tracciamentoOpenSPCoopAppender.setPropertyList(tracciamentoOpenSPCoopAppenderProperties);
            this.tracciamentoOpenSPCoopAppender.initializeAppender(tracciamentoOpenSPCoopAppender);
            this.tracciamentoOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new Exception("Errore durante l'inizializzazione del TracciamentoAppender: " + e.getMessage(), e);
        }
        try {
            this.msgDiagnosticiOpenSPCoopAppender = new MsgDiagnosticoOpenSPCoopProtocolAppender();
            OpenspcoopAppender diagnosticoOpenSPCoopAppender = new OpenspcoopAppender();
            diagnosticoOpenSPCoopAppender.setTipo("__gestoreTransazioniStateful");
            ArrayList diagnosticoOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.logSql, diagnosticoOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabase, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(diagnosticoOpenSPCoopAppenderProperties, (boolean)false);
            diagnosticoOpenSPCoopAppender.setPropertyList(diagnosticoOpenSPCoopAppenderProperties);
            this.msgDiagnosticiOpenSPCoopAppender.initializeAppender(diagnosticoOpenSPCoopAppender);
            this.msgDiagnosticiOpenSPCoopAppender.isAlive();
        }
        catch (Exception e) {
            throw new Exception("Errore durante l'inizializzazione del DiagnosticoAppender: " + e.getMessage(), e);
        }
        try {
            this.dumpOpenSPCoopAppender = new DumpOpenSPCoopProtocolAppender();
            OpenspcoopAppender dumpOpenSPCoopAppender = new OpenspcoopAppender();
            dumpOpenSPCoopAppender.setTipo("__gestoreTransazioniStateful");
            ArrayList dumpOpenSPCoopAppenderProperties = new ArrayList();
            OpenSPCoopAppenderUtilities.addParameters((Logger)this.logSql, dumpOpenSPCoopAppenderProperties, null, null, null, null, null, (String)this.tipoDatabase, (boolean)usePdDConnection, (boolean)this.debug);
            OpenSPCoopAppenderUtilities.addCheckProperties(dumpOpenSPCoopAppenderProperties, (boolean)false);
            dumpOpenSPCoopAppender.setPropertyList(dumpOpenSPCoopAppenderProperties);
            this.dumpOpenSPCoopAppender.initializeAppender(dumpOpenSPCoopAppender);
            this.dumpOpenSPCoopAppender.isAlive();
            this.transazioniRegistrazioneDumpHeadersCompactEnabled = OpenSPCoop2Properties.getInstance().isTransazioniRegistrazioneDumpHeadersCompactEnabled();
        }
        catch (Exception e) {
            throw new Exception("Errore durante l'inizializzazione del DumpAppender: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verificaOggettiPresentiRepository(DAOFactory daoFactory, ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni, Logger daoFactoryLoggerTransazioni, Connection con) throws Exception {
        try {
            if (this.debug) {
                this.log.debug("\n\n****************************************************************************************************");
            }
            boolean autoCommit = false;
            con.setAutoCommit(autoCommit);
            JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, daoFactoryServiceManagerPropertiesTransazioni, daoFactoryLoggerTransazioni);
            jdbcServiceManager.getJdbcProperties().setShowSql(this.debug);
            ITransazioneService transazioneService = jdbcServiceManager.getTransazioneService();
            int size = RepositoryGestioneStateful.size();
            if (this.debug) {
                this.log.debug("Trovati " + size + " elementi da gestire");
            }
            while (size > 0) {
                StatefulObject so = RepositoryGestioneStateful.removeObject();
                try {
                    TransactionDB transactionDB;
                    String type = "";
                    if (so.getType() != null) {
                        type = so.getType().toString();
                    }
                    String className = "";
                    if (so.getObject() != null) {
                        type = so.getObject().getClass().getName();
                    }
                    String idTransazione = "";
                    if (so.getObject() != null) {
                        idTransazione = so.getIdTransazione();
                    }
                    if (so.getIdTransazione() == null) {
                        throw new Exception("Oggetto presente nel repository (Tipo:" + type + ")(Class:" + className + ") senza associato un id di transazione");
                    }
                    if (so.getType() == null) {
                        throw new Exception("Oggetto presente nel repository (ID:" + idTransazione + ")(Class:" + className + ") senza associato un tipo");
                    }
                    if (so.getObject() == null) {
                        throw new Exception("Oggetto presente nel repository (ID:" + idTransazione + ")(Tipo:" + type + ") senza un valore");
                    }
                    if (this.debug) {
                        this.log.debug("-------------- " + so.getType().toString() + "/" + so.getObject().getClass().getName() + "/" + so.getIdTransazione() + " --------------");
                    }
                    if ((transactionDB = this.readTransazione(transazioneService, so.getIdTransazione())) == null) {
                        if (this.debug) {
                            this.log.debug("Transazione non ancora presente, reinserisco nel repository");
                        }
                        RepositoryGestioneStateful.addObject(so);
                        continue;
                    }
                    this.gestioneStatefulObject(transazioneService, con, so, transactionDB, true);
                    con.commit();
                    if (!this.debug) continue;
                    this.log.debug("Commit eseguito con successo");
                }
                catch (Exception e) {
                    try {
                        if (this.debug) {
                            this.log.debug("Errore durante la gestione dell'oggetto (reinserisco nel repository): " + e.getMessage());
                        }
                        RepositoryGestioneStateful.addObject(so);
                        con.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
                finally {
                    --size;
                }
            }
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (Exception exception) {}
        }
    }

    public void gestioneStatefulObject(ITransazioneService transazioneService, Connection con, StatefulObject so) throws Exception {
        this.gestioneStatefulObject(transazioneService, con, so, null, false);
    }

    public void gestioneStatefulObject(ITransazioneService transazioneService, Connection con, StatefulObject so, TransactionDB transactionDB) throws Exception {
        this.gestioneStatefulObject(transazioneService, con, so, transactionDB, false);
    }

    private void gestioneStatefulObject(ITransazioneService transazioneService, Connection con, StatefulObject so, TransactionDB transactionDB, boolean thread) throws Exception {
        String tipoGestione = "[Thread] ";
        if (!thread) {
            tipoGestione = "[GestioneDiretta] ";
        }
        switch (so.getType()) {
            case MSGDIAGNOSTICO: {
                this.msgDiagnosticiOpenSPCoopAppender.log(con, (MsgDiagnostico)so.getObject());
                if (!this.debug) break;
                this.log.debug(tipoGestione + "MsgDiagnostico inserito nel database");
                break;
            }
            case TRACCIA: {
                Traccia traccia = (Traccia)so.getObject();
                this.tracciamentoOpenSPCoopAppender.log(con, traccia);
                if (!this.debug) break;
                this.log.debug(tipoGestione + "Traccia (" + String.valueOf(traccia.getTipoMessaggio()) + ") inserita nel database");
                break;
            }
            case MESSAGGIO: {
                this.dumpOpenSPCoopAppender.dump(con, (Messaggio)so.getObject(), this.transazioniRegistrazioneDumpHeadersCompactEnabled);
                if (!this.debug) break;
                this.log.debug(tipoGestione + "DumpMessaggio inserito nel database");
                break;
            }
            case OUT_REQUEST_STATEFUL_OBJECT: {
                this.updateOutRequestStatefulObject(transazioneService, (OutRequestStatefulObject)so.getObject(), so.getIdTransazione());
                if (!this.debug) break;
                this.log.debug(tipoGestione + "Informazione emesse dall'out request handler aggiornate");
                break;
            }
            case IN_RESPONSE_STATEFUL_OBJECT: {
                this.updateInResponseStatefulObject(transazioneService, (InResponseStatefulObject)so.getObject(), so.getIdTransazione());
                if (!this.debug) break;
                this.log.debug(tipoGestione + "Informazione emesse dall'in response handler aggiornate");
            }
        }
    }

    public TransactionDB readTransazione(ITransazioneService transazioneService, String idTransazione) throws Exception {
        IPaginatedExpression expression = transazioneService.newPaginatedExpression();
        expression.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
        List result = null;
        try {
            result = transazioneService.select(expression, new IField[]{Transazione.model().PROTOCOLLO, Transazione.model().ESITO, Transazione.model().ESITO_CONTESTO});
            if (result == null || result.size() <= 0) {
                if (this.debug) {
                    this.log.debug("Transazione con id [" + idTransazione + "] non trovata");
                }
                return null;
            }
        }
        catch (NotFoundException notFound) {
            if (this.debug) {
                this.log.debug("Transazione con id [" + idTransazione + "] non trovata (DriverNotFound): " + notFound.getMessage());
            }
            return null;
        }
        if (result.size() > 1 && this.debug) {
            this.log.debug("Trovata piu' di una Transazione con id [" + idTransazione + "]");
        }
        Map map = (Map)result.remove(0);
        TransactionDB tr = new TransactionDB();
        tr.setIdTransazione(idTransazione);
        Object oProtocollo = map.get(Transazione.model().PROTOCOLLO.getFieldName());
        if (oProtocollo == null || !(oProtocollo instanceof String)) {
            throw new Exception("Salvata transazione senza protocollo [" + String.valueOf(oProtocollo) + "]");
        }
        String protocollo = (String)oProtocollo;
        Object oEsito = map.get(Transazione.model().ESITO.getFieldName());
        if (oEsito == null || !(oEsito instanceof Integer)) {
            throw new Exception("Salvata transazione senza esito [" + String.valueOf(oEsito) + "]");
        }
        Integer esito = (Integer)oEsito;
        Object oEsitoContesto = map.get(Transazione.model().ESITO_CONTESTO.getFieldName());
        if (oEsitoContesto == null || !(oEsitoContesto instanceof String)) {
            throw new Exception("Salvata transazione senza esito contesto [" + String.valueOf(oEsitoContesto) + "]");
        }
        String esitoContesto = (String)oEsitoContesto;
        tr.setEsitoTransazione(EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)protocollo).convertToEsitoTransazione(esito, esitoContesto));
        if (this.debug) {
            this.log.debug("Trovata transazione");
        }
        return tr;
    }

    private void updateOutRequestStatefulObject(ITransazioneService transazioneService, OutRequestStatefulObject object, String idTransazione) throws Exception {
        UpdateField updateField;
        ArrayList<UpdateField> updateFields = new ArrayList<UpdateField>();
        if (object.getDataUscitaRichiesta() != null) {
            UpdateField updateField2 = new UpdateField(Transazione.model().DATA_USCITA_RICHIESTA, (Object)object.getDataUscitaRichiesta());
            updateFields.add(updateField2);
        }
        RuoloTransazione ruolo = null;
        if (object.getScenarioCooperazione() != null) {
            ruolo = RuoloTransazione.getEnumConstantFromOpenSPCoopValue((String)object.getScenarioCooperazione());
            updateField = new UpdateField(Transazione.model().RUOLO_TRANSAZIONE, (Object)ruolo.getValoreAsInt());
            updateFields.add(updateField);
        }
        if (object.getLocation() != null) {
            updateField = new UpdateField(Transazione.model().LOCATION_CONNETTORE, (Object)object.getLocation());
            updateFields.add(updateField);
        }
        if (object.getTipoConnettore() != null) {
            // empty if block
        }
        if (object.getServiziApplicativiErogatore() != null && object.getServiziApplicativiErogatore().size() > 0) {
            StringBuilder sa_erogatori = new StringBuilder();
            for (int i = 0; i < object.getServiziApplicativiErogatore().size(); ++i) {
                if (i > 0) {
                    sa_erogatori.append(",");
                }
                sa_erogatori.append(object.getServiziApplicativiErogatore().get(i));
            }
            UpdateField updateField3 = new UpdateField(Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)sa_erogatori.toString());
            updateFields.add(updateField3);
        }
        if (object.getEventiGestione() != null && object.getEventiGestione().size() > 0) {
            StringBuilder bf = new StringBuilder();
            for (String s : object.getEventiGestione()) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(s);
            }
            Object attuale = null;
            try {
                Object o;
                IPaginatedExpression expression = transazioneService.newPaginatedExpression();
                expression.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
                List list = transazioneService.select(expression, Transazione.model().EVENTI_GESTIONE);
                if (list != null && list.size() > 0 && (o = list.get(0)) != null && o instanceof String) {
                    attuale = (String)o;
                }
            }
            catch (NotFoundException expression) {
                // empty catch block
            }
            if (attuale != null) {
                attuale = attuale + ",";
                attuale = (String)attuale + bf.toString();
            } else {
                attuale = bf.toString();
            }
            UpdateField updateField4 = new UpdateField(Transazione.model().EVENTI_GESTIONE, attuale);
            updateFields.add(updateField4);
        }
        if (updateFields.size() > 0) {
            transazioneService.updateFields((Object)idTransazione, updateFields.toArray(new UpdateField[1]));
        }
    }

    private void updateInResponseStatefulObject(ITransazioneService transazioneService, InResponseStatefulObject object, String idTransazione) throws Exception {
        UpdateField updateField;
        ArrayList<UpdateField> updateFields = new ArrayList<UpdateField>();
        if (object.getDataRichiestaInoltrata() != null) {
            updateField = new UpdateField(Transazione.model().DATA_USCITA_RICHIESTA_STREAM, (Object)object.getDataRichiestaInoltrata());
            updateFields.add(updateField);
        }
        if (object.getDataAccettazioneRisposta() != null) {
            updateField = new UpdateField(Transazione.model().DATA_ACCETTAZIONE_RISPOSTA, (Object)object.getDataAccettazioneRisposta());
            updateFields.add(updateField);
        }
        if (object.getDataIngressoRisposta() != null) {
            updateField = new UpdateField(Transazione.model().DATA_INGRESSO_RISPOSTA, (Object)object.getDataIngressoRisposta());
            updateFields.add(updateField);
        }
        if (object.getDataUscitaRichiesta() != null) {
            updateField = new UpdateField(Transazione.model().DATA_USCITA_RICHIESTA, (Object)object.getDataUscitaRichiesta());
            updateFields.add(updateField);
        }
        if (object.getLocation() != null) {
            updateField = new UpdateField(Transazione.model().LOCATION_CONNETTORE, (Object)object.getLocation());
            updateFields.add(updateField);
        }
        if (object.getReturnCode() != null) {
            // empty if block
        }
        if (object.getFaultIntegrazione() != null) {
            updateField = new UpdateField(Transazione.model().FAULT_INTEGRAZIONE, (Object)object.getFaultIntegrazione());
            updateFields.add(updateField);
        }
        if (object.getFormatoFaultIntegrazione() != null) {
            updateField = new UpdateField(Transazione.model().FORMATO_FAULT_INTEGRAZIONE, (Object)object.getFormatoFaultIntegrazione());
            updateFields.add(updateField);
        }
        if (object.getFaultCooperazione() != null) {
            updateField = new UpdateField(Transazione.model().FAULT_COOPERAZIONE, (Object)object.getFaultCooperazione());
            updateFields.add(updateField);
        }
        if (object.getFormatoFaultCooperazione() != null) {
            updateField = new UpdateField(Transazione.model().FORMATO_FAULT_COOPERAZIONE, (Object)object.getFormatoFaultCooperazione());
            updateFields.add(updateField);
        }
        if (object.getEventiGestione() != null && object.getEventiGestione().size() > 0) {
            StringBuilder bf = new StringBuilder();
            for (String s : object.getEventiGestione()) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(s);
            }
            Object attuale = null;
            try {
                Object o;
                IPaginatedExpression expression = transazioneService.newPaginatedExpression();
                expression.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
                List list = transazioneService.select(expression, Transazione.model().EVENTI_GESTIONE);
                if (list != null && list.size() > 0 && (o = list.get(0)) != null && o instanceof String) {
                    attuale = (String)o;
                }
            }
            catch (NotFoundException expression) {
                // empty catch block
            }
            if (attuale != null) {
                attuale = attuale + ",";
                attuale = (String)attuale + bf.toString();
            } else {
                attuale = bf.toString();
            }
            UpdateField updateField2 = new UpdateField(Transazione.model().EVENTI_GESTIONE, attuale);
            updateFields.add(updateField2);
        }
        if (updateFields.size() > 0) {
            transazioneService.updateFields((Object)idTransazione, updateFields.toArray(new UpdateField[1]));
        }
    }
}

