/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.sql.Connection;
import java.util.ArrayList;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.dao.ITransazioneService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.transazioni.GestoreTransazioniStateful;
import org.openspcoop2.pdd.core.transazioni.InResponseStatefulObject;
import org.openspcoop2.pdd.core.transazioni.OutRequestStatefulObject;
import org.openspcoop2.pdd.core.transazioni.StatefulObject;
import org.openspcoop2.pdd.core.transazioni.StatefulObjectType;
import org.openspcoop2.pdd.core.transazioni.TransactionDB;
import org.openspcoop2.pdd.core.transazioni.TransactionStatefulNotSupportedException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class RepositoryGestioneStateful {
    private static final String ID_MODULO = "RepositoryGestioneStateful";
    private static Boolean gestioneStatefulAbilitata = null;
    private static String tipoDatabase = null;
    private static DAOFactory daoFactory = null;
    private static ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private static Logger log = null;
    private static Logger daoFactoryLoggerTransazioni = null;
    private static OpenSPCoop2Properties openspcoopProperties = null;
    private static boolean debug;
    private static GestoreTransazioniStateful gestoreTransazioniStateful;
    private static ArrayList<StatefulObject> repository;

    private static synchronized void init() throws TransactionStatefulNotSupportedException {
        if (gestioneStatefulAbilitata == null) {
            try {
                openspcoopProperties = OpenSPCoop2Properties.getInstance();
                gestioneStatefulAbilitata = openspcoopProperties.isTransazioniStatefulEnabled();
                tipoDatabase = openspcoopProperties.getDatabaseType();
                if (tipoDatabase == null) {
                    throw new Exception("Tipo Database non definito");
                }
                openspcoopProperties = OpenSPCoop2Properties.getInstance();
                debug = openspcoopProperties.isTransazioniStatefulDebug();
                DAOFactoryProperties daoFactoryProperties = null;
                log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniStateful(debug);
                daoFactoryLoggerTransazioni = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniStatefulSql(debug);
                daoFactory = DAOFactory.getInstance((Logger)daoFactoryLoggerTransazioni);
                daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)daoFactoryLoggerTransazioni);
                daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
                daoFactoryServiceManagerPropertiesTransazioni.setShowSql(debug);
                daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
            }
            catch (Exception e) {
                throw new TransactionStatefulNotSupportedException("Inizializzazione risorse database non riuscita: " + e.getMessage(), e);
            }
            try {
                gestoreTransazioniStateful = new GestoreTransazioniStateful(log, daoFactoryLoggerTransazioni, tipoDatabase, debug);
            }
            catch (Exception e) {
                throw new TransactionStatefulNotSupportedException("Inizializzazione GestoreTransazioniStateful non riuscita: " + e.getMessage(), e);
            }
        }
    }

    private static void checkGestioneAbilitata() throws TransactionStatefulNotSupportedException {
        if (gestioneStatefulAbilitata == null) {
            RepositoryGestioneStateful.init();
        }
        if (!gestioneStatefulAbilitata.booleanValue()) {
            throw new TransactionStatefulNotSupportedException("Non abilitata la gestione delle transazioni stateful");
        }
    }

    private static void invokeGestoreTransazioniStateful(StatefulObject s, TransactionDB transactionDB) throws TransactionStatefulNotSupportedException {
        Resource dbResource = null;
        DBTransazioniManager dbManager = DBTransazioniManager.getInstance();
        IDSoggetto idDominio = openspcoopProperties.getIdentitaPortaDefault(s.getProtocollo(), null);
        Connection con = null;
        try {
            dbResource = dbManager.getResource(idDominio, ID_MODULO, null);
            con = (Connection)dbResource.getResource();
            boolean autoCommit = false;
            con.setAutoCommit(autoCommit);
            JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, daoFactoryServiceManagerPropertiesTransazioni, daoFactoryLoggerTransazioni);
            jdbcServiceManager.getJdbcProperties().setShowSql(debug);
            ITransazioneService transazioneService = jdbcServiceManager.getTransazioneService();
            gestoreTransazioniStateful.gestioneStatefulObject(transazioneService, con, s, transactionDB);
            con.commit();
        }
        catch (Exception e) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TransactionStatefulNotSupportedException("Errore durante la gestione della transazione stateful", e);
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
            try {
                dbManager.releaseResource(idDominio, ID_MODULO, dbResource);
            }
            catch (Exception exception) {}
        }
    }

    private static TransactionDB invokeGestoreTransazioniStateful_readTransactionDB(String protocollo, String idTransazione) throws TransactionStatefulNotSupportedException {
        Resource dbResource = null;
        DBTransazioniManager dbManager = DBTransazioniManager.getInstance();
        IDSoggetto idDominio = openspcoopProperties.getIdentitaPortaDefault(protocollo, null);
        Connection con = null;
        try {
            dbResource = dbManager.getResource(idDominio, "RepositoryGestioneStateful.read", null);
            con = (Connection)dbResource.getResource();
            JDBCServiceManager jdbcServiceManager = (JDBCServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, daoFactoryServiceManagerPropertiesTransazioni, daoFactoryLoggerTransazioni);
            jdbcServiceManager.getJdbcProperties().setShowSql(debug);
            ITransazioneService transazioneService = jdbcServiceManager.getTransazioneService();
            TransactionDB transactionDB = gestoreTransazioniStateful.readTransazione(transazioneService, idTransazione);
            return transactionDB;
        }
        catch (Exception e) {
            throw new TransactionStatefulNotSupportedException("Errore durante la gestione della transazione stateful", e);
        }
        finally {
            try {
                dbManager.releaseResource(idDominio, ID_MODULO, dbResource);
            }
            catch (Exception exception) {}
        }
    }

    public static void addMessaggio(String idTransazione, Messaggio messaggio) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        StatefulObject s = new StatefulObject(messaggio.getProtocollo());
        s.setIdTransazione(idTransazione);
        s.setObject(messaggio);
        s.setType(StatefulObjectType.MESSAGGIO);
        RepositoryGestioneStateful.invokeGestoreTransazioniStateful(s, null);
    }

    public static void addMsgDiagnostico(String idTransazione, MsgDiagnostico msgDiag) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        StatefulObject s = new StatefulObject(msgDiag.getProtocollo());
        s.setIdTransazione(idTransazione);
        s.setObject(msgDiag);
        s.setType(StatefulObjectType.MSGDIAGNOSTICO);
        RepositoryGestioneStateful.invokeGestoreTransazioniStateful(s, null);
    }

    public static void addTraccia(String idTransazione, Traccia traccia) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        StatefulObject s = new StatefulObject(traccia.getProtocollo());
        s.setIdTransazione(idTransazione);
        s.setObject(traccia);
        s.setType(StatefulObjectType.TRACCIA);
        RepositoryGestioneStateful.invokeGestoreTransazioniStateful(s, null);
    }

    public static void addOutRequestStatefulObject(String protocollo, String idTransazione, OutRequestStatefulObject object) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        StatefulObject s = new StatefulObject(protocollo);
        s.setIdTransazione(idTransazione);
        s.setObject(object);
        s.setType(StatefulObjectType.OUT_REQUEST_STATEFUL_OBJECT);
        TransactionDB tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        if (tr == null) {
            Utilities.sleep((long)500L);
            tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        }
        if (tr == null) {
            Utilities.sleep((long)500L);
            tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        }
        if (tr != null) {
            RepositoryGestioneStateful.invokeGestoreTransazioniStateful(s, tr);
        } else {
            repository.add(s);
        }
    }

    public static void addInResponseStatefulObject(String protocollo, String idTransazione, InResponseStatefulObject object) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        StatefulObject s = new StatefulObject(protocollo);
        s.setIdTransazione(idTransazione);
        s.setObject(object);
        s.setType(StatefulObjectType.IN_RESPONSE_STATEFUL_OBJECT);
        TransactionDB tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        if (tr == null) {
            Utilities.sleep((long)500L);
            tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        }
        if (tr == null) {
            Utilities.sleep((long)500L);
            tr = RepositoryGestioneStateful.invokeGestoreTransazioniStateful_readTransactionDB(protocollo, idTransazione);
        }
        if (tr != null) {
            RepositoryGestioneStateful.invokeGestoreTransazioniStateful(s, tr);
        } else {
            repository.add(s);
        }
    }

    public static void addObject(StatefulObject s) throws TransactionStatefulNotSupportedException {
        RepositoryGestioneStateful.checkGestioneAbilitata();
        repository.add(s);
    }

    public static int size() {
        return repository.size();
    }

    public static StatefulObject getObject() {
        return repository.get(0);
    }

    public static StatefulObject removeObject() {
        return repository.remove(0);
    }

    static {
        gestoreTransazioniStateful = null;
        repository = new ArrayList();
    }
}

