/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.ProtocolliRegistrati;
import org.openspcoop2.protocol.basic.tracciamento.TracciaDriver;
import org.openspcoop2.protocol.engine.BasicProtocolFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracce;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.slf4j.Logger;

public class DriverTracciamento
implements ITracciaDriver {
    TracciaDriver driverBase = null;
    private BasicProtocolFactory basicProtocolFactory;

    public IProtocolFactory<?> getProtocolFactory() {
        return this.basicProtocolFactory;
    }

    public void setProperties(List<String> properties) {
        this.driverBase.setProperties(properties);
    }

    public DriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverTracciamentoException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public DriverTracciamento(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverTracciamentoException {
        try {
            this.basicProtocolFactory = new BasicProtocolFactory(log);
            this.driverBase = (TracciaDriver)this.basicProtocolFactory.createTracciaDriver();
            ProtocolliRegistrati pRegistrati = new ProtocolliRegistrati(ProtocolFactoryManager.getInstance().getProtocolFactories());
            this.driverBase.init(pRegistrati, nomeDataSource, tipoDatabase, prop, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public DriverTracciamento(DataSource dataSourceObject, String tipoDatabase) throws DriverTracciamentoException {
        this(dataSourceObject, tipoDatabase, null);
    }

    public DriverTracciamento(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.basicProtocolFactory = new BasicProtocolFactory(log);
            this.driverBase = (TracciaDriver)this.basicProtocolFactory.createTracciaDriver();
            ProtocolliRegistrati pRegistrati = new ProtocolliRegistrati(ProtocolFactoryManager.getInstance().getProtocolFactories());
            this.driverBase.init(pRegistrati, dataSourceObject, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public DriverTracciamento(Connection connection, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.basicProtocolFactory = new BasicProtocolFactory(log);
            this.driverBase = (TracciaDriver)this.basicProtocolFactory.createTracciaDriver();
            ProtocolliRegistrati pRegistrati = new ProtocolliRegistrati(ProtocolFactoryManager.getInstance().getProtocolFactories());
            this.driverBase.init(pRegistrati, connection, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public DriverTracciamento(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        try {
            this.basicProtocolFactory = new BasicProtocolFactory(log);
            this.driverBase = (TracciaDriver)this.basicProtocolFactory.createTracciaDriver();
            ProtocolliRegistrati pRegistrati = new ProtocolliRegistrati(ProtocolFactoryManager.getInstance().getProtocolFactories());
            this.driverBase.init(pRegistrati, urlJDBC, driverJDBC, username, password, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), (Throwable)e);
        }
    }

    public int countTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        return this.driverBase.countTracce(filtro);
    }

    public List<Traccia> getTracce(FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.driverBase.getTracce(filtro);
    }

    public int deleteTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        return this.driverBase.deleteTracce(filtro);
    }

    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.driverBase.getTraccia(idBusta, codicePorta);
    }

    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta, boolean ricercaIdBustaComeRiferimentoMessaggio) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.driverBase.getTraccia(idBusta, codicePorta, ricercaIdBustaComeRiferimentoMessaggio);
    }

    public Traccia getTraccia(String idTransazione, RuoloMessaggio tipoTraccia) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.driverBase.getTraccia(idTransazione, tipoTraccia);
    }

    public Traccia getTraccia(RuoloMessaggio tipoTraccia, Map<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.driverBase.getTraccia(tipoTraccia, propertiesRicerca);
    }

    public void close() throws DriverTracciamentoException {
        this.driverBase.close();
    }
}

