/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.core.handlers.transazioni.PostOutResponseHandler;
import org.openspcoop2.pdd.core.transazioni.GestoreConsegnaMultipla;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.protocol.engine.BasicProtocolFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.DiagnosticoBuilder;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class MsgDiagnostico {
    public static boolean gestoreDiagnosticaDisponibile = true;
    public static Throwable motivoMalfunzionamentoDiagnostici = null;
    private org.apache.logging.log4j.Logger loggerMsgDiagnostico = null;
    private org.apache.logging.log4j.Logger loggerOpenSPCoop2 = null;
    private org.apache.logging.log4j.Logger loggerIntegrationManager = null;
    private org.apache.logging.log4j.Logger loggerResource = null;
    private Logger loggerOpenSPCoop2Fatal = null;
    private Logger loggerOpenSPCoop2Core = null;
    private List<IDiagnosticProducer> loggerMsgDiagnosticoOpenSPCoopAppender = null;
    private List<String> tipoMsgDiagnosticoOpenSPCoopAppender = null;
    private IDSoggetto idSoggettoDominio;
    private String idModulo;
    private String idMessaggioRichiesta;
    private String idMessaggioRisposta;
    private Context pddContext;
    private DiagnosticoBuilder diagnosticoBuilder;
    private IProtocolFactory<?> protocolFactory;
    private ITraduttore traduttore;
    private ConfigurazionePdDManager _configurazionePdDReader;
    private MsgDiagnosticiProperties msgDiagPropertiesReader;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> keywordLogPersonalizzati = new HashMap<String, String>();
    private String porta;
    private boolean delegata;
    private TipoPdD tipoPdD;
    private Severita severitaPorta;
    private StateMessage state = null;
    private StateMessage responseState = null;
    private RequestInfo requestInfo = null;
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String servizioApplicativo;
    private String idCorrelazioneApplicativa;
    private String idCorrelazioneRisposta;
    private TransazioneApplicativoServer transazioneApplicativoServer;
    private IDPortaApplicativa idPortaApplicativa;
    private String prefixMsgPersonalizzati = null;

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getKeywordLogPersonalizzati() {
        return this.keywordLogPersonalizzati;
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, IDSoggetto idSoggettoDominio, String modulo, String nomePorta, RequestInfo requestInfo, ConfigurazionePdDManager configurazionePdDManager) {
        return new MsgDiagnostico(tipoPdD, idSoggettoDominio, modulo, nomePorta, requestInfo, configurazionePdDManager, null, null);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, IDSoggetto idSoggettoDominio, String modulo, String nomePorta, RequestInfo requestInfo, IState state) {
        return new MsgDiagnostico(tipoPdD, idSoggettoDominio, modulo, nomePorta, requestInfo, null, state, null);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, IDSoggetto idSoggettoDominio, String modulo, String nomePorta, RequestInfo requestInfo, IState state, IState responseState) {
        return new MsgDiagnostico(tipoPdD, idSoggettoDominio, modulo, nomePorta, requestInfo, null, state, responseState);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, String modulo, String nomePorta, RequestInfo requestInfo, ConfigurazionePdDManager configurazionePdDManager) {
        return new MsgDiagnostico(tipoPdD, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, nomePorta, requestInfo, configurazionePdDManager, null, null);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, String modulo, String nomePorta, RequestInfo requestInfo) {
        return new MsgDiagnostico(tipoPdD, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, nomePorta, requestInfo, null, null, null);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, String modulo, ConfigurazionePdDManager configurazionePdDManager) {
        return new MsgDiagnostico(tipoPdD, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, null, null, configurazionePdDManager, null, null);
    }

    public static MsgDiagnostico newInstance(TipoPdD tipoPdD, String modulo) {
        return new MsgDiagnostico(tipoPdD, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, null, null, null, null, null);
    }

    public static MsgDiagnostico newInstance(IDSoggetto idSoggettoDominio, String modulo, ConfigurazionePdDManager configurazionePdDManager) {
        return new MsgDiagnostico(null, idSoggettoDominio, modulo, null, null, configurazionePdDManager, null, null);
    }

    public static MsgDiagnostico newInstance(String modulo, ConfigurazionePdDManager configurazionePdDManager) {
        return new MsgDiagnostico(null, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, null, null, configurazionePdDManager, null, null);
    }

    public static MsgDiagnostico newInstance(String modulo) {
        return new MsgDiagnostico(null, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefaultWithoutProtocol(), modulo, null, null, null, null, null);
    }

    public static MsgDiagnostico newInstance() {
        return new MsgDiagnostico();
    }

    private MsgDiagnostico(TipoPdD tipoPdD, IDSoggetto idSoggettoDominio, String modulo, String nomePorta, RequestInfo requestInfo, ConfigurazionePdDManager configurazionePdDManagerParam, IState stateParam, IState responseStateParam) {
        this.idSoggettoDominio = idSoggettoDominio;
        this.idModulo = modulo;
        this.loggerMsgDiagnostico = OpenSPCoop2Logger.loggerMsgDiagnostico;
        this.loggerOpenSPCoop2 = OpenSPCoop2Logger.loggerOpenSPCoop2;
        this.loggerIntegrationManager = OpenSPCoop2Logger.loggerIntegrationManager;
        this.loggerResource = OpenSPCoop2Logger.loggerOpenSPCoopResourcesAsLoggerImpl;
        this.loggerOpenSPCoop2Fatal = OpenSPCoop2Logger.loggerOpenSPCoopConsole;
        this.loggerMsgDiagnosticoOpenSPCoopAppender = OpenSPCoop2Logger.loggerMsgDiagnosticoOpenSPCoopAppender;
        this.tipoMsgDiagnosticoOpenSPCoopAppender = OpenSPCoop2Logger.tipoMsgDiagnosticoOpenSPCoopAppender;
        this.loggerOpenSPCoop2Core = OpenSPCoop2Logger.loggerOpenSPCoopCore;
        if (configurazionePdDManagerParam != null) {
            this._configurazionePdDReader = configurazionePdDManagerParam;
            this.state = this._configurazionePdDReader.getState();
            this.responseState = this._configurazionePdDReader.getResponseState();
        } else {
            if (stateParam != null && stateParam instanceof StateMessage) {
                this.state = (StateMessage)stateParam;
            }
            if (responseStateParam != null && responseStateParam instanceof StateMessage) {
                this.responseState = (StateMessage)responseStateParam;
            }
            this._configurazionePdDReader = ConfigurazionePdDManager.getInstance(this.state, this.responseState);
        }
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
        try {
            if (requestInfo == null || requestInfo.getProtocolFactory() == null) {
                throw new Exception("ProtocolFactory unknow");
            }
            this.protocolFactory = requestInfo.getProtocolFactory();
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (Throwable e) {
            this.protocolFactory = new BasicProtocolFactory(this.loggerOpenSPCoop2Core);
            try {
                this.traduttore = this.protocolFactory.createTraduttore();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.diagnosticoBuilder = new DiagnosticoBuilder(this.protocolFactory);
        this.requestInfo = requestInfo;
        this.porta = nomePorta;
        this.tipoPdD = tipoPdD;
        if (tipoPdD != null) {
            this.delegata = TipoPdD.DELEGATA.equals((Object)tipoPdD);
        }
        this.setPorta(this.requestInfo);
    }

    private ConfigurazionePdDManager getConfigurazionePdDManager() {
        if (this._configurazionePdDReader != null) {
            return this._configurazionePdDReader;
        }
        if (this.state != null || this.responseState != null) {
            return ConfigurazionePdDManager.getInstance(this.state, this.responseState);
        }
        return ConfigurazionePdDManager.getInstance();
    }

    private MsgDiagnostico() {
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
    }

    private void setPorta(RequestInfo requestInfo) {
        if (this.porta != null) {
            if (this.delegata) {
                try {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(this.porta);
                    PortaDelegata pd = this.getConfigurazionePdDManager().getPortaDelegataSafeMethod(idPD, requestInfo);
                    if (pd != null && pd.getTracciamento() != null) {
                        this.severitaPorta = pd.getTracciamento().getSeverita();
                    }
                }
                catch (Throwable idPD) {}
            } else {
                try {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(this.porta);
                    PortaApplicativa pa = this.getConfigurazionePdDManager().getPortaApplicativaSafeMethod(idPA, requestInfo);
                    if (pa != null && pa.getTracciamento() != null) {
                        this.severitaPorta = pa.getTracciamento().getSeverita();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void updateRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void updatePorta(String porta, RequestInfo requestInfo) {
        this.updatePorta(null, porta, requestInfo);
    }

    public void updatePorta(TipoPdD tipoPdD, String porta, RequestInfo requestInfo) {
        if (tipoPdD != null) {
            this.tipoPdD = tipoPdD;
            this.delegata = TipoPdD.DELEGATA.equals((Object)tipoPdD);
        }
        this.porta = porta;
        this.setPorta(requestInfo);
    }

    public String getPorta() {
        return this.porta;
    }

    public void updateState(IState requestStateParam, IState responseStateParam) {
        StateMessage requestState = null;
        StateMessage responseState = null;
        if (requestStateParam != null && requestStateParam instanceof StateMessage) {
            requestState = (StateMessage)requestStateParam;
        }
        if (responseStateParam != null && responseStateParam instanceof StateMessage) {
            responseState = (StateMessage)responseStateParam;
        }
        this.updateState(requestState, responseState);
    }

    public void updateState(StateMessage requestState, StateMessage responseState) {
        this.state = requestState;
        this.responseState = responseState;
        this._configurazionePdDReader = this.state != null || this.responseState != null ? (this._configurazionePdDReader != null ? this._configurazionePdDReader.refreshState(this.state, this.responseState) : ConfigurazionePdDManager.getInstance(this.state, this.responseState)) : ConfigurazionePdDManager.getInstance();
    }

    public void updateState(ConfigurazionePdDManager configurazionePdDManager) {
        this._configurazionePdDReader = configurazionePdDManager;
        if (this._configurazionePdDReader != null) {
            this.state = this._configurazionePdDReader.getState();
            this.responseState = this._configurazionePdDReader.getResponseState();
        } else {
            this._configurazionePdDReader = ConfigurazionePdDManager.getInstance();
        }
    }

    private Connection getConnectionFromState() {
        Connection c;
        if (this.state != null && (c = StateMessage.getConnection((StateMessage)this.state)) != null) {
            return c;
        }
        if (this.responseState != null && (c = StateMessage.getConnection((StateMessage)this.responseState)) != null) {
            return c;
        }
        return null;
    }

    private IState getValidConnectionState() {
        Connection c;
        if (this.state != null && (c = StateMessage.getConnection((StateMessage)this.state)) != null) {
            return this.state;
        }
        if (this.responseState != null && (c = StateMessage.getConnection((StateMessage)this.responseState)) != null) {
            return this.responseState;
        }
        return null;
    }

    public void setDominio(IDSoggetto idSoggettoDominio) {
        this.idSoggettoDominio = idSoggettoDominio;
    }

    public IDSoggetto getDominio() {
        return this.idSoggettoDominio;
    }

    public void setPddContext(Context pddContext, IProtocolFactory<?> protocolFactory) {
        this.pddContext = pddContext;
        this.protocolFactory = protocolFactory;
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diagnosticoBuilder = new DiagnosticoBuilder(protocolFactory);
        this.addKeywords(protocolFactory);
    }

    public void setFunzione(String modulo) {
        this.idModulo = modulo;
    }

    public String getFunzione() {
        return this.idModulo;
    }

    public void setIdMessaggioRichiesta(String id) {
        this.idMessaggioRichiesta = id;
    }

    public void setIdMessaggioRisposta(String id) {
        this.idMessaggioRisposta = id;
    }

    public void aggiornaFiltri() {
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void setFruitore(IDSoggetto fruitore) {
        this.fruitore = fruitore;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setIdCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
    }

    public void setIdCorrelazioneRisposta(String idCorrelazioneRisposta) {
        this.idCorrelazioneRisposta = idCorrelazioneRisposta;
    }

    public void setTransazioneApplicativoServer(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPortaApplicativa) {
        this.transazioneApplicativoServer = transazioneApplicativoServer;
        this.idPortaApplicativa = idPortaApplicativa;
    }

    public void addKeyword(String key, String value) {
        if (key != null) {
            String tmpValue = value;
            if (tmpValue == null) {
                tmpValue = "";
            }
            this.keywordLogPersonalizzati.put(key, tmpValue);
        }
    }

    public void addKeywordErroreProcessamento(Throwable t) {
        this.addKeywordErroreProcessamento(t, null);
    }

    public void addKeywordErroreProcessamento(Throwable t, String prefix) {
        String eccezione;
        String string = eccezione = t != null ? Utilities.readFirstErrorValidMessageFromException((Throwable)t) : "Internal Error";
        if (prefix != null) {
            if (!((String)(prefix = ((String)prefix).trim())).endsWith(":")) {
                prefix = (String)prefix + ":";
            }
            prefix = (String)prefix + " ";
            this.addKeyword("@ERRORE_PROCESSAMENTO@", (String)prefix + eccezione);
        } else {
            this.addKeyword("@ERRORE_PROCESSAMENTO@", eccezione);
        }
    }

    public void addKeywords(IProtocolFactory<?> protocolFactory) {
        this.addKeyword("@PROTOCOLLO@", protocolFactory.getProtocol());
        try {
            this.addKeyword("@PROTOCOLLO_TIPI_SOGGETTI@", protocolFactory.createProtocolConfiguration().getTipiSoggetti().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RequestInfo requestInfoParam = null;
            requestInfoParam = this.pddContext != null && this.pddContext.containsKey(Costanti.REQUEST_INFO) ? (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO) : this.requestInfo;
            ServiceBinding serviceBinding = null;
            if (requestInfoParam != null) {
                serviceBinding = requestInfoParam.getProtocolContext().isPortaApplicativaService() ? requestInfoParam.getProtocolServiceBinding() : requestInfoParam.getIntegrationServiceBinding();
            }
            this.addKeyword("@PROTOCOLLO_TIPI_SERVIZI@", protocolFactory.createProtocolConfiguration().getTipiServizi(serviceBinding).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addKeywords(Busta busta, boolean richiesta) {
        if (busta != null) {
            if (richiesta) {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    String profilo = null;
                    if (this.traduttore != null) {
                        profilo = this.traduttore.toString(busta.getProfiloDiCollaborazione());
                    } else if (busta.getProtocollo() != null) {
                        try {
                            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                            ITraduttore traduttore = protocolFactory.createTraduttore();
                            profilo = traduttore.toString(busta.getProfiloDiCollaborazione());
                        }
                        catch (Exception e) {
                            profilo = busta.getProfiloDiCollaborazione().name();
                        }
                    } else {
                        profilo = busta.getProfiloDiCollaborazione().name();
                    }
                    if (profilo == null) {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", profilo);
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", busta.getTipoMittente());
                } else {
                    try {
                        this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)busta.getProtocollo()));
                    }
                    catch (Exception profilo) {
                        // empty catch block
                    }
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", busta.getMittente());
                } else {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", "Anonimo");
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", busta.getServizio());
                }
                if (busta.getVersioneServizio() != null) {
                    this.keywordLogPersonalizzati.put("@VERSIONE_SERVIZIO_BUSTA_RICHIESTA@", "" + busta.getVersioneServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", "" + busta.getSequenza());
                }
                if (busta.getIndirizzoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA@", busta.getIndirizzoMittente());
                }
                if (busta.getIndirizzoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA@", busta.getIndirizzoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RICHIESTA@", busta.getScadenza().toString());
                }
                if (busta.getTipoDestinatario() != null && busta.getDestinatario() != null && busta.getTipoServizio() != null && busta.getServizio() != null && busta.getVersioneServizio() != null) {
                    try {
                        this.keywordLogPersonalizzati.put("@URI_ACCORDO_PARTE_SPECIFICA@", IDServizioFactory.getInstance().getUriFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            } else {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RISPOSTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RISPOSTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    String profilo = null;
                    if (this.traduttore != null) {
                        profilo = this.traduttore.toString(busta.getProfiloDiCollaborazione());
                    } else if (busta.getProtocollo() != null) {
                        try {
                            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                            ITraduttore traduttore = protocolFactory.createTraduttore();
                            profilo = traduttore.toString(busta.getProfiloDiCollaborazione());
                        }
                        catch (Exception e) {
                            profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                        }
                    } else {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    if (profilo == null) {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", profilo);
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RISPOSTA@", busta.getTipoMittente());
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RISPOSTA@", busta.getMittente());
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RISPOSTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RISPOSTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RISPOSTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RISPOSTA@", busta.getServizio());
                }
                if (busta.getVersioneServizio() != null) {
                    this.keywordLogPersonalizzati.put("@VERSIONE_SERVIZIO_BUSTA_RISPOSTA@", "" + busta.getVersioneServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", "" + busta.getSequenza());
                }
                if (busta.getIndirizzoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA@", busta.getIndirizzoMittente());
                }
                if (busta.getIndirizzoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA@", busta.getIndirizzoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RISPOSTA@", busta.getScadenza().toString());
                }
            }
        }
    }

    public void addKeywords(IDSoggetto soggettoFruitore) {
        this.addKeywords(soggettoFruitore, null, null);
    }

    public void addKeywords(IDServizio idServizio) {
        this.addKeywords(null, idServizio, null);
    }

    public void addKeywords(IDSoggetto soggettoFruitore, IDServizio idServizio, String idMessaggio) {
        if (idMessaggio != null) {
            this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
        }
        if (soggettoFruitore != null) {
            this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getTipo());
            this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getNome());
        } else if (idServizio != null && idServizio.getTipo() != null) {
            try {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByServiceType(idServizio.getTipo());
                this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", (String)ProtocolFactoryManager.getInstance().getDefaultOrganizationTypes().get((Object)protocollo));
            }
            catch (Exception protocollo) {
                // empty catch block
            }
            this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", "Anonimo");
        }
        if (idServizio != null) {
            if (idServizio.getSoggettoErogatore() != null) {
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getTipo());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getNome());
            }
            this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", idServizio.getTipo());
            this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", idServizio.getNome());
            if (idServizio.getVersione() != null) {
                this.keywordLogPersonalizzati.put("@VERSIONE_SERVIZIO_BUSTA_RICHIESTA@", "" + idServizio.getVersione());
            }
            if (idServizio.getAzione() != null) {
                this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", idServizio.getAzione());
            }
            try {
                this.keywordLogPersonalizzati.put("@URI_ACCORDO_PARTE_SPECIFICA@", IDServizioFactory.getInstance().getUriFromIDServizio(idServizio));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public void updateKeywordIdMessaggioRichiesta(String idMessaggio) {
        if (idMessaggio != null) {
            this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
        }
    }

    public String replaceKeywords(String msg) {
        StringBuilder bf = new StringBuilder();
        StringBuilder keyword = new StringBuilder();
        boolean separator = false;
        char separatorChar = '@';
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (separatorChar == ch) {
                if (!separator) {
                    keyword.append(separatorChar);
                    separator = true;
                    continue;
                }
                keyword.append(separatorChar);
                String valoreRimpiazzato = this.keywordLogPersonalizzati.get(keyword.toString());
                if (valoreRimpiazzato == null) {
                    bf.append(keyword.toString());
                } else {
                    bf.append(valoreRimpiazzato);
                }
                keyword.setLength(0);
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        if (separator) {
            bf.append(keyword.toString());
        }
        return bf.toString();
    }

    public String getPrefixMsgPersonalizzati() {
        return this.prefixMsgPersonalizzati;
    }

    public void setPrefixMsgPersonalizzati(String v) {
        this.prefixMsgPersonalizzati = v;
    }

    public int getLivello(String keyLivelloPersonalizzato) {
        return this.getLivello(this.prefixMsgPersonalizzati, keyLivelloPersonalizzato);
    }

    public int getLivello(String prefix, String keyLivelloPersonalizzato) {
        if (this.msgDiagPropertiesReader == null) {
            return -1;
        }
        Integer livello = this.msgDiagPropertiesReader.getLivello(prefix, keyLivelloPersonalizzato);
        if (livello != null) {
            return livello;
        }
        return -1;
    }

    public String getCodice(String keyCodicePersonalizzato) {
        return this.getCodice(this.prefixMsgPersonalizzati, keyCodicePersonalizzato);
    }

    public String getCodice(String prefix, String keyCodicePersonalizzato) {
        if (this.msgDiagPropertiesReader == null) {
            return "PropertiesReader dei Messaggi Diagnostici non inizializzato";
        }
        return this.msgDiagPropertiesReader.getCodice(prefix, keyCodicePersonalizzato);
    }

    public String getMessaggio(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, false);
    }

    public String getMessaggio(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, false);
    }

    public String getMessaggio_replaceKeywords(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, true);
    }

    public String getMessaggio_replaceKeywords(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, true);
    }

    private String getMessaggio(String prefix, String keyMsgPersonalizzato, boolean replaceKeywords) {
        if (this.msgDiagPropertiesReader == null) {
            return "PropertiesReader dei Messaggi Diagnostici non inizializzato";
        }
        Object msgTmp = this.msgDiagPropertiesReader.getMessaggio(prefix, keyMsgPersonalizzato);
        if (msgTmp == null) {
            msgTmp = "Messaggio diagnostico [" + prefix + keyMsgPersonalizzato + "] non definito nella configurazione della porta di dominio??";
        }
        if (replaceKeywords) {
            String msgReplaceKey = this.replaceKeywords((String)msgTmp);
            return msgReplaceKey;
        }
        return msgTmp;
    }

    private void setEmitErrorConditionInContext(int livelloLog) {
        if (this.pddContext != null && livelloLog <= 2 && !this.pddContext.containsKey(Costanti.EMESSI_DIAGNOSTICI_ERRORE)) {
            this.pddContext.addObject(Costanti.EMESSI_DIAGNOSTICI_ERRORE, (Object)"true");
        }
    }

    public void emitRicezioneMessaggioModuloBuste(MsgDiagnostico msgDiag, PdDContext pddContext, boolean mittenteAnonimo) {
        if (mittenteAnonimo) {
            msgDiag.logPersonalizzato("ricezioneMessaggio.mittenteAnonimo");
        } else {
            String v;
            if (this.keywordLogPersonalizzati != null && ((v = this.keywordLogPersonalizzati.get("@MITTENTE_BUSTA_RICHIESTA@")) == null || "".equals(v) || "Anonimo".equals(v))) {
                mittenteAnonimo = true;
            }
            if (mittenteAnonimo) {
                msgDiag.logPersonalizzato("ricezioneMessaggio.mittenteAnonimo");
            } else {
                msgDiag.logPersonalizzato("ricezioneMessaggio");
            }
        }
    }

    public void logPersonalizzato_custom(String messaggio, int livelloLog, String codiceDiagnostico) {
        this._logPersonalizzato(null, null, null, messaggio, livelloLog, codiceDiagnostico);
    }

    public void logPersonalizzato_custom(String prefix, String messaggio, int livelloLog, String codiceDiagnostico) {
        this._logPersonalizzato(prefix, null, null, messaggio, livelloLog, codiceDiagnostico);
    }

    public void logPersonalizzato_prefix(String prefix, String idModuloFunzionale, String idDiagnostico) {
        this._logPersonalizzato(prefix, idModuloFunzionale, idDiagnostico, null, null, null);
    }

    public void logPersonalizzato_prefix(String prefix, String idDiagnostico) {
        this._logPersonalizzato(prefix, null, idDiagnostico, null, null, null);
    }

    public void logPersonalizzato(String idModuloFunzionale, String idDiagnostico) {
        this._logPersonalizzato(null, idModuloFunzionale, idDiagnostico, null, null, null);
    }

    public void logPersonalizzato(String idDiagnostico) {
        this._logPersonalizzato(null, null, idDiagnostico, null, null, null);
    }

    private void _logPersonalizzato(String prefix, String idModuloFunzionale, String idDiagnostico, String messaggioFromParam, Integer livelloLogFromParam, String codiceDiagnosticoFromParam) {
        if (this.msgDiagPropertiesReader == null) {
            this.logError("MsgDiagnostico.logPersonalizzato [Risorsa non inizializzata], messaggio per idModuloFunzionale[" + idModuloFunzionale + "] idDiagnostico[" + idDiagnostico + "]");
            return;
        }
        int livelloLog = -1;
        livelloLog = livelloLogFromParam != null ? livelloLogFromParam : (idModuloFunzionale != null ? this.getLivello(idModuloFunzionale, idDiagnostico) : this.getLivello(idDiagnostico));
        int severitaLogEmessoPerFiltro = livelloLog;
        int severitaLivelloOpenSPCoop2 = LogLevels.toIntervalloOpenSPCoop2(livelloLog);
        if (severitaLivelloOpenSPCoop2 < 0 || severitaLivelloOpenSPCoop2 > 7) {
            this.logError("MsgDiagnostico.logPersonalizzato error, conversione a livello OpenSPCoop non riuscita [" + severitaLivelloOpenSPCoop2 + "]");
            return;
        }
        this.setEmitErrorConditionInContext(severitaLivelloOpenSPCoop2);
        Level logLevelseveritaLivelloLog4J = LogLevels.toLog4J(severitaLivelloOpenSPCoop2);
        int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
        if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
            severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
        }
        if (this.severitaPorta != null) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
        }
        try {
            boolean emettiLog;
            boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
            boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
            if (!emettiLogSuFile && !emettiLog) {
                return;
            }
            String messaggio = null;
            String codiceDiagnostico = null;
            if (messaggioFromParam != null) {
                messaggio = messaggioFromParam;
                codiceDiagnostico = codiceDiagnosticoFromParam;
            } else if (idModuloFunzionale != null) {
                messaggio = this.getMessaggio(idModuloFunzionale, idDiagnostico);
                codiceDiagnostico = this.getCodice(idModuloFunzionale, idDiagnostico);
            } else {
                messaggio = this.getMessaggio(idDiagnostico);
                codiceDiagnostico = this.getCodice(idDiagnostico);
            }
            if (messaggio == null) {
                this.logError("MsgDiagnostico.logPersonalizzato error, messaggio non definito.");
                return;
            }
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
            }
            Object msgReplaceKey = this.replaceKeywords(messaggio);
            if (prefix != null) {
                msgReplaceKey = prefix + (String)msgReplaceKey;
            }
            org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloOpenSPCoop2, (String)msgReplaceKey, codiceDiagnostico);
            if (emettiLogSuFile && OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                try {
                    String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                    this.loggerMsgDiagnostico.log(logLevelseveritaLivelloLog4J, xml);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            if (emettiLog) {
                if (msgDiag.getIdTransazione() != null) {
                    if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                        this.logMsgDiagnosticoInTransactionContext(msgDiag);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                } else {
                    String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                    try {
                        this.loggerResource.log(logLevelseveritaLivelloLog4J, message);
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && emettiLogSuFile) {
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(logLevelseveritaLivelloLog4J, message);
                    } else {
                        this.loggerOpenSPCoop2.log(logLevelseveritaLivelloLog4J, message);
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            if (msgReplaceKey != null && severitaLivelloOpenSPCoop2 == 0) {
                this.loggerOpenSPCoop2Fatal.error((String)msgReplaceKey);
            }
        }
        catch (Exception e) {
            this.logError("MsgDiagnostico.logPersonalizzato error " + e.getMessage(), e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    public void addLogPersonalizzato(String idModuloFunzionale, String idDiagnostico, Transaction transaction, StringBuilder errorLog) {
        if (this.msgDiagPropertiesReader == null) {
            this.logError("MsgDiagnostico.logPersonalizzato [Risorsa non inizializzata], messaggio per idModuloFunzionale[" + idModuloFunzionale + "] idDiagnostico[" + idDiagnostico + "]");
            return;
        }
        int livelloLog = -1;
        livelloLog = idModuloFunzionale != null ? this.getLivello(idModuloFunzionale, idDiagnostico) : this.getLivello(idDiagnostico);
        int severitaLogEmessoPerFiltro = livelloLog;
        int severitaLivelloOpenSPCoop2 = LogLevels.toIntervalloOpenSPCoop2(livelloLog);
        if (severitaLivelloOpenSPCoop2 < 0 || severitaLivelloOpenSPCoop2 > 7) {
            this.logError("MsgDiagnostico.logPersonalizzato error, conversione a livello OpenSPCoop non riuscita [" + severitaLivelloOpenSPCoop2 + "]");
            return;
        }
        this.setEmitErrorConditionInContext(severitaLivelloOpenSPCoop2);
        int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
        if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
        }
        if (this.severitaPorta != null) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
        }
        try {
            boolean emettiLog;
            boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
            if (!emettiLog) {
                return;
            }
            String messaggio = null;
            String codiceDiagnostico = null;
            if (idModuloFunzionale != null) {
                messaggio = this.getMessaggio(idModuloFunzionale, idDiagnostico);
                codiceDiagnostico = this.getCodice(idModuloFunzionale, idDiagnostico);
            } else {
                messaggio = this.getMessaggio(idDiagnostico);
                codiceDiagnostico = this.getCodice(idDiagnostico);
            }
            if (messaggio == null) {
                this.logError("MsgDiagnostico.logPersonalizzato error, messaggio non definito.");
                return;
            }
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
            }
            String msgReplaceKey = this.replaceKeywords(messaggio);
            org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloOpenSPCoop2, msgReplaceKey, codiceDiagnostico);
            if (errorLog != null) {
                errorLog.append(msgDiag.getMessaggio());
            }
            transaction.addMsgDiagnostico(msgDiag);
        }
        catch (Exception e) {
            this.logError("MsgDiagnostico.logPersonalizzato error " + e.getMessage(), e);
        }
    }

    public void logErroreGenerico(Throwable e, String posizioneErrore) {
        String msg = e != null ? Utilities.readFirstErrorValidMessageFromException((Throwable)e) : "Internal Error";
        this.logErroreGenerico(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(posizioneErrore + ": " + msg, e);
        }
    }

    public void logErroreGenerico(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenerico");
    }

    public void logFatalError(Throwable e, String posizioneErrore) {
        String msg = e != null ? Utilities.readFirstErrorValidMessageFromException((Throwable)e) : "Internal Error";
        this.logFatalError(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(posizioneErrore + ": " + msg, e);
        }
    }

    public void logFatalError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenericoMalfunzionamentoPdD");
    }

    public void logStartupError(Throwable e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logStartupError(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(posizioneErrore + ": " + msg, e);
        }
    }

    public void logStartupError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("openspcoopStartup.", "erroreGenerico");
    }

    public void logDisconnectError(Throwable e, String url) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logDisconnectError(msg, url);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(url + ": " + msg, e);
        }
    }

    public void logDisconnectError(String message, String url) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", url);
        this.logPersonalizzato("all.", "connessioneUscita.disconnectError");
    }

    @Deprecated
    public void fatal(String msg) {
        String codiceDiagnostico = null;
        this.setEmitErrorConditionInContext(0);
        int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(0);
        int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
        if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
            severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
        }
        if (this.severitaPorta != null) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
        }
        try {
            boolean emettiLog;
            boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
            boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
            if (!emettiLogSuFile && !emettiLog) {
                return;
            }
            codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoFatal();
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
            }
            org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
            if (emettiLogSuFile) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                    try {
                        String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                        this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_FATAL, xml);
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            if (emettiLog) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                if (msgDiag.getIdTransazione() != null) {
                    if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                        this.logMsgDiagnosticoInTransactionContext(msgDiag);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                } else {
                    String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                    try {
                        this.loggerResource.log(LogLevels.LOG_LEVEL_FATAL, message);
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && emettiLogSuFile) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_FATAL, message);
                    } else {
                        this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_FATAL, message);
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            this.loggerOpenSPCoop2Fatal.error(msg);
        }
        catch (Exception e) {
            this.logError("MsgDiagnostico.fatalOpenSPCoop error " + e.getMessage(), e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    @Deprecated
    public void errorProtocol(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(1);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(1);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoErrorProtocol();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_ERROR_PROTOCOL, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_ERROR_PROTOCOL, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_ERROR_PROTOCOL, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_ERROR_PROTOCOL, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.errorProtocol error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void errorIntegration(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(2);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(2);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoErrorIntegration();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_ERROR_INTEGRATION, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_ERROR_INTEGRATION, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_ERROR_INTEGRATION, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_ERROR_INTEGRATION, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.errorIntegration error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoProtocol(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(3);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(3);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoInfoProtocol();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_INFO_PROTOCOL, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_INFO_PROTOCOL, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_INFO_PROTOCOL, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_INFO_PROTOCOL, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.infoProtocol error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoIntegration(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(4);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(4);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoInfoIntegration();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_INFO_INTEGRATION, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_INFO_INTEGRATION, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_INFO_INTEGRATION, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_INFO_INTEGRATION, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.infoIntegration error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void lowDebug(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(5);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(5);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugLow();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_DEBUG_LOW, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_DEBUG_LOW, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_DEBUG_LOW, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_DEBUG_LOW, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.lowDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void mediumDebug(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(6);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(6);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugMedium();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_DEBUG_MEDIUM, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_DEBUG_MEDIUM, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_DEBUG_MEDIUM, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_DEBUG_MEDIUM, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.mediumDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void highDebug(String msg) {
        block25: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(7);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(7);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnosticoOpenSPCoop2level7();
            ConfigurazionePdDManager configurazionePdDReader = this.getConfigurazionePdDManager();
            if (configurazionePdDReader != null && configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaMessaggiDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(configurazionePdDReader.getSeveritaLog4JMessaggiDiagnostici());
            }
            if (this.severitaPorta != null) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(LogLevels.toOpenSPCoop2(this.severitaPorta.getValue()));
            }
            try {
                boolean emettiLog;
                boolean emettiLogSuFile = severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD;
                boolean bl = emettiLog = severitaLogEmessoPerFiltro <= severitaRichiestaPdD;
                if (!emettiLogSuFile && !emettiLog) {
                    return;
                }
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugHigh();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (emettiLogSuFile) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag, TipoSerializzazione.DEFAULT);
                            this.loggerMsgDiagnostico.log(LogLevels.LOG_LEVEL_DEBUG_HIGH, xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (emettiLog) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                    }
                    if (msgDiag.getIdTransazione() != null) {
                        if (this.openspcoopProperties.isTransazioniSaveDiagnosticiInUniqueTransaction()) {
                            this.logMsgDiagnosticoInTransactionContext(msgDiag);
                        }
                        for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                            try {
                                this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                                continue;
                            }
                            catch (Exception e) {
                                this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                                this.gestioneErroreDiagnostica(e);
                            }
                        }
                    } else {
                        String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                        try {
                            this.loggerResource.log(LogLevels.LOG_LEVEL_DEBUG_HIGH, message);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico 'human readable' nel log delle risorse (id transazione non fornito): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || !emettiLogSuFile) break block25;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log(LogLevels.LOG_LEVEL_DEBUG_HIGH, message);
                        break block25;
                    }
                    this.loggerOpenSPCoop2.log(LogLevels.LOG_LEVEL_DEBUG_HIGH, message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.highDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    private void logMsgDiagnosticoInTransactionContext(org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag) {
        if (this.transazioneApplicativoServer != null) {
            try {
                msgDiag.setIdTransazione(this.transazioneApplicativoServer.getIdTransazione());
                msgDiag.setApplicativo(this.transazioneApplicativoServer.getServizioApplicativoErogatore());
                GestoreConsegnaMultipla.getInstance().safeSave(msgDiag, this.idPortaApplicativa, this.getValidConnectionState(), this.requestInfo, this.pddContext);
            }
            catch (Throwable t) {
                this.logError("Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                this.gestioneErroreDiagnostica(t);
            }
        } else {
            Exception exc;
            block12: {
                exc = null;
                boolean gestioneStateful = false;
                try {
                    Transaction tr = TransactionContext.getTransaction(msgDiag.getIdTransazione());
                    tr.addMsgDiagnostico(msgDiag);
                }
                catch (TransactionDeletedException e) {
                    gestioneStateful = true;
                }
                catch (TransactionNotExistsException e) {
                    gestioneStateful = true;
                }
                catch (Exception e) {
                    exc = e;
                }
                if (gestioneStateful) {
                    try {
                        RepositoryGestioneStateful.addMsgDiagnostico(msgDiag.getIdTransazione(), msgDiag);
                    }
                    catch (Exception e) {
                        if (IntegrationManager.ID_MODULO.equals(this.idModulo) || ("[" + PostOutResponseHandler.class.getName() + "] invocazione terminata").equals(msgDiag.getMessaggio())) break block12;
                        exc = e;
                    }
                }
            }
            if (exc != null) {
                this.logError("Errore durante l'emissione del msg diagnostico nel contesto della transazione: " + exc.getMessage(), exc);
                this.gestioneErroreDiagnostica(exc);
            }
        }
    }

    private org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico getMsgDiagnostico(Date gdo, int severitaLivelloOpenSPCoop2, String msg, String codiceDiagnostico) {
        List keys;
        org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiagnostico = new org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico();
        if (this.pddContext != null && this.pddContext.containsKey(Costanti.ID_TRANSAZIONE)) {
            msgDiagnostico.setIdTransazione((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
        }
        msgDiagnostico.setGdo(gdo);
        msgDiagnostico.setIdSoggetto(this.idSoggettoDominio);
        msgDiagnostico.setIdFunzione(this.idModulo);
        msgDiagnostico.setSeverita(severitaLivelloOpenSPCoop2);
        msgDiagnostico.setMessaggio(msg);
        msgDiagnostico.setIdBusta(this.idMessaggioRichiesta);
        msgDiagnostico.setIdBustaRisposta(this.idMessaggioRisposta);
        msgDiagnostico.setCodice(codiceDiagnostico);
        msgDiagnostico.setApplicativo(this.servizioApplicativo);
        msgDiagnostico.setProtocollo(this.protocolFactory.getProtocol());
        if (this.pddContext != null && (keys = Costanti.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < keys.size(); ++j) {
                MapKey mapKey = (MapKey)keys.get(j);
                Object o = this.pddContext.getObject(mapKey);
                if (o == null || !(o instanceof String)) continue;
                msgDiagnostico.addProperty((String)((Object)mapKey.getValue()), (String)o);
            }
        }
        if (this.properties != null) {
            this.properties.forEach((k, v) -> msgDiagnostico.addProperty(k, v));
        }
        return msgDiagnostico;
    }

    private void gestioneErroreDiagnostica(Throwable e) {
        if (this.openspcoopProperties.isRegistrazioneDiagnosticaFallita_BloccoServiziPdD()) {
            gestoreDiagnosticaDisponibile = false;
            motivoMalfunzionamentoDiagnostici = e;
            this.logError("Il Sistema di gestione della diagnostica ha rilevato un errore durante la registrazione di un messaggio diagnostico, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio di GovWay. Errore rilevato: ", e);
        }
    }

    private void logError(String msgErrore, Throwable e) {
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(msgErrore, e);
        } else if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error(msgErrore, e);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error(msgErrore, e);
        }
    }

    private void logError(String msgErrore) {
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error(msgErrore);
        } else if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error(msgErrore);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error(msgErrore);
        }
    }
}

