/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import jakarta.mail.BodyPart;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPFault;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.MultipartContent;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.TracciaBuilder;
import org.openspcoop2.protocol.sdk.Allegato;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.slf4j.Logger;

public class Tracciamento {
    public static boolean tracciamentoDisponibile = true;
    public static Exception motivoMalfunzionamentoTracciamento = null;
    protected Logger loggerTracciamento = null;
    private TipoPdD tipoPdD;
    private IDSoggetto idSoggettoDominio;
    private PdDContext pddContext;
    private RequestInfo requestInfo = null;
    private ProtocolFactoryManager protocolFactoryManager = null;
    private IProtocolFactory<?> protocolFactory;
    private boolean tracciamentoSupportatoProtocollo = true;
    private List<ITracciaProducer> loggerTracciamentoOpenSPCoopAppender = null;
    private List<String> tipoTracciamentoOpenSPCoopAppender = null;
    private ConfigurazionePdDManager _configurazionePdDReader;
    private StateMessage state = null;
    private StateMessage responseState = null;
    private TracciaBuilder xmlBuilder;
    private MsgDiagnostico msgDiagErroreTracciamento = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;
    private Transaction transactionNullable = null;

    public static String createLocationString(boolean bustaRicevuta, String location) {
        if (bustaRicevuta) {
            return ConnettoreUtils.limitLocation255Character("IN:" + location);
        }
        return ConnettoreUtils.limitLocation255Character("OUT:" + location);
    }

    public Tracciamento(IDSoggetto idSoggettoDominio, String idFunzione, PdDContext pddContext, TipoPdD tipoPdD, String nomePorta, ConfigurazionePdDManager configurazionePdDManager) throws TracciamentoException {
        this(idSoggettoDominio, idFunzione, pddContext, tipoPdD, nomePorta, configurazionePdDManager, null, null);
    }

    private Tracciamento(IDSoggetto idSoggettoDominio, String idFunzione, PdDContext pddContext, TipoPdD tipoPdD, String nomePorta, ConfigurazionePdDManager configurazionePdDManagerParam, IState stateParam, IState responseStateParam) throws TracciamentoException {
        this.idSoggettoDominio = idSoggettoDominio;
        this.pddContext = pddContext;
        this.tipoPdD = tipoPdD;
        this.loggerTracciamento = OpenSPCoop2Logger.loggerTracciamento;
        this.loggerTracciamentoOpenSPCoopAppender = OpenSPCoop2Logger.loggerTracciamentoOpenSPCoopAppender;
        this.tipoTracciamentoOpenSPCoopAppender = OpenSPCoop2Logger.tipoTracciamentoOpenSPCoopAppender;
        if (configurazionePdDManagerParam != null) {
            this._configurazionePdDReader = configurazionePdDManagerParam;
            this.state = this._configurazionePdDReader.getState();
            this.responseState = this._configurazionePdDReader.getResponseState();
        } else {
            if (stateParam != null && stateParam instanceof StateMessage) {
                this.state = (StateMessage)stateParam;
            }
            if (responseStateParam != null && responseStateParam instanceof StateMessage) {
                this.responseState = (StateMessage)responseStateParam;
            }
            this._configurazionePdDReader = ConfigurazionePdDManager.getInstance(this.state, this.responseState);
        }
        if (pddContext != null && pddContext.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        }
        this.msgDiagErroreTracciamento = MsgDiagnostico.newInstance(tipoPdD, idSoggettoDominio, idFunzione, nomePorta, this.requestInfo, this._configurazionePdDReader);
        this.msgDiagErroreTracciamento.setPrefixMsgPersonalizzati("tracciamento.");
        try {
            if (this.pddContext == null) {
                throw new Exception("PdDContext is null");
            }
            this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
            this.protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)this.pddContext.getObject(Costanti.PROTOCOL_NAME));
            this.tracciamentoSupportatoProtocollo = this.protocolFactory.createProtocolConfiguration().isAbilitataGenerazioneTracce();
        }
        catch (Throwable e) {
            throw new TracciamentoException(e.getMessage(), e);
        }
        this.xmlBuilder = new TracciaBuilder(this.protocolFactory);
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
        try {
            if (this.pddContext != null && this.pddContext.containsKey(Costanti.ID_TRANSAZIONE)) {
                String idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
                this.transactionNullable = TransactionContext.getTransaction(idTransazione);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ConfigurazionePdDManager getConfigurazionePdDManager() {
        if (this._configurazionePdDReader != null) {
            return this._configurazionePdDReader;
        }
        if (this.state != null || this.responseState != null) {
            return ConfigurazionePdDManager.getInstance(this.state, this.responseState);
        }
        return ConfigurazionePdDManager.getInstance();
    }

    public void updateState(IState requestStateParam, IState responseStateParam) {
        StateMessage requestState = null;
        StateMessage responseState = null;
        if (requestStateParam != null && requestStateParam instanceof StateMessage) {
            requestState = (StateMessage)requestStateParam;
        }
        if (responseStateParam != null && responseStateParam instanceof StateMessage) {
            responseState = (StateMessage)responseStateParam;
        }
        this.updateState(requestState, responseState);
    }

    public void updateState(StateMessage requestState, StateMessage responseState) {
        this.state = requestState;
        this.responseState = responseState;
        this._configurazionePdDReader = this.state != null || this.responseState != null ? (this._configurazionePdDReader != null ? this._configurazionePdDReader.refreshState(this.state, this.responseState) : ConfigurazionePdDManager.getInstance(this.state, this.responseState)) : ConfigurazionePdDManager.getInstance();
    }

    public void updateState(ConfigurazionePdDManager configurazionePdDManager) {
        this._configurazionePdDReader = configurazionePdDManager;
        if (this._configurazionePdDReader != null) {
            this.state = this._configurazionePdDReader.getState();
            this.responseState = this._configurazionePdDReader.getResponseState();
        }
    }

    public void setDominio(IDSoggetto dominio) {
        this.idSoggettoDominio = dominio;
    }

    private Connection getConnectionFromState(boolean richiesta) {
        if (richiesta) {
            Connection c = StateMessage.getConnection((StateMessage)this.state);
            if (c != null) {
                return c;
            }
        } else {
            Connection c = StateMessage.getConnection((StateMessage)this.responseState);
            if (c != null) {
                return c;
            }
        }
        return null;
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, esito, location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        block24: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRichiesta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block24;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    busta.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(busta, msg, securityInfo, esito, gdo, RuoloMessaggio.RICHIESTA, location, idCorrelazioneApplicativa);
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, true);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRichiesta();
                }
            }
        }
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, bustaObject, esito, location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        block24: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRichiesta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block24;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    bustaObject.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, RuoloMessaggio.RICHIESTA, location, idCorrelazioneApplicativa);
                traccia.setBustaAsByteArray(busta);
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, true);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRichiesta();
                }
            }
        }
    }

    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, BustaRawContent<?> busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, bustaObject, esito, location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, BustaRawContent<?> busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        block27: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRichiesta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block27;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    bustaObject.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, RuoloMessaggio.RICHIESTA, location, idCorrelazioneApplicativa);
                boolean saveHeader = true;
                try {
                    saveHeader = this.protocolFactory == null || this.protocolFactory.createProtocolConfiguration().isAbilitatoSalvataggioHeaderProtocolloTracce();
                }
                catch (Throwable e) {
                    this.logError("Comprensione opzione 'salvataggio header protocollo tracce' fallita: " + e.getMessage(), new Exception(e));
                }
                if (saveHeader) {
                    traccia.setBustaAsRawContent(busta);
                }
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, true);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RICHIESTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRichiesta();
                }
            }
        }
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, esito, location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        block24: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRisposta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block24;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    busta.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(busta, msg, securityInfo, esito, gdo, RuoloMessaggio.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, false);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRisposta();
                }
            }
        }
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, bustaObject, esito, location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        block24: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRisposta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block24;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    bustaObject.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, RuoloMessaggio.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                traccia.setBustaAsByteArray(busta);
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, false);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRisposta();
                }
            }
        }
    }

    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, BustaRawContent<?> busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, bustaObject, esito, location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, BustaRawContent<?> busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        block27: {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().startTracciamentoRisposta();
            }
            try {
                if (!this.tracciamentoSupportatoProtocollo || !this.getConfigurazionePdDManager().tracciamentoBuste()) break block27;
                String xml = null;
                boolean erroreAppender = false;
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject(Costanti.ID_TRANSAZIONE) != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                    bustaObject.setOraRegistrazione(gdo);
                }
                Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, RuoloMessaggio.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
                boolean saveHeader = true;
                try {
                    saveHeader = this.protocolFactory == null || this.protocolFactory.createProtocolConfiguration().isAbilitatoSalvataggioHeaderProtocolloTracce();
                }
                catch (Throwable e) {
                    this.logError("Comprensione opzione 'salvataggio header protocollo tracce' fallita: " + e.getMessage(), new Exception(e));
                }
                if (saveHeader) {
                    traccia.setBustaAsRawContent(busta);
                }
                try {
                    if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        if (xml == null) {
                            throw new Exception("Traccia non costruita");
                        }
                        this.loggerTracciamento.info(xml);
                    }
                    if (this.openspcoopProperties.isTransazioniSaveTracceInUniqueTransaction()) {
                        this.logTracciaInTransactionContext(traccia, false);
                    }
                    for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                            erroreAppender = true;
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                        try {
                            xml = this.xmlBuilder.toString(traccia, TipoSerializzazione.DEFAULT);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (xml == null) {
                        this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                    } else {
                        this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        if (!erroreAppender) {
                            try {
                                this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", RuoloMessaggio.RISPOSTA.toString());
                                this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                                this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                                this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.gestioneErroreTracciamento(e);
                }
            }
            finally {
                if (this.transactionNullable != null) {
                    this.transactionNullable.getTempiElaborazione().endTracciamentoRisposta();
                }
            }
        }
    }

    private void logTracciaInTransactionContext(Traccia traccia, boolean richiesta) throws TracciamentoException {
        Exception exc = null;
        boolean gestioneStateful = false;
        try {
            Transaction tr = TransactionContext.getTransaction(traccia.getIdTransazione());
            if (richiesta) {
                tr.setTracciaRichiesta(traccia);
            } else {
                tr.setTracciaRisposta(traccia);
            }
        }
        catch (TransactionDeletedException e) {
            gestioneStateful = true;
        }
        catch (TransactionNotExistsException e) {
            gestioneStateful = true;
        }
        catch (Exception e) {
            exc = e;
        }
        if (gestioneStateful) {
            try {
                RepositoryGestioneStateful.addTraccia(traccia.getIdTransazione(), traccia);
            }
            catch (Exception e) {
                exc = e;
            }
        }
        if (exc != null) {
            this.logError("Errore durante l'emissione della traccia nel contesto della transazione: " + exc.getMessage(), exc);
            this.gestioneErroreTracciamento(exc);
        }
    }

    private Traccia getTraccia(Busta busta, OpenSPCoop2Message msg, SecurityInfo securityInfo, EsitoElaborazioneMessaggioTracciato esito, Date gdo, RuoloMessaggio tipoTraccia, String location, String idCorrelazioneApplicativa) {
        return this.getTraccia(busta, msg, securityInfo, esito, gdo, tipoTraccia, location, idCorrelazioneApplicativa, null);
    }

    private Traccia getTraccia(Busta busta, OpenSPCoop2Message msg, SecurityInfo securityInfo, EsitoElaborazioneMessaggioTracciato esito, Date gdo, RuoloMessaggio tipoTraccia, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) {
        List keys;
        Traccia traccia = new Traccia();
        if (this.pddContext != null) {
            traccia.setIdTransazione((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
        }
        traccia.setEsitoElaborazioneMessaggioTracciato(esito);
        try {
            if (RuoloMessaggio.RISPOSTA.equals((Object)tipoTraccia) && msg != null) {
                Object bout;
                StringBuilder bf;
                boolean found = false;
                if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                    if (msg.castAsSoap().hasSOAPFault()) {
                        SOAPBody body = msg.castAsSoap().getSOAPBody();
                        found = true;
                        bf = new StringBuilder();
                        if (esito.getDettaglio() != null) {
                            bf.append(esito.getDettaglio());
                            bf.append("\n");
                        }
                        bf.append(SoapUtils.safe_toString((OpenSPCoop2MessageFactory)msg.getFactory(), (SOAPFault)body.getFault(), (Logger)OpenSPCoop2Logger.loggerOpenSPCoopCore));
                        traccia.getEsitoElaborazioneMessaggioTracciato().setDettaglio(bf.toString());
                    }
                } else if (msg.castAsRest().isProblemDetailsForHttpApis_RFC7807()) {
                    found = true;
                    bout = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)bout, false);
                    ((OutputStream)bout).flush();
                    ((ByteArrayOutputStream)bout).close();
                    bf = new StringBuilder();
                    if (esito.getDettaglio() != null) {
                        bf.append(esito.getDettaglio());
                        bf.append("\n");
                    }
                    bf.append(((ByteArrayOutputStream)bout).toString());
                    traccia.getEsitoElaborazioneMessaggioTracciato().setDettaglio(bf.toString());
                }
                if (!found && MessageRole.FAULT.equals((Object)msg.getMessageRole())) {
                    bout = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)bout, false);
                    ((OutputStream)bout).flush();
                    ((ByteArrayOutputStream)bout).close();
                    bf = new StringBuilder();
                    if (esito.getDettaglio() != null) {
                        bf.append(esito.getDettaglio());
                        bf.append("\n");
                    }
                    bf.append(((ByteArrayOutputStream)bout).toString());
                    traccia.getEsitoElaborazioneMessaggioTracciato().setDettaglio(bf.toString());
                }
            }
        }
        catch (Exception e) {
            this.logError("errore durante la registrazione del SOAPFault nelle tracce", e);
        }
        traccia.setGdo(gdo);
        traccia.setIdSoggetto(this.idSoggettoDominio);
        traccia.setTipoMessaggio(tipoTraccia);
        traccia.setTipoPdD(this.tipoPdD);
        traccia.setCorrelazioneApplicativa(idCorrelazioneApplicativa);
        traccia.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        if (location != null) {
            if (location.length() > 230) {
                traccia.setLocation(location.substring(0, 230) + " ...");
            } else {
                traccia.setLocation(location);
            }
        }
        traccia.setProtocollo(this.protocolFactory.getProtocol());
        if (securityInfo != null) {
            busta.setDigest(securityInfo.getDigestHeader());
            Map properties = securityInfo.getProperties();
            if (properties != null && !properties.isEmpty()) {
                for (String key : properties.keySet()) {
                    busta.addProperty(key, (String)properties.get(key));
                }
            }
        }
        traccia.setBusta(busta);
        if (msg != null) {
            try {
                MimeMultipart mime;
                MultipartContent mc;
                if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                    if (msg.isContentBuilded() && msg.castAsSoap().hasAttachments()) {
                        Iterator it = msg.castAsSoap().getAttachments();
                        while (it.hasNext()) {
                            AttachmentPart ap = (AttachmentPart)it.next();
                            Allegato allegato = new Allegato();
                            allegato.setContentId(ap.getContentId());
                            allegato.setContentLocation(ap.getContentLocation());
                            allegato.setContentType(ap.getContentType());
                            if (securityInfo != null && ap.getContentId() != null) {
                                for (int i = 0; i < securityInfo.sizeListaAllegati(); ++i) {
                                    Allegato a = securityInfo.getAllegato(i);
                                    if (a.getContentId() == null || !a.getContentId().equals(ap.getContentId())) continue;
                                    allegato.setDigest(a.getDigest());
                                }
                            }
                            traccia.addAllegato(allegato);
                        }
                    }
                } else if (MessageType.MIME_MULTIPART.equals((Object)msg.getMessageType()) && msg.isContentBuilded() && (mc = (MultipartContent)msg.castAsRestMimeMultipart().getContent()) != null && (mime = mc.getMimeMultipart()) != null) {
                    for (int i = 0; i < mime.countBodyParts(); ++i) {
                        BodyPart bodyPart = mime.getBodyPart(i);
                        String contentId = mime.getContentID(bodyPart);
                        if (contentId == null) {
                            contentId = mime.getContentDisposition(bodyPart);
                        }
                        Allegato allegato = new Allegato();
                        allegato.setContentId(contentId);
                        allegato.setContentLocation(mime.getContentLocation(bodyPart));
                        allegato.setContentType(bodyPart.getContentType());
                        if (securityInfo != null && contentId != null) {
                            for (int j = 0; j < securityInfo.sizeListaAllegati(); ++j) {
                                Allegato a = securityInfo.getAllegato(j);
                                if (a.getContentId() == null || !a.getContentId().equals(contentId)) continue;
                                allegato.setDigest(a.getDigest());
                            }
                        }
                        traccia.addAllegato(allegato);
                    }
                }
            }
            catch (Exception e) {
                this.logError("errore durante la registrazione degli allegati nelle tracce", e);
            }
        }
        if (this.pddContext != null && (keys = Costanti.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < keys.size(); ++j) {
                MapKey mapKey = (MapKey)keys.get(j);
                Object o = this.pddContext.getObject(mapKey);
                if (o == null || !(o instanceof String)) continue;
                traccia.addProperty((String)((Object)mapKey.getValue()), (String)o);
            }
        }
        return traccia;
    }

    private void gestioneErroreTracciamento(Exception e) throws TracciamentoException {
        if (this.openspcoopProperties.isTracciaturaFallita_BloccoServiziPdD()) {
            tracciamentoDisponibile = false;
            motivoMalfunzionamentoTracciamento = e;
            try {
                this.msgDiagErroreTracciamento.logPersonalizzato("errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError("Il Sistema di tracciamento ha rilevato un errore durante la registrazione di una traccia legale, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio di GovWay. Errore rilevato: ", e);
        }
        if (this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) {
            throw new TracciamentoException((Throwable)e);
        }
    }

    private void logError(String msgErrore, Exception e) {
        if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error(msgErrore, (Throwable)e);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error(msgErrore, (Throwable)e);
        }
    }

    private void logError(String msgErrore) {
        if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error(msgErrore);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error(msgErrore);
        }
    }
}

