/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.diagnostica;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.logger.diagnostica.DynamicExtendedInfoDiagnosticoType;

public class DynamicExtendedInfoDiagnostico {
    private DynamicExtendedInfoDiagnosticoType type;
    private int diagnosticPosition;
    private String value;

    public DynamicExtendedInfoDiagnostico(DynamicExtendedInfoDiagnosticoType type, int diagnosticPosition, String value) {
        this.type = type;
        this.diagnosticPosition = diagnosticPosition;
        this.value = value;
    }

    public DynamicExtendedInfoDiagnosticoType getType() {
        return this.type;
    }

    public void setType(DynamicExtendedInfoDiagnosticoType type) {
        this.type = type;
    }

    public int getDiagnosticPosition() {
        return this.diagnosticPosition;
    }

    public void setDiagnosticPosition(int diagnosticPosition) {
        this.diagnosticPosition = diagnosticPosition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String convertToDBValue() {
        StringBuilder bf = new StringBuilder();
        bf.append(this.type.getValue());
        bf.append(" ");
        bf.append(this.diagnosticPosition);
        bf.append(" ");
        bf.append(this.value);
        return bf.toString();
    }

    public static DynamicExtendedInfoDiagnostico convertoFromDBColumnValue(String dbValue) throws CoreException {
        if (dbValue == null) {
            throw new CoreException("Parameter dbValue not defined");
        }
        if (!dbValue.contains(" ")) {
            throw new CoreException("Parameter dbValue with wrong format ( )");
        }
        int indexType = dbValue.indexOf(" ");
        if (indexType <= 0) {
            throw new CoreException("Parameter dbValue with wrong format (indexType:" + indexType + ")");
        }
        if (indexType == dbValue.length()) {
            throw new CoreException("Parameter dbValue with wrong format (indexType:" + indexType + " equals length)");
        }
        String tipo = dbValue.substring(0, indexType);
        DynamicExtendedInfoDiagnosticoType type = null;
        try {
            type = DynamicExtendedInfoDiagnosticoType.getEnum(tipo);
        }
        catch (Exception e) {
            throw new CoreException("Parameter dbValue with wrong format (type unknwon '" + tipo + "')");
        }
        int indexPosition = dbValue.indexOf(" ", tipo.length() + 1);
        String prefixIndexPosition = "Parameter dbValue with wrong format (indexPosition:" + indexPosition;
        if (indexPosition <= 0) {
            throw new CoreException(prefixIndexPosition + ")");
        }
        if (indexPosition == dbValue.length()) {
            throw new CoreException(prefixIndexPosition + " equals length)");
        }
        String tmpPosition = dbValue.substring(tipo.length() + 1, indexPosition);
        int position = -1;
        try {
            position = Integer.parseInt(tmpPosition);
        }
        catch (Exception e) {
            throw new CoreException(prefixIndexPosition + " format to int [" + tmpPosition + "] error) " + e.getMessage(), (Throwable)e);
        }
        String value = dbValue.substring(indexPosition + 1, dbValue.length());
        if (value == null || "".equals(value)) {
            throw new CoreException("Parameter dbValue with wrong format (value undefined)");
        }
        return new DynamicExtendedInfoDiagnostico(type, position, value);
    }
}

