/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.diagnostica;

import java.util.Calendar;
import java.util.Date;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;

public class InfoDiagnostico {
    private Date gdoFirstDiagnostic;
    private Date gdo;
    private String code;

    public Date getGdo() {
        return this.gdo;
    }

    public String getCode() {
        return this.code;
    }

    public InfoDiagnostico(Date gdoFirstDiagnostic, MsgDiagnostico msgDiag) {
        this.gdoFirstDiagnostic = gdoFirstDiagnostic;
        this.gdo = msgDiag.getGdo();
        this.code = msgDiag.getCodice();
    }

    private InfoDiagnostico(Date gdoFirstDiagnostic) {
        this.gdoFirstDiagnostic = gdoFirstDiagnostic;
    }

    public String convertToDBValue() {
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultTimeFormatter((String)"HHmmssSSS");
        StringBuilder bf = new StringBuilder();
        bf.append(this.code);
        bf.append(dateformat.format(this.gdo));
        bf.append(InfoDiagnostico.diffDay(this.gdo, this.gdoFirstDiagnostic));
        return bf.toString();
    }

    public static InfoDiagnostico convertoFromDBColumnValue(Date gdoFirstDiagnostic, String dbValue) throws CoreException {
        if (gdoFirstDiagnostic == null) {
            throw new CoreException("Parameter gdoFirstDiagnostic not defined");
        }
        if (dbValue == null) {
            throw new CoreException("Parameter dbValue not defined");
        }
        if (dbValue.length() != 16) {
            throw new CoreException("Formato diagnostico[" + dbValue + "] possiede una lunghezza [" + dbValue.length() + "] differente da quella attesa di 16 caratteri (CODICEHHmmssSSST)");
        }
        InfoDiagnostico info = new InfoDiagnostico(gdoFirstDiagnostic);
        info.code = dbValue.substring(0, 6);
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateFormatter((String)"yyyyMMdd");
        String data = dateformat.format(gdoFirstDiagnostic);
        String dataConTime = data + dbValue.substring(6, 6 + "HHmmssSSS".length());
        dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyyMMddHHmmssSSS");
        Date gdo = null;
        try {
            gdo = dateformat.parse(dataConTime);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
        long dayDiff = InfoDiagnostico.diffDay(gdoFirstDiagnostic, gdo);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(gdo);
        calendar.add(6, (int)dayDiff);
        info.gdo = calendar.getTime();
        return info;
    }

    public static long diffDay(Date gdoFirstDiagnosticParam, Date gdo) {
        return (gdo.getTime() - gdoFirstDiagnosticParam.getTime()) / 86400000L;
    }
}

