/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.logger.transazioni.TransazioneUtilities;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;

public class InfoConfigurazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String KEYS_SEPARATOR = ",";
    protected static final String PROPERTY_SEPARATOR = " ";
    protected static final String VALUE_SEPARATOR = "=";
    private Map<String, String> context;
    private Map<String, String> apiImplProperties;
    private Map<String, String> soggettoFruitoreProperties;
    private Map<String, String> soggettoErogatoreProperties;
    private Map<String, String> applicativoFruitoreProperties;
    private Map<String, String> tokenClientApplicationProperties;
    private Map<String, String> tokenClientOrganizationProperties;
    private String nomeConnettoriMultipli;

    public InfoConfigurazione(Transazione transazioneDTO, Context contextGateway, CredenzialiMittente credenzialiMittente) {
        block42: {
            ServizioApplicativo sa2;
            Soggetto soggetto2;
            this.context = new HashMap<String, String>();
            this.apiImplProperties = new HashMap<String, String>();
            this.soggettoFruitoreProperties = new HashMap<String, String>();
            this.soggettoErogatoreProperties = new HashMap<String, String>();
            this.applicativoFruitoreProperties = new HashMap<String, String>();
            this.tokenClientApplicationProperties = new HashMap<String, String>();
            this.tokenClientOrganizationProperties = new HashMap<String, String>();
            this.nomeConnettoriMultipli = null;
            if (contextGateway != null && !contextGateway.isEmpty()) {
                for (MapKey key : contextGateway.keys()) {
                    Object o = contextGateway.getObject(key);
                    if (o == null || !(o instanceof String)) continue;
                    String s = (String)o;
                    this.context.put((String)((Object)key.getValue()), s);
                }
            }
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance();
            RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance();
            IDSoggetto idSoggettoFruitore = null;
            IDSoggetto idSoggettoErogatore = null;
            RequestInfo requestInfo = null;
            if (contextGateway != null) {
                this.nomeConnettoriMultipli = TransazioneUtilities.getConnettoriMultipli(contextGateway);
                if (contextGateway.containsKey(Costanti.REQUEST_INFO)) {
                    try {
                        requestInfo = (RequestInfo)contextGateway.getObject(Costanti.REQUEST_INFO);
                        if (requestInfo.getProtocolContext() != null) {
                            String nomePorta = requestInfo.getProtocolContext().getInterfaceName();
                            if (PddRuolo.DELEGATA.equals((Object)transazioneDTO.getPddRuolo())) {
                                IDPortaDelegata idPD = new IDPortaDelegata();
                                idPD.setNome(nomePorta);
                                PortaDelegata pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                                if (pd != null) {
                                    idSoggettoFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                                    idSoggettoErogatore = new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome());
                                    if (pd.sizeProprietaList() > 0) {
                                        for (Proprieta prop : pd.getProprietaList()) {
                                            if (prop.getNome() == null || prop.getValore() == null) continue;
                                            this.apiImplProperties.put(prop.getNome(), prop.getValore());
                                        }
                                    }
                                }
                            } else {
                                IDPortaApplicativa idPA = new IDPortaApplicativa();
                                idPA.setNome(nomePorta);
                                PortaApplicativa pa = configurazionePdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo);
                                if (pa != null) {
                                    idSoggettoErogatore = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
                                    if (pa.sizeProprietaList() > 0) {
                                        for (Proprieta prop : pa.getProprietaList()) {
                                            if (prop.getNome() == null || prop.getValore() == null) continue;
                                            this.apiImplProperties.put(prop.getNome(), prop.getValore());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable nomePorta) {
                        // empty catch block
                    }
                }
            }
            if (idSoggettoFruitore == null && transazioneDTO.getTipoSoggettoFruitore() != null && transazioneDTO.getNomeSoggettoFruitore() != null) {
                idSoggettoFruitore = new IDSoggetto(transazioneDTO.getTipoSoggettoFruitore(), transazioneDTO.getNomeSoggettoFruitore());
            }
            if (idSoggettoFruitore != null) {
                try {
                    soggetto2 = registroServiziManager.getSoggetto(idSoggettoFruitore, null, requestInfo);
                    if (soggetto2.sizeProprietaList() > 0) {
                        for (Object prop : soggetto2.getProprietaList()) {
                            if (prop.getNome() == null || prop.getValore() == null) continue;
                            this.soggettoFruitoreProperties.put(prop.getNome(), prop.getValore());
                        }
                    }
                }
                catch (Throwable soggetto2) {
                    // empty catch block
                }
                if (transazioneDTO.getServizioApplicativoFruitore() != null) {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setNome(transazioneDTO.getServizioApplicativoFruitore());
                    idSA.setIdSoggettoProprietario(idSoggettoFruitore);
                    try {
                        sa2 = configurazionePdDManager.getServizioApplicativo(idSA, requestInfo);
                        if (sa2.sizeProprietaList() > 0) {
                            for (Proprieta prop : sa2.getProprietaList()) {
                                if (prop.getNome() == null || prop.getValore() == null) continue;
                                this.applicativoFruitoreProperties.put(prop.getNome(), prop.getValore());
                            }
                        }
                    }
                    catch (Throwable sa2) {
                        // empty catch block
                    }
                }
            }
            if (idSoggettoErogatore == null && transazioneDTO.getTipoSoggettoErogatore() != null && transazioneDTO.getNomeSoggettoErogatore() != null) {
                idSoggettoErogatore = new IDSoggetto(transazioneDTO.getTipoSoggettoErogatore(), transazioneDTO.getNomeSoggettoErogatore());
            }
            if (idSoggettoErogatore != null) {
                try {
                    soggetto2 = registroServiziManager.getSoggetto(idSoggettoErogatore, null, requestInfo);
                    if (soggetto2.sizeProprietaList() > 0) {
                        for (Object prop : soggetto2.getProprietaList()) {
                            if (prop.getNome() == null || prop.getValore() == null) continue;
                            this.soggettoErogatoreProperties.put(prop.getNome(), prop.getValore());
                        }
                    }
                }
                catch (Throwable soggetto3) {
                    // empty catch block
                }
            }
            try {
                IDServizioApplicativo tokenClientApplication;
                IDServizioApplicativo iDServizioApplicativo = tokenClientApplication = credenzialiMittente != null && credenzialiMittente.getTokenClientId() != null ? CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)credenzialiMittente.getTokenClientId().getCredenziale()) : null;
                if (tokenClientApplication == null || tokenClientApplication.getNome() == null || tokenClientApplication.getIdSoggettoProprietario() == null || tokenClientApplication.getIdSoggettoProprietario().getTipo() == null || tokenClientApplication.getIdSoggettoProprietario().getNome() == null) break block42;
                try {
                    sa2 = configurazionePdDManager.getServizioApplicativo(tokenClientApplication, requestInfo);
                    if (sa2.sizeProprietaList() > 0) {
                        for (Proprieta prop : sa2.getProprietaList()) {
                            if (prop.getNome() == null || prop.getValore() == null) continue;
                            this.tokenClientApplicationProperties.put(prop.getNome(), prop.getValore());
                        }
                    }
                }
                catch (Throwable sa3) {
                    // empty catch block
                }
                try {
                    Soggetto soggetto4 = registroServiziManager.getSoggetto(tokenClientApplication.getIdSoggettoProprietario(), null, requestInfo);
                    if (soggetto4.sizeProprietaList() > 0) {
                        for (Proprieta prop : soggetto4.getProprietaList()) {
                            if (prop.getNome() == null || prop.getValore() == null) continue;
                            this.tokenClientOrganizationProperties.put(prop.getNome(), prop.getValore());
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getContextProperty(String nome) {
        return this._getProperty(this.context, nome);
    }

    public Map<String, String> getContextProperties(String nome) {
        return this.context;
    }

    public List<String> getContextPropertiesKeys() {
        return this._getPropertiesKeys(this.context);
    }

    public String getContextPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.context, separator);
    }

    public String getContextPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.context, propertySeparator, valueSeparator);
    }

    public String getApiImplProperty(String nome) {
        return this._getProperty(this.apiImplProperties, nome);
    }

    public Map<String, String> getApiImplProperties(String nome) {
        return this.apiImplProperties;
    }

    public List<String> getApiImplPropertiesKeys() {
        return this._getPropertiesKeys(this.apiImplProperties);
    }

    public String getApiImplPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.apiImplProperties, separator);
    }

    public String getApiImplPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.apiImplProperties, propertySeparator, valueSeparator);
    }

    public String getSenderProperty(String nome) {
        return this._getProperty(this.soggettoFruitoreProperties, nome);
    }

    public Map<String, String> getSenderProperties(String nome) {
        return this.soggettoFruitoreProperties;
    }

    public List<String> getSenderPropertiesKeys() {
        return this._getPropertiesKeys(this.soggettoFruitoreProperties);
    }

    public String getSenderPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.soggettoFruitoreProperties, separator);
    }

    public String getSenderPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.soggettoFruitoreProperties, propertySeparator, valueSeparator);
    }

    public String getProviderProperty(String nome) {
        return this._getProperty(this.soggettoErogatoreProperties, nome);
    }

    public Map<String, String> getProviderProperties(String nome) {
        return this.soggettoErogatoreProperties;
    }

    public List<String> getProviderPropertiesKeys() {
        return this._getPropertiesKeys(this.soggettoErogatoreProperties);
    }

    public String getProviderPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.soggettoErogatoreProperties, separator);
    }

    public String getProviderPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.soggettoErogatoreProperties, propertySeparator, valueSeparator);
    }

    public String getApplicationProperty(String nome) {
        return this._getProperty(this.applicativoFruitoreProperties, nome);
    }

    public Map<String, String> getApplicationProperties(String nome) {
        return this.applicativoFruitoreProperties;
    }

    public List<String> getApplicationPropertiesKeys() {
        return this._getPropertiesKeys(this.applicativoFruitoreProperties);
    }

    public String getApplicationPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.applicativoFruitoreProperties, separator);
    }

    public String getApplicationPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.applicativoFruitoreProperties, propertySeparator, valueSeparator);
    }

    public String getTokenClientApplicationProperty(String nome) {
        return this._getProperty(this.tokenClientApplicationProperties, nome);
    }

    public Map<String, String> getTokenClientApplicationProperties(String nome) {
        return this.tokenClientApplicationProperties;
    }

    public List<String> getTokenClientApplicationPropertiesKeys() {
        return this._getPropertiesKeys(this.tokenClientApplicationProperties);
    }

    public String getTokenClientApplicationPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.tokenClientApplicationProperties, separator);
    }

    public String getTokenClientApplicationPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.tokenClientApplicationProperties, propertySeparator, valueSeparator);
    }

    public String getTokenClientOrganizationProperty(String nome) {
        return this._getProperty(this.tokenClientOrganizationProperties, nome);
    }

    public Map<String, String> getTokenClientOrganizationProperties(String nome) {
        return this.tokenClientOrganizationProperties;
    }

    public List<String> getTokenClientOrganizationPropertiesKeys() {
        return this._getPropertiesKeys(this.tokenClientOrganizationProperties);
    }

    public String getTokenClientOrganizationPropertiesKeysAsString(String separator) {
        return this._getPropertiesKeysAsString(this.tokenClientOrganizationProperties, separator);
    }

    public String getTokenClientOrganizationPropertiesAsString(String propertySeparator, String valueSeparator) {
        return this._getPropertiesAsString(this.tokenClientOrganizationProperties, propertySeparator, valueSeparator);
    }

    public String getOutConnectorName() {
        return this.nomeConnettoriMultipli;
    }

    private String _getProperty(Map<String, String> p, String nome) {
        if (p != null) {
            return p.get(nome);
        }
        return null;
    }

    private List<String> _getPropertiesKeys(Map<String, String> p) {
        if (p != null && !p.isEmpty()) {
            ArrayList<String> l = new ArrayList<String>();
            l.addAll(p.keySet());
            return l;
        }
        return null;
    }

    private String _getPropertiesKeysAsString(Map<String, String> p, String separator) {
        if (p != null && !p.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : p.keySet()) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(key);
            }
            return sb.toString();
        }
        return null;
    }

    private String _getPropertiesAsString(Map<String, String> p, String propertySeparator, String valueSeparator) {
        if (p != null && !p.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : p.keySet()) {
                if (sb.length() > 0) {
                    sb.append(propertySeparator);
                }
                sb.append(key);
                sb.append(valueSeparator);
                sb.append(p.get(key));
            }
            return sb.toString();
        }
        return null;
    }
}

