/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.info;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.pdd.logger.info.DatiMittente;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;

public class InfoMittenteFormatUtils {
    private InfoMittenteFormatUtils() {
    }

    public static String getRichiedente(DatiMittente infoDatiMittente) {
        String sTokenUsername = infoDatiMittente.getTokenUsername();
        if (StringUtils.isNotEmpty((CharSequence)sTokenUsername)) {
            return sTokenUsername;
        }
        String sTokenClient = infoDatiMittente.getTokenClient();
        if (StringUtils.isNotEmpty((CharSequence)sTokenClient)) {
            return sTokenClient;
        }
        String sTokenClientPdndOrganizationName = infoDatiMittente.getPdndOrganizationName();
        if (StringUtils.isNotEmpty((CharSequence)sTokenClientPdndOrganizationName)) {
            return sTokenClientPdndOrganizationName;
        }
        String sApplicativoFruitore = infoDatiMittente.getServizioApplicativoFruitore();
        if (StringUtils.isNotEmpty((CharSequence)sApplicativoFruitore)) {
            return sApplicativoFruitore;
        }
        String sTokenClientId = infoDatiMittente.getTokenClientId();
        String sTokenSubject = infoDatiMittente.getTokenSubject();
        boolean clientCredentialsFlow = false;
        if (StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            boolean bl = clientCredentialsFlow = sTokenSubject == null || StringUtils.isEmpty((CharSequence)sTokenSubject) || sTokenSubject.equals(sTokenClientId);
        }
        if (clientCredentialsFlow && StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            return sTokenClientId;
        }
        if (StringUtils.isNotEmpty((CharSequence)sTokenSubject)) {
            String sTokenIssuer = infoDatiMittente.getTokenIssuer();
            if (StringUtils.isNotEmpty((CharSequence)sTokenIssuer)) {
                return sTokenSubject + "@" + sTokenIssuer;
            }
            return sTokenSubject;
        }
        if (!clientCredentialsFlow && StringUtils.isNotEmpty((CharSequence)sTokenClientId)) {
            return sTokenClientId;
        }
        String sTrasporto = InfoMittenteFormatUtils.getRichiedenteTrasporto(infoDatiMittente);
        if (sTrasporto != null) {
            return sTrasporto;
        }
        return null;
    }

    private static String getRichiedenteTrasporto(DatiMittente infoDatiMittente) {
        String sTrasportoMittente = infoDatiMittente.getTrasportoMittente();
        String sTipoTrasportoMittente = infoDatiMittente.getTipoTrasportoMittente();
        if (StringUtils.isNotEmpty((CharSequence)sTrasportoMittente) && StringUtils.isNotEmpty((CharSequence)sTipoTrasportoMittente)) {
            if (sTipoTrasportoMittente.endsWith("_" + TipoAutenticazione.SSL.getValue())) {
                return InfoMittenteFormatUtils.getRichiedenteTrasportoSSLEngine(sTrasportoMittente);
            }
            return sTrasportoMittente;
        }
        return null;
    }

    private static String getRichiedenteTrasportoSSLEngine(String sTrasportoMittente) {
        try {
            List<String> cnList;
            Map l = CertificateUtils.getPrincipalIntoMap((String)sTrasportoMittente, (PrincipalType)PrincipalType.SUBJECT);
            if (l != null && !l.isEmpty() && (cnList = InfoMittenteFormatUtils.getCNList(l)) != null && !cnList.isEmpty()) {
                StringBuilder bfList = new StringBuilder();
                for (String s : cnList) {
                    if (bfList.length() > 0) {
                        bfList.append(", ");
                    }
                    bfList.append(s);
                }
                return bfList.toString();
            }
            return sTrasportoMittente;
        }
        catch (Exception t) {
            return sTrasportoMittente;
        }
    }

    private static List<String> getCNList(Map<String, List<String>> l) {
        List<String> cnList = l.get("CN");
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("cn");
        }
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("Cn");
        }
        if (cnList == null || cnList.isEmpty()) {
            cnList = l.get("cN");
        }
        return cnList;
    }

    public static String getIpRichiedente(DatiMittente infoDatiMittente) {
        String t = infoDatiMittente.getTransportClientAddress();
        if (StringUtils.isNotEmpty((CharSequence)t)) {
            return t;
        }
        String s = infoDatiMittente.getSocketClientAddress();
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return s;
        }
        return null;
    }

    public static String getLabelRichiedenteConFruitore(DatiMittente infoDatiMittente) {
        String sTokenClient;
        StringBuilder bf = new StringBuilder();
        String richiedente = InfoMittenteFormatUtils.getRichiedente(infoDatiMittente);
        if (StringUtils.isNotEmpty((CharSequence)richiedente)) {
            bf.append(richiedente);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sTokenClient = infoDatiMittente.getTokenClient()))) {
            InfoMittenteFormatUtils.processLabelRichiedenteConFruitoreTokenClient(infoDatiMittente, bf);
        } else {
            InfoMittenteFormatUtils.processLabelRichiedenteConFruitore(infoDatiMittente, bf, richiedente);
        }
        return bf.toString();
    }

    private static void processLabelRichiedenteConFruitoreTokenClient(DatiMittente infoDatiMittente, StringBuilder bfParam) {
        if (infoDatiMittente.getTokenClientSoggettoFruitore() != null && infoDatiMittente.getTokenClientTipoSoggettoFruitore() != null && infoDatiMittente.getTokenClientNomeSoggettoFruitore() != null) {
            boolean addFruitore = true;
            IDSoggetto idSoggettoFruitore = new IDSoggetto(infoDatiMittente.getTokenClientTipoSoggettoFruitore(), infoDatiMittente.getTokenClientNomeSoggettoFruitore());
            if (PddRuolo.DELEGATA.equals((Object)infoDatiMittente.getPddRuolo())) {
                boolean bl = addFruitore = infoDatiMittente.getSoggettoOperativo() == null || !infoDatiMittente.getSoggettoOperativo().equals(idSoggettoFruitore.toString());
            }
            if (addFruitore) {
                if (bfParam.length() > 0) {
                    bfParam.append("@");
                }
                bfParam.append(infoDatiMittente.getTokenClientSoggettoFruitore());
            }
        }
    }

    private static void processLabelRichiedenteConFruitore(DatiMittente infoDatiMittente, StringBuilder bfParam, String richiedente) {
        String sFruitore = infoDatiMittente.getSoggettoFruitore();
        if (StringUtils.isNotEmpty((CharSequence)sFruitore)) {
            boolean addFruitore = true;
            if (PddRuolo.APPLICATIVA.equals((Object)infoDatiMittente.getPddRuolo())) {
                InfoMittenteFormatUtils.processLabelRichiedenteConFruitorePortaApplicativa(infoDatiMittente, bfParam, richiedente);
            } else if (PddRuolo.DELEGATA.equals((Object)infoDatiMittente.getPddRuolo()) && infoDatiMittente.getSoggettoOperativo() != null && StringUtils.isNotEmpty((CharSequence)infoDatiMittente.getTipoSoggettoFruitore()) && StringUtils.isNotEmpty((CharSequence)infoDatiMittente.getNomeSoggettoFruitore())) {
                IDSoggetto idSoggettoFruitore = new IDSoggetto(infoDatiMittente.getTipoSoggettoFruitore(), infoDatiMittente.getNomeSoggettoFruitore());
                boolean bl = addFruitore = !infoDatiMittente.getSoggettoOperativo().equals(idSoggettoFruitore.toString());
            }
            if (addFruitore) {
                if (bfParam.length() > 0) {
                    bfParam.append("@");
                }
                bfParam.append(sFruitore);
            }
        }
    }

    private static void processLabelRichiedenteConFruitorePortaApplicativa(DatiMittente infoDatiMittente, StringBuilder bfParam, String richiedente) {
        String sTipoTrasportoMittente;
        String sTrasportoMittente = infoDatiMittente.getTrasportoMittente();
        if (richiedente != null && sTrasportoMittente != null && richiedente.equals(sTrasportoMittente) && (sTipoTrasportoMittente = infoDatiMittente.getTipoTrasportoMittente()) != null && StringUtils.isNotEmpty((CharSequence)sTipoTrasportoMittente) && sTipoTrasportoMittente.endsWith("_" + TipoAutenticazione.APIKEY.getValue()) && !sTrasportoMittente.contains("@") && bfParam.length() > 0) {
            bfParam.setLength(0);
        }
    }
}

