/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.traccia;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.util.Properties;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.logger.traccia.TracciaException;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.KeystoreUtils;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JsonSignature;
import org.openspcoop2.utils.security.XmlSignature;
import org.w3c.dom.Element;

public class Signature {
    private String keystore_type = KeystoreType.JKS.getNome();
    private String keystore_path = null;
    private String keystore_password = null;
    private String key_alias = null;
    private String key_password = null;
    private String json_signatureAlgorithm = "RS256";
    private JOSESerialization json_signatureSerialization = JOSESerialization.COMPACT;
    private boolean json_signatureDetached = false;
    private boolean json_signaturePayloadEncoding = true;
    private String xml_signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private String xml_digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    private String xml_canonicalizationAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    private boolean xml_addBouncyCastleProvider;
    private boolean xml_addX509KeyInfo = true;
    private boolean xml_addRSAKeyInfo = false;
    private boolean initialized = false;
    private JsonSignature jsonCompactSignature;
    private XmlSignature xmlSignature;
    private MessageXMLUtils xmlUtils;

    public Signature() {
    }

    public Signature(Properties pConf) throws TracciaException {
        try {
            Field[] fields;
            for (Field field : fields = Signature.class.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!pConf.containsKey(fieldName = fieldName.replace("_", "."))) continue;
                String value = pConf.getProperty(fieldName);
                String bCN = Boolean.TYPE.getName();
                String joseS = JOSESerialization.class.getName();
                if (bCN.equals(field.getType().getName())) {
                    field.set(this, "true".equalsIgnoreCase(value));
                    continue;
                }
                if (joseS.equals(field.getType().getName())) {
                    field.set(this, JOSESerialization.valueOf((String)value));
                    continue;
                }
                field.set(this, value);
            }
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public synchronized void init() throws TracciaException {
        if (!this.initialized) {
            if (this.keystore_path == null) {
                throw new TracciaException("Keystore path undefined");
            }
            if (this.keystore_type == null) {
                throw new TracciaException("Keystore type undefined");
            }
            if (this.keystore_password == null) {
                throw new TracciaException("Keystore type undefined");
            }
            if (this.key_alias == null) {
                throw new TracciaException("Alias key undefined");
            }
            if (this.key_password == null) {
                throw new TracciaException("Password key undefined");
            }
            if (this.json_signatureAlgorithm == null) {
                throw new TracciaException("Json Signature Algorithm undefined");
            }
            if (this.json_signatureSerialization == null) {
                throw new TracciaException("Json Signature Representation undefined");
            }
            if (this.xml_signatureAlgorithm == null) {
                throw new TracciaException("Xml Signature Algorithm undefined");
            }
            if (this.xml_digestAlgorithm == null) {
                throw new TracciaException("Xml Digest Algorithm undefined");
            }
            if (this.xml_canonicalizationAlgorithm == null) {
                throw new TracciaException("Xml Canonicalization Algorithm undefined");
            }
            InputStream isKeystore = Signature.class.getResourceAsStream(this.keystore_path);
            try {
                if (isKeystore == null) {
                    File f = new File(this.keystore_path);
                    if (!f.exists()) {
                        throw new TracciaException("Keystore path '" + this.keystore_path + "' not exists");
                    }
                    if (!f.canRead()) {
                        throw new TracciaException("Keystore path '" + this.keystore_path + "' cannot read");
                    }
                    isKeystore = new FileInputStream(f);
                }
                KeyStore keystore = KeystoreUtils.readKeystore((InputStream)isKeystore, (String)this.keystore_type, (String)this.keystore_password);
                JWSOptions jwsOptions = new JWSOptions(this.json_signatureSerialization);
                jwsOptions.setDetached(this.json_signatureDetached);
                jwsOptions.setPayloadEncoding(this.json_signaturePayloadEncoding);
                this.jsonCompactSignature = new JsonSignature(keystore, false, this.key_alias, this.key_password, this.json_signatureAlgorithm, jwsOptions);
                this.xmlSignature = new XmlSignature(keystore, this.key_alias, this.key_password, this.xml_addBouncyCastleProvider);
                if (this.xml_addX509KeyInfo) {
                    this.xmlSignature.addX509KeyInfo();
                } else if (this.xml_addRSAKeyInfo) {
                    this.xmlSignature.addRSAKeyInfo();
                }
                this.xmlUtils = MessageXMLUtils.DEFAULT;
            }
            catch (Exception e) {
                throw new TracciaException(e.getMessage(), e);
            }
            finally {
                try {
                    if (isKeystore != null) {
                        isKeystore.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.initialized = true;
        }
    }

    public String jsonSign(String content) throws TracciaException {
        try {
            return this.jsonCompactSignature.sign(content);
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public String xmlSign(String content) throws TracciaException {
        return this.xmlSign(content.getBytes());
    }

    public String xmlSign(byte[] content) throws TracciaException {
        try {
            Element node = this.xmlUtils.newElement(content);
            this.xmlSignature.sign(node);
            return this.xmlUtils.toString(node);
        }
        catch (Exception e) {
            throw new TracciaException(e.getMessage(), e);
        }
    }

    public void setKeystore_type(String keystore_type) {
        this.keystore_type = keystore_type;
    }

    public void setKeystore_path(String keystore_path) {
        this.keystore_path = keystore_path;
    }

    public void setKeystore_password(String keystore_password) {
        this.keystore_password = keystore_password;
    }

    public void setKey_alias(String key_alias) {
        this.key_alias = key_alias;
    }

    public void setKey_password(String key_password) {
        this.key_password = key_password;
    }

    public void setJson_signatureAlgorithm(String json_signatureAlgorithm) {
        this.json_signatureAlgorithm = json_signatureAlgorithm;
    }

    public void setJson_signatureSerialization(JOSESerialization json_signatureSerialization) {
        this.json_signatureSerialization = json_signatureSerialization;
    }

    public void setJson_signatureDetached(boolean json_signatureDetached) {
        this.json_signatureDetached = json_signatureDetached;
    }

    public void setJson_signaturePayloadEncoding(boolean json_signaturePayloadEncoding) {
        this.json_signaturePayloadEncoding = json_signaturePayloadEncoding;
    }

    public void setXml_signatureAlgorithm(String xml_signatureAlgorithm) {
        this.xml_signatureAlgorithm = xml_signatureAlgorithm;
    }

    public void setXml_digestAlgorithm(String xml_digestAlgorithm) {
        this.xml_digestAlgorithm = xml_digestAlgorithm;
    }

    public void setXml_canonicalizationAlgorithm(String xml_canonicalizationAlgorithm) {
        this.xml_canonicalizationAlgorithm = xml_canonicalizationAlgorithm;
    }

    public void setXml_addBouncyCastleProvider(boolean xml_addBouncyCastleProvider) {
        this.xml_addBouncyCastleProvider = xml_addBouncyCastleProvider;
    }

    public void setXml_addX509KeyInfo(boolean xml_addX509KeyInfo) {
        this.xml_addX509KeyInfo = xml_addX509KeyInfo;
    }

    public void setXml_addRSAKeyInfo(boolean xml_addRSAKeyInfo) {
        this.xml_addRSAKeyInfo = xml_addRSAKeyInfo;
    }
}

