/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposteMessage;
import org.openspcoop2.pdd.services.DirectVMProtocolInfo;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

public class ImbustamentoRisposte
extends GenericLib {
    public static final String ID_MODULO = "ImbustamentoRisposte";

    public ImbustamentoRisposte(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        OpenSPCoop2Message msgRisposta;
        EsitoLib esito = new EsitoLib();
        ImbustamentoRisposteMessage imbustamentoRisposteMsg = (ImbustamentoRisposteMessage)openspcoopstate.getMessageLib();
        ParseException parseException = null;
        if (openspcoopstate instanceof OpenSPCoopStateless && (msgRisposta = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg()) != null) {
            parseException = msgRisposta.getParseException();
        }
        PdDContext pddContext = imbustamentoRisposteMsg.getPddContext();
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
        RequestInfo requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.setPddContext(pddContext, protocolFactory);
        String idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        String implementazionePdDMittente = imbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente();
        Busta bustaRichiesta = imbustamentoRisposteMsg.getBusta();
        RichiestaApplicativa richiestaApplicativa = imbustamentoRisposteMsg.getRichiestaApplicativa();
        RichiestaDelegata richiestaDelegata = imbustamentoRisposteMsg.getRichiestaDelegata();
        TipoPdD tipoPdD = TipoPdD.APPLICATIVA;
        if (msgDiag.getPorta() == null) {
            if (richiestaApplicativa != null && richiestaApplicativa.getIdPortaApplicativa() != null) {
                msgDiag.updatePorta(tipoPdD, richiestaApplicativa.getIdPortaApplicativa().getNome(), requestInfo);
            } else if (richiestaDelegata != null && richiestaDelegata.getIdPortaDelegata() != null) {
                msgDiag.updatePorta(TipoPdD.DELEGATA, richiestaDelegata.getIdPortaDelegata().getNome(), requestInfo);
            }
        }
        String idMessageResponse = imbustamentoRisposteMsg.getIDMessageResponse();
        String idModuloInAttesa = null;
        IDSoggetto identitaPdD = null;
        String scenarioCooperazione = null;
        IDSoggetto soggettoFruitore = null;
        IDServizio idServizio = null;
        String servizioApplicativo = null;
        String profiloGestione = null;
        String servizioApplicativoFruitore = null;
        String servizioApplicativoErogatore = null;
        String idCorrelazioneApplicativa = null;
        String idCorrelazioneApplicativaRisposta = null;
        IDSoggetto soggettoErogatoreServizioHeaderIntegrazione = null;
        if (richiestaApplicativa != null) {
            identitaPdD = richiestaApplicativa.getDominio();
            idModuloInAttesa = richiestaApplicativa.getIdModuloInAttesa();
            scenarioCooperazione = richiestaApplicativa.getScenario();
            soggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
            idServizio = richiestaApplicativa.getIDServizio();
            servizioApplicativo = richiestaApplicativa.getServizioApplicativo();
            soggettoErogatoreServizioHeaderIntegrazione = idServizio.getSoggettoErogatore();
            profiloGestione = richiestaApplicativa.getProfiloGestione();
            servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
            servizioApplicativoErogatore = richiestaApplicativa.getServizioApplicativo();
            idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
            idCorrelazioneApplicativaRisposta = richiestaApplicativa.getIdCorrelazioneApplicativaRisposta();
        } else {
            identitaPdD = richiestaDelegata.getDominio();
            idModuloInAttesa = richiestaDelegata.getIdModuloInAttesa();
            scenarioCooperazione = richiestaDelegata.getScenario();
            soggettoFruitore = richiestaDelegata.getIdSoggettoFruitore();
            idServizio = richiestaDelegata.getIdServizio();
            servizioApplicativo = richiestaDelegata.getServizioApplicativo();
            soggettoErogatoreServizioHeaderIntegrazione = idServizio.getSoggettoErogatore();
            profiloGestione = richiestaDelegata.getProfiloGestione();
            servizioApplicativoFruitore = richiestaDelegata.getServizioApplicativo();
            idCorrelazioneApplicativa = richiestaDelegata.getIdCorrelazioneApplicativa();
            idCorrelazioneApplicativaRisposta = richiestaDelegata.getIdCorrelazioneApplicativaRisposta();
        }
        IDServizio servizioHeaderIntegrazione = null;
        if (bustaRichiesta != null) {
            try {
                servizioHeaderIntegrazione = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), soggettoErogatoreServizioHeaderIntegrazione, bustaRichiesta.getVersioneServizio().intValue());
                servizioHeaderIntegrazione.setAzione(bustaRichiesta.getAzione());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "IDServizioFactory.getIDServizioFromValues");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
        }
        msgDiag.mediumDebug("Profilo di gestione [ImbustamentoRisposte] della busta: " + profiloGestione);
        msgDiag.setDominio(identitaPdD);
        msgDiag.setIdMessaggioRichiesta(idMessageRequest);
        msgDiag.setIdMessaggioRisposta(idMessageResponse);
        msgDiag.setFruitore(soggettoFruitore);
        if (servizioHeaderIntegrazione != null) {
            msgDiag.setServizio(servizioHeaderIntegrazione);
        } else {
            msgDiag.setServizio(idServizio);
        }
        msgDiag.setServizioApplicativo(servizioApplicativo);
        msgDiag.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
        msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
        msgDiag.setPrefixMsgPersonalizzati("imbustamentoRispostaBusta.");
        msgDiag.addKeywords(bustaRichiesta, true);
        msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
        msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
        if (servizioApplicativoFruitore != null) {
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
        }
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
        registroServiziManager = registroServiziManager.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        configurazionePdDManager = configurazionePdDManager.refreshState(registroServiziManager);
        msgDiag.updateState(configurazionePdDManager);
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPdD, ID_MODULO, idMessageRequest, idMessageResponse, "OUTBOX", openspcoopstate, msgDiag, false, imbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente(), imbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario(), profiloGestione, pddContext);
            ejbUtils.setSpedizioneMsgIngresso(imbustamentoRisposteMsg.getSpedizioneMsgIngresso());
            ejbUtils.setRicezioneMsgRisposta(imbustamentoRisposteMsg.getRicezioneMsgRisposta());
            ejbUtils.setServizioApplicativoErogatore(servizioApplicativo);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        try {
            RicezioneBusteExternalErrorGenerator generatoreErrorePA = new RicezioneBusteExternalErrorGenerator(this.log, this.idModulo, requestInfo, openspcoopstate.getStatoRichiesta());
            generatoreErrorePA.updateInformazioniCooperazione(soggettoFruitore, idServizio);
            generatoreErrorePA.updateInformazioniCooperazione(servizioApplicativoFruitore);
            generatoreErrorePA.updateTipoPdD(TipoPdD.APPLICATIVA);
            ejbUtils.setGeneratoreErrorePortaApplicativa(generatoreErrorePA);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "RicezioneBusteExternalErrorGenerator.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        boolean oneWayVersione11 = imbustamentoRisposteMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        IState statoRichiesta = openspcoopstate.getStatoRichiesta();
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new ProfiloDiCollaborazione(statoRichiesta, protocolFactory);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        RepositoryBuste repositoryBuste = new RepositoryBuste(statoRichiesta, true, protocolFactory);
        GestoreMessaggi msgResponse = null;
        boolean newConnectionForResponse = false;
        if (!org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRichiesta.getProfiloDiCollaborazione()) && !imbustamentoRisposteMsg.isStateless()) {
            newConnectionForResponse = configurazionePdDManager.newConnectionForResponse();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        boolean gestioneIndirizzoTelematico = false;
        if (!imbustamentoRisposteMsg.isStateless()) {
            gestioneIndirizzoTelematico = configurazionePdDManager.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        try {
            IProtocolVersionManager protocolManager = protocolFactory.createProtocolVersionManager(profiloGestione);
            Busta bustaRisposta = null;
            TipoOraRegistrazione tipoTempo = this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente);
            boolean asincronoStateless = false;
            if ("Sincrono_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Sincrono...");
                    bustaRisposta = profiloCollaborazione.sincrono_generaBustaRisposta(idMessageRequest, tipoTempo);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.sincrono_generaBustaRisposta");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, (Throwable)e, parseException);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "profiloCollaborazione.sincrono_generaBustaRisposta");
                    return esito;
                }
            }
            if ("AsincronoSimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Simmetrico (richiesta)...");
                    bustaRisposta = profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(idMessageRequest, idMessageRequest, true, tipoTempo);
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Richiesta)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, (Throwable)e, parseException);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Richiesta)");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoSimmetrico_ConsegnaRisposta".equals(scenarioCooperazione)) {
                try {
                    msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Simmetrico (risposta)...");
                    bustaRisposta = profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta), idMessageRequest, false, tipoTempo);
                    if (bustaRisposta != null) {
                        bustaRisposta.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                        bustaRisposta.setAzione(bustaRichiesta.getAzione());
                    }
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Risposta)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, (Throwable)e, parseException);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoSimmetrico_getBustaRicevuta(Risposta)");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoAsimmetrico_InvocazioneServizio".equals(scenarioCooperazione)) {
                try {
                    boolean generazionAttributiAsincroni = protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente);
                    msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Asimmetrico (richiesta)...");
                    bustaRisposta = profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(idMessageRequest, idMessageRequest, true, generazionAttributiAsincroni, tipoTempo);
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Richiesta)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, (Throwable)e, parseException);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Richiesta)");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            if ("AsincronoAsimmetrico_Polling".equals(scenarioCooperazione)) {
                try {
                    msgDiag.mediumDebug("Generazione busta per il profilo di Collaborazione Asincrono Asimmetrico (richiestaStato)...");
                    boolean generazionAttributiAsincroni = protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente);
                    bustaRisposta = profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta), idMessageRequest, false, generazionAttributiAsincroni, tipoTempo);
                    if (bustaRisposta != null) {
                        bustaRisposta.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                        bustaRisposta.setAzione(bustaRichiesta.getAzione());
                    }
                    asincronoStateless = imbustamentoRisposteMsg.isStateless();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Risposta)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, (Throwable)e, parseException);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoAsimmetrico_getBustaRicevuta(Risposta)");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            msgDiag.mediumDebug("Check busta...");
            if (bustaRisposta == null) {
                throw new Exception("Busta di risposta [" + scenarioCooperazione + "] non generata.");
            }
            switch (protocolManager.getConsegnaAffidabile(bustaRisposta)) {
                case ABILITATA: {
                    bustaRisposta.setConfermaRicezione(true);
                    break;
                }
                case DISABILITATA: {
                    bustaRisposta.setConfermaRicezione(false);
                    break;
                }
            }
            switch (protocolManager.getFiltroDuplicati(bustaRisposta)) {
                case ABILITATA: {
                    bustaRisposta.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                    break;
                }
                case DISABILITATA: {
                    bustaRisposta.setInoltro(Inoltro.CON_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                    break;
                }
            }
            bustaRisposta.setID(idMessageResponse);
            msgDiag.addKeywords(bustaRisposta, false);
            bustaRisposta.setServizioApplicativoErogatore(servizioApplicativoErogatore);
            DirectVMProtocolInfo.setInfoFromContext(pddContext, bustaRisposta);
            msgDiag.mediumDebug("Spedizione busta di risposta al modulo in uscita (RicezioneBuste/InoltroRisposte)...");
            msgResponse = ejbUtils.sendBustaRisposta(idModuloInAttesa, bustaRisposta, profiloGestione, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore);
            msgDiag.mediumDebug("Elimino utilizzo busta dalla PdD...");
            repositoryBuste.eliminaUtilizzoPdDFromInBox(idMessageRequest, asincronoStateless);
            openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta", idMessageRequest, false);
            }
            msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setStatoInvocazione(1, null);
            esito.setEsitoInvocazione(true);
            return esito;
        }
        catch (Throwable e) {
            this.log.error("ErroreGenerale", e);
            msgDiag.logErroreGenerico(e, "Generale");
            try {
                ejbUtils.sendAsRispostaBustaErroreProcessamento(idModuloInAttesa, bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, servizioApplicativoFruitore, e, parseException);
                esito.setStatoInvocazione(2, "ErroreGenerale");
                esito.setEsitoInvocazione(true);
            }
            catch (Exception er) {
                msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta con gestione della risposta non riuscita", esito);
                esito.setStatoInvocazioneErroreNonGestito(er);
                esito.setEsitoInvocazione(false);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
    }
}

