/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import jakarta.xml.soap.SOAPFault;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.IntegrationContext;
import org.openspcoop2.pdd.core.MTOMProcessor;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.connettori.GestoreErroreConnettore;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop2.pdd.core.controllo_traffico.ConnettoreUtilities;
import org.openspcoop2.pdd.core.controllo_traffico.DatiTempiRisposta;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.InoltroRisposteMessage;
import org.openspcoop2.pdd.services.core.FlowProperties;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.engine.MessageSecurityFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.digest.IDigestReader;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class InoltroRisposte
extends GenericLib {
    public static final String ID_MODULO = "InoltroRisposte";

    public InoltroRisposte(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        Tracciamento tracciamento;
        EsitoLib esito = new EsitoLib();
        if (openspcoopstate == null) {
            if (msgDiag != null) {
                msgDiag.logErroreGenerico("openspcoopstate is null", "openspcoopstate.checkNull");
            } else {
                this.log.error("openspcoopstate is null");
            }
            esito.setEsitoInvocazione(false);
            return esito;
        }
        InoltroRisposteMessage inoltroRisposteMsg = (InoltroRisposteMessage)openspcoopstate.getMessageLib();
        if (msgDiag == null) {
            if (this.log != null) {
                this.log.error("MsgDiagnostico is null");
            }
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            return esito;
        }
        PdDContext pddContext = inoltroRisposteMsg.getPddContext();
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
        RequestInfo requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
        Busta busta = inoltroRisposteMsg.getBustaRisposta();
        if (busta == null) {
            msgDiag.logErroreGenerico("Busta is null", "Busta.checkNull");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            return esito;
        }
        String implementazionePdDDestinatario = inoltroRisposteMsg.getImplementazionePdDSoggettoDestinatario();
        IDSoggetto identitaPdD = inoltroRisposteMsg.getDominio();
        msgDiag.setDominio(identitaPdD);
        boolean inoltroSegnalazioneErrore = inoltroRisposteMsg.getInoltroSegnalazioneErrore();
        msgDiag.setPrefixMsgPersonalizzati("inoltroBuste.");
        msgDiag.addKeywords(busta, true);
        IDSoggetto soggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
        IDSoggetto soggettoDestinatario = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
        IDServizio idServizio = null;
        try {
            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), soggettoDestinatario, busta.getVersioneServizio().intValue());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "IDServizioFactory.getIDServizioFromValues");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazioneErroreNonGestito(e);
            esito.setEsitoInvocazione(false);
            return esito;
        }
        idServizio.setAzione(busta.getAzione());
        String idMessageResponse = busta.getID();
        msgDiag.setIdMessaggioRichiesta(busta.getRiferimentoMessaggio());
        msgDiag.setIdMessaggioRisposta(busta.getID());
        msgDiag.setFruitore(soggettoMittente);
        msgDiag.setServizio(idServizio);
        msgDiag.setIdCorrelazioneApplicativa(inoltroRisposteMsg.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", inoltroRisposteMsg.getIdCorrelazioneApplicativa());
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
        registroServiziManager = registroServiziManager.refreshState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        configurazionePdDManager = configurazionePdDManager.refreshState(registroServiziManager);
        msgDiag.updateState(configurazionePdDManager);
        IProtocolFactory protocolFactory = null;
        IValidazioneSemantica validazioneSemantica = null;
        ITraduttore traduttore = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME));
            traduttore = protocolFactory.createTraduttore();
            validazioneSemantica = protocolFactory.createValidazioneSemantica(openspcoopstate.getStatoRichiesta());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        Transaction transactionNullable = null;
        try {
            transactionNullable = TransactionContext.getTransaction(idTransazione);
        }
        catch (Exception exception) {
            // empty catch block
        }
        msgDiag.setPddContext(pddContext, protocolFactory);
        String idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        boolean oneWayVersione11 = inoltroRisposteMsg.isOneWayVersione11();
        boolean functionAsRouter = false;
        msgDiag.mediumDebug("Esamina modalita' di ricezione (PdD/Router)...");
        boolean existsSoggetto = false;
        try {
            existsSoggetto = configurazionePdDManager.existsSoggetto(soggettoMittente, requestInfo);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "existsSoggetto(" + soggettoMittente.toString() + ")");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazioneErroreNonGestito(e);
            esito.setEsitoInvocazione(false);
            return esito;
        }
        if (!existsSoggetto) {
            boolean routerFunctionActive = false;
            try {
                routerFunctionActive = configurazionePdDManager.routerFunctionActive();
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "routerFunctionActive()");
                openspcoopstate.releaseResource();
                esito.setStatoInvocazioneErroreNonGestito(e);
                esito.setEsitoInvocazione(false);
                return esito;
            }
            if (routerFunctionActive) {
                functionAsRouter = true;
            } else {
                msgDiag.logPersonalizzato("routingTable.soggettoFruitoreNonGestito");
                try {
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "OUTBOX", msgDiag, pddContext);
                    msgResponse.setOneWayVersione11(oneWayVersione11);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
                    repositoryBuste.eliminaBustaStatelessFromOutBox(busta.getID());
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "EliminazioneMessaggioSoggettoFruitoreNonGestito");
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    return esito;
                }
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3, "routingTable.soggettoFruitoreNonGestito");
                esito.setEsitoInvocazione(true);
                return esito;
            }
        }
        TipoPdD tipoPorta = TipoPdD.APPLICATIVA;
        if (functionAsRouter) {
            tipoPorta = TipoPdD.ROUTER;
        }
        String versioneProtocollo = inoltroRisposteMsg.getProfiloGestione();
        msgDiag.mediumDebug("Profilo di gestione [InoltroRisposte] della busta: " + versioneProtocollo);
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPorta, ID_MODULO, idMessageRequest, idMessageResponse, "OUTBOX", openspcoopstate, msgDiag, functionAsRouter, inoltroRisposteMsg.getImplementazionePdDSoggettoMittente(), inoltroRisposteMsg.getImplementazionePdDSoggettoDestinatario(), versioneProtocollo, pddContext);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setStatoInvocazioneErroreNonGestito(e);
            esito.setEsitoInvocazione(false);
            return esito;
        }
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "OUTBOX", msgDiag, pddContext);
        msgResponse.setOneWayVersione11(oneWayVersione11);
        GestoreMessaggi msgConnectionReply = null;
        try {
            if (!msgResponse.isRiconsegnaMessaggio(null)) {
                msgDiag.logPersonalizzato("riconsegnaMessaggioPrematura");
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("riconsegnaMessaggioPrematura"));
                esito.setEsitoInvocazione(false);
                return esito;
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "msgRequest.isRiconsegnaMessaggio()");
            ejbUtils.rollbackMessage("Errore verifica riconsegna messaggio", esito);
            openspcoopstate.releaseResource();
            esito.setStatoInvocazioneErroreNonGestito(e);
            esito.setEsitoInvocazione(true);
            return esito;
        }
        RepositoryBuste repositoryBuste = null;
        RepositoryBuste repositoryConnectionReply = null;
        try {
            tracciamento = new Tracciamento(identitaPdD, "InoltroBuste", pddContext, tipoPorta, msgDiag.getPorta(), configurazionePdDManager);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        ProprietaManifestAttachments proprietaManifestAttachments = this.propertiesReader.getProprietaManifestAttachments(implementazionePdDDestinatario);
        boolean readQualifiedAttribute = this.propertiesReader.isReadQualifiedAttribute(implementazionePdDDestinatario);
        Validatore validatoreProtocolConnectionReply = null;
        IConnettore connectorSender = null;
        String location = "";
        try {
            String motivazioneErrore;
            Object pValidazioneErrori;
            PortaApplicativa pa;
            OpenSPCoop2Message responseMessage;
            Trasmissione tras;
            Connettore connettore;
            IProtocolVersionManager protocolManager;
            block340: {
                protocolManager = protocolFactory.createProtocolVersionManager(versioneProtocollo);
                connettore = null;
                Object erroreRicercaConnettore = null;
                if (functionAsRouter) {
                    msgDiag.logPersonalizzato_prefix("(Router) ", "routingTable.esaminaInCorso");
                    try {
                        connettore = configurazionePdDManager.getForwardRoute(soggettoDestinatario, functionAsRouter, requestInfo);
                    }
                    catch (Exception e) {
                        erroreRicercaConnettore = e.getMessage();
                    }
                    msgDiag.logPersonalizzato_prefix("(Router) ", "routingTable.esaminaEffettuata");
                } else if (configurazionePdDManager.isUtilizzoIndirizzoTelematico() && busta.getIndirizzoDestinatario() != null) {
                    msgDiag.logPersonalizzato("routingTable.utilizzoIndirizzoTelematico");
                    Property locationIndTel = new Property();
                    locationIndTel.setNome("location");
                    locationIndTel.setValore(busta.getIndirizzoDestinatario());
                    connettore = new Connettore();
                    connettore.setTipo(TipiConnettore.HTTP.getNome());
                    connettore.addProperty(locationIndTel);
                } else {
                    msgDiag.logPersonalizzato("routingTable.esaminaInCorso");
                    if (inoltroSegnalazioneErrore) {
                        try {
                            connettore = configurazionePdDManager.getForwardRoute(soggettoMittente, idServizio, functionAsRouter, requestInfo);
                        }
                        catch (Exception e) {
                            erroreRicercaConnettore = "RicercaConnettoreSpecializzato, " + e.getMessage();
                        }
                        if (connettore == null) {
                            try {
                                connettore = configurazionePdDManager.getForwardRoute(soggettoDestinatario, functionAsRouter, requestInfo);
                            }
                            catch (Exception e) {
                                erroreRicercaConnettore = "\nRicercaConnettore, " + e.getMessage();
                            }
                        }
                    } else {
                        try {
                            connettore = configurazionePdDManager.getForwardRoute(soggettoDestinatario, functionAsRouter, requestInfo);
                        }
                        catch (Exception e) {
                            erroreRicercaConnettore = e.getMessage();
                        }
                    }
                    msgDiag.logPersonalizzato("routingTable.esaminaEffettuata");
                }
                if (connettore == null) {
                    if (erroreRicercaConnettore != null) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", (String)erroreRicercaConnettore);
                        erroreRicercaConnettore = "Riscontrato errore durante la ricerca del connettore a cui inoltrare la busta: " + (String)erroreRicercaConnettore;
                    } else {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "non definito");
                        erroreRicercaConnettore = "Riscontrato errore durante la ricerca del connettore a cui inoltrare la busta: non definito";
                    }
                    msgDiag.logPersonalizzato("routingTable.esaminaInCorsoFallita");
                    ejbUtils.rollbackMessage((String)erroreRicercaConnettore, esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(3, (String)erroreRicercaConnettore);
                    esito.setEsitoInvocazione(false);
                    EsitoLib e = esito;
                    return e;
                }
                Object soggettoDestinatarioTrasmissione = "";
                tras = null;
                if (this.propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDDestinatario)) {
                    msgDiag.mediumDebug("Aggiunta trasmissione della busta ...");
                    tras = new Trasmissione();
                    tras.setOrigine(identitaPdD.getNome());
                    tras.setTipoOrigine(identitaPdD.getTipo());
                    IDSoggetto destTrasm = null;
                    destTrasm = connettore.getNomeDestinatarioTrasmissioneBusta() != null && connettore.getTipoDestinatarioTrasmissioneBusta() != null ? new IDSoggetto(connettore.getTipoDestinatarioTrasmissioneBusta(), connettore.getNomeDestinatarioTrasmissioneBusta()) : new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                    tras.setDestinazione(destTrasm.getNome());
                    tras.setTipoDestinazione(destTrasm.getTipo());
                    tras.setOraRegistrazione(busta.getOraRegistrazione());
                    tras.setTempo(this.propertiesReader.getTipoTempoBusta(implementazionePdDDestinatario));
                    busta.addTrasmissione(tras);
                    if (!soggettoDestinatario.getNome().equals(destTrasm.getNome()) || !soggettoDestinatario.getTipo().equals(destTrasm.getTipo())) {
                        soggettoDestinatarioTrasmissione = " (tramite router " + destTrasm.getTipo() + "/" + destTrasm.getNome() + ")";
                    }
                }
                msgDiag.addKeyword("@DESTINATARIO_TRASMISSIONE@", (String)soggettoDestinatarioTrasmissione);
                msgDiag.mediumDebug("Lettura messaggio da spedire...");
                responseMessage = null;
                try {
                    responseMessage = msgResponse.getMessage();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    ejbUtils.rollbackMessage("Ricostruzione del messaggio Soap da Spedire non riuscita.", esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    EsitoLib esitoLib = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e2) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e2, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e2);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return esitoLib;
                }
                pa = null;
                if (!functionAsRouter) {
                    try {
                        IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoMittente(), busta.getMittente(), busta.getVersioneServizio().intValue());
                        idServizioPA.setAzione(busta.getAzione());
                        pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                    }
                    catch (Exception e) {
                        if (e instanceof DriverConfigurazioneNotFound) break block340;
                        msgDiag.logErroreGenerico(e, "getPortaApplicativaSafeMethod");
                        ejbUtils.rollbackMessage("Ricostruzione errore durante la lettura della porta applicativa.", esito);
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazioneErroreNonGestito(e);
                        esito.setEsitoInvocazione(false);
                        EsitoLib e2 = esito;
                        try {
                            if (connectorSender != null) {
                                connectorSender.disconnect();
                            }
                        }
                        catch (Exception e3) {
                            try {
                                if (msgDiag != null) {
                                    msgDiag.logDisconnectError(e3, location);
                                }
                            }
                            catch (Exception eDisconnect) {
                                this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e3);
                            }
                        }
                        if (validatoreProtocolConnectionReply != null) {
                            if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                                validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                            }
                            validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                        }
                        validatoreProtocolConnectionReply = null;
                        return e2;
                    }
                }
            }
            boolean scartaBody = false;
            if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.getTipoServizio() != null && busta.getServizio() != null) {
                boolean allegaBody = configurazionePdDManager.isAllegaBody(pa);
                scartaBody = allegaBody ? true : configurazionePdDManager.isScartaBody(pa);
            }
            if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.sizeListaEccezioni() == 0 && protocolManager.isEccezioniLivelloInfoAbilitato()) {
                RepositoryBuste repositoryBustaRichiesta = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
                List erroriValidazione = repositoryBustaRichiesta.getErrorsFromInBox(busta.getRiferimentoMessaggio());
                for (int i = 0; i < erroriValidazione.size(); ++i) {
                    Eccezione ec = (Eccezione)erroriValidazione.get(i);
                    if (!LivelloRilevanza.INFO.equals((Object)ec.getRilevanza())) continue;
                    busta.addEccezione(ec);
                }
            }
            msgDiag.mediumDebug("Imbustamento ...");
            BustaRawContent headerBusta = null;
            Imbustamento imbustatore = null;
            boolean gestioneManifest = false;
            RuoloMessaggio ruoloMessaggio = null;
            if (inoltroRisposteMsg.isImbustamento()) {
                try {
                    ruoloMessaggio = RuoloMessaggio.RISPOSTA;
                    if (inoltroSegnalazioneErrore) {
                        ruoloMessaggio = RuoloMessaggio.RICHIESTA;
                    }
                    imbustatore = new Imbustamento(this.log, protocolFactory, openspcoopstate.getStatoRichiesta());
                    gestioneManifest = configurazionePdDManager.isGestioneManifestAttachments();
                    if (!functionAsRouter && !inoltroSegnalazioneErrore && busta.getTipoServizio() != null && busta.getServizio() != null) {
                        gestioneManifest = configurazionePdDManager.isGestioneManifestAttachments(pa, protocolFactory);
                    }
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(busta.getTipoMittente()) && identitaPdD.getNome().equals(busta.getMittente()))) {
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                        ProtocolMessage protocolMessage = imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBusta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                    } else {
                        Integrazione integrazione = new Integrazione();
                        integrazione.setStateless(false);
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento [" + responseMessage.getClass().getName() + "]");
                        ProtocolMessage protocolMessage = null;
                        protocolMessage = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? imbustatore.imbustamentoRichiesta(responseMessage, (Context)pddContext, busta, integrazione, gestioneManifest, scartaBody, proprietaManifestAttachments, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO) : imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContext, busta, null, integrazione, gestioneManifest, scartaBody, proprietaManifestAttachments, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBusta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento [" + responseMessage.getClass().getName() + "]");
                    }
                }
                catch (Exception e) {
                    if (functionAsRouter) {
                        msgDiag.logErroreGenerico(e, "imbustatore.before-security.addTrasmissione");
                    } else {
                        msgDiag.logErroreGenerico(e, "imbustatore.before-security.imbustamento");
                    }
                    ejbUtils.rollbackMessage("Imbustamento non riuscito.", esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    EsitoLib protocolMessage = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e4) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e4, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e4);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return protocolMessage;
                }
            }
            msgDiag.mediumDebug("Raccolta FlowParameter MTOM / Security proprieta...");
            MTOMProcessor mtomProcessor = null;
            MessageSecurityConfig securityConfig = null;
            FlowProperties flowProperties = null;
            if (!functionAsRouter) {
                try {
                    flowProperties = this.getFlowProperties(busta, configurazionePdDManager, openspcoopstate.getStatoRisposta(), msgDiag, protocolFactory, pa, requestInfo);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "RaccoltaFlowParameter_MTOM_Security");
                    ejbUtils.rollbackMessage("RaccoltaFlowParameter_MTOM_Security non riuscita:" + e.getMessage(), esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    EsitoLib esitoLib = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e5) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e5, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e5);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return esitoLib;
                }
                if (flowProperties != null) {
                    msgDiag.mediumDebug("init MTOM Processor ...");
                    mtomProcessor = new MTOMProcessor(flowProperties.mtom, flowProperties.messageSecurity, tipoPorta, msgDiag, this.log, pddContext);
                    securityConfig = flowProperties.messageSecurity;
                }
            }
            msgDiag.mediumDebug("MTOM Processor [BeforeSecurity]...");
            try {
                if (mtomProcessor != null && flowProperties != null) {
                    mtomProcessor.mtomBeforeSecurity(responseMessage, flowProperties.tipoMessaggio);
                }
            }
            catch (Exception e) {
                ejbUtils.rollbackMessage("Riscontrato errore durante la gestione MTOM(BeforeSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + "): " + e.getMessage(), esito);
                openspcoopstate.releaseResource();
                esito.setStatoInvocazioneErroreNonGestito(e);
                esito.setEsitoInvocazione(false);
                EsitoLib esitoLib = esito;
                try {
                    if (connectorSender != null) {
                        connectorSender.disconnect();
                    }
                }
                catch (Exception e6) {
                    try {
                        if (msgDiag != null) {
                            msgDiag.logDisconnectError(e6, location);
                        }
                    }
                    catch (Exception eDisconnect) {
                        this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e6);
                    }
                }
                if (validatoreProtocolConnectionReply != null) {
                    if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                        validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                    }
                    validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                }
                validatoreProtocolConnectionReply = null;
                return esitoLib;
            }
            SecurityInfo securityInfo = null;
            if (!inoltroSegnalazioneErrore && !functionAsRouter) {
                msgDiag.mediumDebug("Gestione MessageSecurity del messaggio da inoltrare...");
                MessageSecurityContext messageSecurityContext = null;
                if (securityConfig != null && securityConfig.getFlowParameters() != null && securityConfig.getFlowParameters().size() > 0) {
                    try {
                        MessageSecurityContextParameters contextParameters = new MessageSecurityContextParameters();
                        contextParameters.setUseActorDefaultIfNotDefined(this.propertiesReader.isGenerazioneActorDefault(implementazionePdDDestinatario));
                        contextParameters.setActorDefault(this.propertiesReader.getActorDefault(implementazionePdDDestinatario));
                        contextParameters.setLog(this.log);
                        contextParameters.setFunctionAsClient(false);
                        contextParameters.setPrefixWsuId(this.propertiesReader.getPrefixWsuId());
                        contextParameters.setRemoveAllWsuIdRef(this.propertiesReader.isRemoveAllWsuIdRef());
                        contextParameters.setIdFruitore(soggettoMittente);
                        contextParameters.setIdServizio(idServizio);
                        contextParameters.setPddFruitore(registroServiziManager.getIdPortaDominio(soggettoMittente, null, requestInfo));
                        contextParameters.setPddErogatore(registroServiziManager.getIdPortaDominio(idServizio.getSoggettoErogatore(), null, requestInfo));
                        messageSecurityContext = new MessageSecurityFactory().getMessageSecurityContext(contextParameters);
                        messageSecurityContext.setOutgoingProperties(securityConfig.getFlowParameters());
                        DynamicMapBuilderUtils.injectDynamicMap(busta, requestInfo, (org.openspcoop2.utils.Map<Object>)pddContext, this.log);
                        if (!messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)pddContext, transactionNullable != null ? transactionNullable.getTempiElaborazione() : null)) {
                            msgDiag.logErroreGenerico(messageSecurityContext.getMsgErrore(), "Costruzione header MessageSecurity");
                            String motivazioneErrore2 = "Applicazione MessageSecurity non riuscita:" + messageSecurityContext.getMsgErrore();
                            ejbUtils.rollbackMessage(motivazioneErrore2, esito);
                            openspcoopstate.releaseResource();
                            esito.setStatoInvocazione(3, motivazioneErrore2);
                            esito.setEsitoInvocazione(false);
                            EsitoLib esitoLib = esito;
                            return esitoLib;
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "set MessageSecurityContext");
                        ejbUtils.rollbackMessage("Applicazione MessageSecurity non riuscita:" + e.getMessage(), esito);
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazioneErroreNonGestito(e);
                        esito.setEsitoInvocazione(false);
                        EsitoLib motivazioneErrore2 = esito;
                        return motivazioneErrore2;
                    }
                }
                try {
                    IDigestReader digestReader = null;
                    if (messageSecurityContext != null) {
                        digestReader = messageSecurityContext.getDigestReader(responseMessage != null ? responseMessage.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
                    }
                    if (digestReader != null) {
                        securityInfo = validazioneSemantica.readSecurityInformation(digestReader, responseMessage);
                    }
                }
                catch (Exception e8) {
                    msgDiag.logErroreGenerico(e8, "ErroreLetturaInformazioniSicurezza");
                    ejbUtils.rollbackMessage("Lettura informazioni di sicurezza:" + e8.getMessage(), esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e8);
                    esito.setEsitoInvocazione(false);
                    EsitoLib motivazioneErrore2 = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e7) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e7, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e7);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return motivazioneErrore2;
                }
            }
            msgDiag.mediumDebug("MTOM Processor [AfterSecurity]...");
            try {
                if (mtomProcessor != null) {
                    mtomProcessor.mtomAfterSecurity(responseMessage, flowProperties != null ? flowProperties.tipoMessaggio : RuoloMessaggio.RISPOSTA);
                }
            }
            catch (Exception e) {
                ejbUtils.rollbackMessage("Riscontrato errore durante la gestione MTOM(AfterSec-" + String.valueOf(mtomProcessor.getMTOMProcessorType()) + "): " + e.getMessage(), esito);
                openspcoopstate.releaseResource();
                esito.setStatoInvocazioneErroreNonGestito(e);
                esito.setEsitoInvocazione(false);
                EsitoLib e8 = esito;
                try {
                    if (connectorSender != null) {
                        connectorSender.disconnect();
                    }
                }
                catch (Exception e9) {
                    try {
                        if (msgDiag != null) {
                            msgDiag.logDisconnectError(e9, location);
                        }
                    }
                    catch (Exception eDisconnect) {
                        this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e9);
                    }
                }
                if (validatoreProtocolConnectionReply != null) {
                    if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                        validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                    }
                    validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                }
                validatoreProtocolConnectionReply = null;
                return e8;
            }
            msgDiag.mediumDebug("Imbustamento (after-security) ...");
            if (inoltroRisposteMsg.isImbustamento()) {
                EsitoLib protocolMessage;
                try {
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(busta.getTipoMittente()) && identitaPdD.getNome().equals(busta.getMittente()))) {
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                        ProtocolMessage protocolMessage2 = imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                        if (protocolMessage2 != null && !protocolMessage2.isPhaseUnsupported()) {
                            headerBusta = protocolMessage2.getBustaRawContent();
                            responseMessage = protocolMessage2.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    } else {
                        Integrazione integrazione = new Integrazione();
                        integrazione.setStateless(false);
                        msgDiag.highDebug("Tipo Messaggio Risposta prima dell'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                        protocolMessage = null;
                        protocolMessage = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? imbustatore.imbustamentoRichiesta(responseMessage, (Context)pddContext, busta, integrazione, gestioneManifest, scartaBody, proprietaManifestAttachments, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO) : imbustatore.imbustamentoRisposta(responseMessage, (Context)pddContext, busta, null, integrazione, gestioneManifest, scartaBody, proprietaManifestAttachments, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO);
                        if (protocolMessage != null && !protocolMessage.isPhaseUnsupported()) {
                            headerBusta = protocolMessage.getBustaRawContent();
                            responseMessage = protocolMessage.getMessage();
                        }
                        msgDiag.highDebug("Tipo Messaggio Risposta dopo l'imbustamento (after-security) [" + responseMessage.getClass().getName() + "]");
                    }
                }
                catch (Exception e) {
                    if (functionAsRouter) {
                        msgDiag.logErroreGenerico(e, "imbustatore.after-security.addTrasmissione");
                    } else {
                        msgDiag.logErroreGenerico(e, "imbustatore.after-security.imbustamento");
                    }
                    ejbUtils.rollbackMessage("Imbustamento non riuscito (after-security).", esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    protocolMessage = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e10) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e10, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e10);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return protocolMessage;
                }
            }
            OutResponseContext outResponseContext = new OutResponseContext(this.log, protocolFactory, openspcoopstate.getStatoRichiesta());
            EsitoTransazione esitoHandler = null;
            if (!inoltroSegnalazioneErrore) {
                outResponseContext.setMessaggio(responseMessage);
                ProtocolContext protocolContext = new ProtocolContext();
                protocolContext.setIdRichiesta(idMessageRequest);
                protocolContext.setFruitore(soggettoMittente);
                if (busta != null) {
                    protocolContext.setIndirizzoFruitore(busta.getIndirizzoMittente());
                }
                protocolContext.setErogatore(soggettoDestinatario);
                if (busta != null) {
                    protocolContext.setIndirizzoErogatore(busta.getIndirizzoDestinatario());
                }
                if (busta != null) {
                    protocolContext.setTipoServizio(busta.getTipoServizio());
                    protocolContext.setServizio(busta.getServizio());
                    protocolContext.setVersioneServizio(busta.getVersioneServizio());
                    protocolContext.setAzione(busta.getAzione());
                    protocolContext.setProfiloCollaborazione(busta.getProfiloDiCollaborazione(), busta.getProfiloDiCollaborazioneValue());
                    protocolContext.setCollaborazione(busta.getCollaborazione());
                    protocolContext.setIdRisposta(busta.getID());
                }
                protocolContext.setDominio(msgDiag.getDominio());
                outResponseContext.setProtocollo(protocolContext);
                IntegrationContext integrationContext = new IntegrationContext();
                integrationContext.setIdCorrelazioneApplicativa(inoltroRisposteMsg.getIdCorrelazioneApplicativa());
                integrationContext.setServizioApplicativoFruitore(inoltroRisposteMsg.getServizioApplicativoFruitore());
                integrationContext.setGestioneStateless(false);
                outResponseContext.setIntegrazione(integrationContext);
                outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                outResponseContext.setPddContext(pddContext);
                outResponseContext.setTipoPorta(tipoPorta);
                outResponseContext.setIdModulo(this.idModulo);
                try {
                    GestoreHandlers.outResponse(outResponseContext, msgDiag, this.log);
                }
                catch (Exception e) {
                    Object he;
                    if (e instanceof HandlerException) {
                        he = (HandlerException)e;
                        if (((HandlerException)he).isEmettiDiagnostico()) {
                            msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                        }
                        ejbUtils.rollbackMessage(((HandlerException)e).getIdentitaHandler() + " error: " + e.getMessage(), esito);
                    } else {
                        msgDiag.logErroreGenerico(e, "OutResponseHandler");
                        ejbUtils.rollbackMessage("OutResponseHandler error: " + e.getMessage(), esito);
                    }
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    he = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e11) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e11, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e11);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return he;
                }
                responseMessage = outResponseContext.getMessaggio();
                if (responseMessage != null) {
                    esitoHandler = protocolFactory.createEsitoBuilder().getEsito(null, 200, requestInfo.getProtocolServiceBinding(), responseMessage, null, (org.openspcoop2.utils.Map)pddContext);
                }
            }
            msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Impostazione messaggio del connettore...");
            String tipoConnector = connettore.getTipo();
            Property[] cps = null;
            if (connettore.getPropertyList().size() > 0) {
                cps = connettore.getPropertyList().toArray(new Property[connettore.getPropertyList().size()]);
            }
            ConnettoreMsg connettoreMsg = new ConnettoreMsg(tipoConnector, responseMessage, cps);
            connettoreMsg.setBusta(busta);
            connettoreMsg.setIdModulo(ID_MODULO);
            connettoreMsg.setProtocolFactory(protocolFactory);
            connettoreMsg.setMsgDiagnostico(msgDiag);
            connettoreMsg.setState(openspcoopstate.getStatoRichiesta());
            connettoreMsg.initPolicyGestioneToken(configurazionePdDManager, requestInfo);
            tipoConnector = ConnettoreUtils.formatTipoConnettore(this.propertiesReader, tipoConnector, connettoreMsg, this.asyncResponseCallback);
            msgDiag.addKeyword("@TIPO_CONNETTORE@", tipoConnector);
            int codiceRitornato = -1;
            OpenSPCoop2Message responseHttpReply = null;
            boolean errorConsegna = false;
            boolean riconsegna = false;
            Timestamp dataRiconsegna = null;
            String motivoErroreConsegna = null;
            boolean invokerNonSupportato = false;
            SOAPFault soapFaultConnectionReply = null;
            ProblemRFC7807 restProblemConnectionReply = null;
            OpenSPCoop2MessageFactory faultConnectionReplyMessageFactory = null;
            Exception eccezioneProcessamentoConnettore = null;
            String connectorClass = null;
            Exception eInvokerNonSupportato = null;
            if (!invokerNonSupportato) {
                try {
                    connectorSender = this.pluginLoader.newConnettore(tipoConnector);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Inizializzazione Connettore");
                    invokerNonSupportato = true;
                    eInvokerNonSupportato = e;
                }
                if (connectorSender != null) {
                    try {
                        connectorClass = connectorSender.getClass().getName();
                        AbstractCore.init(connectorSender, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                        invokerNonSupportato = true;
                        eInvokerNonSupportato = e;
                    }
                }
                if (!invokerNonSupportato && connectorSender == null) {
                    msgDiag.logErroreGenerico("ConnectorSender is null", "IConnettore.newInstance(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                    invokerNonSupportato = true;
                }
            }
            HttpRequestMethod httpRequestMethod = null;
            if (connectorSender != null) {
                try {
                    if (connectorSender instanceof ConnettoreBaseHTTP) {
                        ConnettoreBaseHTTP baseHttp = (ConnettoreBaseHTTP)connectorSender;
                        baseHttp.setHttpMethod(responseMessage);
                        if (ServiceBinding.REST.equals((Object)responseMessage.getServiceBinding())) {
                            httpRequestMethod = baseHttp.getHttpMethod();
                        }
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ConnettoreBaseHTTP.setHttpMethod(tipo:" + tipoConnector + " class:" + connectorClass + ")");
                    invokerNonSupportato = true;
                    eInvokerNonSupportato = e;
                }
            }
            if ((location = ConnettoreUtils.getAndReplaceLocationWithBustaValues(connectorSender, connettoreMsg, busta, pddContext, protocolFactory, this.log)) != null) {
                String locationWithUrl = ConnettoreUtils.buildLocationWithURLBasedParameter(this.log, responseMessage, connettoreMsg.getTipoConnettore(), connettoreMsg.getPropertiesUrlBased(), location, protocolFactory, this.idModulo);
                locationWithUrl = ConnettoreUtils.addProxyInfoToLocationForHTTPConnector(connettoreMsg.getTipoConnettore(), connettoreMsg.getConnectorProperties(), locationWithUrl);
                msgDiag.addKeyword("@LOCATION@", ConnettoreUtils.formatLocation(httpRequestMethod, locationWithUrl));
                pddContext.addObject(CostantiPdD.CONNETTORE_REQUEST_METHOD, httpRequestMethod);
                pddContext.addObject(CostantiPdD.CONNETTORE_REQUEST_URL, locationWithUrl);
            } else {
                msgDiag.addKeyword("@LOCATION@", "N.D.");
            }
            if (connettoreMsg.getConnectorProperties() == null) {
                HashMap<String, String> propCon = new HashMap<String, String>();
                connettoreMsg.setConnectorProperties(propCon);
            }
            if (connettoreMsg.getConnectorProperties().get("connectionTimeout") == null || connettoreMsg.getConnectorProperties().get("readConnectionTimeout") == null) {
                DatiTempiRisposta datiTempiRisposta = ConnettoreUtilities.readDatiGlobaliTimeout(configurazionePdDManager, TipoPdD.DELEGATA, requestInfo, this.propertiesReader);
                if (connettoreMsg.getConnectorProperties().get("connectionTimeout") == null) {
                    connettoreMsg.getConnectorProperties().put("connectionTimeout", "" + (datiTempiRisposta != null && datiTempiRisposta.getConnectionTimeout() != null ? datiTempiRisposta.getConnectionTimeout().intValue() : this.propertiesReader.getConnectionTimeoutInoltroBuste()));
                    connettoreMsg.getConnectorProperties().put("connectionTimeoutGlobale", "true");
                }
                if (connettoreMsg.getConnectorProperties().get("readConnectionTimeout") == null) {
                    connettoreMsg.getConnectorProperties().put("readConnectionTimeout", "" + (datiTempiRisposta != null && datiTempiRisposta.getReadConnectionTimeout() != null ? datiTempiRisposta.getReadConnectionTimeout().intValue() : this.propertiesReader.getReadConnectionTimeoutInoltroBuste()));
                    connettoreMsg.getConnectorProperties().put("readConnectionTimeoutGlobale", "true");
                }
            }
            UtilitiesIntegrazione httpUtilities = UtilitiesIntegrazione.getInstancePAResponse(this.log);
            if (connettoreMsg.getPropertiesTrasporto() == null) {
                HashMap<String, List<String>> trasporto = new HashMap<String, List<String>>();
                connettoreMsg.setPropertiesTrasporto(trasporto);
            }
            httpUtilities.setInfoProductTransportProperties(connettoreMsg.getPropertiesTrasporto());
            InfoConnettoreUscita infoConnettoreUscita = new InfoConnettoreUscita();
            infoConnettoreUscita.setLocation(location);
            infoConnettoreUscita.setProperties(connettoreMsg.getConnectorProperties());
            infoConnettoreUscita.setHeaders(connettoreMsg.getPropertiesTrasporto());
            infoConnettoreUscita.setParameters(connettoreMsg.getPropertiesUrlBased());
            infoConnettoreUscita.setSbustamentoSoap(connettoreMsg.isSbustamentoSOAP());
            infoConnettoreUscita.setSbustamentoInformazioniProtocollo(connettoreMsg.isSbustamentoInformazioniProtocollo());
            infoConnettoreUscita.setTipoAutenticazione(connettoreMsg.getAutenticazione());
            infoConnettoreUscita.setCredenziali(connettoreMsg.getCredenziali());
            infoConnettoreUscita.setTipoConnettore(connettoreMsg.getTipoConnettore());
            if (!invokerNonSupportato) {
                String tmpLocation;
                GestioneErrore gestioneConsegnaConnettore;
                GestoreErroreConnettore gestoreErrore;
                msgDiag.logPersonalizzato("inoltroInCorso");
                errorConsegna = !connectorSender.send(null, connettoreMsg);
                motivoErroreConsegna = connectorSender.getErrore();
                eccezioneProcessamentoConnettore = connectorSender.getEccezioneProcessamento();
                if (errorConsegna && motivoErroreConsegna == null) {
                    motivoErroreConsegna = "Errore durante la consegna";
                }
                boolean bl = errorConsegna = !(gestoreErrore = new GestoreErroreConnettore()).verificaConsegna(gestioneConsegnaConnettore = configurazionePdDManager.getGestioneErroreConnettoreComponenteCooperazione(protocolFactory, responseMessage.getServiceBinding()), motivoErroreConsegna, eccezioneProcessamentoConnettore, connectorSender);
                if (errorConsegna) {
                    motivoErroreConsegna = gestoreErrore.getErrore();
                    riconsegna = gestoreErrore.isRiconsegna();
                    dataRiconsegna = gestoreErrore.getDataRispedizione();
                }
                soapFaultConnectionReply = gestoreErrore.getFault();
                restProblemConnectionReply = gestoreErrore.getProblem();
                faultConnectionReplyMessageFactory = connectorSender.getResponse() != null ? connectorSender.getResponse().getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                codiceRitornato = connectorSender.getCodiceTrasporto();
                responseHttpReply = connectorSender.getResponse();
                Map<String, List<String>> headerTrasportoReply = connectorSender.getHeaderTrasporto();
                msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + codiceRitornato);
                if (motivoErroreConsegna != null) {
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", motivoErroreConsegna);
                }
                if ((tmpLocation = connectorSender.getLocation()) != null) {
                    boolean responseCached = false;
                    if (pddContext.containsKey(ConnettoreBase.RESPONSE_FROM_CACHE)) {
                        responseCached = (Boolean)pddContext.getObject(ConnettoreBase.RESPONSE_FROM_CACHE);
                    }
                    if (!responseCached) {
                        pddContext.addObject(CostantiPdD.CONNETTORE_REQUEST_METHOD, httpRequestMethod);
                        pddContext.addObject(CostantiPdD.CONNETTORE_REQUEST_URL, tmpLocation);
                    }
                    location = tmpLocation;
                    if (responseCached) {
                        msgDiag.addKeyword("@LOCATION@", location);
                    } else {
                        msgDiag.addKeyword("@LOCATION@", ConnettoreUtils.formatLocation(httpRequestMethod, location));
                    }
                }
                if (responseHttpReply != null) {
                    DumpConfigurazione dumpConfig = configurazionePdDManager.getDumpConfigurazione(pa);
                    Dump dumpApplicativo = new Dump(identitaPdD, ID_MODULO, idMessageRequest, soggettoMittente, idServizio, tipoPorta, msgDiag.getPorta(), pddContext, openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta(), dumpConfig);
                    dumpApplicativo.dumpRispostaIngresso(responseHttpReply, infoConnettoreUscita, headerTrasportoReply);
                }
            }
            msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
            openspcoopstate.updateResource(idTransazione);
            IValidatoreErrori validatoreErrori = protocolFactory.createValidatoreErrori(openspcoopstate.getStatoRichiesta());
            if (!invokerNonSupportato) {
                msgDiag.mediumDebug("Tracciamento della busta...");
                EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                if (inoltroSegnalazioneErrore) {
                    tracciamento.registraRichiesta(responseMessage, securityInfo, headerBusta, busta, esitoTraccia, Tracciamento.createLocationString(false, location), inoltroRisposteMsg.getIdCorrelazioneApplicativa());
                } else {
                    tracciamento.registraRisposta(responseMessage, securityInfo, headerBusta, busta, esitoTraccia, Tracciamento.createLocationString(false, location), inoltroRisposteMsg.getIdCorrelazioneApplicativa(), inoltroRisposteMsg.getIdCorrelazioneApplicativaRisposta());
                }
                if (errorConsegna) {
                    msgDiag.logPersonalizzato("ricezioneRestProblem");
                } else {
                    Object tipoMsg = "Messaggio Protocollo";
                    pValidazioneErrori = new ProprietaValidazioneErrori();
                    pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
                    pValidazioneErrori.setVersioneProtocollo(versioneProtocollo);
                    if (validatoreErrori.isBustaErrore(busta, responseMessage, pValidazioneErrori)) {
                        tipoMsg = (String)tipoMsg + " Errore";
                    }
                    if (configurazionePdDManager.isUtilizzoIndirizzoTelematico() && busta.getIndirizzoDestinatario() != null) {
                        msgDiag.addKeyword("@LOCATION@", "indirizzoTelematico[" + busta.getIndirizzoDestinatario() + "]");
                        msgDiag.logPersonalizzato("inoltroEffettuato");
                    } else {
                        msgDiag.logPersonalizzato("inoltroEffettuato");
                    }
                }
            }
            boolean presenzaRispostaProtocolConnectionReply = false;
            if (responseHttpReply != null) {
                msgDiag.mediumDebug("Analisi della risposta (validazione sintattica)...");
                ProprietaValidazione property = new ProprietaValidazione();
                property.setValidazioneConSchema(configurazionePdDManager.isLivelloValidazioneRigido(implementazionePdDDestinatario));
                property.setValidazioneProfiloCollaborazione(configurazionePdDManager.isValidazioneProfiloCollaborazione(implementazionePdDDestinatario));
                property.setValidazioneManifestAttachments(configurazionePdDManager.isValidazioneManifestAttachments(implementazionePdDDestinatario));
                validatoreProtocolConnectionReply = new Validatore(responseHttpReply, (Context)pddContext, property, openspcoopstate.getStatoRisposta(), readQualifiedAttribute, protocolFactory);
                presenzaRispostaProtocolConnectionReply = validatoreProtocolConnectionReply.validazioneSintattica();
                if (presenzaRispostaProtocolConnectionReply) {
                    msgDiag.addKeywords(validatoreProtocolConnectionReply.getBusta(), false);
                } else if (validatoreProtocolConnectionReply.getErrore() != null) {
                    this.log.debug("Messaggio non riconosciuto come busta (" + traduttore.toString(validatoreProtocolConnectionReply.getErrore().getCodiceErrore()) + "): " + validatoreProtocolConnectionReply.getErrore().getDescrizione(protocolFactory));
                }
            }
            msgDiag.mediumDebug("Gestione errore consegna della risposta...");
            if (invokerNonSupportato) {
                motivazioneErrore = "Connettore non supportato [tipo:" + tipoConnector + " class:" + connectorClass + "]";
                ejbUtils.rollbackMessage(motivazioneErrore, esito);
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3, motivazioneErrore);
                esito.setEsitoInvocazione(false);
                pValidazioneErrori = esito;
                return pValidazioneErrori;
            }
            if (errorConsegna && !presenzaRispostaProtocolConnectionReply) {
                if (soapFaultConnectionReply != null) {
                    msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.safe_toString(faultConnectionReplyMessageFactory, soapFaultConnectionReply, (Logger)this.log));
                    msgDiag.logPersonalizzato("ricezioneSoapFault");
                } else if (restProblemConnectionReply != null) {
                    msgDiag.addKeyword("@REST_PROBLEM@", restProblemConnectionReply.getRaw());
                    msgDiag.logPersonalizzato("ricezioneRestProblem");
                }
                motivazioneErrore = "Errore duranta la spedizione della busta: " + motivoErroreConsegna;
                if (riconsegna) {
                    ejbUtils.rollbackMessage(motivazioneErrore, dataRiconsegna, esito);
                    esito.setEsitoInvocazione(false);
                } else {
                    if (inoltroSegnalazioneErrore) {
                        ejbUtils.releaseOutboxMessage(false);
                    } else {
                        ejbUtils.releaseInboxMessage(false);
                    }
                    esito.setEsitoInvocazione(true);
                }
                openspcoopstate.releaseResource();
                esito.setStatoInvocazione(3, motivazioneErrore);
                pValidazioneErrori = esito;
                return pValidazioneErrori;
            }
            boolean isMessaggioErroreProtocolloConnectionReply = false;
            Busta bustaConnectionReply = null;
            if (presenzaRispostaProtocolConnectionReply) {
                bustaConnectionReply = validatoreProtocolConnectionReply.getBusta();
                isMessaggioErroreProtocolloConnectionReply = validatoreProtocolConnectionReply.isErroreProtocollo();
                if (isMessaggioErroreProtocolloConnectionReply) {
                    msgDiag.logPersonalizzato("ricezioneMessaggioErrore");
                } else {
                    msgDiag.logPersonalizzato("ricezioneMessaggio");
                }
                msgDiag.mediumDebug("Sbustamento della risposta...");
                BustaRawContent headerProtocolloRispostaConnectionReply = null;
                try {
                    Sbustamento sbustatore;
                    ProtocolMessage protocolMessage;
                    boolean gestioneManifestRispostaHttp = false;
                    if (!functionAsRouter) {
                        gestioneManifestRispostaHttp = configurazionePdDManager.isGestioneManifestAttachments();
                    }
                    if ((protocolMessage = (sbustatore = new Sbustamento(protocolFactory, openspcoopstate.getStatoRichiesta())).sbustamento(responseHttpReply, (Context)pddContext, busta, RuoloMessaggio.RISPOSTA, gestioneManifestRispostaHttp, proprietaManifestAttachments, FaseSbustamento.POST_CONSEGNA_RISPOSTA_NEW_CONNECTION, requestInfo)) != null) {
                        headerProtocolloRispostaConnectionReply = protocolMessage.getBustaRawContent();
                        responseHttpReply = protocolMessage.getMessage();
                    }
                }
                catch (Exception e) {
                    EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Sbustamento busta nella connection Reply non riuscita: " + e.getMessage()));
                    tracciamento.registraRisposta(responseHttpReply, null, validatoreProtocolConnectionReply.getHeaderProtocollo(), bustaConnectionReply, esitoTraccia, Tracciamento.createLocationString(true, location), inoltroRisposteMsg.getIdCorrelazioneApplicativa(), inoltroRisposteMsg.getIdCorrelazioneApplicativaRisposta());
                    msgDiag.logErroreGenerico(e, "sbustatore.sbustamento(" + bustaConnectionReply.getID() + ")");
                    ejbUtils.rollbackMessage("Sbustamento busta nella connection Reply non riuscita.", esito);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    esito.setEsitoInvocazione(false);
                    EsitoLib protocolMessage = esito;
                    try {
                        if (connectorSender != null) {
                            connectorSender.disconnect();
                        }
                    }
                    catch (Exception e12) {
                        try {
                            if (msgDiag != null) {
                                msgDiag.logDisconnectError(e12, location);
                            }
                        }
                        catch (Exception eDisconnect) {
                            this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e12);
                        }
                    }
                    if (validatoreProtocolConnectionReply != null) {
                        if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                            validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                        }
                        validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                    }
                    validatoreProtocolConnectionReply = null;
                    return protocolMessage;
                }
                msgDiag.mediumDebug("Tracciamento della risposta...");
                EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioRicevuto();
                tracciamento.registraRisposta(responseHttpReply, null, headerProtocolloRispostaConnectionReply, bustaConnectionReply, esitoTraccia, Tracciamento.createLocationString(true, location), inoltroRisposteMsg.getIdCorrelazioneApplicativa(), inoltroRisposteMsg.getIdCorrelazioneApplicativaRisposta());
                if (functionAsRouter) {
                    Object msg;
                    msgDiag.mediumDebug("Registrazione messaggio nel Repository Messaggi/Buste...");
                    msgConnectionReply = new GestoreMessaggi(openspcoopstate, false, bustaConnectionReply.getID(), "OUTBOX", msgDiag, pddContext);
                    msgConnectionReply.setOneWayVersione11(oneWayVersione11);
                    try {
                        repositoryConnectionReply = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
                        if (msgConnectionReply.existsMessage_noCache()) {
                            String proprietarioMessaggio = msgConnectionReply.getProprietario(ID_MODULO);
                            if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", bustaConnectionReply.getID());
                                msgDiag.logPersonalizzato_prefix("(http reply) ", "ricezioneSoapMessage.msgGiaPresente");
                                msg = "(http reply)" + msgDiag.getMessaggio_replaceKeywords("ricezioneSoapMessage.msgGiaPresente");
                                if (this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                    msgConnectionReply._deleteMessageWithLock((String)msg, this.propertiesReader.getMsgGiaInProcessamentoAttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                } else {
                                    msgConnectionReply.deleteMessageByNow();
                                }
                            } else {
                                throw new Exception("Altra copia della Busta ricevuta come risposta nella http reply con id[" + bustaConnectionReply.getID() + "] in elaborazione dal modulo " + proprietarioMessaggio);
                            }
                        }
                        msgConnectionReply.registraMessaggio(responseHttpReply, inoltroRisposteMsg.getIdCorrelazioneApplicativa(), inoltroRisposteMsg.getIdCorrelazioneApplicativaRisposta());
                        msgConnectionReply.aggiornaProprietarioMessaggio(ID_MODULO);
                        msgConnectionReply.aggiornaRiferimentoMessaggio(busta.getID());
                        repositoryConnectionReply.registraBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                        Integrazione infoIntegrazione = new Integrazione();
                        repositoryConnectionReply.aggiornaInfoIntegrazioneIntoOutBox(bustaConnectionReply.getID(), infoIntegrazione);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "RegistrazioneRisposta(" + bustaConnectionReply.getID() + ")");
                        ejbUtils.rollbackMessage("Salvataggio messaggio nella connection Reply non riuscita.", esito);
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazioneErroreNonGestito(e);
                        esito.setEsitoInvocazione(false);
                        msg = esito;
                        try {
                            if (connectorSender != null) {
                                connectorSender.disconnect();
                            }
                        }
                        catch (Exception e13) {
                            try {
                                if (msgDiag != null) {
                                    msgDiag.logDisconnectError(e13, location);
                                }
                            }
                            catch (Exception eDisconnect) {
                                this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e13);
                            }
                        }
                        if (validatoreProtocolConnectionReply != null) {
                            if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                                validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                            }
                            validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                        }
                        validatoreProtocolConnectionReply = null;
                        return msg;
                    }
                    msgDiag.mediumDebug("Ridirezione messaggio a InoltroRisposte...");
                    try {
                        ejbUtils.sendToInoltroRisposte(bustaConnectionReply, true, null, msgConnectionReply, null, null, null, true);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroRisposte ID:" + bustaConnectionReply.getID() + ")");
                        ejbUtils.rollbackMessage("Inoltro messaggio ricevuto nella connection Reply non riuscito.", esito);
                        openspcoopstate.releaseResource();
                        esito.setStatoInvocazioneErroreNonGestito(e);
                        esito.setEsitoInvocazione(false);
                        msg = esito;
                        try {
                            if (connectorSender != null) {
                                connectorSender.disconnect();
                            }
                        }
                        catch (Exception e14) {
                            try {
                                if (msgDiag != null) {
                                    msgDiag.logDisconnectError(e14, location);
                                }
                            }
                            catch (Exception eDisconnect) {
                                this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e14);
                            }
                        }
                        if (validatoreProtocolConnectionReply != null) {
                            if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                                validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                            }
                            validatoreProtocolConnectionReply.setValidatoreSintattico(null);
                        }
                        validatoreProtocolConnectionReply = null;
                        return msg;
                    }
                }
            } else if (responseHttpReply != null) {
                if (soapFaultConnectionReply != null) {
                    msgDiag.addKeyword("@SOAP_FAULT@", SoapUtils.safe_toString(faultConnectionReplyMessageFactory, (SOAPFault)soapFaultConnectionReply, (Logger)this.log));
                    msgDiag.logPersonalizzato("ricezioneSoapFault");
                } else if (restProblemConnectionReply != null) {
                    msgDiag.addKeyword("@REST_PROBLEM@", restProblemConnectionReply.getRaw());
                    msgDiag.logPersonalizzato("ricezioneRestProblem");
                }
            }
            msgDiag.mediumDebug("Aggiorno proprietario messaggio ...");
            msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
            msgDiag.mediumDebug("Elimino utilizzo busta dalla PdD ...");
            repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
            if (oneWayVersione11) {
                repositoryBuste.eliminaBustaStatelessFromOutBox(busta.getID());
            } else {
                repositoryBuste.eliminaUtilizzoPdDFromOutBox(busta.getID());
            }
            msgDiag.addKeyword("@TIPO_CONNETTORE@", tipoConnector);
            msgDiag.logPersonalizzato("gestioneConsegnaTerminata");
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "busta da inoltrare");
            }
            if (msgConnectionReply != null) {
                msgConnectionReply.addMessaggiIntoCache_readFromTable(ID_MODULO, "connection http reply");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "busta da inoltrare", idMessageRequest, functionAsRouter);
            }
            if (msgConnectionReply != null) {
                msgConnectionReply.addProprietariIntoCache_readFromTable(ID_MODULO, "connection http reply", idMessageResponse, functionAsRouter);
            }
            msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            PostOutResponseContext postOutResponseContext = new PostOutResponseContext(this.log, protocolFactory);
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            if (responseMessage != null) {
                postOutResponseContext.setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                postOutResponseContext.setOutputResponseMessageSize(responseMessage.getOutgoingMessageContentLength());
            }
            postOutResponseContext.setProtocollo(outResponseContext.getProtocollo());
            postOutResponseContext.setEsito(esitoHandler);
            postOutResponseContext.setPddContext(pddContext);
            postOutResponseContext.setIntegrazione(outResponseContext.getIntegrazione());
            postOutResponseContext.setMessaggio(responseMessage);
            postOutResponseContext.setTipoPorta(outResponseContext.getTipoPorta());
            GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag, this.log);
            msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setEsitoInvocazione(true);
            esito.setStatoInvocazione(1, null);
            EsitoLib esitoLib = esito;
            return esitoLib;
        }
        catch (Throwable e) {
            this.log.error("ErroreGenerale", e);
            msgDiag.logErroreGenerico(e, "Generale");
            ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), esito);
            esito.setStatoInvocazioneErroreNonGestito(e);
            esito.setEsitoInvocazione(false);
            openspcoopstate.releaseResource();
            EsitoLib esitoLib = esito;
            return esitoLib;
        }
        finally {
            try {
                if (connectorSender != null) {
                    connectorSender.disconnect();
                }
            }
            catch (Exception e) {
                try {
                    if (msgDiag != null) {
                        msgDiag.logDisconnectError(e, location);
                    }
                }
                catch (Exception eDisconnect) {
                    this.log.error("Errore durante la chiusura delle connessione: " + eDisconnect.getMessage(), (Throwable)e);
                }
            }
            if (validatoreProtocolConnectionReply != null) {
                if (validatoreProtocolConnectionReply.getValidatoreSintattico() != null) {
                    validatoreProtocolConnectionReply.getValidatoreSintattico().setHeaderSOAP(null);
                }
                validatoreProtocolConnectionReply.setValidatoreSintattico(null);
            }
            validatoreProtocolConnectionReply = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowProperties getFlowProperties(Busta bustaRisposta, ConfigurazionePdDManager configurazionePdDManager, IState state, MsgDiagnostico msgDiag, IProtocolFactory<?> protocolFactory, PortaApplicativa paFind, RequestInfo requestInfo) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = RuoloMessaggio.RISPOSTA;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            if (bustaRisposta.getProfiloDiCollaborazione() == null && bustaRisposta.sizeListaRiscontri() > 0) {
                if (bustaRisposta.getTipoServizioRichiedenteBustaDiServizio() != null && bustaRisposta.getServizioRichiedenteBustaDiServizio() != null) {
                    PortaApplicativa pa = paFind;
                    if (pa == null) {
                        IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRisposta.getTipoServizioRichiedenteBustaDiServizio(), bustaRisposta.getServizioRichiedenteBustaDiServizio(), bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getVersioneServizioRichiedenteBustaDiServizio().intValue());
                        idServizioPA.setAzione(bustaRisposta.getAzioneRichiedenteBustaDiServizio());
                        pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                    }
                    flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pa);
                }
            } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)bustaRisposta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                PortaApplicativa pa = paFind;
                if (pa == null) {
                    IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getVersioneServizio().intValue());
                    idServizioPA.setAzione(bustaRisposta.getAzione());
                    pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                }
                flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pa);
                flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pa);
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(state, protocolFactory);
                if (profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRisposta.getRiferimentoMessaggio())) {
                    PortaApplicativa pa = paFind;
                    if (pa == null) {
                        IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getVersioneServizio().intValue());
                        idServizioPA.setAzione(bustaRisposta.getAzione());
                        pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                    }
                    flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pa);
                } else if (profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRisposta.getRiferimentoMessaggio())) {
                    RepositoryBuste repository = new RepositoryBuste(state, false, protocolFactory);
                    Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRisposta.getRiferimentoMsgBustaRichiedenteServizio());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(integrazione.getNomePorta());
                    PortaDelegata pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                    flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pd);
                    flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pd);
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)bustaRisposta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(state, protocolFactory);
                if (profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRisposta.getRiferimentoMessaggio())) {
                    PortaApplicativa pa = paFind;
                    if (pa == null) {
                        IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(bustaRisposta.getTipoServizio(), bustaRisposta.getServizio(), bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getVersioneServizio().intValue());
                        idServizioPA.setAzione(bustaRisposta.getAzione());
                        pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                    }
                    flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pa);
                } else if (profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRisposta.getRiferimentoMessaggio())) {
                    PortaApplicativa pa = paFind;
                    if (pa == null) {
                        IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRisposta.getRiferimentoMsgBustaRichiedenteServizio());
                        IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(idServizioOriginale.getTipo(), idServizioOriginale.getNome(), bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), idServizioOriginale.getVersione().intValue());
                        idServizioPA.setAzione(idServizioOriginale.getAzione());
                        pa = this.getPortaApplicativa(configurazionePdDManager, idServizioPA);
                    }
                    flowProperties.messageSecurity = configurazionePdDManager.getMessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDManager.getMTOMProcessorForSender(pa);
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "LetturaDatiMessageSecurity");
            this.log.error("Lettura dati MessageSecurity per la spedizione del messaggio di risposta non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null && state instanceof StatefulMessage) {
                ((StatefulMessage)state).closePreparedStatement();
            }
        }
        return flowProperties;
    }

    private PortaApplicativa getPortaApplicativa(ConfigurazionePdDManager configurazionePdDReader, IDServizio idServizio) throws Exception {
        List<PortaApplicativa> listPa = configurazionePdDReader.getPorteApplicative(idServizio, false);
        if (listPa.size() <= 0) {
            throw new Exception("Non esiste alcuna porta applicativa indirizzabile tramite il servizio [" + String.valueOf(idServizio) + "]");
        }
        if (listPa.size() > 1) {
            throw new Exception("Esiste pi\u00f9 di una porta applicativa indirizzabile tramite il servizio [" + String.valueOf(idServizio) + "]");
        }
        return listPa.get(0);
    }
}

