/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.connector.ConnectorApplicativeThreadFactory;
import org.openspcoop2.pdd.services.connector.ConnectorAsyncThreadPoolConfig;
import org.openspcoop2.utils.threads.MonitoredVirtualThreadExecutor;

public class ConnectorApplicativeThreadPool {
    private static ExecutorService syncRequestPool;
    private static String inRequestThreadPoolId;
    private static String outRequestThreadPoolId;
    private static String outResponseThreadPoolId;
    private static String inResponseThreadPoolId;
    private static Map<String, ExecutorService> asyncThreadPool;

    private ConnectorApplicativeThreadPool() {
    }

    public String getInRequestThreadPoolId() {
        return inRequestThreadPoolId;
    }

    public String getOutRequestThreadPoolId() {
        return outRequestThreadPoolId;
    }

    public String getOutResponseThreadPoolId() {
        return outResponseThreadPoolId;
    }

    public String getInResponseThreadPoolId() {
        return inResponseThreadPoolId;
    }

    public static void initialize(OpenSPCoop2Properties op2) {
        int size;
        if (!op2.isBIOConfigSyncClientUseCustomMessageObjectEntity() && (size = op2.getBIOConfigSyncClientApplicativeThreadPoolSize()) > 0) {
            syncRequestPool = Executors.newFixedThreadPool(size, new ConnectorApplicativeThreadFactory("request-bio-nonblocking-io"));
        }
        if (op2.isNIOEnabled() && (op2.isNIOConfigAsyncRequestStreamEnabled() || op2.isNIOConfigAsyncResponseStreamEnabled())) {
            ConnectorAsyncThreadPoolConfig poolConfig = op2.getNIOConfigAsyncThreadPoolConfig();
            inRequestThreadPoolId = poolConfig.getInRequestThreadPoolId();
            outRequestThreadPoolId = poolConfig.getOutRequestThreadPoolId();
            inResponseThreadPoolId = poolConfig.getInResponseThreadPoolId();
            outResponseThreadPoolId = poolConfig.getOutResponseThreadPoolId();
            asyncThreadPool = new HashMap<String, ExecutorService>();
            for (Map.Entry<String, Boolean> entry : poolConfig.getPoolVirtualThreadType().entrySet()) {
                String poolName = entry.getKey();
                boolean virtualThreads = entry.getValue();
                if (virtualThreads) {
                    asyncThreadPool.put(poolName, (ExecutorService)new MonitoredVirtualThreadExecutor(poolName + "-worker-"));
                    continue;
                }
                int size2 = poolConfig.getPoolSize().get(poolName);
                asyncThreadPool.put(poolName, Executors.newFixedThreadPool(size2, new ConnectorApplicativeThreadFactory(poolName + "-worker")));
            }
        }
    }

    public static void executeBySyncRequestPool(Runnable runnable) {
        syncRequestPool.execute(runnable);
    }

    public static void executeByAsyncInRequestPool(Runnable runnable) {
        asyncThreadPool.get(inRequestThreadPoolId).execute(runnable);
    }

    public static void executeByAsyncOutRequestPool(Runnable runnable) {
        asyncThreadPool.get(outRequestThreadPoolId).execute(runnable);
    }

    public static void executeByAsyncInResponsePool(Runnable runnable) {
        asyncThreadPool.get(inResponseThreadPoolId).execute(runnable);
    }

    public static void executeByAsyncOutResponsePool(Runnable runnable) {
        asyncThreadPool.get(outResponseThreadPoolId).execute(runnable);
    }

    public static ExecutorService getSyncRequestPool() {
        return syncRequestPool;
    }

    public static ExecutorService getAsyncInRequestPool() {
        return asyncThreadPool.get(inRequestThreadPoolId);
    }

    public static ExecutorService getAsyncOutRequestPool() {
        return asyncThreadPool.get(outRequestThreadPoolId);
    }

    public static ExecutorService getAsyncInResponsePool() {
        return asyncThreadPool.get(inResponseThreadPoolId);
    }

    public static ExecutorService getAsyncOutResponsePool() {
        return asyncThreadPool.get(outResponseThreadPoolId);
    }

    public static void shutdown() {
        if (syncRequestPool != null) {
            syncRequestPool.shutdown();
        }
        for (Map.Entry<String, ExecutorService> entry : asyncThreadPool.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().shutdown();
        }
    }

    public static String getSyncRequestPoolThreadsImage() {
        ExecutorService executorService = syncRequestPool;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
            return ConnectorApplicativeThreadPool.getThreadsImage(tpe);
        }
        return null;
    }

    public static boolean isSyncRequestPoolThreadsEnabled() {
        return syncRequestPool != null;
    }

    public static String getAsyncPoolThreadsImage() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ExecutorService> entry : asyncThreadPool.entrySet()) {
            if (entry.getKey() == null) continue;
            ConnectorApplicativeThreadPool.fillAsyncPoolThreadsImage(entry, sb);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static void fillAsyncPoolThreadsImage(Map.Entry<String, ExecutorService> entry, StringBuilder sb) {
        ExecutorService executorService = entry.getValue();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append("[").append(entry.getKey()).append("] ").append(ConnectorApplicativeThreadPool.getThreadsImage(tpe)).append(", virtualThreads:false");
        } else {
            executorService = entry.getValue();
            if (executorService instanceof MonitoredVirtualThreadExecutor) {
                MonitoredVirtualThreadExecutor tpe = (MonitoredVirtualThreadExecutor)executorService;
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append("[").append(entry.getKey()).append("] ").append(tpe.getStatus()).append(", virtualThreads:true");
            }
        }
    }

    public static boolean isAsyncPoolThreadsEnabled() {
        return asyncThreadPool != null;
    }

    private static String getThreadsImage(ThreadPoolExecutor tpe) {
        return String.format("(queue:%d) [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", tpe.getQueue() != null ? tpe.getQueue().size() : -1, tpe.getPoolSize(), tpe.getCorePoolSize(), tpe.getActiveCount(), tpe.getCompletedTaskCount(), tpe.getTaskCount(), tpe.isShutdown(), tpe.isTerminated());
    }

    static {
        inRequestThreadPoolId = null;
        outRequestThreadPoolId = null;
        outResponseThreadPoolId = null;
        inResponseThreadPoolId = null;
        asyncThreadPool = null;
    }
}

