/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.CheckStatoPdD;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.Proxy;
import org.openspcoop2.pdd.services.connector.RicezioneBusteConnector;
import org.openspcoop2.pdd.services.connector.RicezioneBusteConnectorAsync;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiConnector;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiConnectorAsync;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiHTTPtoSOAPConnector;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiHTTPtoSOAPConnectorAsync;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.FunctionContextsCustom;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class OpenSPCoop2Servlet
extends HttpServlet {
    private static Logger logger = null;
    private static boolean checkSecrets = false;
    private static final Semaphore semaphoreCheckSecrets = new Semaphore("GovWaySecrets");

    private static synchronized Logger getLoggerStartup() {
        if (logger == null) {
            logger = LoggerWrapperFactory.getLogger((String)"govway.startup");
        }
        return logger;
    }

    private static Logger getLogger() {
        if (logger == null) {
            OpenSPCoop2Servlet.getLoggerStartup();
        }
        return logger;
    }

    private static void checkSecrets() {
        if (!checkSecrets) {
            OpenSPCoop2Servlet.initSecrets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSecrets() {
        block6: {
            SemaphoreLock lock = semaphoreCheckSecrets.acquireThrowRuntime("initSecrets");
            try {
                if (checkSecrets) break block6;
                BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                if (secretsProperties != null && secretsProperties.isExistsUnwrapPropertiesAfterGovWayStartup()) {
                    secretsProperties.setGovWayStarted(true);
                    try {
                        secretsProperties.initEnvironment();
                        String secretsConfig = OpenSPCoop2Properties.getInstance().getBYOKEnvSecretsConfig();
                        String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "' dopo il completamento dell'avvio di GovWay\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                        OpenSPCoop2Startup.logStartupInfo(msgInit);
                    }
                    catch (Exception e) {
                        OpenSPCoop2Startup.logStartupError("Inizializzazione ambiente (secrets) non riuscita: " + e.getMessage(), e);
                    }
                }
                checkSecrets = true;
            }
            finally {
                semaphoreCheckSecrets.release(lock, "initSecrets");
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpRequestMethod m = null;
        try {
            m = HttpRequestMethod.valueOf((String)req.getMethod().toUpperCase());
        }
        catch (Exception e) {
            super.service(req, resp);
            return;
        }
        switch (m) {
            case DELETE: {
                this.doDelete(req, resp);
                break;
            }
            case GET: {
                this.doGet(req, resp);
                break;
            }
            case HEAD: {
                this.doHead(req, resp);
                break;
            }
            case OPTIONS: {
                this.doOptions(req, resp);
                break;
            }
            case POST: {
                this.doPost(req, resp);
                break;
            }
            case PUT: {
                this.doPut(req, resp);
                break;
            }
            case TRACE: {
                this.doTrace(req, resp);
                break;
            }
            case PATCH: 
            case LINK: 
            case UNLINK: {
                boolean enabled = true;
                OpenSPCoop2Properties op2Properties = null;
                try {
                    op2Properties = OpenSPCoop2Properties.getInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (op2Properties != null) {
                    enabled = HttpRequestMethod.PATCH.equals((Object)m) ? op2Properties.isServiceRequestHttpMethodPatchEnabled() : (HttpRequestMethod.LINK.equals((Object)m) ? op2Properties.isServiceRequestHttpMethodLinkEnabled() : op2Properties.isServiceRequestHttpMethodUnlinkEnabled());
                }
                if (enabled) {
                    this.dispatch(req, resp, m);
                    break;
                }
                super.service(req, resp);
                break;
            }
            default: {
                super.service(req, resp);
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.DELETE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.GET);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.HEAD);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.OPTIONS);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.POST);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.PUT);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, HttpRequestMethod.TRACE);
    }

    private void dispatch(HttpServletRequest req, HttpServletResponse res, HttpRequestMethod method) {
        block64: {
            Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            Logger logOpenSPCoop2Servlet = OpenSPCoop2Servlet.getLogger();
            OpenSPCoop2Properties op2Properties = null;
            try {
                if (!OpenSPCoop2Startup.initialize) {
                    String contextPath = req.getContextPath();
                    String requestUri = req.getRequestURI();
                    if (requestUri != null && contextPath != null && requestUri.startsWith(contextPath) && requestUri.length() > contextPath.length()) {
                        String function = requestUri.substring(contextPath.length(), requestUri.length());
                        if (function.startsWith("/") && function.length() > 1) {
                            function = function.substring(1);
                        }
                        if (function.equals("check") || function.equals("proxy")) {
                            CheckStatoPdD.serializeNotInitializedResponse(res, logCore != null ? logCore : logOpenSPCoop2Servlet);
                            return;
                        }
                    }
                    int max = 90;
                    int sleepCheck = 1000;
                    for (int i = 0; i < 5; ++i) {
                        if (OpenSPCoop2Properties.getInstance() == null) {
                            Utilities.sleep((long)1000L);
                        }
                        if (OpenSPCoop2Properties.getInstance() != null) break;
                    }
                    if (OpenSPCoop2Properties.getInstance() != null) {
                        max = OpenSPCoop2Properties.getInstance().getStartupRichiesteIngressoTimeoutSecondi();
                        sleepCheck = OpenSPCoop2Properties.getInstance().getStartupRichiesteIngressoCheckMs();
                    }
                    int maxMs = max * 1000;
                    for (int actualMs = 0; !OpenSPCoop2Startup.initialize && actualMs < maxMs; actualMs += sleepCheck) {
                        Utilities.sleep((long)sleepCheck);
                    }
                    if (!OpenSPCoop2Startup.initialize) {
                        StringBuilder bfLogError = new StringBuilder();
                        ConnectorUtils.generateErrorMessage(IDService.OPENSPCOOP2_SERVLET, method, req, bfLogError, "GovWay non inizializzato", true, false);
                        if (logCore != null) {
                            String msg = bfLogError.toString();
                            logCore.error(msg);
                        } else {
                            String msg = bfLogError.toString();
                            logOpenSPCoop2Servlet.error(msg);
                        }
                        res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeGovWayNotInitialized(IDService.OPENSPCOOP2_SERVLET)));
                        return;
                    }
                }
                op2Properties = OpenSPCoop2Properties.getInstance();
                boolean nioEnabled = false;
                boolean printCertificate = false;
                FunctionContextsCustom customContexts = null;
                if (op2Properties != null) {
                    nioEnabled = op2Properties.isNIOEnabled();
                    printCertificate = op2Properties.isPrintInfoCertificate();
                    customContexts = op2Properties.getCustomContexts();
                }
                URLProtocolContextImpl protocolContext = new URLProtocolContextImpl(req, logCore, printCertificate, customContexts);
                String function = protocolContext.getFunction();
                String prefixFunction = "Service [" + function + "] ";
                IDService idServiceCustom = protocolContext.getIdServiceCustom();
                IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByServletContext(protocolContext.getProtocolWebContext());
                if (pf == null) {
                    if (!"@EMPTY@".equals(protocolContext.getProtocolWebContext())) {
                        throw new CoreException("Non risulta registrato un protocollo con contesto [" + protocolContext.getProtocolWebContext() + "]");
                    }
                    throw new CoreException("Non risulta registrato un protocollo con contesto speciale 'vuoto'");
                }
                if (function.equals("PD") && op2Properties.isEnabledFunctionPD() || idServiceCustom != null && IDService.PORTA_DELEGATA.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    if (nioEnabled && op2Properties.isEnabledPDChannelNIODefault()) {
                        RicezioneContenutiApplicativiConnectorAsync r = new RicezioneContenutiApplicativiConnectorAsync();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    } else {
                        RicezioneContenutiApplicativiConnector r = new RicezioneContenutiApplicativiConnector();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    }
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_DELEGATA_NIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneContenutiApplicativiConnectorAsync r = new RicezioneContenutiApplicativiConnectorAsync();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_DELEGATA_BIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneContenutiApplicativiConnector r = new RicezioneContenutiApplicativiConnector();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (function.equals("PDtoSOAP") && op2Properties.isEnabledFunctionPDtoSOAP() || idServiceCustom != null && IDService.PORTA_DELEGATA_XML_TO_SOAP.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    if (nioEnabled && op2Properties.isEnabledPDtoSoapChannelNIODefault()) {
                        RicezioneContenutiApplicativiHTTPtoSOAPConnectorAsync r = new RicezioneContenutiApplicativiHTTPtoSOAPConnectorAsync();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    } else {
                        RicezioneContenutiApplicativiHTTPtoSOAPConnector r = new RicezioneContenutiApplicativiHTTPtoSOAPConnector();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    }
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_DELEGATA_XML_TO_SOAP_NIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneContenutiApplicativiHTTPtoSOAPConnectorAsync r = new RicezioneContenutiApplicativiHTTPtoSOAPConnectorAsync();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_DELEGATA_XML_TO_SOAP_BIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneContenutiApplicativiHTTPtoSOAPConnector r = new RicezioneContenutiApplicativiHTTPtoSOAPConnector();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (function.equals("PA") && op2Properties.isEnabledFunctionPA() || idServiceCustom != null && IDService.PORTA_APPLICATIVA.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    if (nioEnabled && op2Properties.isEnabledPAChannelNIODefault()) {
                        RicezioneBusteConnectorAsync r = new RicezioneBusteConnectorAsync();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    } else {
                        RicezioneBusteConnector r = new RicezioneBusteConnector();
                        r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    }
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_APPLICATIVA_NIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneBusteConnectorAsync r = new RicezioneBusteConnectorAsync();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (nioEnabled && idServiceCustom != null && IDService.PORTA_APPLICATIVA_BIO.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    RicezioneBusteConnector r = new RicezioneBusteConnector();
                    r.doEngine(ConnectorUtils.getRequestInfo(pf, (URLProtocolContext)protocolContext), req, res, method);
                    break block64;
                }
                if (function.equals("IntegrationManager") || idServiceCustom != null && IDService.INTEGRATION_MANAGER_SOAP.equals((Object)idServiceCustom)) {
                    OpenSPCoop2Servlet.checkSecrets();
                    if (op2Properties != null && !op2Properties.isIntegrationManagerEnabled()) {
                        throw new CoreException(prefixFunction + "not active");
                    }
                    boolean wsdl = false;
                    if (HttpRequestMethod.GET.equals((Object)method)) {
                        Enumeration parameters = req.getParameterNames();
                        while (parameters.hasMoreElements()) {
                            String key = (String)parameters.nextElement();
                            String value = req.getParameter(key);
                            if (!"wsdl".equalsIgnoreCase(key) || value != null && !"".equals(value)) continue;
                            if (op2Properties != null && !op2Properties.isGenerazioneWsdlIntegrationManagerEnabled()) {
                                res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeWsdlUnsupported(IDService.INTEGRATION_MANAGER_SOAP)));
                                return;
                            }
                            wsdl = true;
                            break;
                        }
                    }
                    if (!HttpRequestMethod.POST.equals((Object)method) && !wsdl) {
                        boolean errore404 = false;
                        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedIntegrationManagerEnabled()) {
                            errore404 = true;
                        }
                        if (errore404) {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(IDService.INTEGRATION_MANAGER_SOAP, method)));
                            return;
                        }
                        res.setStatus(500);
                        ConnectorUtils.generateErrorMessage(IDService.INTEGRATION_MANAGER_SOAP, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
                        this.resFlushAndCloseSafe(res);
                        return;
                    }
                    String serviceIM = protocolContext.getFunctionParameters();
                    if ("out".equals(serviceIM) || "out/".equals(serviceIM)) {
                        serviceIM = "PD";
                    }
                    String forwardUrl = "/IntegrationManagerEngine/" + serviceIM;
                    req.setAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()), (Object)protocolContext.getProtocolName());
                    req.setAttribute((String)((Object)Costanti.PROTOCOL_WEB_CONTEXT.getValue()), (Object)protocolContext.getProtocolWebContext());
                    req.setAttribute((String)((Object)Costanti.INTEGRATION_MANAGER_ENGINE_AUTHORIZED.getValue()), (Object)true);
                    RequestDispatcher dispatcher = req.getRequestDispatcher(forwardUrl);
                    dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                    break block64;
                }
                if (function.equals("check")) {
                    if (!HttpRequestMethod.GET.equals((Object)method)) {
                        boolean errore404 = false;
                        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedCheckEnabled()) {
                            errore404 = true;
                        }
                        if (errore404) {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(IDService.CHECK_PDD, method)));
                            return;
                        }
                        res.setStatus(500);
                        ConnectorUtils.generateErrorMessage(IDService.CHECK_PDD, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
                        this.resFlushAndCloseSafe(res);
                        return;
                    }
                    CheckStatoPdD checkStatoPdD = new CheckStatoPdD();
                    req.setAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()), (Object)protocolContext.getProtocolName());
                    checkStatoPdD.doGet(req, res);
                    break block64;
                }
                if (function.equals("proxy")) {
                    if (op2Properties != null && !op2Properties.isProxyReadJMXResourcesEnabled()) {
                        throw new CoreException(prefixFunction + "not supported");
                    }
                    if (!HttpRequestMethod.GET.equals((Object)method)) {
                        boolean errore404 = false;
                        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedProxyEnabled()) {
                            errore404 = true;
                        }
                        if (errore404) {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(IDService.PROXY, method)));
                            return;
                        }
                        res.setStatus(500);
                        ConnectorUtils.generateErrorMessage(IDService.PROXY, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
                        this.resFlushAndCloseSafe(res);
                        return;
                    }
                    Proxy proxy = new Proxy();
                    req.setAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()), (Object)protocolContext.getProtocolName());
                    proxy.doGet(req, res);
                    break block64;
                }
                throw new CoreException(prefixFunction + "not supported");
            }
            catch (Exception e) {
                block66: {
                    block65: {
                        StringBuilder bf = new StringBuilder();
                        bf.append("RemoteAddr[" + req.getRemoteAddr() + "] ");
                        bf.append("RemoteHost[" + req.getRemoteHost() + "] ");
                        bf.append("RemotePort[" + req.getRemotePort() + "] ");
                        bf.append("RemoteUser[" + req.getRemoteUser() + "] ");
                        bf.append("LocalAddr[" + req.getLocalAddr() + "] ");
                        bf.append("LocalHost[" + req.getLocalName() + "] ");
                        bf.append("LocalPort[" + req.getLocalPort() + "] ");
                        bf.append("ServerName[" + req.getServerName() + "] ");
                        bf.append("ServerPort[" + req.getServerPort() + "] ");
                        if (logCore != null) {
                            logCore.error(e.getMessage(), (Throwable)e);
                            msgError = "Detail: " + bf.toString();
                            logCore.error(msgError);
                        } else {
                            logOpenSPCoop2Servlet.error(e.getMessage(), (Throwable)e);
                            msgError = "Detail: " + bf.toString();
                            logOpenSPCoop2Servlet.error(msgError);
                        }
                        StringBuilder bfLogError = new StringBuilder();
                        try {
                            ConnectorUtils.generateErrorMessage(IDService.OPENSPCOOP2_SERVLET, method, req, bfLogError, e.getMessage(), true, false);
                            if (logCore != null) {
                                logCore.error(bfLogError.toString());
                            } else {
                                logOpenSPCoop2Servlet.error(bfLogError.toString());
                            }
                        }
                        catch (Throwable t) {
                            if (logCore != null) {
                                logCore.error("generateErrorMessage log failed: " + t.getMessage(), t);
                                break block65;
                            }
                            logOpenSPCoop2Servlet.error("generateErrorMessage log failed: " + t.getMessage(), t);
                        }
                    }
                    boolean errore404 = true;
                    if (op2Properties != null && op2Properties.isGenerazioneErroreProtocolloNonSupportato()) {
                        errore404 = false;
                    }
                    if (errore404) {
                        try {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeProtocolUnsupported(IDService.OPENSPCOOP2_SERVLET)));
                        }
                        catch (Throwable t) {
                            if (logCore != null) {
                                logCore.error("sendError404 failed: " + t.getMessage(), t);
                                break block64;
                            }
                            logOpenSPCoop2Servlet.error("sendError404 failed: " + t.getMessage(), t);
                        }
                    }
                    res.setStatus(500);
                    try {
                        ConnectorUtils.generateErrorMessage(IDService.OPENSPCOOP2_SERVLET, method, req, res, e.getMessage(), true, true);
                    }
                    catch (Throwable t) {
                        if (logCore != null) {
                            logCore.error("generateErrorMessage failed: " + t.getMessage(), t);
                            break block66;
                        }
                        logOpenSPCoop2Servlet.error("generateErrorMessage failed: " + t.getMessage(), t);
                    }
                }
                this.resFlushAndCloseSafe(res);
            }
        }
    }

    private void resFlushAndCloseSafe(HttpServletResponse res) {
        try {
            res.getOutputStream().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            res.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

