/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.pdd.core.jmx.MonitoraggioRisorse;
import org.openspcoop2.utils.datasource.JmxDataSource;
import org.openspcoop2.utils.transport.http.HttpResponse;

class ResultAggregate {
    private String resourceName;
    private String methodName;
    private List<String> list1 = new ArrayList<String>();
    private List<String> list2 = new ArrayList<String>();
    private List<String> list3 = new ArrayList<String>();
    private List<String> list4 = new ArrayList<String>();
    private List<String> list5 = new ArrayList<String>();
    private List<String> list6 = new ArrayList<String>();
    private List<String> list7 = new ArrayList<String>();
    private List<String> list8 = new ArrayList<String>();

    ResultAggregate(String resourceName, String methodName) {
        this.resourceName = resourceName;
        this.methodName = methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(String sResponse, String hostname) throws IOException {
        if (sResponse == null) {
            return;
        }
        try (StringReader sReader = new StringReader(sResponse);
             BufferedReader bReader = new BufferedReader(sReader);){
            String line = bReader.readLine();
            List<String> listUse = this.list1;
            while (line != null && !"Nessuna connessione allocata".equals(line) && !"Nessuna transazione attiva".equals(line)) {
                if ("Nessuna connessione allocata".equals(line)) {
                    break;
                }
                try {
                    if (line.contains(" risorse allocate: ") || line.contains(" connessioni allocate: ") || line.contains(" transazioni attive: ") || line.contains(" id di protocollo attivi: ") || line.contains(" connessioni allocate: ")) continue;
                    if (line.contains(" risorse allocate per la gestione delle transazioni: ")) {
                        listUse = this.list2;
                        continue;
                    }
                    if (line.contains(" risorse allocate per la generazione delle statistiche: ")) {
                        listUse = this.list3;
                        continue;
                    }
                    if (line.contains(" risorse allocate per lo smistatore dei messaggi presi in carico: ")) {
                        listUse = this.list4;
                        continue;
                    }
                    if (line.contains(" risorse allocate per il gestore runtime dei messaggi presi in carico: ")) {
                        listUse = this.list5;
                        continue;
                    }
                    if (line.contains(" risorse allocate per il gestore delle tracce relative ai messaggi presi in carico: ")) {
                        listUse = this.list6;
                        continue;
                    }
                    if (line.contains(" risorse allocate per il gestore runtime del servizio MessageBox: ")) {
                        listUse = this.list7;
                        continue;
                    }
                    if (line.contains(" risorse allocate per il gestore delle tracce del servizio MessageBox: ")) {
                        listUse = this.list8;
                        continue;
                    }
                    listUse.add(line + " [" + hostname + "]");
                }
                finally {
                    line = bReader.readLine();
                }
            }
        }
    }

    public HttpResponse getHttpResponse() {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setResultHTTPOperation(200);
        String content = null;
        if ("MonitoraggioRisorse".equals(this.resourceName)) {
            if ("getUsedDBConnections".equals(this.methodName) || "getUsedQueueConnections".equals(this.methodName)) {
                String[] risorse = null;
                String[] risorseTransaction = null;
                String[] risorseStatistiche = null;
                String[] risorseConsegnePreseInCaricoSmistatore = null;
                String[] risorseConsegnePreseInCaricoRuntime = null;
                String[] risorseConsegnePreseInCaricoTransazioni = null;
                String[] risorseConsegneMessageBoxRuntime = null;
                String[] risorseConsegneMessageBoxTransazioni = null;
                if (this.list1 != null && !this.list1.isEmpty()) {
                    risorse = this.list1.toArray(new String[1]);
                }
                if (this.list2 != null && !this.list2.isEmpty()) {
                    risorseTransaction = this.list2.toArray(new String[1]);
                }
                if (this.list3 != null && !this.list3.isEmpty()) {
                    risorseStatistiche = this.list3.toArray(new String[1]);
                }
                if (this.list4 != null && !this.list4.isEmpty()) {
                    risorseConsegnePreseInCaricoSmistatore = this.list4.toArray(new String[1]);
                }
                if (this.list5 != null && !this.list5.isEmpty()) {
                    risorseConsegnePreseInCaricoRuntime = this.list5.toArray(new String[1]);
                }
                if (this.list6 != null && !this.list6.isEmpty()) {
                    risorseConsegnePreseInCaricoTransazioni = this.list6.toArray(new String[1]);
                }
                if (this.list7 != null && !this.list7.isEmpty()) {
                    risorseConsegneMessageBoxRuntime = this.list7.toArray(new String[1]);
                }
                if (this.list8 != null && !this.list8.isEmpty()) {
                    risorseConsegneMessageBoxTransazioni = this.list8.toArray(new String[1]);
                }
                if ("getUsedDBConnections".equals(this.methodName)) {
                    content = MonitoraggioRisorse.getResultUsedDBConnections(risorse, risorseTransaction, risorseStatistiche, risorseConsegnePreseInCaricoSmistatore, risorseConsegnePreseInCaricoRuntime, risorseConsegnePreseInCaricoTransazioni, risorseConsegneMessageBoxRuntime, risorseConsegneMessageBoxTransazioni);
                } else if ("getUsedQueueConnections".equals(this.methodName)) {
                    content = MonitoraggioRisorse.getResultUsedQueueConnections(risorse);
                }
            } else if ("getActiveTransactions".equals(this.methodName)) {
                content = MonitoraggioRisorse.getResultTransazioniAttiveId(this.list1);
            } else if ("getActiveProtocolIds".equals(this.methodName)) {
                content = MonitoraggioRisorse.getResultTransazioniAttiveIdProtocollo(this.list1);
            } else if ("getActivePDConnections".equals(this.methodName)) {
                content = MonitoraggioRisorse.getResultActiveConnections(this.list1);
            } else if ("getActivePAConnections".equals(this.methodName)) {
                content = MonitoraggioRisorse.getResultActiveConnections(this.list1);
            }
        } else if ("DatasourceGW".equals(this.resourceName)) {
            String[] risorse = null;
            if (this.list1 != null && !this.list1.isEmpty()) {
                risorse = this.list1.toArray(new String[1]);
            }
            content = JmxDataSource.getResultUsedDBConnections(risorse);
        } else if ("LoadBalancer".equals(this.resourceName) && this.list1 != null && !this.list1.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String l : this.list1) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(l);
            }
            content = sb.toString();
        }
        if (content != null) {
            httpResponse.setContentType("text/plain");
            httpResponse.setContent(content.getBytes());
        }
        return httpResponse;
    }
}

