/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.messages;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorOutMessage;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;

public class HttpServletConnectorAsyncOutMessage
extends HttpServletConnectorOutMessage {
    protected AsyncContext asyncContext;
    private CompletableFuture<Boolean> asyncWriteTask = null;
    private boolean flowStream = false;
    private Throwable nioException;

    public HttpServletConnectorAsyncOutMessage(RequestInfo requestInfo, IProtocolFactory<?> protocolFactory, AsyncContext ac, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        super(requestInfo, protocolFactory, HttpServletConnectorAsyncOutMessage.getHttpServletResponse(ac), idModuloAsIDService, idModulo);
        this.asyncContext = ac;
    }

    public static HttpServletResponse getHttpServletResponse(AsyncContext ac) {
        return (HttpServletResponse)ac.getResponse();
    }

    public void setNioException(Throwable nioException) {
        this.nioException = nioException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeTo(final OutputStream out, final OpenSPCoop2Message msg, final boolean consume) throws MessageException {
        try {
            this.asyncWriteTask = new CompletableFuture();
            if (this.flowStream) {
                this.res.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        try {
                            msg.writeTo(out, consume);
                            HttpServletConnectorAsyncOutMessage.this.asyncWriteTask.complete(true);
                        }
                        catch (MessageException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }

                    public void onError(Throwable t) {
                        HttpServletConnectorAsyncOutMessage.this.asyncWriteTask.complete(false);
                        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante la consegna della risposta asincrona: " + t.getMessage(), t);
                        HttpServletConnectorAsyncOutMessage.this.asyncContext.complete();
                    }
                });
            } else {
                super.writeTo(out, msg, consume);
            }
        }
        catch (Exception e) {
            this.doMessageErrorWriteTo(e);
        }
        finally {
            if (!this.flowStream) {
                this.asyncWriteTask.complete(true);
            }
        }
    }

    private void doMessageErrorWriteTo(Exception e) throws MessageException {
        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante la scrittura della risposta asincrona: " + e.getMessage(), (Throwable)e);
        throw new MessageException(e.getMessage(), (Throwable)e);
    }

    @Override
    public void sendResponse(final DumpByteArrayOutputStream message) throws ConnectorException {
        try {
            this.asyncWriteTask = new CompletableFuture();
            final HttpServletConnectorAsyncOutMessage httpServletConnectorOutMessage = this;
            if (this.flowStream) {
                this.res.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        try {
                            httpServletConnectorOutMessage.sendResponseByBuffer(message);
                            HttpServletConnectorAsyncOutMessage.this.asyncWriteTask.complete(true);
                        }
                        catch (ConnectorException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }

                    public void onError(Throwable t) {
                        HttpServletConnectorAsyncOutMessage.this.asyncWriteTask.complete(false);
                        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante la consegna della risposta asincrona (DumpByteArrayOutputStream): " + t.getMessage(), t);
                        HttpServletConnectorAsyncOutMessage.this.asyncContext.complete();
                    }
                });
            } else {
                httpServletConnectorOutMessage.sendResponseByBuffer(message);
            }
        }
        catch (Exception e) {
            this.doConnectionErrorWriteTo(e);
        }
        finally {
            if (!this.flowStream) {
                this.asyncWriteTask.complete(true);
            }
        }
    }

    private void doConnectionErrorWriteTo(Exception e) throws ConnectorException {
        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante la scrittura della risposta asincrona (DumpByteArrayOutputStream): " + e.getMessage(), (Throwable)e);
        throw new ConnectorException(e.getMessage(), e);
    }

    @Override
    public void flush(boolean throwException) throws ConnectorException {
        block5: {
            try {
                if (this.asyncWriteTask != null) {
                    boolean taskRes = this.asyncWriteTask.get();
                    this.asyncWriteTask = null;
                    if (!taskRes && throwException) {
                        throw new ConnectorException("Response write uncomplete (flush)?");
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (!throwException) break block5;
                Thread.currentThread().interrupt();
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        if (this.nioException != null && throwException) {
            throw new ConnectorException(this.nioException.getMessage(), this.nioException);
        }
        super.flush(throwException);
    }

    @Override
    public void close(AsyncResponseCallbackClientEvent clientEvent, boolean throwException) throws ConnectorException {
        super.close(clientEvent, throwException);
        try {
            if (this.asyncWriteTask != null) {
                boolean taskRes = this.asyncWriteTask.get();
                this.asyncWriteTask = null;
                if (!taskRes && throwException) {
                    throw new ConnectorException("Response write uncomplete (close)?");
                }
            }
            if (this.asyncContext != null) {
                this.asyncContextCompleteSafe(throwException);
            }
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private void asyncContextCompleteSafe(boolean throwException) {
        block2: {
            try {
                this.asyncContext.complete();
            }
            catch (Exception e) {
                if (!throwException) break block2;
                throw e;
            }
        }
    }
}

