/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.messages;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.DimensioneMessaggiUtils;
import org.openspcoop2.pdd.core.controllo_traffico.LimitExceededNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifier;
import org.openspcoop2.pdd.core.controllo_traffico.TimeoutNotifierType;
import org.openspcoop2.pdd.logger.DiagnosticInputStream;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.ITimeoutNotifier;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class HttpServletConnectorInMessage
implements ConnectorInMessage {
    protected RequestInfo requestInfo;
    protected HttpServletRequest req;
    protected OpenSPCoop2Properties openspcoopProperties;
    protected OpenSPCoop2Message message;
    protected InputStream is;
    protected LimitedInputStream internalLimitedIS;
    protected TimeoutInputStream internalTimeoutIS;
    protected DiagnosticInputStream internalDiagnosticIS;
    protected DumpByteArrayOutputStream buffer;
    protected boolean buffered = false;
    protected OpenSPCoop2MessageSoapStreamReader soapReader;
    protected Logger log;
    protected String idModulo;
    private IDService idModuloAsIDService;
    private MessageType requestMessageType;
    protected Date dataIngressoRichiesta;
    private Context context;
    private String idTransazione;
    private int soglia;
    private File repositoryFile;
    private SogliaReadTimeout requestReadTimeout;
    private SogliaDimensioneMessaggio requestLimitSize;
    private boolean requestLimitSizeDisabled = false;
    private boolean useDiagnosticInputStream;
    private MsgDiagnostico msgDiagnostico;

    public HttpServletConnectorInMessage(RequestInfo requestInfo, HttpServletRequest req, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        try {
            this.requestInfo = requestInfo;
            this.req = req;
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
            this.is = this.req.getInputStream();
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                this.log = LoggerWrapperFactory.getLogger(HttpServletConnectorInMessage.class);
            }
            this.idModuloAsIDService = idModuloAsIDService;
            this.idModulo = idModulo;
            this.requestMessageType = IDService.PORTA_APPLICATIVA.equals((Object)idModuloAsIDService) || IDService.PORTA_APPLICATIVA_NIO.equals((Object)idModuloAsIDService) ? this.getRequestInfo().getProtocolRequestMessageType() : this.getRequestInfo().getIntegrationRequestMessageType();
            if (this.openspcoopProperties != null) {
                this.useDiagnosticInputStream = IDService.PORTA_APPLICATIVA.equals((Object)idModuloAsIDService) || IDService.PORTA_APPLICATIVA_NIO.equals((Object)idModuloAsIDService) ? this.openspcoopProperties.isConnettoriUseDiagnosticInputStreamRicezioneBuste() : this.openspcoopProperties.isConnettoriUseDiagnosticInputStreamRicezioneContenutiApplicativi();
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setThresholdContext(Context context, int soglia, File repositoryFile) {
        this.context = context;
        if (this.context != null) {
            this.idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
        if (this.internalTimeoutIS != null && this.context != null) {
            this.internalTimeoutIS.updateContext((Map)this.context);
        }
        if (this.internalLimitedIS != null && this.context != null) {
            this.internalLimitedIS.updateContext((Map)this.context);
        }
    }

    @Override
    public void setRequestReadTimeout(SogliaReadTimeout timeout) {
        this.requestReadTimeout = timeout;
        if (this.internalTimeoutIS != null) {
            try {
                this.internalTimeoutIS.updateThreshold(this.requestReadTimeout.getSogliaMs());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            TimeoutNotifier notifier = new TimeoutNotifier(this.context, this.getProtocolFactory(), this.requestReadTimeout, TimeoutNotifierType.REQUEST, this.log, true);
            this.internalTimeoutIS.updateNotifier((ITimeoutNotifier)notifier);
        }
    }

    @Override
    public void disableReadTimeout() {
        if (this.internalTimeoutIS != null) {
            this.internalTimeoutIS.disableCheckTimeout();
        }
    }

    @Override
    public void setRequestLimitedStream(SogliaDimensioneMessaggio requestLimitSize) {
        this.requestLimitSize = requestLimitSize;
        if (this.internalLimitedIS != null && this.requestLimitSize != null && this.requestLimitSize.getSogliaKb() > 0L) {
            try {
                long limitBytes = this.requestLimitSize.getSogliaKb() * 1024L;
                this.internalLimitedIS.updateThreshold(limitBytes);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            LimitExceededNotifier notifier = new LimitExceededNotifier(this.context, this.requestLimitSize, this.log);
            this.internalLimitedIS.updateNotifier((ILimitExceededNotifier)notifier);
        }
    }

    @Override
    public void disableLimitedStream() {
        if (this.internalLimitedIS != null) {
            this.internalLimitedIS.disableCheck();
        }
        this.requestLimitSizeDisabled = true;
    }

    @Override
    public void checkContentLengthLimit() throws LimitExceededIOException {
        List l;
        if (!this.requestLimitSizeDisabled && this.requestLimitSize != null && this.requestLimitSize.getSogliaKb() > 0L && this.requestLimitSize.isUseContentLengthHeader() && (l = TransportUtils.getHeaderValues((HttpServletRequest)this.req, (String)"Content-Length")) != null && !l.isEmpty()) {
            LimitExceededNotifier notifier = new LimitExceededNotifier(this.context, this.requestLimitSize, this.log);
            DimensioneMessaggiUtils.verifyByContentLength(this.log, l, this.requestLimitSize, notifier, (Map<Object>)this.context, true);
        }
    }

    @Override
    public void setDiagnosticProducer(Context context, MsgDiagnostico msgDiag) {
        if (this.context == null) {
            this.context = context;
        }
        this.msgDiagnostico = msgDiag;
    }

    private InputStream buildInputStream() throws IOException {
        Object notifier;
        if (this.buffered && this.buffer != null && this.buffer.size() > 0) {
            return new ByteArrayInputStream(this.buffer.toByteArray());
        }
        if (this.is != null && this.soapReader != null) {
            return this.is;
        }
        if (this.is != null && this.requestLimitSize != null && this.requestLimitSize.getSogliaKb() > 0L) {
            notifier = new LimitExceededNotifier(this.context, this.requestLimitSize, this.log);
            long limitBytes = this.requestLimitSize.getSogliaKb() * 1024L;
            this.internalLimitedIS = new LimitedInputStream(this.is, limitBytes, "Request ", (Map)this.context, (ILimitExceededNotifier)notifier);
            this.is = this.internalLimitedIS;
        }
        if (this.is != null && this.requestReadTimeout != null && this.requestReadTimeout.getSogliaMs() > 0) {
            notifier = new TimeoutNotifier(this.context, this.getProtocolFactory(), this.requestReadTimeout, TimeoutNotifierType.REQUEST, this.log, true);
            this.internalTimeoutIS = new TimeoutInputStream(this.is, this.requestReadTimeout.getSogliaMs(), "Request ", (Map)this.context, (ITimeoutNotifier)notifier);
            this.is = this.internalTimeoutIS;
        }
        if (this.is != null && this.useDiagnosticInputStream && this.msgDiagnostico != null) {
            String idModuloFunzionale = IDService.PORTA_APPLICATIVA.equals((Object)this.idModuloAsIDService) ? "ricezioneBuste." : "ricezioneContenutiApplicativi.";
            this.internalDiagnosticIS = new DiagnosticInputStream(this.is, idModuloFunzionale, "letturaPayloadRichiesta", true, this.msgDiagnostico, this.log != null ? this.log : OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), (Map<Object>)this.context);
            this.is = this.internalDiagnosticIS;
        }
        return this.is;
    }

    @Override
    public IDService getIdModuloAsIDService() {
        return this.idModuloAsIDService;
    }

    @Override
    public String getIdModulo() {
        return this.idModulo;
    }

    @Override
    public void updateRequestInfo(RequestInfo requestInfo) throws ConnectorException {
        this.requestInfo = requestInfo;
        this.requestMessageType = IDService.PORTA_APPLICATIVA.equals((Object)this.idModuloAsIDService) ? this.getRequestInfo().getProtocolRequestMessageType() : this.getRequestInfo().getIntegrationRequestMessageType();
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    @Override
    public MessageType getRequestMessageType() {
        return this.requestMessageType;
    }

    @Override
    public Object getAttribute(String key) throws ConnectorException {
        return this.req.getAttribute(key);
    }

    @Override
    public List<String> getHeaderValues(String key) throws ConnectorException {
        return TransportUtils.getHeaderValues((HttpServletRequest)this.req, (String)key);
    }

    @Override
    public List<String> getParameterValues(String key) throws ConnectorException {
        return TransportUtils.getParameterValues((HttpServletRequest)this.req, (String)key);
    }

    @Override
    public IProtocolFactory<?> getProtocolFactory() {
        return this.requestInfo.getProtocolFactory();
    }

    @Override
    public String getContentType() throws ConnectorException {
        try {
            return this.requestInfo.getProtocolContext().getContentType(true);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getSOAPAction() throws ConnectorException {
        try {
            String contentType = this.getContentType();
            return SoapUtils.getSoapAction((TransportRequestContext)this.requestInfo.getProtocolContext(), (MessageType)this.requestMessageType, (String)contentType);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public OpenSPCoop2MessageSoapStreamReader getSoapReader() throws ConnectorException {
        try {
            if (this.openspcoopProperties.useSoapMessageReader()) {
                if (this.buffered) {
                    return null;
                }
                if (this.soapReader != null) {
                    return this.soapReader;
                }
                String contentType = this.getContentType();
                if (contentType != null) {
                    this.soapReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, this.buildInputStream(), this.openspcoopProperties.getSoapMessageReaderBufferThresholdKb());
                    try {
                        this.soapReader.read();
                    }
                    finally {
                        this.is = this.soapReader.getBufferedInputStream();
                    }
                }
                return this.soapReader;
            }
            return null;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public OpenSPCoop2MessageParseResult getRequest(NotifierInputStreamParams notifierInputStreamParams) throws ConnectorException {
        try {
            OpenSPCoop2MessageParseResult pr = org.openspcoop2.pdd.core.Utilities.getOpenspcoop2MessageFactory(this.log, this.requestInfo, MessageRole.REQUEST).createMessage(this.requestMessageType, (TransportRequestContext)this.requestInfo.getProtocolContext(), this.buildInputStream(), notifierInputStreamParams, this.soapReader, this.openspcoopProperties.getAttachmentsProcessingMode());
            this.dataIngressoRichiesta = DateManager.getDate();
            return pr;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public OpenSPCoop2MessageParseResult getRequest(DumpByteArrayOutputStream buffer, NotifierInputStreamParams notifierInputStreamParams) throws ConnectorException {
        try {
            InputStream in = null;
            try {
                Utilities.writeAsByteArrayOuputStream((OutputStream)buffer, (InputStream)this.buildInputStream(), (boolean)false);
                if (buffer.size() > 0) {
                    in = buffer.isSerializedOnFileSystem() ? new FileInputStream(buffer.getSerializedFile()) : new ByteArrayInputStream(buffer.toByteArray());
                }
            }
            catch (Throwable t) {
                OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
                result.setParseException(ParseExceptionUtils.buildParseException((Throwable)t, (MessageRole)MessageRole.REQUEST));
                return result;
            }
            OpenSPCoop2MessageParseResult pr = org.openspcoop2.pdd.core.Utilities.getOpenspcoop2MessageFactory(this.log, this.requestInfo, MessageRole.REQUEST).createMessage(this.requestMessageType, (TransportRequestContext)this.requestInfo.getProtocolContext(), in, notifierInputStreamParams, this.soapReader, this.openspcoopProperties.getAttachmentsProcessingMode());
            this.dataIngressoRichiesta = DateManager.getDate();
            return pr;
        }
        catch (Throwable t) {
            OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
            result.setParseException(ParseExceptionUtils.buildParseException((Throwable)t, (MessageRole)MessageRole.REQUEST));
            return result;
        }
    }

    @Override
    public DumpByteArrayOutputStream getRequest() throws ConnectorException {
        return this.getRequest(true);
    }

    @Override
    public DumpByteArrayOutputStream getRequest(boolean consume) throws ConnectorException {
        if (this.buffered) {
            return this.buffer;
        }
        DumpByteArrayOutputStream bout = null;
        try {
            this.dataIngressoRichiesta = DateManager.getDate();
            bout = new DumpByteArrayOutputStream(this.soglia, this.repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.getValue());
            Utilities.writeAsByteArrayOuputStream((OutputStream)bout, (InputStream)this.buildInputStream(), (boolean)false);
            bout.flush();
            DumpByteArrayOutputStream dumpByteArrayOutputStream = bout;
            return dumpByteArrayOutputStream;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Throwable throwable) {}
            if (!consume) {
                this.buffer = bout;
                this.buffered = true;
            }
        }
    }

    @Override
    public Date getDataIngressoRichiesta() {
        return this.dataIngressoRichiesta;
    }

    @Override
    public URLProtocolContext getURLProtocolContext() throws ConnectorException {
        try {
            return this.requestInfo.getProtocolContext();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public Credential getCredential() throws ConnectorException {
        try {
            return this.requestInfo.getProtocolContext().getCredential();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getSource() throws ConnectorException {
        try {
            return this.requestInfo.getProtocolContext().getSource();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getProtocol() throws ConnectorException {
        return this.req.getProtocol();
    }

    @Override
    public int getContentLength() throws ConnectorException {
        return this.req.getContentLength();
    }

    @Override
    public void close() throws ConnectorException {
        try {
            if (this.is != null) {
                this.isCloseSafe();
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    private void isCloseSafe() {
        try {
            this.is.close();
            this.is = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getRemoteAddress() throws ConnectorException {
        return this.req.getRemoteAddr();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }
}

