/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.service;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.pdd.config.CachedConfigIntegrationReader;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreRichieste;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.transazioni.PreInRequestHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherErrorInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.service.RicezionePropertiesConfig;
import org.openspcoop2.protocol.basic.registry.IdentificazionePortaDelegata;
import org.openspcoop2.protocol.basic.registry.ServiceIdentificationReader;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestInfoConfigUtilities;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativiServiceUtils {
    public static RicezionePropertiesConfig readPropertiesConfig(RequestInfo requestInfo, Logger logCore, IState state) {
        if (requestInfo != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getInterfaceName() != null && !"".equals(requestInfo.getProtocolContext().getInterfaceName())) {
            try {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)state);
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(requestInfo.getProtocolContext().getInterfaceName());
                PortaDelegata pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                if (pd != null) {
                    RicezionePropertiesConfig config = new RicezionePropertiesConfig();
                    config.setApiImplementation(configurazionePdDManager.getProprietaConfigurazione(pd));
                    IDSoggetto idSoggettoProprietario = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                    Soggetto soggetto = registroServiziManager.getSoggetto(idSoggettoProprietario, null, requestInfo);
                    config.setSoggettoFruitore(registroServiziManager.getProprietaConfigurazione(soggetto));
                    IDSoggetto idSoggettoErogatore = new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome());
                    Soggetto soggettoErogatore = registroServiziManager.getSoggetto(idSoggettoErogatore, null, requestInfo);
                    config.setSoggettoErogatore(registroServiziManager.getProprietaConfigurazione(soggettoErogatore));
                    return config;
                }
            }
            catch (Exception e) {
                logCore.error("Errore durante la lettura delle propriet\u00e0 di configurazione della porta delegata [" + requestInfo.getProtocolContext().getInterfaceName() + "]: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public static ConnectorDispatcherInfo updatePortaDelegataRequestInfo(RequestInfo requestInfo, Logger logCore, ConnectorInMessage req, ConnectorOutMessage res, RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore, ServiceIdentificationReader serviceIdentificationReader, MsgDiagnostico msgDiag, PdDContext pddContextNullable) throws ConnectorException {
        if (requestInfo == null) {
            throw new ConnectorException("Param requestInfo is null");
        }
        URLProtocolContext protocolContext = requestInfo.getProtocolContext();
        IProtocolFactory pf = requestInfo.getProtocolFactory();
        ServiceBindingConfiguration bindingConfig = requestInfo.getBindingConfig();
        ServiceBinding integrationServiceBinding = requestInfo.getIntegrationServiceBinding();
        ServiceBinding protocolServiceBinding = requestInfo.getProtocolServiceBinding();
        IDService idModuloAsServiceNullable = req != null ? req.getIdModuloAsIDService() : null;
        IRegistryReader registryReader = serviceIdentificationReader.getRegistryReader();
        CachedConfigIntegrationReader configIntegrationReader = (CachedConfigIntegrationReader)serviceIdentificationReader.getConfigIntegrationReader();
        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance();
        IDPortaDelegata idPD = null;
        PortaDelegata pdDefault = null;
        try {
            if (requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getIdPortaDelegataDefault() != null) {
                idPD = requestInfo.getRequestConfig().getIdPortaDelegataDefault();
            } else {
                idPD = serviceIdentificationReader.findPortaDelegata((TransportRequestContext)protocolContext, true);
                if (requestInfo.getRequestConfig() != null) {
                    requestInfo.getRequestConfig().setIdPortaDelegataDefault(idPD);
                }
            }
        }
        catch (RegistryNotFound notFound) {
            if (pddContextNullable != null) {
                pddContextNullable.addObject(Costanti.API_NON_INDIVIDUATA, "true");
            }
            logCore.error("Porta Delegata non trovata: " + notFound.getMessage(), (Throwable)notFound);
            msgDiag.addKeywordErroreProcessamento(notFound);
            msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
            ConnectorDispatcherErrorInfo c = ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, serviceIdentificationReader.getErroreIntegrazioneNotFound(), IntegrationFunctionError.API_OUT_UNKNOWN, (Throwable)notFound, null, res, logCore, true);
            try {
                EsitoTransazione esito = requestInfo.getProtocolFactory().createEsitoBuilder().getEsito((TransportRequestContext)requestInfo.getProtocolContext(), EsitoTransazioneName.API_NON_INDIVIDUATA);
                c.setEsitoTransazione(esito);
            }
            catch (Throwable t) {
                logCore.error("Errore durante l'impostazione dell'esito 'API_NON_INDIVIDUATA'");
            }
            return c;
        }
        if (idPD != null) {
            protocolContext.setInterfaceName(idPD.getNome());
            IDSoggetto idSoggettoFruitore = null;
            IDServizio idServizio = null;
            if (requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getIdServizio() != null && requestInfo.getRequestConfig().getIdFruitore() != null) {
                idServizio = requestInfo.getRequestConfig().getIdServizio().clone();
                idSoggettoFruitore = requestInfo.getRequestConfig().getIdFruitore().clone();
            } else {
                if (idPD.getIdentificativiFruizione() != null) {
                    if (idPD.getIdentificativiFruizione().getSoggettoFruitore() != null) {
                        idSoggettoFruitore = idPD.getIdentificativiFruizione().getSoggettoFruitore().clone();
                    }
                    if (idPD.getIdentificativiFruizione().getIdServizio() != null) {
                        idServizio = idPD.getIdentificativiFruizione().getIdServizio().clone();
                    }
                }
                if (idServizio == null) {
                    try {
                        idServizio = serviceIdentificationReader.convertToIDServizio(idPD);
                        if (idServizio != null) {
                            idServizio = idServizio.clone();
                        }
                    }
                    catch (RegistryNotFound notFound) {
                        logCore.debug("Conversione Dati PortaDelegata in identificativo servizio fallita (notFound): " + notFound.getMessage(), (Throwable)notFound);
                        msgDiag.addKeywordErroreProcessamento(notFound);
                        msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                        return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, serviceIdentificationReader.getErroreIntegrazioneNotFound(), IntegrationFunctionError.API_OUT_UNKNOWN, (Throwable)notFound, null, res, logCore, true);
                    }
                }
                if (idSoggettoFruitore == null) {
                    try {
                        idSoggettoFruitore = serviceIdentificationReader.convertToIDSoggettoFruitore(idPD);
                    }
                    catch (RegistryNotFound notFound) {
                        logCore.debug("Conversione Dati PortaDelegata in identificativo soggetto fruitore fallita (notFound): " + notFound.getMessage(), (Throwable)notFound);
                        msgDiag.addKeywordErroreProcessamento(notFound);
                        msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                        return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, serviceIdentificationReader.getErroreIntegrazioneNotFound(), IntegrationFunctionError.API_OUT_UNKNOWN, (Throwable)notFound, null, res, logCore, true);
                    }
                }
                if (requestInfo.getRequestConfig() != null) {
                    requestInfo.getRequestConfig().setIdServizio(idServizio);
                    requestInfo.getRequestConfig().setIdFruitore(idSoggettoFruitore);
                }
            }
            if (generatoreErrore != null && idSoggettoFruitore != null) {
                generatoreErrore.updateDominio(idSoggettoFruitore);
                generatoreErrore.updateInformazioniCooperazione(idSoggettoFruitore, null);
            }
            if (idServizio != null) {
                RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance();
                try {
                    integrationServiceBinding = pf.createProtocolConfiguration().getIntegrationServiceBinding(idServizio, registryReader);
                    requestInfo.setIntegrationServiceBinding(integrationServiceBinding);
                    protocolServiceBinding = pf.createProtocolConfiguration().getProtocolServiceBinding(integrationServiceBinding, (TransportRequestContext)protocolContext);
                    requestInfo.setProtocolServiceBinding(protocolServiceBinding);
                    if (generatoreErrore != null) {
                        generatoreErrore.updateServiceBinding(integrationServiceBinding);
                    }
                }
                catch (RegistryNotFound notFound) {
                    logCore.debug("Lettura ServiceBinding fallita (notFound): " + notFound.getMessage(), (Throwable)notFound);
                    msgDiag.addKeywordErroreProcessamento(notFound);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione(), IntegrationFunctionError.API_OUT_UNKNOWN, (Throwable)notFound, null, res, logCore, true);
                }
                catch (Exception error) {
                    logCore.error("Lettura ServiceBinding fallita: " + error.getMessage(), (Throwable)error);
                    msgDiag.addKeywordErroreProcessamento(error);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Lettura ServiceBinding fallita"), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)error, null, res, logCore, false);
                }
                OpenSPCoop2MessageSoapStreamReader soapStreamReader = null;
                if (ServiceBinding.SOAP.equals((Object)integrationServiceBinding) && !IDService.PORTA_DELEGATA_XML_TO_SOAP.equals((Object)idModuloAsServiceNullable)) {
                    try {
                        if (req != null) {
                            soapStreamReader = req.getSoapReader();
                        }
                    }
                    catch (Exception e) {
                        logCore.debug("SOAPStream lettura non riuscita: " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    if (requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getPortaDelegataDefault() != null) {
                        pdDefault = requestInfo.getRequestConfig().getPortaDelegataDefault();
                    } else {
                        pdDefault = configurazionePdDManager.getPortaDelegata(idPD, null);
                        if (requestInfo.getRequestConfig() != null) {
                            requestInfo.getRequestConfig().setPortaDelegataDefault(pdDefault);
                        }
                    }
                }
                catch (Exception e) {
                    logCore.debug("Recupero porta default fallita: " + e.getMessage(), (Throwable)e);
                }
                RequestInfoConfigUtilities.checkRequestInfoConfig((PortaDelegata)pdDefault, (Logger)logCore, (ServiceBinding)integrationServiceBinding, (OpenSPCoop2MessageSoapStreamReader)soapStreamReader, (RequestInfo)requestInfo);
                GestoreRichieste.updateRequestConfig(requestInfo, integrationServiceBinding, soapStreamReader);
                if (requestInfo != null && requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getIdServizio() != null) {
                    idServizio = requestInfo.getRequestConfig().getIdServizio();
                }
                try {
                    PortaDelegata pdSearchAzione = pdDefault;
                    idServizio.setAzione(configIntegrationReader.getAzione(pdSearchAzione, protocolContext, requestInfo, requestInfo.getProtocolFactory(), soapStreamReader));
                }
                catch (Exception e) {
                    logCore.debug("Azione non trovata: " + e.getMessage(), (Throwable)e);
                }
                try {
                    String msgFactory;
                    Map props;
                    if (pdDefault != null && pdDefault.getOptions() != null && !StringUtils.isEmpty((CharSequence)pdDefault.getOptions()) && (props = PropertiesSerializator.convertoFromDBColumnValue((String)pdDefault.getOptions())) != null && props.size() > 0 && (msgFactory = TransportUtils.getFirstValue((Map)props, (String)"MessageEngine")) != null) {
                        requestInfo.setMessageFactory(msgFactory);
                    }
                }
                catch (Throwable e) {
                    logCore.debug("Lettura Message Factory fallita: " + e.getMessage(), e);
                }
                try {
                    if (requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getIdPortaDelegata() != null) {
                        idPD = requestInfo.getRequestConfig().getIdPortaDelegata();
                        if (requestInfo.getRequestConfig().getIdPortaDelegataDefault() != null && !requestInfo.getRequestConfig().getIdPortaDelegataDefault().equals((Object)idPD)) {
                            if (pddContextNullable != null) {
                                pddContextNullable.addObject(CostantiPdD.NOME_PORTA_INVOCATA, requestInfo.getRequestConfig().getIdPortaDelegataDefault().getNome());
                            }
                            msgDiag.addKeyword("@PORTA_DELEGATA@", idPD.getNome());
                            msgDiag.updatePorta(idPD.getNome(), requestInfo);
                            protocolContext.setInterfaceName(idPD.getNome());
                        }
                    } else {
                        IDPortaDelegata idPD_action;
                        IdentificazionePortaDelegata identificazione;
                        if (idServizio.getAzione() != null && (identificazione = new IdentificazionePortaDelegata(logCore, pf, serviceIdentificationReader.getRegistryReader(), serviceIdentificationReader.getConfigIntegrationReader(), requestInfo, pdDefault)).find(idServizio.getAzione()) && (idPD_action = identificazione.getIDPortaDelegata(idServizio.getAzione())) != null) {
                            if (pddContextNullable != null) {
                                pddContextNullable.addObject(CostantiPdD.NOME_PORTA_INVOCATA, idPD.getNome());
                            }
                            msgDiag.addKeyword("@PORTA_DELEGATA@", idPD_action.getNome());
                            msgDiag.updatePorta(idPD_action.getNome(), requestInfo);
                            protocolContext.setInterfaceName(idPD_action.getNome());
                            idPD = idPD_action;
                        }
                        if (idPD != null && requestInfo.getRequestConfig() != null) {
                            requestInfo.getRequestConfig().setIdPortaDelegata(idPD);
                        }
                    }
                }
                catch (Exception e) {
                    logCore.debug("Gestione porta specifica per azione fallita: " + e.getMessage(), (Throwable)e);
                }
                if (idPD != null && requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getPortaDelegata() == null) {
                    try {
                        PortaDelegata pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, null);
                        requestInfo.getRequestConfig().setPortaDelegata(pd);
                    }
                    catch (Exception e) {
                        logCore.debug("Recupero porta delegata fallito: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (idServizio != null && idServizio.getSoggettoErogatore() != null && requestInfo.getRequestConfig() != null) {
                    if (requestInfo.getRequestConfig().getSoggettoErogatoreRegistry() == null) {
                        try {
                            Soggetto soggettoRegistry = registroServiziManager.getSoggetto(idServizio.getSoggettoErogatore(), null, null);
                            requestInfo.getRequestConfig().setSoggettoErogatoreRegistry(soggettoRegistry);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero soggetto erogatore dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoErogatoreConfig() == null) {
                        try {
                            org.openspcoop2.core.config.Soggetto soggettoConfig = configurazionePdDManager.getSoggetto(idServizio.getSoggettoErogatore(), null);
                            requestInfo.getRequestConfig().setSoggettoErogatoreConfig(soggettoConfig);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero soggetto erogatore dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoErogatoreIdentificativoPorta() == null) {
                        try {
                            String idPorta = configurazionePdDManager.getIdentificativoPorta(idServizio.getSoggettoErogatore(), pf, null);
                            requestInfo.getRequestConfig().setSoggettoErogatoreIdentificativoPorta(idPorta);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto erogatore (identificativoPorta) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoErogatoreSoggettoVirtuale() == null) {
                        try {
                            boolean soggettoVirtuale = configurazionePdDManager.isSoggettoVirtuale(idServizio.getSoggettoErogatore(), null);
                            requestInfo.getRequestConfig().setSoggettoErogatoreSoggettoVirtuale(Boolean.valueOf(soggettoVirtuale));
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto erogatore (soggettoVirtuale) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoErogatorePddReaded() == null) {
                        try {
                            if (requestInfo.getRequestConfig().getSoggettoErogatoreRegistry() != null) {
                                if (requestInfo.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio() != null && StringUtils.isNotEmpty((CharSequence)requestInfo.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio())) {
                                    PortaDominio pdd = registroServiziManager.getPortaDominio(requestInfo.getRequestConfig().getSoggettoErogatoreRegistry().getPortaDominio(), null, null);
                                    requestInfo.getRequestConfig().setSoggettoErogatorePddReaded(Boolean.valueOf(true));
                                    requestInfo.getRequestConfig().setSoggettoErogatorePdd(pdd);
                                } else {
                                    requestInfo.getRequestConfig().setSoggettoErogatorePddReaded(Boolean.valueOf(true));
                                }
                            }
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto erogatore (pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoErogatoreImplementazionePdd() == null) {
                        try {
                            String impl = registroServiziManager.getImplementazionePdD(idServizio.getSoggettoErogatore(), null, null);
                            requestInfo.getRequestConfig().setSoggettoErogatoreImplementazionePdd(impl);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto erogatore (implementazione pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (idSoggettoFruitore != null && requestInfo.getRequestConfig() != null) {
                    if (requestInfo.getRequestConfig().getSoggettoFruitoreRegistry() == null) {
                        try {
                            Soggetto soggettoRegistry = registroServiziManager.getSoggetto(idSoggettoFruitore, null, null);
                            requestInfo.getRequestConfig().setSoggettoFruitoreRegistry(soggettoRegistry);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero soggetto fruitore dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoFruitoreConfig() == null) {
                        try {
                            org.openspcoop2.core.config.Soggetto soggettoConfig = configurazionePdDManager.getSoggetto(idSoggettoFruitore, null);
                            requestInfo.getRequestConfig().setSoggettoFruitoreConfig(soggettoConfig);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero soggetto fruitore dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoFruitoreIdentificativoPorta() == null) {
                        try {
                            String idPorta = configurazionePdDManager.getIdentificativoPorta(idSoggettoFruitore, pf, null);
                            requestInfo.getRequestConfig().setSoggettoFruitoreIdentificativoPorta(idPorta);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto fruitore (identificativoPorta) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoFruitoreSoggettoVirtuale() == null) {
                        try {
                            boolean soggettoVirtuale = configurazionePdDManager.isSoggettoVirtuale(idSoggettoFruitore, null);
                            requestInfo.getRequestConfig().setSoggettoFruitoreSoggettoVirtuale(Boolean.valueOf(soggettoVirtuale));
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto fruitore (soggettoVirtuale) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoFruitorePddReaded() == null) {
                        try {
                            if (requestInfo.getRequestConfig().getSoggettoFruitoreRegistry() != null) {
                                if (requestInfo.getRequestConfig().getSoggettoFruitoreRegistry().getPortaDominio() != null && StringUtils.isNotEmpty((CharSequence)requestInfo.getRequestConfig().getSoggettoFruitoreRegistry().getPortaDominio())) {
                                    PortaDominio pdd = registroServiziManager.getPortaDominio(requestInfo.getRequestConfig().getSoggettoFruitoreRegistry().getPortaDominio(), null, null);
                                    requestInfo.getRequestConfig().setSoggettoFruitorePddReaded(Boolean.valueOf(true));
                                    requestInfo.getRequestConfig().setSoggettoFruitorePdd(pdd);
                                } else {
                                    requestInfo.getRequestConfig().setSoggettoFruitorePddReaded(Boolean.valueOf(true));
                                }
                            }
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto fruitore (pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (requestInfo.getRequestConfig().getSoggettoFruitoreImplementazionePdd() == null) {
                        try {
                            String impl = registroServiziManager.getImplementazionePdD(idSoggettoFruitore, null, null);
                            requestInfo.getRequestConfig().setSoggettoFruitoreImplementazionePdd(impl);
                        }
                        catch (Exception e) {
                            logCore.debug("Recupero dati soggetto fruitore (implementazione pdd) dal registro fallito: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                requestInfo.setFruitore(idSoggettoFruitore);
                requestInfo.setIdServizio(idServizio);
                if (generatoreErrore != null) {
                    generatoreErrore.updateInformazioniCooperazione(idSoggettoFruitore, idServizio);
                }
                try {
                    bindingConfig = pf.createProtocolConfiguration().getServiceBindingConfiguration((TransportRequestContext)protocolContext, integrationServiceBinding, idServizio, registryReader);
                    requestInfo.setBindingConfig(bindingConfig);
                }
                catch (RegistryNotFound notFound) {
                    logCore.debug("Lettura Configurazione Servizio fallita (notFound): " + notFound.getMessage(), (Throwable)notFound);
                    msgDiag.addKeywordErroreProcessamento(notFound);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione(), IntegrationFunctionError.API_OUT_UNKNOWN, (Throwable)notFound, null, res, logCore, true);
                }
                catch (Exception error) {
                    logCore.error("Lettura Configurazione Servizio fallita: " + error.getMessage(), (Throwable)error);
                    msgDiag.addKeywordErroreProcessamento(error);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Lettura Configurazione Servizio fallita"), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)error, null, res, logCore, false);
                }
                String ct = null;
                try {
                    ct = protocolContext.getContentType();
                    if (ct != null && !"".equals(ct)) {
                        ContentTypeUtilities.validateContentType((String)ct);
                    }
                }
                catch (Exception error) {
                    if (res != null) {
                        logCore.error("Lettura ContentType fallita: " + error.getMessage(), (Throwable)error);
                        msgDiag.addKeywordErroreProcessamento(error);
                        msgDiag.addKeyword("@DETAILS@", " Content-Type '" + ct + "' presente nella richiesta non valido;");
                        msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "richiestaNonValida");
                        ConnectorDispatcherErrorInfo cdiError = ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_432_PARSING_EXCEPTION_RICHIESTA.getErrore432_MessaggioRichiestaMalformato((Throwable)error), IntegrationFunctionError.BAD_REQUEST, (Throwable)error, null, res, logCore, true);
                        try {
                            cdiError.setEsitoTransazione(pf.createEsitoBuilder().getEsito((TransportRequestContext)requestInfo.getProtocolContext(), EsitoTransazioneName.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO));
                            if (pddContextNullable != null) {
                                pddContextNullable.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return cdiError;
                    }
                    return null;
                }
                try {
                    MessageType requestMessageTypeIntegration = bindingConfig.getRequestMessageType(integrationServiceBinding, (TransportRequestContext)protocolContext, protocolContext.getContentType());
                    requestInfo.setIntegrationRequestMessageType(requestMessageTypeIntegration);
                    MessageType requestMessageTypeProtocol = bindingConfig.getRequestMessageType(protocolServiceBinding, (TransportRequestContext)protocolContext, protocolContext.getContentType());
                    requestInfo.setProtocolRequestMessageType(requestMessageTypeProtocol);
                    if (generatoreErrore != null) {
                        generatoreErrore.updateRequestMessageType(requestMessageTypeIntegration);
                    }
                }
                catch (Exception error) {
                    logCore.error("Identificazione MessageType fallita: " + error.getMessage(), (Throwable)error);
                    msgDiag.addKeywordErroreProcessamento(error);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Identificazione MessageType fallita"), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)error, null, res, logCore, false);
                }
                if (requestInfo.getProtocolContext() != null && !bindingConfig.isServiceBindingContextEnabled(integrationServiceBinding, requestInfo.getProtocolContext().getProtocolWebContext())) {
                    if (res != null) {
                        String url = requestInfo.getProtocolContext().getRequestURI();
                        logCore.error("L'API invocata possiede un service binding '" + String.valueOf(integrationServiceBinding) + "' non abilitato sul contesto utilizzato: " + url);
                        msgDiag.logErroreGenerico("L'API invocata possiede un service binding '" + String.valueOf(integrationServiceBinding) + "' non abilitato sul contesto utilizzato", "CheckServiceBinding");
                        return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_447_API_NON_INVOCABILE_CONTESTO_UTILIZZATO.getErroreIntegrazione(), IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, null, null, res, logCore, true);
                    }
                    return null;
                }
                if (!bindingConfig.isServiceBindingServiceTypeEnabled(integrationServiceBinding, idServizio.getTipo())) {
                    if (res != null) {
                        logCore.error("L'API invocata possiede un service binding '" + String.valueOf(integrationServiceBinding) + "' non abilitato per il tipo di servizio '" + idServizio.getTipo() + "'");
                        msgDiag.logErroreGenerico("L'API invocata possiede un service binding '" + String.valueOf(integrationServiceBinding) + "' non abilitato per il tipo di servizio '" + idServizio.getTipo(), "CheckServiceBinding");
                        return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_448_API_NON_INVOCABILE_TIPO_SERVIZIO_UTILIZZATO.getErroreIntegrazione(), IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, null, null, res, logCore, true);
                    }
                    return null;
                }
            }
        }
        if (requestInfo != null && requestInfo.getProtocolServiceBinding() != null && ServiceBinding.SOAP.equals((Object)requestInfo.getProtocolServiceBinding()) && requestInfo.getProtocolContext() != null && HttpRequestMethod.OPTIONS.name().equalsIgnoreCase(requestInfo.getProtocolContext().getRequestType())) {
            try {
                CorsConfigurazione cors = null;
                HttpServletRequest httpServletRequest = null;
                if (requestInfo != null && requestInfo.getProtocolContext() != null) {
                    httpServletRequest = requestInfo.getProtocolContext().getHttpServletRequest();
                }
                if (httpServletRequest != null) {
                    cors = pdDefault != null ? configurazionePdDManager.getConfigurazioneCORS(pdDefault) : configurazionePdDManager.getConfigurazioneCORS();
                } else {
                    cors = new CorsConfigurazione();
                    cors.setStato(StatoFunzionalita.DISABILITATO);
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)cors.getStato())) {
                    if (TipoGestioneCORS.GATEWAY.equals((Object)cors.getTipo())) {
                        requestInfo.setIntegrationServiceBinding(ServiceBinding.REST);
                        requestInfo.setProtocolServiceBinding(ServiceBinding.REST);
                        generatoreErrore.updateServiceBinding(ServiceBinding.REST);
                        requestInfo.setIntegrationRequestMessageType(MessageType.BINARY);
                        requestInfo.setProtocolRequestMessageType(MessageType.BINARY);
                        generatoreErrore.updateRequestMessageType(MessageType.BINARY);
                        if (pddContextNullable != null) {
                            pddContextNullable.addObject(CostantiPdD.CORS_PREFLIGHT_REQUEST_SOAP, "true");
                        }
                    } else {
                        if (pddContextNullable != null) {
                            pddContextNullable.addObject(Costanti.CORS_PREFLIGHT_REQUEST_TRASPARENTE, "true");
                        }
                        requestInfo.setIntegrationServiceBinding(ServiceBinding.REST);
                        requestInfo.setProtocolServiceBinding(ServiceBinding.REST);
                        generatoreErrore.updateServiceBinding(ServiceBinding.REST);
                        requestInfo.setIntegrationRequestMessageType(MessageType.BINARY);
                        requestInfo.setProtocolRequestMessageType(MessageType.BINARY);
                        generatoreErrore.updateRequestMessageType(MessageType.BINARY);
                    }
                }
            }
            catch (Exception error) {
                if (res != null) {
                    logCore.error("Gestione CORS fallita: " + error.getMessage(), (Throwable)error);
                    msgDiag.addKeywordErroreProcessamento(error);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "portaDelegataNonEsistente");
                    return ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Gestione CORS fallita"), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)error, null, res, logCore, false);
                }
                return null;
            }
        }
        return null;
    }

    public static void emitTransaction(Logger logCore, ConnectorInMessage req, PdDContext pddContext, Date dataAccettazioneRichiesta, ConnectorDispatcherInfo info) {
        RicezioneContenutiApplicativiServiceUtils.emitTransaction(null, logCore, req, pddContext, dataAccettazioneRichiesta, info);
    }

    public static void emitTransaction(RicezioneContenutiApplicativiContext context, Logger logCore, ConnectorInMessage req, PdDContext pddContext, Date dataAccettazioneRichiesta, ConnectorDispatcherInfo info) {
        try {
            if (!OpenSPCoop2Startup.initialize || OpenSPCoop2Properties.getInstance() == null) {
                logCore.error("emitTransaction, registrazione non effettuata: inizializzazione govway non rilevata");
                return;
            }
            String idModulo = req.getIdModulo();
            IDService idModuloAsService = req.getIdModuloAsIDService();
            IProtocolFactory<?> protocolFactory = req.getProtocolFactory();
            RequestInfo requestInfo = req.getRequestInfo();
            if (context != null && context.getPddContext() != null) {
                PreInRequestHandler.readClientAddress(logCore, req, context.getPddContext());
                if (OpenSPCoop2Properties.getInstance().isTransazioniEnabled()) {
                    try {
                        String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                        if (idTransazione != null) {
                            Transaction tr = TransactionContext.getTransaction(idTransazione);
                            PreInRequestHandler.setInfoInvocation(tr, requestInfo, req);
                        }
                    }
                    catch (Throwable e) {
                        logCore.error("postOutResponse, lettura parametri fallita: " + e.getMessage(), e);
                    }
                }
            }
            RicezioneContenutiApplicativiServiceUtils.emitTransaction(context, logCore, idModulo, idModuloAsService, protocolFactory, requestInfo, pddContext, dataAccettazioneRichiesta, info);
        }
        catch (Throwable e) {
            logCore.error("postOutResponse, registrazione fallita: " + e.getMessage(), e);
        }
    }

    public static void emitTransaction(RicezioneContenutiApplicativiContext context, Logger logCore, String idModulo, IDService idModuloAsService, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo, PdDContext pddContext, Date dataAccettazioneRichiesta, ConnectorDispatcherInfo info) {
        try {
            if (!OpenSPCoop2Startup.initialize || OpenSPCoop2Properties.getInstance() == null) {
                logCore.error("postOutResponse, registrazione non effettuata: inizializzazione govway non rilevata");
                return;
            }
            if (context == null) {
                context = new RicezioneContenutiApplicativiContext(idModuloAsService, dataAccettazioneRichiesta, requestInfo);
            }
            PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
            postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
            postOutResponseContext.setIdModulo(idModulo);
            postOutResponseContext.setPddContext(pddContext);
            if (pddContext == null) {
                postOutResponseContext.setPddContext(context.getPddContext());
            } else {
                pddContext.addAll((org.openspcoop2.utils.Map)context.getPddContext(), true);
            }
            postOutResponseContext.getPddContext().addObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA, dataAccettazioneRichiesta);
            if (OpenSPCoop2Properties.getInstance().isTransazioniEnabled()) {
                TransactionContext.createTransaction((String)postOutResponseContext.getPddContext().getObject(Costanti.ID_TRANSAZIONE), "RicezioneContenutiApplicativi.3");
            }
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            postOutResponseContext.setEsito(info.getEsitoTransazione());
            postOutResponseContext.setReturnCode(info.getStatus());
            postOutResponseContext.setResponseHeaders(info.getTrasporto());
            if (info.getContentType() != null) {
                if (postOutResponseContext.getResponseHeaders() == null) {
                    postOutResponseContext.setResponseHeaders(new HashMap<String, List<String>>());
                }
                TransportUtils.setHeader(postOutResponseContext.getResponseHeaders(), (String)"Content-Type", (String)info.getContentType());
            }
            if (info.getMessage() != null) {
                postOutResponseContext.setOutputResponseMessageSize(info.getMessage().getOutgoingMessageContentLength());
                postOutResponseContext.setMessaggio(info.getMessage());
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.DELEGATA, idModulo);
            msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag, logCore);
        }
        catch (Throwable e) {
            logCore.error("postOutResponse, registrazione fallita: " + e.getMessage(), e);
        }
    }
}

