/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.skeleton;

import java.util.Date;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class IdentificativoIM {
    public static final String DATE_PREFIX_SEPARATOR = "@";
    public static final String FORMAT = "yyyyMMddHHmmssSSS";
    private String id;
    private Date data;

    public IdentificativoIM(String id, Date data) {
        this.id = id;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getIdWithDate() {
        if (this.data != null) {
            return DateUtils.getSimpleDateFormat((String)FORMAT).format(this.data) + DATE_PREFIX_SEPARATOR + this.id;
        }
        return this.id;
    }

    public Date getData() {
        return this.data;
    }

    public static IdentificativoIM getIdentificativoIM(String identificativo, Logger log) {
        if (identificativo.length() > FORMAT.length() + 1 && identificativo.contains(DATE_PREFIX_SEPARATOR) && !identificativo.endsWith(DATE_PREFIX_SEPARATOR) && !identificativo.startsWith(DATE_PREFIX_SEPARATOR) && identificativo.indexOf(DATE_PREFIX_SEPARATOR) == FORMAT.length()) {
            String dataString = identificativo.substring(0, identificativo.indexOf(DATE_PREFIX_SEPARATOR));
            String id = identificativo.substring(identificativo.indexOf(DATE_PREFIX_SEPARATOR) + 1);
            try {
                Date data = DateUtils.getSimpleDateFormat((String)FORMAT).parse(dataString);
                IdentificativoIM idIM = new IdentificativoIM(id, data);
                return idIM;
            }
            catch (Exception e) {
                log.error("Conversione data '" + dataString + "' non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        return new IdentificativoIM(identificativo, null);
    }
}

