/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.skeleton;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.ws.WebFault;
import java.io.Serializable;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.Costanti;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.protocol.engine.builder.DateBuilder;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;

@XmlType(name="IntegrationManagerException", namespace="http://services.pdd.openspcoop2.org", propOrder={"codiceEccezione", "descrizioneEccezione", "identificativoFunzione", "identificativoPorta", "oraRegistrazione", "tipoEccezione"})
@WebFault(name="IntegrationManagerException", targetNamespace="http://services.pdd.openspcoop2.org")
public class IntegrationManagerException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 4100781617691120752L;
    public static final String ECCEZIONE_PROTOCOLLO = "EccezioneProtocollo";
    public static final String ECCEZIONE_INTEGRAZIONE = "EccezioneIntegrazione";
    private String codiceEccezione;
    private String descrizioneEccezione;
    private String identificativoFunzione;
    private String identificativoPorta;
    private String oraRegistrazione;
    private String tipoEccezione;
    private CodiceErroreIntegrazione codiceErroreIntegrazione;
    private CodiceErroreCooperazione codiceErroreCooperazione;
    private ProprietaErroreApplicativo proprietaErroreAppl;

    private void _setCode(String codErrore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) throws ProtocolException {
        String govwayType;
        this.codiceEccezione = org.openspcoop2.protocol.basic.Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO() ? codErrore : (govwayType = erroriProperties.getErrorType(functionError));
    }

    private static String _getDescription(String descrErrore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        try {
            boolean genericDetails = false;
            if (erroriProperties.isForceGenericDetails(functionError).booleanValue()) {
                genericDetails = true;
            }
            if (org.openspcoop2.protocol.basic.Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                genericDetails = false;
            }
            if (genericDetails) {
                String govwayDetails = erroriProperties.getGenericDetails(functionError);
                return govwayDetails;
            }
            return descrErrore;
        }
        catch (ProtocolException pExc) {
            return descrErrore;
        }
    }

    private void _setDescription(String descrErrore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) throws ProtocolException {
        this.descrizioneEccezione = IntegrationManagerException._getDescription(descrErrore, functionError, erroriProperties);
    }

    public IntegrationManagerException(OpenSPCoop2SoapMessage message, String faultCode, String faultString, IDSoggetto identitaPdD, String identificativoFunzione) throws Exception {
        Object govwayPrefixCodeInContextProperty = message.getContextProperty(Costanti.ERRORE_GOVWAY_PREFIX_CODE);
        Object govwayCodeInContextProperty = message.getContextProperty(Costanti.ERRORE_GOVWAY_CODE);
        String govwayPrefixInternalErrorCode = null;
        String govwayInternalErrorCode = null;
        if (govwayPrefixCodeInContextProperty != null && govwayCodeInContextProperty != null) {
            govwayPrefixInternalErrorCode = (String)govwayPrefixCodeInContextProperty;
            govwayInternalErrorCode = (String)govwayCodeInContextProperty;
            this.codiceEccezione = org.openspcoop2.protocol.basic.Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO() ? govwayInternalErrorCode : (faultCode.startsWith("Client.") ? faultCode.substring("Client.".length()) : (faultCode.startsWith("Server.") ? faultCode.substring("Server.".length()) : faultCode));
            if ("protocol:".equals(govwayPrefixInternalErrorCode)) {
                this.setTipoEccezione(ECCEZIONE_PROTOCOLLO);
            } else {
                this.setTipoEccezione(ECCEZIONE_INTEGRAZIONE);
            }
        } else {
            throw new Exception("Not exists internal error code");
        }
        this.setDescrizioneEccezione(faultString);
        this.setOraRegistrazione(DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()));
        this.setIdentificativoPorta(identitaPdD.getCodicePorta());
        this.setIdentificativoFunzione(identificativoFunzione);
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreIntegrazione errore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_INTEGRAZIONE, null, functionError, erroriProperties);
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreIntegrazione errore, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_INTEGRAZIONE, servizioApplicativo, functionError, erroriProperties);
    }

    private IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreIntegrazione errore, String tipo, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        super(IntegrationManagerException._getDescription(errore.getDescrizioneRawValue(), functionError, erroriProperties));
        try {
            this.initProprietaBase(protocolFactory, tipo, servizioApplicativo);
            this.codiceErroreIntegrazione = errore.getCodiceErrore();
            Object cod = null;
            String desc = null;
            if (protocolFactory != null) {
                cod = protocolFactory.createTraduttore().toString(errore.getCodiceErrore(), this.proprietaErroreAppl.getFaultPrefixCode(), this.proprietaErroreAppl.isFaultAsGenericCode());
                desc = errore.getDescrizione(protocolFactory);
            } else {
                cod = "" + errore.getCodiceErrore().getCodice();
                desc = errore.getDescrizioneRawValue();
            }
            this._setCode((String)cod, functionError, erroriProperties);
            this._setDescription(desc, functionError, erroriProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreCooperazione errore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_PROTOCOLLO, null, functionError, erroriProperties);
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreCooperazione errore, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_PROTOCOLLO, servizioApplicativo, functionError, erroriProperties);
    }

    private IntegrationManagerException(IProtocolFactory<?> protocolFactory, ErroreCooperazione errore, String tipo, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        super(IntegrationManagerException._getDescription(errore.getDescrizioneRawValue(), functionError, erroriProperties));
        try {
            this.initProprietaBase(protocolFactory, tipo, servizioApplicativo);
            this.codiceErroreCooperazione = errore.getCodiceErrore();
            String cod = protocolFactory.createTraduttore().toString(errore.getCodiceErrore());
            String desc = errore.getDescrizione(protocolFactory);
            this._setCode(cod, functionError, erroriProperties);
            this._setDescription(desc, functionError, erroriProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, Eccezione errore, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_PROTOCOLLO, null, functionError, erroriProperties);
    }

    public IntegrationManagerException(IProtocolFactory<?> protocolFactory, Eccezione errore, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        this(protocolFactory, errore, ECCEZIONE_PROTOCOLLO, servizioApplicativo, functionError, erroriProperties);
    }

    private IntegrationManagerException(IProtocolFactory<?> protocolFactory, Eccezione errore, String tipo, IDServizioApplicativo servizioApplicativo, IntegrationFunctionError functionError, ErroriProperties erroriProperties) {
        super(IntegrationManagerException._getDescription(IntegrationManagerException.getDescrizione(errore, protocolFactory), functionError, erroriProperties));
        try {
            this.initProprietaBase(protocolFactory, tipo, servizioApplicativo);
            this.codiceErroreCooperazione = errore.getCodiceEccezione();
            String cod = protocolFactory.createTraduttore().toString(errore.getCodiceEccezione());
            String desc = errore.getDescrizione(protocolFactory);
            this._setCode(cod, functionError, erroriProperties);
            this._setDescription(desc, functionError, erroriProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getDescrizione(Eccezione errore, IProtocolFactory<?> protocolFactory) {
        try {
            return errore.getDescrizione(protocolFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public IntegrationManagerException() {
    }

    private void initProprietaBase(IProtocolFactory<?> protocolFactory, String tipoEccezione, IDServizioApplicativo servizioApplicativo) throws ProtocolException {
        this.oraRegistrazione = DateBuilder.getDate_Format(null);
        this.identificativoFunzione = IntegrationManager.ID_MODULO;
        this.tipoEccezione = tipoEccezione;
        OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
        openspcoopProperties = OpenSPCoop2Properties.getInstance();
        try {
            IProtocolManager pm = null;
            if (protocolFactory != null) {
                pm = protocolFactory.createProtocolManager();
            }
            this.proprietaErroreAppl = openspcoopProperties.getProprietaGestioneErrorePD(pm);
        }
        catch (Exception pm) {
            // empty catch block
        }
        if (servizioApplicativo != null) {
            try {
                ConfigurazionePdDManager configPdDReader = ConfigurazionePdDManager.getInstance();
                ServizioApplicativo sa = configPdDReader.getServizioApplicativo(servizioApplicativo, null);
                configPdDReader.aggiornaProprietaGestioneErrorePD(this.proprietaErroreAppl, sa);
            }
            catch (Exception configPdDReader) {
                // empty catch block
            }
        }
        String protocol = null;
        if (protocolFactory != null) {
            protocol = protocolFactory.getProtocol();
        }
        this.identificativoPorta = openspcoopProperties.getIdentificativoPortaDefault(protocol, null);
    }

    @XmlTransient
    public CodiceErroreIntegrazione getCodiceErroreIntegrazione() {
        return this.codiceErroreIntegrazione;
    }

    @XmlTransient
    public CodiceErroreCooperazione getCodiceErroreCooperazione() {
        return this.codiceErroreCooperazione;
    }

    @XmlElement(required=true, nillable=true)
    public void setDescrizioneEccezione(String descrizione) {
        this.descrizioneEccezione = descrizione;
    }

    public String getDescrizioneEccezione() {
        return this.descrizioneEccezione;
    }

    @XmlElement(required=true, nillable=true)
    public void setTipoEccezione(String tipo) {
        this.tipoEccezione = tipo;
    }

    public String getTipoEccezione() {
        return this.tipoEccezione;
    }

    @XmlElement(required=true, nillable=true)
    public void setOraRegistrazione(String ora) {
        this.oraRegistrazione = ora;
    }

    public String getOraRegistrazione() {
        return this.oraRegistrazione;
    }

    @XmlElement(required=true, nillable=true)
    public void setIdentificativoPorta(String id) {
        this.identificativoPorta = id;
    }

    public String getIdentificativoPorta() {
        return this.identificativoPorta;
    }

    @XmlElement(required=true, nillable=true)
    public void setIdentificativoFunzione(String id) {
        this.identificativoFunzione = id;
    }

    public String getIdentificativoFunzione() {
        return this.identificativoFunzione;
    }

    @XmlElement(required=true, nillable=true)
    public void setCodiceEccezione(String codice) {
        this.codiceEccezione = codice;
    }

    public String getCodiceEccezione() {
        return this.codiceEccezione;
    }

    protected ProprietaErroreApplicativo getProprietaErroreApplicativo() {
        return this.proprietaErroreAppl;
    }

    @Override
    @XmlTransient
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    @Override
    @XmlTransient
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    @XmlTransient
    public String getLocalizedMessage() {
        return super.getLocalizedMessage();
    }

    @Override
    @XmlTransient
    public synchronized Throwable getCause() {
        return super.getCause();
    }
}

