/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Timestamp;
import org.openspcoop2.pdd.config.ConfigurazioneCoda;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.threads.GestoreCodaRunnable;
import org.openspcoop2.utils.threads.IGestoreCodaRunnableInstance;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.slf4j.Logger;

public class TimerConsegnaContenutiApplicativiThread
extends GestoreCodaRunnable {
    public static final String ID_MODULO = "TimerConsegnaContenutiApplicativi";
    public static Timestamp LOCK_CONSEGNA_FUTURA = null;
    private OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
    private MsgDiagnostico msgDiag;
    private Logger log = null;
    private boolean debug = false;
    private int limit = 50;
    private ConfigurazioneCoda configurazioneCoda;
    private static MsgDiagnostico msgDiag_staticInstance;

    public String getQueueConfig() {
        return this.configurazioneCoda.toString(false, ", ");
    }

    private static String getModuleId() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        return ID_MODULO;
    }

    private static synchronized MsgDiagnostico getMsgDiagnostico() throws TimerException {
        if (msgDiag_staticInstance == null) {
            try {
                msgDiag_staticInstance = MsgDiagnostico.newInstance(ID_MODULO);
                msgDiag_staticInstance.setPrefixMsgPersonalizzati("timerConsegnaContenutiApplicativi.");
                msgDiag_staticInstance.addKeyword("@ID_TIMER@", ID_MODULO);
            }
            catch (Exception e) {
                String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
                throw new TimerException(msgErrore, e);
            }
        }
        return msgDiag_staticInstance;
    }

    private static TimerConsegnaContenutiApplicativi newTimerConsegnaContenutiApplicativi(ConfigurazioneCoda configurazioneCoda) throws TimerException {
        return new TimerConsegnaContenutiApplicativi(configurazioneCoda, TimerConsegnaContenutiApplicativiThread.getMsgDiagnostico(), new RunnableLogger(ID_MODULO, OpenSPCoop2Logger.getLoggerOpenSPCoopConsegnaContenuti(configurazioneCoda.isDebug())), new RunnableLogger(ID_MODULO, OpenSPCoop2Logger.getLoggerOpenSPCoopConsegnaContenutiSql(configurazioneCoda.isDebug())), OpenSPCoop2Properties.getInstance(), ConfigurazionePdDManager.getInstance(), RegistroServiziManager.getInstance());
    }

    public TimerConsegnaContenutiApplicativiThread(ConfigurazioneCoda configurazioneCoda) throws TimerException, UtilsException {
        super(TimerConsegnaContenutiApplicativiThread.getModuleId(), configurazioneCoda.getPoolSize(), configurazioneCoda.getQueueSize(), configurazioneCoda.getNextMessages_limit(), configurazioneCoda.getNextMessages_intervalloControllo(), (IGestoreCodaRunnableInstance)TimerConsegnaContenutiApplicativiThread.newTimerConsegnaContenutiApplicativi(configurazioneCoda), OpenSPCoop2Logger.getLoggerOpenSPCoopConsegnaContenuti(configurazioneCoda.isDebug()));
        this.configurazioneCoda = configurazioneCoda;
        this.debug = configurazioneCoda.isDebug();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopConsegnaContenuti(this.debug);
        try {
            this.msgDiag = TimerConsegnaContenutiApplicativiThread.getMsgDiagnostico();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.log.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.log.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        this.setTimeout(configurazioneCoda.getNextMessages_intervalloControllo());
        String s = "secondi";
        if (this.getTimeout() == 1) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + s);
        this.limit = configurazioneCoda.getNextMessages_limit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.log.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    static {
        try {
            LOCK_CONSEGNA_FUTURA = new Timestamp(DateUtils.getSimpleDateFormatDay().parse("2200-12-31").getTime());
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        msgDiag_staticInstance = null;
    }
}

