/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggiLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestoreMessaggiThread
extends BaseThread {
    private long scadenzaMessaggio = 7200L;
    private long scadenzaCorrelazioneApplicativa = 7200L;
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = true;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = false;

    public TimerGestoreMessaggiThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance("GestoreMessaggi");
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error(msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.setTimeout((int)this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi());
        String s = "secondi";
        if (this.getTimeout() == 1) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + s);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestoreMessaggiLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        this.scadenzaCorrelazioneApplicativa = this.propertiesReader.getRepositoryIntervalloScadenzaCorrelazioneApplicativa();
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = this.propertiesReader.isRepositoryScadenzaCorrelazioneApplicativaFiltraRispettoOraRegistrazione();
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = this.propertiesReader.isRepositoryScadenzaCorrelazioneApplicativaFiltraRispettoOraRegistrazioneEscludiConScadenzaImpostata();
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    public void process() {
        try {
            TimerGestoreMessaggiLib gestoreMessaggiLib = new TimerGestoreMessaggiLib(this.msgDiag, this.logTimer, this.propertiesReader, this.scadenzaMessaggio, this.logQuery, this.limit, this.orderByQuery, this.scadenzaCorrelazioneApplicativa, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
            gestoreMessaggiLib.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreMessaggiLib.check()");
            this.logTimer.error("Errore generale: " + e.getMessage(), (Throwable)e);
        }
    }
}

